/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.db;

import commvault.cte.db.CTEDBColumn;
import commvault.cte.db.CTEDBException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CTEDBInteger
extends CTEDBColumn {
    public CTEDBInteger(String string, boolean bl, boolean bl2) {
        super(string, bl, bl2);
    }

    public CTEDBInteger(String string, int n, boolean bl, boolean bl2) {
        super(string, n, bl, bl2);
    }

    public Integer get() {
        return (Integer)this.getValue();
    }

    public int getIntValue() {
        if (this.getValue() == null) {
            return 0;
        }
        return this.get();
    }

    public void set(Integer n) {
        this.setValue(n);
    }

    @Override
    protected void fromResult(ResultSet resultSet) throws CTEDBException {
        try {
            this.set(resultSet.getInt(this.getColumnName()));
        }
        catch (SQLException sQLException) {
            throw new CTEDBException("error retrieving integer value from result set for column [" + this.getColumnName() + "]", sQLException);
        }
    }

    @Override
    protected void fromResult(ResultSet resultSet, int n) throws CTEDBException {
        try {
            this.set(resultSet.getInt(n));
        }
        catch (SQLException sQLException) {
            throw new CTEDBException("error retrieving integer value from result set for column index [" + n + "], col [" + this.getColumnName() + "]", sQLException);
        }
    }

    @Override
    protected void setParameter(PreparedStatement preparedStatement, int n) throws CTEDBException {
        try {
            if (this.get() == null) {
                preparedStatement.setNull(n, 4);
            } else {
                preparedStatement.setInt(n, this.get());
            }
        }
        catch (SQLException sQLException) {
            throw new CTEDBException("error adding integer parameter [" + this.get() + "] for index [" + n + "], col [" + this.getColumnName() + "]", sQLException);
        }
    }

    @Override
    protected void zero() {
        this.set(0);
    }
}

