/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.wizard;

import commvault.cte.CteStringBank;
import commvault.cte.component.BasicJDialog;
import commvault.cte.component.CVFrame;
import commvault.cte.component.CXFocusManager;
import commvault.cte.component.GlassPane;
import commvault.cte.component.LayoutUtils;
import commvault.cte.component.SortedListModel;
import commvault.cte.component.Utilities;
import commvault.cte.component.wizard.AbstractWizardPage;
import commvault.cte.component.wizard.IWizardController;
import commvault.cte.component.wizard.IWizardPage;
import commvault.cte.help.CVHelp;
import commvault.cte.util.Logger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class WizardDialog
extends BasicJDialog
implements ActionListener,
ChangeListener,
CXFocusManager.FocusManagerListener {
    public static final String BACK = CteStringBank._24_Back.getI18n();
    public static final String NEXT = CteStringBank.Next_25.getI18n();
    public static final String FINISH = CteStringBank.Finish.getI18n();
    static HashSet disabledPages = new HashSet();
    Container contentPane = null;
    JPanel descriptionPanel = new JPanel();
    JSplitPane splitPane = new JSplitPane();
    protected JButton backButton;
    protected Utilities.DefaultCapableButton nextButton;
    protected Utilities.DefaultCapableButton finishButton;
    protected JButton cancelButton;
    protected JButton helpButton;
    private final CVHelp cvHelp = new CVHelp(this);
    public static final int BACK_BUTTON = 1;
    public static final int NEXT_BUTTON = 2;
    public static final int FINISH_BUTTON = 4;
    public static final int CANCEL_BUTTON = 8;
    public static final int HELP_BUTTON = 16;
    protected JPanel buttonPanel = new JPanel();
    private CVList contentList;
    private Component rightComponent;
    private ImagedPanel contentPanel;
    private JPanel contentLabelPanel;
    private WrappedCellRenderer cellRenderer;
    private JLabel label;
    private int selectedIndex = -1;
    protected IWizardController wizardController;
    private Dimension cachedDimension;
    private boolean isHyperLink = false;
    String origTitle = "";
    protected boolean disposeOnClose = true;
    protected int buttonPressed = 0;
    private static final String EMPTY_FILLED_MSG = CteStringBank.cte_component_wizard_WizardDialog_key1.getI18n();
    private JPanel contentListContainer;
    private IValidator iValidator;

    public WizardDialog(String string, boolean bl, int n, int n2) {
        this((Frame)((Object)CVFrame.getInstance()), string, bl, n, n2, true);
    }

    public WizardDialog(Frame frame, String string, boolean bl, int n, int n2) {
        this(frame, string, bl, n, n2, true);
    }

    public WizardDialog(Frame frame, String string, boolean bl, int n, int n2, boolean bl2) {
        super(frame, string, true);
        this.initWizardDialog(string, bl, n, n2, bl2);
    }

    public WizardDialog(Dialog dialog, String string, boolean bl, int n, int n2) {
        super(dialog, string, true);
        this.initWizardDialog(string, bl, n, n2, true);
    }

    protected void initWizardDialog(String string, boolean bl, int n, int n2, boolean bl2) {
        this.isHyperLink = bl;
        this.origTitle = string;
        this.resetPreferredSize();
        this.setGlassPane(new GlassPane());
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.contentPane = this.getContentPane();
        if (bl2) {
            this.createContentPanel(true, new Dimension(200, n2));
            this.splitPane.setLeftComponent(this.contentPanel);
        } else {
            this.splitPane.setLeftComponent(null);
        }
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(n, n2));
        this.rightComponent = jPanel;
        this.splitPane.setRightComponent(this.rightComponent);
        this.contentPane.add((Component)this.splitPane, LayoutUtils.getConstraints(gridBagConstraints, -1, -1, 0, 1, 1.0, 1.0, 18, 1));
        this.contentPane.add((Component)new JSeparator(), LayoutUtils.getConstraints(gridBagConstraints, -1, -1, 0, 1, 1.0, 0.0, 18, 2));
        this.buttonPanel.setLayout(new GridBagLayout());
        this.helpButton = new Utilities.NonDefaultButton(BasicJDialog.HELP);
        this.cancelButton = new Utilities.NonDefaultButton(BasicJDialog.CANCEL);
        this.backButton = new Utilities.NonDefaultButton(BACK);
        this.nextButton = new Utilities.DefaultCapableButton(NEXT);
        this.finishButton = new Utilities.DefaultCapableButton(FINISH);
        this.backButton.setMnemonic('B');
        this.nextButton.setMnemonic('N');
        this.helpButton.setMnemonic('H');
        this.helpButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.backButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.finishButton.addActionListener(this);
        LayoutUtils.addRow((Container)this.buttonPanel, new JComponent[]{this.backButton, this.nextButton, this.finishButton, this.cancelButton, this.helpButton}, false);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.buttonPanel, "East");
        this.contentPane.add((Component)jPanel2, LayoutUtils.getConstraints(gridBagConstraints, -1, -1, 0, 0, 1.0, 0.0, 10, 1, new Insets(15, 5, 5, 5)));
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setLocationRelativeTo((Component)((Object)CVFrame.getInstance()));
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.setDefaultCloseOperation(2);
        this.initHelp("MainHelp");
    }

    public WizardDialog(String string, int n, int n2) {
        this(string, false, n, n2);
    }

    public WizardDialog(String string, boolean bl) {
        this(string, bl, 400, 250);
    }

    public WizardDialog(String string) {
        this(string, false, 400, 250);
    }

    public WizardDialog(Frame frame, String string) {
        this(frame, string, false, 400, 250, true);
    }

    public WizardDialog(Frame frame, String string, boolean bl) {
        this(frame, string, false, 400, 250, bl);
    }

    public String getOriginalTitle() {
        return this.origTitle;
    }

    public IWizardController getWizardController() {
        return this.wizardController;
    }

    public void setWizardController(IWizardController iWizardController) {
        this.wizardController = iWizardController;
        this.setContentList(this.wizardController.getSteps());
        this.updateState();
    }

    public void updateState() {
        IWizardPage iWizardPage = this.wizardController.getCurrentPage();
        if (this.wizardController.getCurrentIndex() == this.selectedIndex) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            iWizardPage.activated();
            this.updateButtonState();
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        try {
            if (this.selectedIndex != -1) {
                IWizardPage iWizardPage2 = this.getCurrentPage();
                this.setCursor(Cursor.getPredefinedCursor(3));
                iWizardPage2.deactivated();
                iWizardPage2.removeChangeListener(this);
                this.setCursor(Cursor.getDefaultCursor());
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            int n = this.splitPane.getDividerLocation();
            iWizardPage.activated();
            iWizardPage.addChangeListener(this);
            this.splitPane.setRightComponent(iWizardPage.getPanel());
            this.splitPane.setDividerLocation(n);
            this.setSelectedIndex(this.wizardController.getCurrentIndex());
            this.updateButtonState();
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (IllegalStateException illegalStateException) {
            if (illegalStateException.getMessage() != null && !illegalStateException.getMessage().isEmpty()) {
                Utilities.showErrorMessage(this, illegalStateException.getMessage());
            }
            this.setCursor(Cursor.getDefaultCursor());
            throw illegalStateException;
        }
    }

    protected IWizardPage getCurrentPage() {
        IWizardPage iWizardPage = (IWizardPage)((Object)this.splitPane.getRightComponent());
        return iWizardPage;
    }

    private void createContentPanel(boolean bl, Dimension dimension) {
        this.initContentList();
        this.cellRenderer = new WrappedCellRenderer(bl, dimension.width);
        this.cellRenderer.setOpaque(false);
        this.label = new JLabel(CteStringBank.Steps.getI18n());
        this.label.setForeground(Color.black);
        this.label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.label.getForeground()));
        this.label.setFont(this.label.getFont().deriveFont(1));
        this.contentLabelPanel = new JPanel(new BorderLayout());
        this.contentLabelPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.contentLabelPanel.setOpaque(false);
        this.contentLabelPanel.add((Component)this.label, "North");
        this.contentListContainer = new JPanel(new BorderLayout());
        this.contentPanel = new ImagedPanel(null);
        this.contentPanel.add((Component)this.contentLabelPanel, "North");
        this.contentPanel.add((Component)this.contentListContainer, "Center");
        this.addContentListToContainer();
        this.contentPanel.setPreferredSize(dimension);
        int n = this.contentPanel.getPreferredSize().width;
        this.splitPane.setDividerLocation(Utilities.userDefinedFont == 0 ? n : (Utilities.userDefinedFont > 14 && Utilities.userDefinedFont <= 15 ? n + 60 : (Utilities.userDefinedFont >= 12 && Utilities.userDefinedFont <= 14 ? n + 45 : n)));
    }

    protected void setSplitPaneDividerLocation(int n) {
        this.splitPane.setDividerLocation(n);
    }

    private void initContentList() {
        this.contentList = this.isHyperLink ? new CVList(this) : new CVList();
    }

    private void addContentListToContainer() {
        if (this.contentListContainer != null) {
            this.contentListContainer.removeAll();
            this.contentListContainer.add((Component)this.contentList, "Center");
        }
    }

    public void setContentList(String[] stringArray) {
        this.initContentList();
        this.addContentListToContainer();
        SortedListModel sortedListModel = this.contentList.getModel();
        sortedListModel.removeAllElements();
        for (int i = 0; i < stringArray.length; ++i) {
            sortedListModel.addElement(stringArray[i]);
        }
        this.contentList.initComponents();
    }

    public void setContentList(Vector vector) {
        this.initContentList();
        this.addContentListToContainer();
        SortedListModel sortedListModel = this.contentList.getModel();
        sortedListModel.removeAllElements();
        for (int i = 0; i < vector.size(); ++i) {
            sortedListModel.addElement(vector.elementAt(i));
        }
        this.contentList.initComponents();
    }

    public void setSelectedIndex(int n) {
        this.selectedIndex = n;
        if (this.cellRenderer != null) {
            this.contentList.setSelectedIndex(n);
        }
    }

    @Override
    public void requestFocus() {
        if (this.rightComponent != null) {
            this.rightComponent.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public void resetPreferredSize() {
        this.cachedDimension = new Dimension(650, 400);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.height > this.cachedDimension.height) {
            this.cachedDimension.height = dimension.height;
        }
        if (dimension.width > this.cachedDimension.width) {
            this.cachedDimension.width = dimension.width;
        }
        return this.cachedDimension;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateState();
    }

    public void backButton() {
        if (this.backButton != null && this.backButton.isEnabled()) {
            this.backButton.doClick();
        }
    }

    public void nextButton() {
        if (this.nextButton != null && this.nextButton.isEnabled()) {
            this.nextButton.doClick();
        }
    }

    public void finishButton() {
        if (this.finishButton != null && this.finishButton.isEnabled()) {
            this.finishButton.doClick();
        }
    }

    public void cancelButton() {
        if (this.cancelButton != null && this.cancelButton.isEnabled()) {
            this.cancelButton.doClick();
        }
    }

    @Override
    public void actionPerformed(final ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.nextButton) {
            this.nextButton.setEnabled(false);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                block30: {
                    if (actionEvent.getSource() == WizardDialog.this.nextButton) {
                        WizardDialog.this.buttonPressed = 2;
                        try {
                            WizardDialog.this.wizardController.nextPage();
                            WizardDialog.this.setContentList(WizardDialog.this.wizardController.getSteps());
                            WizardDialog.this.updateState();
                            if (WizardDialog.this.nextButton.isEnabled() && WizardDialog.this.wizardController.hasNext()) {
                                WizardDialog.this.nextButton.requestFocus();
                            } else if (WizardDialog.this.finishButton.isEnabled() && !WizardDialog.this.wizardController.hasNext()) {
                                WizardDialog.this.finishButton.requestFocus();
                            }
                            if (WizardDialog.this.wizardController.getCurrentPage().canSkip()) {
                                WizardDialog.this.actionPerformed(actionEvent);
                            }
                            break block30;
                        }
                        catch (IllegalStateException illegalStateException) {
                            WizardDialog.this.wizardController.prevPage();
                            WizardDialog.this.updateState();
                            if (WizardDialog.this.nextButton.isEnabled() && WizardDialog.this.wizardController.hasNext()) {
                                WizardDialog.this.nextButton.requestFocus();
                            } else if (WizardDialog.this.finishButton.isEnabled() && !WizardDialog.this.wizardController.hasNext()) {
                                WizardDialog.this.finishButton.requestFocus();
                            }
                            break block30;
                        }
                    }
                    if (actionEvent.getSource() == WizardDialog.this.backButton) {
                        WizardDialog.this.buttonPressed = 1;
                        try {
                            WizardDialog.this.wizardController.prevPage();
                            WizardDialog.this.setContentList(WizardDialog.this.wizardController.getSteps());
                            WizardDialog.this.updateState();
                            if (WizardDialog.this.nextButton.isEnabled() && WizardDialog.this.wizardController.hasNext()) {
                                WizardDialog.this.nextButton.requestFocus();
                            } else if (WizardDialog.this.finishButton.isEnabled() && !WizardDialog.this.wizardController.hasNext()) {
                                WizardDialog.this.finishButton.requestFocus();
                            }
                            if (WizardDialog.this.wizardController.getCurrentPage().canSkip()) {
                                WizardDialog.this.actionPerformed(actionEvent);
                            }
                        }
                        catch (Exception exception) {}
                    } else if (actionEvent.getSource() == WizardDialog.this.cancelButton) {
                        WizardDialog.this.buttonPressed = 8;
                        WizardDialog.this.close();
                    } else if (actionEvent.getSource() == WizardDialog.this.finishButton) {
                        if (WizardDialog.this.iValidator != null && !WizardDialog.this.iValidator.isValid()) {
                            return;
                        }
                        WizardDialog.this.buttonPressed = 4;
                        while (WizardDialog.this.wizardController.hasNext()) {
                            if (WizardDialog.this.wizardController.getCurrentIndex() < WizardDialog.this.wizardController.getSteps().length - 1 && !WizardDialog.this.wizardController.getCurrentPage().checkValid() && !WizardDialog.this.wizardController.getCurrentPage().isFinishAllowed()) {
                                JOptionPane.showMessageDialog(WizardDialog.this, EMPTY_FILLED_MSG);
                                if (WizardDialog.this.nextButton.isEnabled() && WizardDialog.this.wizardController.hasNext()) {
                                    WizardDialog.this.nextButton.requestFocus();
                                } else if (WizardDialog.this.finishButton.isEnabled() && !WizardDialog.this.wizardController.hasNext()) {
                                    WizardDialog.this.finishButton.requestFocus();
                                }
                                return;
                            }
                            WizardDialog.this.wizardController.nextPage();
                            WizardDialog.this.updateState();
                        }
                        WizardDialog.this.finishButtonActionPerfomed(actionEvent);
                    } else if (actionEvent.getSource() == WizardDialog.this.helpButton) {
                        IWizardPage iWizardPage;
                        WizardDialog.this.buttonPressed = 16;
                        if (WizardDialog.this.wizardController != null && (iWizardPage = WizardDialog.this.wizardController.getCurrentPage()) != null) {
                            WizardDialog.this.cvHelp.setCurrentID(iWizardPage.getHelpLink());
                            WizardDialog.this.cvHelp.displayHelp();
                        }
                    }
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void finishButtonActionPerfomed(ActionEvent actionEvent) {
        this.close();
    }

    public int getActionPerformed() {
        return this.buttonPressed;
    }

    public void setActionPerformed(int n) {
        this.buttonPressed = n;
    }

    public void setDisposeOnClose(boolean bl) {
        this.disposeOnClose = bl;
        if (!bl) {
            this.setDefaultCloseOperation(1);
        } else {
            this.setDefaultCloseOperation(2);
        }
    }

    public void close() {
        disabledPages.clear();
        this.setVisible(false);
        if (this.disposeOnClose) {
            this.dispose();
        }
    }

    public void setEnableButton(int n, boolean bl) {
        if (n == 1) {
            this.backButton.setEnabled(bl);
        } else if (n == 2) {
            this.nextButton.setEnabled(bl);
        } else if (n == 4) {
            this.finishButton.setEnabled(bl);
        } else if (n == 8) {
            this.cancelButton.setEnabled(bl);
        } else if (n == 16) {
            this.helpButton.setEnabled(bl);
        }
    }

    public void setEnableButtons(int n) {
        if ((n & 1) != 0) {
            this.backButton.setEnabled(true);
        } else {
            this.backButton.setEnabled(false);
        }
        if ((n & 2) != 0) {
            this.nextButton.setEnabled(true);
        } else {
            this.nextButton.setEnabled(false);
        }
        if ((n & 4) != 0) {
            this.finishButton.setEnabled(true);
        } else {
            this.finishButton.setEnabled(false);
        }
        if ((n & 8) != 0) {
            this.cancelButton.setEnabled(true);
        } else {
            this.cancelButton.setEnabled(false);
        }
        if ((n & 0x10) != 0) {
            this.helpButton.setEnabled(true);
        } else {
            this.helpButton.setEnabled(false);
        }
    }

    public void setVisibleButton(int n, boolean bl) {
        if (n == 1) {
            this.backButton.setVisible(bl);
        } else if (n == 2) {
            this.nextButton.setVisible(bl);
        } else if (n == 4) {
            this.finishButton.setVisible(bl);
        } else if (n == 8) {
            this.cancelButton.setVisible(bl);
        } else if (n == 16) {
            this.helpButton.setVisible(bl);
        }
    }

    public void selectPage(int n) {
        this.wizardController.setCurrentIndex(n);
        this.updateState();
    }

    @Override
    public boolean acceptChanges(Component component) {
        if (this.wizardController.hasNext()) {
            this.nextButton();
        } else {
            this.finishButton();
        }
        return true;
    }

    @Override
    public boolean goToNextPage(Component component) {
        return false;
    }

    @Override
    public boolean goToNextTab(Component component) {
        return false;
    }

    @Override
    public boolean goToPreviousPage(Component component) {
        return false;
    }

    @Override
    public boolean goToPreviousTab(Component component) {
        return false;
    }

    @Override
    public boolean rejectChanges(Component component) {
        this.cancelButton();
        return true;
    }

    private void updateButtonState() {
        boolean bl;
        int n = this.wizardController.getCurrentIndex();
        IWizardPage iWizardPage = this.wizardController.getCurrentPage();
        int n2 = 24;
        boolean bl2 = this.wizardController.getMode() == 2;
        boolean bl3 = this.wizardController.getMode() == 3;
        boolean bl4 = bl = iWizardPage instanceof AbstractWizardPage && ((AbstractWizardPage)iWizardPage).finishOverrideModify();
        if (bl && (bl2 || bl3 || iWizardPage.isFinishAllowed())) {
            n2 |= 4;
        }
        if (n >= 0) {
            if (this.wizardController.hasNext()) {
                if (iWizardPage.checkValid()) {
                    n2 |= 2;
                }
            } else {
                n2 |= 4;
            }
            if (this.wizardController.hasPrevious()) {
                n2 |= 1;
            }
        }
        this.setEnableButtons(n2);
    }

    @Override
    public void dispose() {
        super.dispose();
        disabledPages.clear();
    }

    @Override
    public void show() {
        super.show();
    }

    public void initHelp(String string) {
        this.cvHelp.createHelpBroker(string);
    }

    public void enableDisableComponent(String string, boolean bl) {
        if (bl) {
            disabledPages.remove(string);
        } else {
            disabledPages.add(string);
        }
    }

    public IValidator getValidator() {
        return this.iValidator;
    }

    public void setValidator(IValidator iValidator) {
        this.iValidator = iValidator;
    }

    public static interface IValidator {
        public boolean isValid();
    }

    public static class CVList
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        SortedListModel listModel = new SortedListModel(false);
        SortedListModel componentListModel = new SortedListModel(false);
        JPanel listPanel = new JPanel(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(this.listPanel);
        int selected;
        WizardDialog wizard = null;
        Cursor defaultCursor = new Cursor(0);
        Cursor handCursor = new Cursor(12);
        Rectangle oldRectangle;

        public CVList() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.add((Component)this.scrollPane, LayoutUtils.getConstraints(gridBagConstraints, -1, -1, 0, 0, 1.0, 1.0, 18, 1, new Insets(2, 2, 0, 2)));
            this.setOpaque(false);
            this.listPanel.setOpaque(false);
            this.scrollPane.getViewport().setOpaque(false);
            this.scrollPane.setOpaque(false);
            this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        }

        public CVList(WizardDialog wizardDialog) {
            this();
            this.wizard = wizardDialog;
        }

        public void setWizardController(WizardDialog wizardDialog) {
            this.wizard = wizardDialog;
        }

        public SortedListModel getModel() {
            return this.listModel;
        }

        /*
         * Unable to fully structure code
         */
        public boolean initComponents() {
            this.listPanel.removeAll();
            var2_1 = new GridBagConstraints();
            var3_2 = 0;
            var4_3 = this.listModel.elements();
            while (var4_3.hasMoreElements()) {
                block5: {
                    var5_4 = var4_3.nextElement();
                    var6_5 = null;
                    if (!(var5_4 instanceof String)) break block5;
                    var6_5 = new JTextPane();
                    var6_5.setFocusable(false);
                    var7_6 = new SimpleAttributeSet();
                    if (this.wizard != null) {
                        StyleConstants.setUnderline(var7_6, true);
                    }
                    var6_5.setCharacterAttributes(var7_6, true);
                    var6_5.setText(Integer.toString(var3_2 + 1) + ". " + (String)var5_4);
                    var6_5.setOpaque(false);
                    var6_5.setEditable(false);
                    var6_5.setBorder(BorderFactory.createEmptyBorder());
                    var6_5.setCursor(this.handCursor);
                    var6_5.setEnabled(WizardDialog.disabledPages.contains(var5_4) == false);
                    if (this.wizard != null) {
                        var6_5.addMouseMotionListener(this);
                        var6_5.addMouseListener(this);
                    }
                    ** GOTO lbl30
                }
                if (!(var5_4 instanceof JTextPane)) {
                    Logger.write(Logger.ERROR, this, "initComponents", "Unknown element type found in the list model");
                } else {
                    var6_5 = (JTextPane)var5_4;
lbl30:
                    // 2 sources

                    this.componentListModel.addElement(var6_5);
                    this.listPanel.add((Component)var6_5, LayoutUtils.getConstraints(var2_1, -1, -1, 0, 1, 1.0, 0.0, 18, 2, new Insets(5, 10, 0, 2)));
                    this.listPanel.setFocusable(false);
                }
                ++var3_2;
            }
            this.listPanel.add((Component)new JLabel(), LayoutUtils.getConstraints(var2_1, -1, -1, 0, 0, 1.0, 1.0, 18, 1, new Insets(2, 2, 0, 2)));
            return true;
        }

        private void setSelectedIndex(int n) {
            JTextPane jTextPane = null;
            SimpleAttributeSet simpleAttributeSet = null;
            String string = null;
            if (this.selected != -1) {
                jTextPane = (JTextPane)this.componentListModel.getElementAt(this.selected);
                simpleAttributeSet = new SimpleAttributeSet();
                if (this.wizard != null) {
                    StyleConstants.setUnderline(simpleAttributeSet, true);
                }
                string = jTextPane.getText();
                jTextPane.setText("");
                jTextPane.setCharacterAttributes(simpleAttributeSet, true);
                jTextPane.setText(string);
            }
            this.selected = n;
            jTextPane = (JTextPane)this.componentListModel.getElementAt(n);
            simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setBold(simpleAttributeSet, true);
            string = jTextPane.getText();
            jTextPane.setText("");
            jTextPane.setCharacterAttributes(simpleAttributeSet, true);
            jTextPane.setText(string);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof JTextPane) {
                JTextPane jTextPane = (JTextPane)mouseEvent.getSource();
                if (!jTextPane.isEnabled()) {
                    return;
                }
                String string = this.wizard.getWizardController().getSteps()[this.componentListModel.indexOf(jTextPane)];
                if (this.wizard != null) {
                    if (this.wizard.getWizardController().getCurrentIndex() >= this.componentListModel.indexOf(jTextPane)) {
                        this.wizard.selectPage(this.componentListModel.indexOf(jTextPane));
                    } else {
                        this.wizard.buttonPressed = 0;
                        while (this.wizard.getWizardController().hasNext() && this.wizard.getWizardController().getCurrentIndex() < this.componentListModel.indexOf(jTextPane)) {
                            if (!this.wizard.getWizardController().getCurrentPage().checkValid()) {
                                JOptionPane.showMessageDialog(this, MessageFormat.format(CteStringBank.cte_component_wizard_WizardDialog_key2.getI18n(), string));
                                return;
                            }
                            if (this.wizard.getWizardController().hasActiveNextPage()) {
                                return;
                            }
                            this.wizard.getWizardController().nextPage();
                            this.wizard.updateState();
                        }
                    }
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof JTextPane) {
                JTextPane jTextPane = (JTextPane)mouseEvent.getSource();
                if (this.oldRectangle != null) {
                    jTextPane.paintImmediately(this.oldRectangle);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof JTextPane) {
                JTextPane jTextPane = (JTextPane)mouseEvent.getSource();
                AttributeSet attributeSet = jTextPane.getCharacterAttributes();
                if (StyleConstants.isUnderline(attributeSet)) {
                    this.setCursor(this.handCursor);
                } else {
                    this.setCursor(this.defaultCursor);
                }
                Rectangle rectangle = jTextPane.getBounds();
                if (this.oldRectangle != null) {
                    jTextPane.paintImmediately(this.oldRectangle);
                }
                this.oldRectangle = rectangle;
                if (this.oldRectangle != null) {
                    jTextPane.paintImmediately(this.oldRectangle);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private static class WrappedCellRenderer
    extends JPanel
    implements ListCellRenderer {
        JTextArea ta = new JTextArea();
        JLabel numberLabel;
        int selected = -1;
        boolean contentNumbered;
        int taWidth;

        private WrappedCellRenderer(boolean bl, int n) {
            super(new BorderLayout());
            this.contentNumbered = bl;
            this.ta.setOpaque(false);
            this.ta.setEditable(false);
            this.ta.setLineWrap(true);
            this.ta.setWrapStyleWord(true);
            this.ta.setFont(UIManager.getFont("Label.font"));
            this.ta.getAccessibleContext().setAccessibleDescription("");
            this.taWidth = n - 12 - 12;
            this.numberLabel = new JLabel(){

                @Override
                protected void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    if (!contentNumbered) {
                        Rectangle rectangle = graphics.getClipBounds();
                        graphics.fillOval(rectangle.x, rectangle.y, 7, 7);
                    }
                }
            };
            this.numberLabel.setLabelFor(this.ta);
            this.numberLabel.setHorizontalAlignment(2);
            this.numberLabel.setVerticalAlignment(1);
            this.numberLabel.setFont(this.ta.getFont());
            this.numberLabel.setOpaque(false);
            this.numberLabel.setPreferredSize(new Dimension(25, 0));
            this.add((Component)this.numberLabel, "West");
            this.taWidth -= 25;
            Insets insets = this.ta.getInsets();
            this.ta.setSize(this.taWidth, insets.top + insets.bottom + 1);
            this.add((Component)this.ta, "Center");
            this.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12));
            this.setOpaque(false);
        }

        public void setHyperLink(boolean bl) {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (n == this.selected) {
                this.numberLabel.setFont(this.numberLabel.getFont().deriveFont(1));
                this.ta.setFont(this.ta.getFont().deriveFont(1));
            } else {
                this.numberLabel.setFont(this.numberLabel.getFont().deriveFont(0));
                this.ta.setFont(this.ta.getFont().deriveFont(0));
            }
            if (this.contentNumbered) {
                this.numberLabel.setText(Integer.toString(n + 1) + ".");
            }
            Insets insets = this.ta.getInsets();
            this.ta.setSize(this.taWidth, insets.top + insets.bottom + 1);
            this.ta.setText((String)object);
            return this;
        }

        private void setSelectedIndex(int n) {
            this.selected = n;
        }
    }

    private static class ImagedPanel
    extends JComponent
    implements Accessible {
        Image image;
        boolean isDefault = false;
        boolean north = false;

        public ImagedPanel(Image image) {
            this.setImage(image);
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (graphics instanceof Graphics2D) {
                Color color = UIManager.getColor("control");
                Color color2 = Color.white;
                Graphics2D graphics2D = (Graphics2D)graphics;
                Paint paint = graphics2D.getPaint();
                int n = this.getWidth();
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color2, n, this.getHeight(), color);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics2D.setPaint(paint);
            } else {
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.image != null) {
                // empty if block
            }
        }

        public void setImageAlignment(String string) {
            this.north = "North".equals(string);
        }

        public void setImage(Image image) {
            if (image != null) {
                this.image = image;
                this.isDefault = false;
                return;
            }
            if (!this.isDefault) {
                ImageIcon imageIcon = Utilities.getIcon("wizardbg.GIF");
                if (imageIcon != null) {
                    this.image = imageIcon.getImage();
                }
                this.isDefault = true;
            }
        }
    }
}

