/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.wizard;

import commvault.cte.component.Utilities;
import commvault.cte.component.wizard.IWizardController;
import commvault.cte.component.wizard.IWizardPage;
import commvault.cte.component.wizard.WizardDialog;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractWizardPage
extends JPanel
implements IWizardPage {
    Collection changeListeners = null;
    public static final Font TITLE_FONT = new Font("Dialog", 3, 16);
    protected WizardDialog wizard;
    protected JLabel titleLabel = new JLabel();
    protected JPanel headerPanel = new JPanel();
    protected JPanel componentPanel = new JPanel();
    private boolean isActivatedAlreadyCalled = false;
    protected JPanel footerPanel = new JPanel();
    private String helpLink;
    private boolean isFinishAllowed = false;
    public static int isNotifyOwners;

    public AbstractWizardPage(WizardDialog wizardDialog) {
        this.wizard = wizardDialog;
    }

    @Override
    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void setTitle(String string) {
        this.titleLabel.setText(string);
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public IWizardController getWizardController() {
        return this.wizard.getWizardController();
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new HashSet();
        }
        this.changeListeners.add(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(changeListener);
        }
    }

    protected void fireStateChanged() {
        if (this.changeListeners != null && this.changeListeners.size() != 0) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            Iterator iterator = this.changeListeners.iterator();
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged(changeEvent);
            }
        }
    }

    @Override
    public void help() {
        throw new UnsupportedOperationException("not implemented");
    }

    protected void addComponents() {
        this.setLayout(new GridBagLayout());
        this.addTitle();
        this.addHeaderPanel();
        this.addComponentsPanel();
        this.addFooterPanel();
    }

    protected void addTitle() {
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.titleLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.titleLabel.getForeground()));
        Utilities.getRightConstraints(18, true, 0);
        Utilities.addRow((Container)this, null, (JComponent)this.titleLabel, true);
    }

    protected void addHeaderPanel() {
        Utilities.addRow((Container)this, null, (JComponent)this.headerPanel, true);
    }

    protected void addFooterPanel() {
        Utilities.fillRemaining(this.footerPanel);
    }

    protected void addComponentsPanel() {
        Utilities.fillRemaining(this, this.componentPanel);
    }

    @Override
    public boolean canSkip() {
        return false;
    }

    @Override
    public String getHelpLink() {
        if (this.helpLink == null) {
            this.helpLink = "english-en-us-main-nt-NO_TOCHEADINGS.txt-" + this.wizard.getClass().getSimpleName() + "-" + this.getClass().getName().replaceAll("\\.", "_");
        }
        return this.helpLink;
    }

    @Override
    public void setHelpLink(String string) {
        this.helpLink = string;
    }

    public boolean isActivatedAlreadyCalled() {
        return this.isActivatedAlreadyCalled;
    }

    public void setActivatedAlreadyCalled(boolean bl) {
        this.isActivatedAlreadyCalled = bl;
    }

    @Override
    public boolean isFinishAllowed() {
        return this.isFinishAllowed;
    }

    public boolean finishOverrideModify() {
        return true;
    }

    public void setIsFinishAllowed(boolean bl) {
        this.isFinishAllowed = bl;
    }
}

