/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.tree;

import com.jidesoft.swing.TreeSearchable;
import commvault.cte.component.tree.CommNetTreeNode;
import commvault.cte.component.tree.Entity;
import commvault.cte.component.tree.EntityImpl;
import commvault.cte.component.tree.EntityTreeNode;
import commvault.msgs.CvEntities.EntityType;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeUtils {
    public static final String pathSeparator = new String("\\");

    public static CommNetTreeNode getNode(CommNetTreeNode commNetTreeNode, String string) {
        if (commNetTreeNode.isVirgin()) {
            commNetTreeNode.populate();
        }
        Enumeration<TreeNode> enumeration = commNetTreeNode.children();
        while (enumeration.hasMoreElements()) {
            CommNetTreeNode commNetTreeNode2 = (CommNetTreeNode)enumeration.nextElement();
            if (!commNetTreeNode2.toString().equals(string)) continue;
            return commNetTreeNode2;
        }
        return null;
    }

    public static String getStringPath(TreePath treePath) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < treePath.getPathCount(); ++i) {
            if (i != 0) {
                stringBuffer.append("\\");
            }
            stringBuffer.append(treePath.getPathComponent(i).toString());
        }
        return stringBuffer.toString();
    }

    public static String getStringPath(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append("\\");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static TreePath getTreePath(CommNetTreeNode commNetTreeNode, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, pathSeparator);
        TreePath treePath = new TreePath(commNetTreeNode);
        if (stringTokenizer.countTokens() == 1) {
            return treePath;
        }
        stringTokenizer.nextToken();
        CommNetTreeNode commNetTreeNode2 = commNetTreeNode;
        while (stringTokenizer.hasMoreTokens() && (commNetTreeNode2 = TreeUtils.getNode(commNetTreeNode2, stringTokenizer.nextToken())) != null) {
            treePath = treePath.pathByAddingChild(commNetTreeNode2);
        }
        return treePath;
    }

    public static boolean isDescendant(TreePath treePath, TreePath treePath2) {
        return TreeUtils.getStringPath(treePath).startsWith(TreeUtils.getStringPath(treePath2));
    }

    public static boolean isDescendant(String string, String string2) {
        return string.startsWith(string2);
    }

    public static String[] getPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, pathSeparator);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public static String[] getPath(TreePath treePath) {
        return TreeUtils.getPath(TreeUtils.getStringPath(treePath));
    }

    public static TreePath getPathFromRoot(DefaultMutableTreeNode defaultMutableTreeNode, TreePath treePath) {
        if (defaultMutableTreeNode.getParent() == null) {
            return TreeUtils.getPathFromRoot((TreePath)null, treePath);
        }
        return TreeUtils.getPathFromRoot(new TreePath(defaultMutableTreeNode.getPath()), treePath);
    }

    public static TreePath getPathFromRoot(TreePath treePath, TreePath treePath2) {
        if (treePath == null || !treePath.isDescendant(treePath2)) {
            return treePath2;
        }
        Object[] objectArray = new Object[treePath2.getPathCount() - treePath.getPathCount() + 1];
        System.arraycopy(treePath2.getPath(), treePath.getPathCount() - 1, objectArray, 0, objectArray.length);
        TreePath treePath3 = new TreePath(objectArray);
        return treePath3;
    }

    public static List<TreeNode> getLeafNodes(TreeNode treeNode) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        TreeUtils.findLeafNodes(treeNode, arrayList);
        return arrayList;
    }

    private static void findLeafNodes(TreeNode treeNode, List<TreeNode> list) {
        if (treeNode.isLeaf()) {
            list.add(treeNode);
        } else {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeUtils.findLeafNodes(enumeration.nextElement(), list);
            }
        }
    }

    public static void expandAll(JTree jTree) {
        TreeUtils.expandAll(jTree, true);
    }

    public static void expandAll(JTree jTree, boolean bl) {
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        TreeUtils.expandAll(jTree, new TreePath(treeNode), bl);
    }

    private static void expandAll(JTree jTree, TreePath treePath, boolean bl) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                TreeUtils.expandAll(jTree, treePath2, bl);
            }
        }
        if (bl) {
            jTree.expandPath(treePath);
        } else {
            jTree.collapsePath(treePath);
        }
    }

    public static void expandToShowParentsOfLeaves(JTree jTree) {
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        TreeUtils.expandToShowParentsOfLeaves(jTree, new TreePath(treeNode));
    }

    private static void expandToShowParentsOfLeaves(JTree jTree, TreePath treePath) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() > 0 && treeNode.getChildAt(0).isLeaf()) {
            return;
        }
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                TreeUtils.expandToShowParentsOfLeaves(jTree, treePath2);
            }
        }
        jTree.expandPath(treePath);
    }

    public static void expandPath(JTree jTree, TreePath treePath) {
        Object object = jTree.getModel().getRoot();
        if (object instanceof CommNetTreeNode) {
            CommNetTreeNode commNetTreeNode = (CommNetTreeNode)object;
            boolean bl = true;
            boolean bl2 = true;
            for (Object object2 : treePath.getPath()) {
                if (bl2) {
                    bl2 = false;
                    continue;
                }
                commNetTreeNode.populate();
                CommNetTreeNode commNetTreeNode2 = commNetTreeNode.getChildOfName(object2.toString());
                if (commNetTreeNode2 == null) {
                    bl = false;
                    return;
                }
                commNetTreeNode = commNetTreeNode2;
            }
            TreePath treePath2 = new TreePath(commNetTreeNode.getPath());
            if (bl && !jTree.isExpanded(treePath2)) {
                com.jidesoft.tree.TreeUtils.expandAll((JTree)jTree, (TreePath)treePath2, (boolean)false);
            }
        }
    }

    public static void expandNodesBasedonOnLevels(JTree jTree, TreePath treePath, int n, int n2, boolean bl) {
        if (jTree == null) {
            return;
        }
        if (bl && n <= n2 && n > 0) {
            return;
        }
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        TreeModel treeModel = jTree.getModel();
        if (treeModel.getChildCount(treeNode) >= 0) {
            for (int i = 0; i < treeModel.getChildCount(treeNode); ++i) {
                TreeNode treeNode2 = (TreeNode)treeModel.getChild(treeNode, i);
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                TreeUtils.expandNodesBasedonOnLevels(jTree, treePath2, n, n2 + 1, bl);
            }
            if (!bl && n2 < n) {
                return;
            }
        }
        if (bl) {
            jTree.expandPath(treePath);
        } else {
            jTree.collapsePath(treePath);
        }
    }

    public static TreeSearchable getDisplayNameTreeSearchable(JTree jTree) {
        TreeSearchable treeSearchable = new TreeSearchable(jTree){

            protected String convertElementToString(Object object) {
                try {
                    String string;
                    EntityImpl entityImpl;
                    Entity entity;
                    Object object2 = ((TreePath)object).getLastPathComponent();
                    if (object2 instanceof EntityTreeNode && (entity = ((EntityTreeNode)object2).getEntity()) instanceof EntityImpl && (entityImpl = (EntityImpl)entity).getNodeType().getNodeType() == EntityType.CLIENT_ENTITY.getEnumValue() && (string = entityImpl.getDisplayName()) != null && string.trim().length() > 0) {
                        return string;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return super.convertElementToString(object);
            }
        };
        return treeSearchable;
    }
}

