/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.tree;

import com.jgoodies.binding.beans.BeanAdapter;
import commvault.cte.component.Utilities;
import commvault.cte.component.tree.Entity;
import commvault.cte.component.tree.EntityContext;
import commvault.cte.component.tree.EntityTreeNode;
import commvault.cte.component.tree.NodeState;
import commvault.cte.component.tree.UnselectedChildrenHidable;
import commvault.msgs.CvEntities.EntityType;
import commvault.msgs.CvEntities.GenericEntity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class MultiStateTreeNode
extends EntityTreeNode
implements Iterable<MultiStateTreeNode> {
    protected NodeState state = NodeState.Null;
    protected NodeState newCheckBoxSelectionState = null;
    private int childExclusionCount = 0;
    private int childTotalSelectionCount = 0;
    protected NodeState oldState = NodeState.Null;

    public NodeState getNewCheckBoxSelectionState() {
        return this.newCheckBoxSelectionState;
    }

    public MultiStateTreeNode(Entity entity, EntityContext entityContext, boolean bl) {
        super(entity, entityContext, bl);
        this.setState(entity.isSelected() ? NodeState.Selected : NodeState.NotSelected);
    }

    public void setState(NodeState nodeState) {
        boolean bl;
        boolean bl2;
        this.nodeData.setSelected(nodeState == NodeState.Selected || nodeState == NodeState.SelectedWithExclusions);
        this.nodeData.setExcluded(nodeState == NodeState.Excluded);
        if (!(this.parent instanceof MultiStateTreeNode)) {
            return;
        }
        this.oldState = this.state;
        this.state = nodeState;
        if (this.oldState == nodeState || nodeState == NodeState.Null) {
            return;
        }
        MultiStateTreeNode multiStateTreeNode = (MultiStateTreeNode)this.parent;
        boolean bl3 = nodeState != NodeState.Null && (nodeState == NodeState.Excluded || nodeState == NodeState.ExcludedBecauseParentIsExcluded);
        boolean bl4 = nodeState != NodeState.Null && (nodeState == NodeState.Selected || nodeState == NodeState.SelectedBecauseParentIsSelected);
        boolean bl5 = bl2 = nodeState != NodeState.Null && nodeState != NodeState.NotSelected && !bl3;
        if (bl4) {
            ++multiStateTreeNode.childTotalSelectionCount;
        }
        if (bl2) {
            ++multiStateTreeNode.childSelectionCount;
        } else if (nodeState != NodeState.NotSelected && bl3) {
            ++multiStateTreeNode.childExclusionCount;
        }
        if (this.oldState == NodeState.Null) {
            return;
        }
        boolean bl6 = this.oldState != NodeState.Null && (this.oldState == NodeState.Excluded || this.oldState == NodeState.ExcludedBecauseParentIsExcluded);
        boolean bl7 = this.oldState != NodeState.Null && (this.oldState == NodeState.Selected || this.oldState == NodeState.SelectedBecauseParentIsSelected);
        boolean bl8 = bl = this.oldState != NodeState.Null && this.oldState != NodeState.NotSelected && !bl6;
        if (bl7 && multiStateTreeNode.childTotalSelectionCount != 0) {
            --multiStateTreeNode.childTotalSelectionCount;
        }
        if (bl && multiStateTreeNode.childSelectionCount != 0) {
            --multiStateTreeNode.childSelectionCount;
        } else if (bl6 && multiStateTreeNode.childExclusionCount != 0) {
            --multiStateTreeNode.childExclusionCount;
        }
    }

    public MultiStateTreeNode(Entity entity, EntityContext entityContext) {
        this(entity, entityContext, true);
    }

    @Override
    public void toggleSelection() {
        this.moveToNextState();
        if (this.getParent() instanceof UnselectedChildrenHidable) {
            ((UnselectedChildrenHidable)((Object)this.getParent())).resetSelectedIndex();
        }
    }

    protected NodeState getNextState(NodeState nodeState) {
        switch (nodeState) {
            case NotSelected: {
                return NodeState.Selected;
            }
            case Excluded: {
                return NodeState.SelectedBecauseParentIsSelected;
            }
            case SelectedBecauseParentIsSelected: {
                return NodeState.Excluded;
            }
            case Selected: {
                return NodeState.NotSelected;
            }
            case SelectedWithExclusions: {
                return NodeState.Selected;
            }
            case SelectedWithExclusionsBecOfParent: {
                return NodeState.SelectedBecauseParentIsSelected;
            }
            case PartiallySelected: {
                return NodeState.Selected;
            }
            case Null: {
                return NodeState.Selected;
            }
        }
        return this.state;
    }

    protected NodeState getNextStateForParent(NodeState nodeState) {
        NodeState nodeState2 = this.getParentState();
        switch (nodeState) {
            case NotSelected: {
                return NodeState.PartiallySelected;
            }
            case Excluded: {
                if (this.areAnySiblingsExcluded()) {
                    if (nodeState2 == NodeState.SelectedWithExclusionsBecOfParent) {
                        return NodeState.SelectedWithExclusionsBecOfParent;
                    }
                    return NodeState.SelectedWithExclusions;
                }
                if (nodeState2 == NodeState.SelectedBecauseParentIsSelected) {
                    return NodeState.SelectedBecauseParentIsSelected;
                }
                return NodeState.Selected;
            }
            case SelectedBecauseParentIsSelected: {
                if (nodeState2 == NodeState.SelectedBecauseParentIsSelected) {
                    return NodeState.SelectedWithExclusionsBecOfParent;
                }
                return NodeState.SelectedWithExclusions;
            }
            case Selected: {
                if (this.areAnySiblingsSelected()) {
                    return NodeState.PartiallySelected;
                }
                return NodeState.NotSelected;
            }
            case SelectedWithExclusions: {
                return this.getParentState();
            }
            case SelectedWithExclusionsBecOfParent: {
                return this.getParentState();
            }
            case PartiallySelected: {
                if (this.areAnySiblingsSelected()) {
                    return NodeState.PartiallySelected;
                }
                return NodeState.NotSelected;
            }
        }
        return this.state;
    }

    protected NodeState getNextStateForKids(NodeState nodeState) {
        switch (nodeState) {
            case NotSelected: {
                return NodeState.SelectedBecauseParentIsSelected;
            }
            case Excluded: {
                return NodeState.SelectedBecauseParentIsSelected;
            }
            case SelectedBecauseParentIsSelected: {
                return NodeState.ExcludedBecauseParentIsExcluded;
            }
            case Selected: {
                return NodeState.NotSelected;
            }
            case SelectedWithExclusions: 
            case SelectedWithExclusionsBecOfParent: 
            case PartiallySelected: {
                return NodeState.SelectedBecauseParentIsSelected;
            }
        }
        return this.state;
    }

    protected NodeState getParentState() {
        TreeNode treeNode = this.getParent();
        if (treeNode instanceof MultiStateTreeNode) {
            return ((MultiStateTreeNode)treeNode).state;
        }
        return NodeState.Null;
    }

    protected boolean areAnySiblingsSelected() {
        MultiStateTreeNode multiStateTreeNode = (MultiStateTreeNode)this.getParent();
        return multiStateTreeNode != null ? multiStateTreeNode.childSelectionCount > 0 : false;
    }

    protected boolean areAnySiblingsExcluded() {
        MultiStateTreeNode multiStateTreeNode = (MultiStateTreeNode)this.getParent();
        return multiStateTreeNode != null ? multiStateTreeNode.childExclusionCount > 0 : false;
    }

    protected boolean isParentFullySelected(MultiStateTreeNode multiStateTreeNode) {
        return multiStateTreeNode != null ? multiStateTreeNode.getChildCount() == multiStateTreeNode.childTotalSelectionCount && multiStateTreeNode.childExclusionCount == 0 : false;
    }

    private boolean isInSelectedState() {
        return this.state == NodeState.Selected || this.state == NodeState.SelectedBecauseParentIsSelected || this.state == NodeState.SelectedWithExclusions || this.state == NodeState.SelectedWithExclusionsBecOfParent;
    }

    private void moveToNextState(boolean bl) {
        NodeState nodeState = this.getNextState(this.state);
        NodeState nodeState2 = this.getNextStateForKids(this.state);
        if (nodeState == NodeState.Selected) {
            this.clearRelatedChildrenFromExclusionsAndSelections();
        } else if (nodeState == NodeState.NotSelected) {
            this.removeAllChildrenEntitySelections(this.nodeData);
            this.clearRelatedChildrenFromExclusionsAndSelections();
        }
        this.setNodeState(nodeState);
        if (bl) {
            this.setParentState(nodeState);
            Iterator<MultiStateTreeNode> iterator = this.iterator();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    MultiStateTreeNode multiStateTreeNode = iterator.next();
                    this.setChildState(multiStateTreeNode, nodeState2);
                }
            }
        }
        this.newCheckBoxSelectionState = nodeState;
    }

    private void removeAllChildrenEntitySelections(Entity entity) {
        if (entity.isSelected()) {
            entity.setSelected(false);
        }
        if (entity.getChildren() == null) {
            return;
        }
        for (Entity entity2 : entity.getChildren()) {
            this.removeAllChildrenEntitySelections(entity2);
        }
    }

    private void clearRelatedChildrenFromExclusionsAndSelections() {
        this.clearRelatedChildren(super.getEntityContext().getExcludedEntities());
        this.clearRelatedChildren(super.getEntityContext().getSelectedEntities());
    }

    private void clearRelatedChildren(List<GenericEntity> list) {
        ArrayList<GenericEntity> arrayList = new ArrayList<GenericEntity>();
        int n = this.getClientId(this.nodeData);
        if (this.nodeData.getNodeType().getNodeType() == EntityType.ALL_CLIENTS.ordinal()) {
            if (list != null) {
                for (GenericEntity genericEntity : list) {
                    if (genericEntity.getClientGroupId(false) != null && genericEntity.getClientGroupId(false) != 0) continue;
                    arrayList.add(genericEntity);
                }
            }
        } else if (this.nodeData.getNodeType().getNodeType() == EntityType.ALL_CLIENT_GROUPS_ENTITY.ordinal()) {
            if (list != null) {
                for (GenericEntity genericEntity : list) {
                    if (genericEntity.getClientGroupId(false) == null || genericEntity.getClientGroupId(false) <= 0) continue;
                    arrayList.add(genericEntity);
                }
            }
        } else if (list != null) {
            String string = this.nodeData.getNodeType().getIdDef();
            if (string == null) {
                return;
            }
            for (GenericEntity genericEntity : list) {
                BeanAdapter beanAdapter = new BeanAdapter((Object)genericEntity);
                Object object = beanAdapter.getValue(string);
                if (!object.equals(this.nodeData.getId()) || string.equals("applicationId") && genericEntity.getClientId() != n) continue;
                arrayList.add(genericEntity);
            }
        }
        if (list != null) {
            list.removeAll(arrayList);
        }
    }

    private int getClientId(Entity entity) {
        if (entity == null || entity.getNodeType().getIdDef() == null) {
            return 0;
        }
        if (entity.getNodeType().getIdDef().equals("clientId")) {
            return entity.getId();
        }
        return this.getClientId(entity.getParentEntity());
    }

    protected void setParentState(NodeState nodeState) {
        if (!(this.parent instanceof MultiStateTreeNode)) {
            return;
        }
        MultiStateTreeNode multiStateTreeNode = (MultiStateTreeNode)this.parent;
        if (multiStateTreeNode == null || multiStateTreeNode == this.getRoot()) {
            return;
        }
        NodeState nodeState2 = this.getParentState();
        NodeState nodeState3 = null;
        switch (nodeState) {
            case Selected: {
                if (nodeState2 == NodeState.NotSelected) {
                    nodeState3 = NodeState.PartiallySelected;
                    break;
                }
                if (nodeState2 != NodeState.SelectedWithExclusions) break;
                nodeState3 = NodeState.PartiallySelected;
                if (!this.areAnySiblingsExcluded()) break;
                nodeState3 = nodeState2;
                break;
            }
            case Excluded: {
                if (nodeState2 == NodeState.Selected || nodeState2 == NodeState.SelectedWithExclusions) {
                    nodeState3 = NodeState.SelectedWithExclusions;
                    break;
                }
                if (nodeState2 == NodeState.SelectedWithExclusionsBecOfParent) {
                    nodeState3 = nodeState2;
                    break;
                }
                if (nodeState2 != NodeState.SelectedBecauseParentIsSelected) break;
                nodeState3 = NodeState.SelectedWithExclusionsBecOfParent;
                break;
            }
            case ExcludedBecauseParentIsExcluded: {
                break;
            }
            case NotSelected: {
                if (this.areAnySiblingsSelected()) {
                    nodeState3 = NodeState.PartiallySelected;
                    break;
                }
                nodeState3 = NodeState.NotSelected;
                break;
            }
            case Null: {
                break;
            }
            case PartiallySelected: {
                nodeState3 = NodeState.PartiallySelected;
                break;
            }
            case SelectedBecauseParentIsSelected: {
                if (nodeState2 == NodeState.Selected || nodeState2 == NodeState.SelectedBecauseParentIsSelected) {
                    nodeState3 = nodeState2;
                    break;
                }
                if (nodeState2 == NodeState.SelectedWithExclusionsBecOfParent) {
                    if (this.areAnySiblingsExcluded()) {
                        nodeState3 = nodeState2;
                        break;
                    }
                    nodeState3 = NodeState.SelectedBecauseParentIsSelected;
                    break;
                }
                if (nodeState2 != NodeState.SelectedWithExclusions) break;
                if (multiStateTreeNode.nodeData.isSelected()) {
                    nodeState3 = NodeState.Selected;
                    break;
                }
                if (this.isParentFullySelected(multiStateTreeNode)) {
                    nodeState3 = NodeState.PartiallySelected;
                    break;
                }
                nodeState3 = nodeState2;
                break;
            }
            case SelectedWithExclusions: {
                nodeState3 = NodeState.PartiallySelected;
                break;
            }
            case SelectedWithExclusionsBecOfParent: {
                if (nodeState2 == NodeState.SelectedWithExclusionsBecOfParent) {
                    nodeState3 = nodeState2;
                    break;
                }
                if (nodeState2 == NodeState.Selected) {
                    nodeState3 = NodeState.SelectedWithExclusions;
                    break;
                }
                if (nodeState2 != NodeState.SelectedBecauseParentIsSelected) break;
                nodeState3 = NodeState.SelectedWithExclusionsBecOfParent;
            }
        }
        if (nodeState3 != null && nodeState3 != nodeState2) {
            multiStateTreeNode.setNodeState(nodeState3);
            multiStateTreeNode.setParentState(nodeState3);
        }
    }

    private boolean hasOtherExclusionChild(MultiStateTreeNode multiStateTreeNode) {
        Iterator<MultiStateTreeNode> iterator = multiStateTreeNode.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                MultiStateTreeNode multiStateTreeNode2 = iterator.next();
                if (multiStateTreeNode2 == this || !multiStateTreeNode2.isInExclusiondState()) continue;
                return true;
            }
        }
        return false;
    }

    private void setChildState(MultiStateTreeNode multiStateTreeNode, NodeState nodeState) {
        multiStateTreeNode.setNodeState(nodeState);
        multiStateTreeNode.newCheckBoxSelectionState = nodeState;
        Iterator<MultiStateTreeNode> iterator = multiStateTreeNode.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                MultiStateTreeNode multiStateTreeNode2 = iterator.next();
                this.setChildState(multiStateTreeNode2, nodeState);
            }
        }
    }

    public void moveToNextStateWithoutChangingParentsAndKidsState() {
        this.moveToNextState(false);
    }

    public void moveToNextState() {
        this.moveToNextState(true);
    }

    protected void setNodeState(NodeState nodeState) {
        if (this.state == nodeState) {
            return;
        }
        this.setState(nodeState);
        this.setTreeIcon(this.getIconForCurrentState());
    }

    public Icon getIconForCurrentState() {
        if (this.state == NodeState.Null) {
            this.state = this.getStateBasedOnParent();
        }
        if (this.nodeData.isRestricted() && this.getTreeIcon() != null && this.parent != this.getRoot()) {
            return this.getTreeIcon();
        }
        return Utilities.getIcon(this.state.getIcon());
    }

    protected NodeState getStateBasedOnParent() {
        NodeState nodeState = NodeState.Null;
        TreeNode treeNode = this.getParent();
        if (!(treeNode instanceof MultiStateTreeNode)) {
            return NodeState.Null;
        }
        MultiStateTreeNode multiStateTreeNode = (MultiStateTreeNode)treeNode;
        if (multiStateTreeNode != this.getRoot() && multiStateTreeNode != null) {
            nodeState = multiStateTreeNode.state;
            while (multiStateTreeNode != null && nodeState == NodeState.Null) {
                if ((multiStateTreeNode = (MultiStateTreeNode)multiStateTreeNode.getParent()) == null) continue;
                nodeState = multiStateTreeNode.state;
            }
        }
        if (nodeState == NodeState.Null) {
            return NodeState.NotSelected;
        }
        if (nodeState == NodeState.Selected || nodeState == NodeState.SelectedBecauseParentIsSelected) {
            return NodeState.SelectedBecauseParentIsSelected;
        }
        if (nodeState == NodeState.SelectedWithExclusions || nodeState == NodeState.SelectedWithExclusionsBecOfParent) {
            return NodeState.SelectedWithExclusionsBecOfParent;
        }
        return nodeState;
    }

    private boolean isInExcludedState() {
        return this.state == NodeState.Excluded || this.state == NodeState.ExcludedBecauseParentIsExcluded;
    }

    private boolean isInExclusiondState() {
        return this.state == NodeState.Excluded || this.state == NodeState.ExcludedBecauseParentIsExcluded || this.state == NodeState.SelectedWithExclusions || this.state == NodeState.SelectedWithExclusionsBecOfParent;
    }

    @Override
    public Iterator<MultiStateTreeNode> iterator() {
        if (super.getChildren() != null && !super.getChildren().isEmpty() && super.getChildren().get(0) instanceof MultiStateTreeNode) {
            return new Vector<EntityTreeNode>(super.getChildren()).iterator();
        }
        return this.children != null && this.children.size() > 0 ? new Vector(this.children).iterator() : null;
    }

    @Override
    public void setSelected(boolean bl) {
        super.setSelected(bl);
    }

    @Override
    public boolean isSelected() {
        return this.state == NodeState.Selected || this.state == NodeState.SelectedWithExclusions || this.state == NodeState.SelectedBecauseParentIsSelected;
    }

    public boolean isNodeSelectionState() {
        if (this.nodeData.getNodeType().getNodeType() == EntityType.ROOT_ENTITY.getEnumValue()) {
            if (this.children != null) {
                for (Object e : this.children) {
                    if (!(e instanceof MultiStateTreeNode) || ((MultiStateTreeNode)e).state == NodeState.NotSelected || ((MultiStateTreeNode)e).state == NodeState.Null) continue;
                    return true;
                }
            }
            return false;
        }
        return this.state != NodeState.NotSelected && this.state != NodeState.Null;
    }

    public boolean isExcluded() {
        return this.state == NodeState.Excluded;
    }

    @Override
    public void applyState(int n) {
        if (n == 3) {
            this.state = NodeState.NotSelected;
        } else if (n == 1) {
            this.state = NodeState.PartiallySelected;
        } else if (n == 2) {
            this.state = NodeState.Selected;
        } else if (n == 0) {
            this.state = NodeState.NotSelected;
        }
    }

    @Override
    public void updateNodeState() {
        if (!this.isVisible()) {
            return;
        }
        NodeState nodeState = null;
        if (this.getParent() instanceof MultiStateTreeNode) {
            nodeState = ((MultiStateTreeNode)this.getParent()).newCheckBoxSelectionState;
        }
        if (nodeState != null) {
            if (nodeState == NodeState.NotSelected || nodeState == NodeState.Null) {
                this.setNodeState(NodeState.NotSelected);
                this.newCheckBoxSelectionState = NodeState.NotSelected;
                return;
            }
            if (nodeState == NodeState.Selected || nodeState == NodeState.SelectedBecauseParentIsSelected) {
                this.setNodeState(NodeState.SelectedBecauseParentIsSelected);
                this.newCheckBoxSelectionState = NodeState.SelectedBecauseParentIsSelected;
                return;
            }
            if (nodeState == NodeState.Excluded || nodeState == NodeState.ExcludedBecauseParentIsExcluded) {
                this.setNodeState(NodeState.ExcludedBecauseParentIsExcluded);
                this.newCheckBoxSelectionState = NodeState.ExcludedBecauseParentIsExcluded;
                return;
            }
        }
        if (this.isEntityExcluded(this.nodeData)) {
            this.nodeData.setExcluded(true);
        }
        if (this.nodeData.isExcluded()) {
            this.setNodeState(NodeState.Excluded);
        } else if (this.nodeData.isSelected()) {
            if (this.isAnyChildExcluded(this.nodeData)) {
                this.setNodeState(NodeState.SelectedWithExclusions);
            } else {
                NodeState nodeState2 = this.getParentState();
                if (nodeState2 == NodeState.PartiallySelected && this.parent != null && this.parent.getChildCount() == 1 && !this.nodeData.getAssociationSelectionState()) {
                    this.setNodeState(NodeState.PartiallySelected);
                } else {
                    this.setNodeState(NodeState.Selected);
                }
            }
        } else if (this.isChildEntitySelected(this.nodeData)) {
            this.setNodeState(NodeState.PartiallySelected);
        } else if (this.isAnyChildExcluded(this.nodeData)) {
            this.setNodeState(NodeState.SelectedWithExclusionsBecOfParent);
        } else if (this.nodeData.getChildren() == null || this.nodeData.getChildren().isEmpty()) {
            boolean bl;
            NodeState nodeState3 = this.getParentState();
            boolean bl2 = bl = this.parent instanceof MultiStateTreeNode ? ((MultiStateTreeNode)this.parent).nodeData.getAssociationSelectionState() : false;
            if (bl || nodeState3 == NodeState.SelectedWithExclusions || nodeState3 == NodeState.SelectedWithExclusionsBecOfParent || nodeState3 == NodeState.SelectedBecauseParentIsSelected) {
                this.setNodeState(NodeState.SelectedBecauseParentIsSelected);
            } else if (nodeState3 == NodeState.Excluded || nodeState3 == NodeState.ExcludedBecauseParentIsExcluded) {
                this.setNodeState(NodeState.ExcludedBecauseParentIsExcluded);
            } else {
                this.setNodeState(NodeState.NotSelected);
            }
        } else {
            this.setNodeState(this.getStateBasedOnParent());
        }
        this.setParentState(this.state);
    }

    public void updateEntityState(boolean bl) {
        int n;
        if (this.nodeData.isRestricted()) {
            return;
        }
        if (this.isExcluded()) {
            this.nodeData.setExcluded(true);
        }
        if (this.isSelected()) {
            this.nodeData.setSelected(true);
        }
        if ((n = this.getChildCount()) > 0) {
            for (int i = 0; i < n; ++i) {
                MultiStateTreeNode multiStateTreeNode = (MultiStateTreeNode)this.getChildAt(i);
                multiStateTreeNode.updateEntityState(true);
            }
        }
    }

    @Override
    protected boolean isChildEntitySelected(Entity entity) {
        if (entity.isSelected() && !entity.isExcluded()) {
            return true;
        }
        if (entity.getChildren() == null) {
            return false;
        }
        for (Entity entity2 : entity.getChildren()) {
            if (!this.isChildEntitySelected(entity2)) continue;
            return true;
        }
        return false;
    }

    public NodeState getCurrentState() {
        return this.state;
    }

    public boolean isPartiallySelected() {
        return this.state == NodeState.PartiallySelected;
    }

    public void setnewCheckBoxSelectionState(NodeState nodeState) {
        this.newCheckBoxSelectionState = nodeState;
        if (this.getParent() instanceof UnselectedChildrenHidable) {
            ((UnselectedChildrenHidable)((Object)this.getParent())).resetSelectedIndex();
        }
    }

    public void setChildExclusionCount(int n) {
        this.childExclusionCount = n;
    }

    public int getChildExclusionCount() {
        return this.childExclusionCount;
    }
}

