/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.tree;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.SearchableBar;
import com.jidesoft.swing.TreeSearchable;
import commvault.cte.component.ComponentComboEditor;
import commvault.cte.component.CompoundIcon;
import commvault.cte.component.Utilities;
import commvault.cte.component.tree.CVFilterableTreeModel;
import commvault.cte.component.tree.CommNetBrowseBaseNode;
import commvault.cte.component.tree.EntityImpl;
import commvault.cte.component.tree.EntityTreeNode;
import commvault.cte.component.tree.EntityTreeSelectionListener;
import commvault.cte.component.tree.MultiStateTreeNode;
import commvault.cte.component.tree.TreeUtils;
import commvault.cte.util.Logger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class EntityTree
extends JTree
implements TreeWillExpandListener,
ComponentComboEditor {
    protected boolean populate = true;
    public static final String STATE_CHANGE = "stateChange";
    ValueHolder selection = new ValueHolder();
    private EntityTreeSelectionListener selectionListener;
    private CommNetBrowseBaseNode rootNode;
    private SearchableBar searchBar;
    private JPanel searchbarPanel;
    private Map<KeyStroke, ActionListener> keyboardShortcutMap;
    private final KeyStroke showSearchBarKeyStroke = KeyStroke.getKeyStroke(70, 128);
    private INodeSelection iNodeSelection;

    public EntityTree(CommNetBrowseBaseNode commNetBrowseBaseNode) {
        this(commNetBrowseBaseNode, true);
    }

    public EntityTree(CommNetBrowseBaseNode commNetBrowseBaseNode, boolean bl) {
        this(commNetBrowseBaseNode, bl, null);
    }

    public EntityTree(CommNetBrowseBaseNode commNetBrowseBaseNode, boolean bl, EntityTreeSelectionListener entityTreeSelectionListener) {
        this(commNetBrowseBaseNode, bl, entityTreeSelectionListener, true);
    }

    public EntityTree(CommNetBrowseBaseNode commNetBrowseBaseNode, boolean bl, EntityTreeSelectionListener entityTreeSelectionListener, boolean bl2) {
        commNetBrowseBaseNode.setTree(this);
        this.rootNode = commNetBrowseBaseNode;
        this.selectionListener = entityTreeSelectionListener;
        this.setModel(new CVFilterableTreeModel(commNetBrowseBaseNode));
        this.setRootVisible(false);
        this.setCellRenderer(new QNetTreeRenderer());
        this.addTreeWillExpandListener(this);
        this.resetRowHeight();
        if (bl) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (EntityTree.this.isTriStateClick(mouseEvent) && EntityTree.this.isEnabled()) {
                        EntityTree.this.toggleSelection((CommNetBrowseBaseNode)EntityTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()).getLastPathComponent());
                    }
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (EntityTree.this.getSelectionPath() == null) {
                        return;
                    }
                    Object object = EntityTree.this.getSelectionPath().getLastPathComponent();
                    if (object != null && object instanceof CommNetBrowseBaseNode) {
                        CommNetBrowseBaseNode commNetBrowseBaseNode = (CommNetBrowseBaseNode)object;
                        if (keyEvent.getKeyChar() == '\n' && keyEvent.isControlDown()) {
                            keyEvent.consume();
                            EntityTree.this.toggleSelection(commNetBrowseBaseNode);
                        }
                    }
                }
            });
            if (bl2) {
                this.expandRootChilds();
            }
        }
    }

    private void resetRowHeight() {
        Utilities.resetRowHeight(this);
    }

    protected boolean isParentAndAllSiblingsSelected(CommNetBrowseBaseNode commNetBrowseBaseNode) {
        return true;
    }

    public void setSelection(CommNetBrowseBaseNode commNetBrowseBaseNode) {
        this.toggleSelection(commNetBrowseBaseNode);
    }

    protected void toggleSelection(CommNetBrowseBaseNode commNetBrowseBaseNode) {
        if (commNetBrowseBaseNode instanceof EntityTreeNode && ((EntityTreeNode)commNetBrowseBaseNode).getEntity().isRestricted()) {
            return;
        }
        if (commNetBrowseBaseNode != null && commNetBrowseBaseNode.isEnabled()) {
            commNetBrowseBaseNode.toggleSelection();
            this.firePropertyChange(STATE_CHANGE, null, commNetBrowseBaseNode);
        }
        if (this.selectionListener != null) {
            this.selectionListener.nodeSelectionChanged(this.rootNode);
        }
        if (this.iNodeSelection != null) {
            this.iNodeSelection.fireNodeSelected((EntityTreeNode)commNetBrowseBaseNode);
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        if (this.populate) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            CommNetBrowseBaseNode commNetBrowseBaseNode = (CommNetBrowseBaseNode)treeExpansionEvent.getPath().getLastPathComponent();
            long l = System.currentTimeMillis();
            commNetBrowseBaseNode.populate();
            Logger.write(Logger.JC, this, "Loading time", new Integer((int)((System.currentTimeMillis() - l) / 60000L)));
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void expandRootChilds() {
        TreeNode treeNode = (TreeNode)this.getModel().getRoot();
        if (treeNode.getChildCount() > 0) {
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                this.expandPath(new TreePath(((DefaultMutableTreeNode)treeNode.getChildAt(i)).getPath()));
            }
        }
    }

    public void expandAll(boolean bl) {
        TreeUtils.expandAll(this, bl);
    }

    public void expandBasedOnLevel(int n, int n2) {
        TreeNode treeNode = (TreeNode)this.getModel().getRoot();
        TreeUtils.expandNodesBasedonOnLevels(this, new TreePath(treeNode), n, n2, true);
    }

    public void expandSelectedAndLoadedNodes(TreeNode treeNode) {
        if (treeNode.getChildCount() > 0) {
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                TreeNode treeNode2 = treeNode.getChildAt(i);
                if (treeNode2 instanceof MultiStateTreeNode) {
                    if (!((MultiStateTreeNode)treeNode2).isNodeSelectionState() || ((MultiStateTreeNode)treeNode2).isVirgin()) continue;
                    this.expandPath(new TreePath(((DefaultMutableTreeNode)treeNode2).getPath()));
                    this.expandSelectedAndLoadedNodes(treeNode2);
                    continue;
                }
                if (!(treeNode2 instanceof CommNetBrowseBaseNode) || ((CommNetBrowseBaseNode)treeNode2).getTriState() != 2 && ((CommNetBrowseBaseNode)treeNode2).getTriState() != 1) continue;
                this.expandPath(new TreePath(((DefaultMutableTreeNode)treeNode2).getPath()));
                this.expandSelectedAndLoadedNodes(treeNode2);
            }
        }
    }

    public boolean isTriStateClick(MouseEvent mouseEvent) {
        mouseEvent.getX();
        try {
            TreePath treePath = this.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            Rectangle rectangle = this.getPathBounds(treePath);
            rectangle.width = rectangle.height;
            return rectangle.contains(mouseEvent.getPoint());
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public JComponent getEditor() {
        return this;
    }

    @Override
    public ValueModel getSelectionValueModel() {
        return this.selection;
    }

    public void setPopulate(boolean bl) {
        this.populate = bl;
    }

    public JPanel getSearchBar() {
        this.searchbarPanel = new JPanel(new BorderLayout());
        TreeSearchable treeSearchable = TreeUtils.getDisplayNameTreeSearchable(this);
        treeSearchable.setRecursive(true);
        treeSearchable.setFromStart(false);
        this.searchBar = new SearchableBar((Searchable)treeSearchable);
        this.searchBar.setCompact(true);
        this.searchBar.setInstaller(new SearchableBar.Installer(){

            public void openSearchBar(SearchableBar searchableBar) {
                EntityTree.this.searchbarPanel.add((Component)searchableBar, "Center");
                EntityTree.this.searchbarPanel.invalidate();
                EntityTree.this.searchbarPanel.revalidate();
            }

            public void closeSearchBar(SearchableBar searchableBar) {
                EntityTree.this.searchbarPanel.removeAll();
                EntityTree.this.searchbarPanel.invalidate();
                EntityTree.this.searchbarPanel.revalidate();
            }
        });
        this.initializeKeyboardShortcuts();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EntityTree.this.searchBar.focusSearchField();
            }
        });
        this.searchBar.getInstaller().openSearchBar(this.searchBar);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                ((TreeSearchable)EntityTree.this.searchBar.getSearchable()).treeNodesChanged(new TreeModelEvent((Object)this, treeExpansionEvent.getPath()));
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }
        });
        return this.searchbarPanel;
    }

    public void setSearchbarButtons(int n) {
        if (this.searchBar != null) {
            this.searchBar.setVisibleButtons(n);
        }
    }

    private void initializeKeyboardShortcuts() {
        this.keyboardShortcutMap = new HashMap<KeyStroke, ActionListener>();
        this.keyboardShortcutMap.put(this.showSearchBarKeyStroke, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntityTree.this.searchBar.getInstaller().openSearchBar(EntityTree.this.searchBar);
                EntityTree.this.searchBar.focusSearchField();
            }
        });
        this.keyboardShortcutMap.put(KeyStroke.getKeyStroke(27, 0, false), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntityTree.this.searchbarPanel.removeAll();
                EntityTree.this.searchbarPanel.invalidate();
                EntityTree.this.searchbarPanel.revalidate();
            }
        });
        this.registerKeyboardShortcuts(this);
    }

    public void registerKeyboardShortcuts(JComponent jComponent) {
        if (jComponent != null) {
            for (Map.Entry<KeyStroke, ActionListener> entry : this.keyboardShortcutMap.entrySet()) {
                jComponent.registerKeyboardAction(entry.getValue(), entry.getKey(), 1);
            }
        }
    }

    public void setINodeSelection(INodeSelection iNodeSelection) {
        this.iNodeSelection = iNodeSelection;
    }

    public static interface INodeSelection {
        public void fireNodeSelected(EntityTreeNode var1);
    }

    public static class QNetTreeRenderer
    extends DefaultTreeCellRenderer {
        private static final int ILM_CLASS = 8;

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof CommNetBrowseBaseNode && component.isEnabled()) {
                EntityImpl entityImpl;
                CommNetBrowseBaseNode commNetBrowseBaseNode = (CommNetBrowseBaseNode)object;
                Icon icon = commNetBrowseBaseNode.getTreeIcon();
                if (object instanceof MultiStateTreeNode) {
                    icon = ((MultiStateTreeNode)object).getIconForCurrentState();
                } else if (object instanceof EntityTreeNode) {
                    if ((((EntityTreeNode)object).getEntity().getFlags() & 8) > 0) {
                        icon = new CompoundIcon(icon, Utilities.getIcon("DCA_Installed_16x16.gif"), 2);
                    } else if (((EntityTreeNode)object).getEntity().isRestricted() && (((EntityTreeNode)object).getTriState() == 0 || ((EntityTreeNode)object).getTriState() == -1)) {
                        icon = CommNetBrowseBaseNode.EMPTY_DISABLED_ICON;
                    } else if (((EntityTreeNode)object).getEntity().isRestricted() && ((EntityTreeNode)object).getTriState() == 1) {
                        icon = CommNetBrowseBaseNode.HALF_DISABLED_ICON;
                    } else if (((EntityTreeNode)object).getEntity().isRestricted() && ((EntityTreeNode)object).getTriState() == 2) {
                        icon = CommNetBrowseBaseNode.FULL_DISABLED_ICON;
                    } else if (((EntityTreeNode)object).getTriState() == -1) {
                        icon = CommNetBrowseBaseNode.EMPTY_ICON;
                    }
                }
                if (object instanceof EntityTreeNode && ((EntityTreeNode)object).getEntity() instanceof EntityImpl && (entityImpl = (EntityImpl)((EntityTreeNode)object).getEntity()).getDisplayName() != null) {
                    this.setText(entityImpl.getDisplayName());
                }
                this.setIcon(icon);
                this.setDisabledIcon(icon);
                component.setEnabled(commNetBrowseBaseNode.isEnabled());
            }
            return component;
        }
    }
}

