/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.tree;

import commvault.cte.component.tree.CommTreeCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.BevelBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DynamicTree
extends JPanel {
    public JTree tree;

    public DynamicTree(TreeModel treeModel) {
        this.tree = new JTree();
        this.tree.setModel(treeModel);
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(false);
        this.tree.setScrollsOnExpand(true);
        this.tree.setCellRenderer(new CommTreeCellRenderer());
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setBorder(new BevelBorder(1));
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
        this.tree.setDoubleBuffered(false);
    }

    public DynamicTree() {
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.tree.addMouseListener(mouseListener);
        super.addMouseListener(mouseListener);
    }

    public JTree getTree() {
        return this.tree;
    }

    public void clearup() {
        this.tree.getParent().remove(this.tree);
        ToolTipManager.sharedInstance().unregisterComponent(this.tree);
        this.tree.getUI().uninstallUI(this);
        ((DefaultTreeModel)this.tree.getModel()).setRoot(new DefaultMutableTreeNode());
        this.tree.getSelectionModel().setSelectionPath(null);
        this.tree.setSelectionPath(null);
        this.tree.setSelectionModel(null);
        this.tree.setModel(null);
        this.tree = null;
    }

    public TreePath getSelectionPath() {
        return this.tree.getSelectionPath();
    }

    public TreeNode getSelectedNode() {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null) {
            return (TreeNode)treePath.getLastPathComponent();
        }
        return null;
    }

    void resetTreeSelection(MouseEvent mouseEvent) {
        int n = -1;
        TreePath treePath = null;
        try {
            n = this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        }
        catch (Exception exception) {
            return;
        }
        if (n != -1 && mouseEvent.getClickCount() == 1) {
            this.tree.setSelectionPath(treePath);
        }
    }
}

