/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.tooolbar;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

class FakeSheetWindowListener
implements ComponentListener {
    Point lastLocation;
    Window window1;
    Window window2;
    JComponent modalCover;
    JComponent dialogAnchor;

    public FakeSheetWindowListener(Window window, Window window2, JComponent jComponent, JComponent jComponent2) {
        this.lastLocation = window.getLocation();
        this.window1 = window;
        this.window2 = window2;
        this.modalCover = jComponent2;
        this.dialogAnchor = jComponent;
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        Point point = this.window1.getLocation();
        FakeSheetWindowListener.translate(this.window2, point.x - this.lastLocation.x, point.y - this.lastLocation.y);
        this.lastLocation = point;
    }

    public static void translate(Window window, int n, int n2) {
        Point point = window.getLocation();
        point.x += n;
        point.y += n2;
        window.setLocation(point);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.modalCover.setSize(this.window1.getSize());
        this.repositionDialog();
    }

    protected void repositionDialog() {
        Point point = new Point(0, 0);
        point = SwingUtilities.convertPoint(this.dialogAnchor, point, this.window1);
        Rectangle rectangle = new Rectangle(this.dialogAnchor.getWidth() / 2 - this.window2.getWidth() / 2 + this.window1.getX(), point.y + this.dialogAnchor.getHeight() + 5 + this.window1.getY(), this.window2.getWidth(), this.window2.getHeight());
        SwingUtilities.convertRectangle(this.dialogAnchor, rectangle, this.window1);
        this.window2.setBounds(rectangle);
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }
}

