/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.table.link;

import commvault.cte.component.table.filter.FilterColumnType;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;

public class LinkModel
extends FilterColumnType<LinkModel> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(LinkModel.class.getName());
    protected String text;
    public int msgNum;
    public int subSysNum;
    protected URL url;
    protected String target;
    private boolean visited = false;
    private PropertyChangeSupport propertyChangeSupport;
    public static final String VISITED_PROPERTY = "visited";
    private static String defaultURLString = "https://jdnc.dev.java.net";
    private static URL defaultURL;

    public LinkModel(int n, int n2, String string, String string2, URL uRL) {
        this.subSysNum = n;
        this.msgNum = n2;
        this.setText(string);
        this.setTarget(string2);
        this.setURL(uRL != null ? uRL : this.getDefaultURL());
    }

    public LinkModel(String string, String string2, URL uRL) {
        this.setText(string);
        this.setTarget(string2);
        this.setURL(uRL != null ? uRL : this.getDefaultURL());
    }

    public LinkModel() {
        this(" ", null, null);
    }

    public LinkModel(String string) {
        this(string, null, null);
    }

    public LinkModel(String string, String string2, String string3, String[] stringArray) {
        this.setText(string);
        this.setTarget(string2);
        this.setURL(this.createURL(string3, stringArray));
    }

    public void setText(String string) {
        String string2 = this.getText();
        this.text = string;
        this.firePropertyChange("text", string2, this.getText());
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        if (this.url != null) {
            return this.getURL().toString();
        }
        return null;
    }

    public void setURLString(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = this.getDefaultURL();
            LOG.warning("the given urlString is malformed: " + string + "\n falling back to default url: " + uRL);
        }
        this.setURL(uRL);
    }

    private URL getDefaultURL() {
        if (defaultURL == null) {
            try {
                defaultURL = new URL(defaultURLString);
            }
            catch (MalformedURLException malformedURLException) {
                LOG.fine("should not happen - defaultURL is wellFormed: " + defaultURLString);
            }
        }
        return defaultURL;
    }

    public void setURL(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("URL for link cannot be null");
        }
        if (uRL.equals(this.getURL())) {
            return;
        }
        URL uRL2 = this.getURL();
        this.url = uRL;
        this.firePropertyChange("URL", uRL2, uRL);
        this.setVisited(false);
    }

    public URL getURL() {
        return this.url;
    }

    private URL createURL(String string, String[] stringArray) {
        URL uRL = null;
        try {
            String string2 = string;
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = string2.replaceAll("@\\{" + (i + 1) + "\\}", stringArray[i]);
            }
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public String getTarget() {
        if (this.target != null) {
            return this.target;
        }
        return "_blank";
    }

    public void setVisited(boolean bl) {
        boolean bl2 = this.getVisited();
        this.visited = bl;
        this.firePropertyChange(VISITED_PROPERTY, bl2, this.getVisited());
    }

    public boolean getVisited() {
        return this.visited;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange(string, bl, bl2);
    }

    private PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    @Override
    public int compareTo(LinkModel linkModel) {
        if (linkModel == null) {
            return 1;
        }
        if (linkModel instanceof LinkModel) {
            LinkModel linkModel2 = linkModel;
            long l = linkModel2.subSysNum;
            l <<= 32;
            long l2 = this.subSysNum;
            l2 <<= 32;
            if ((l2 |= (long)this.msgNum) < (l |= (long)linkModel2.msgNum)) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this != null && object.toString().equalsIgnoreCase(this.toString())) {
            return true;
        }
        if (object != null && object instanceof LinkModel) {
            LinkModel linkModel = (LinkModel)object;
            if (!this.getText().equals(linkModel.getText())) {
                return false;
            }
            if (!this.getTarget().equals(linkModel.getTarget())) {
                return false;
            }
            return this.getURL().equals(linkModel.getURL());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 7;
        n = 37 * n + (this.getText() == null ? 0 : this.getText().hashCode());
        n = 37 * n + (this.getTarget() == null ? 1 : this.getTarget().hashCode());
        return n;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append("url=");
        stringBuffer.append(this.url);
        stringBuffer.append(", target=");
        stringBuffer.append(this.target);
        stringBuffer.append(", text=");
        stringBuffer.append(this.text);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

