/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.table.link;

import commvault.cte.component.table.link.LinkModel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;

public class LinkController
implements PropertyChangeListener {
    public static final String EXECUTE_BUTTON_ACTIONCOMMAND = "executeButtonAction";
    private Cursor oldCursor;
    private JTable table;

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("swingx.rollover".equals(propertyChangeEvent.getPropertyName())) {
            this.rollover((JTable)propertyChangeEvent.getSource(), (Point)propertyChangeEvent.getOldValue(), (Point)propertyChangeEvent.getNewValue());
        } else if ("swingx.clicked".equals(propertyChangeEvent.getPropertyName())) {
            this.click((JTable)propertyChangeEvent.getSource(), (Point)propertyChangeEvent.getOldValue(), (Point)propertyChangeEvent.getNewValue());
        }
    }

    public void install(JTable jTable) {
        this.release();
        this.table = jTable;
        jTable.addPropertyChangeListener(this);
        this.registerExecuteButtonAction();
    }

    public void release() {
        if (this.table == null) {
            return;
        }
        this.table.removePropertyChangeListener(this);
        this.unregisterExecuteButtonAction();
    }

    private void rollover(JTable jTable, Point point, Point point2) {
        Rectangle rectangle;
        if (point != null) {
            rectangle = jTable.getCellRect(point.y, point.x, false);
            rectangle.x = 0;
            rectangle.width = jTable.getWidth();
            jTable.repaint(rectangle);
        }
        if (point2 != null) {
            rectangle = jTable.getCellRect(point2.y, point2.x, false);
            rectangle.x = 0;
            rectangle.width = jTable.getWidth();
            jTable.repaint(rectangle);
        }
        this.setLinkCursor(jTable, point2);
    }

    private void click(JTable jTable, Point point, Point point2) {
        if (!this.isLinkColumn(jTable, point2)) {
            return;
        }
        if (jTable.isCellEditable(point2.y, point2.x)) {
            return;
        }
        TableCellRenderer tableCellRenderer = jTable.getCellRenderer(point2.y, point2.x);
        Component component = jTable.prepareRenderer(tableCellRenderer, point2.y, point2.x);
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).doClick();
            jTable.repaint();
        }
    }

    private void setLinkCursor(JTable jTable, Point point) {
        if (this.isLinkColumn(jTable, point)) {
            if (this.oldCursor == null) {
                this.oldCursor = jTable.getCursor();
                jTable.setCursor(Cursor.getPredefinedCursor(12));
            }
        } else if (this.oldCursor != null) {
            jTable.setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    private boolean isLinkColumn(JTable jTable, Point point) {
        if (point == null || point.x < 0) {
            return false;
        }
        return jTable.getColumnClass(point.x) == LinkModel.class;
    }

    private void unregisterExecuteButtonAction() {
        this.table.getActionMap().put(EXECUTE_BUTTON_ACTIONCOMMAND, null);
        KeyStroke keyStroke = KeyStroke.getKeyStroke("released SPACE");
        this.table.getInputMap(1).put(keyStroke, null);
    }

    private void registerExecuteButtonAction() {
        this.table.getActionMap().put(EXECUTE_BUTTON_ACTIONCOMMAND, this.createExecuteButtonAction());
        KeyStroke keyStroke = KeyStroke.getKeyStroke("released SPACE");
        this.table.getInputMap(1).put(keyStroke, EXECUTE_BUTTON_ACTIONCOMMAND);
    }

    private Action createExecuteButtonAction() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = this.getClickableRendererComponent();
                if (abstractButton != null) {
                    abstractButton.doClick();
                    LinkController.this.table.repaint();
                }
            }

            @Override
            public boolean isEnabled() {
                return this.isClickable();
            }

            private boolean isClickable() {
                return this.getClickableRendererComponent() != null;
            }

            private AbstractButton getClickableRendererComponent() {
                if (LinkController.this.table == null || !LinkController.this.table.isEnabled() || !LinkController.this.table.hasFocus()) {
                    return null;
                }
                int n = LinkController.this.table.getSelectionModel().getLeadSelectionIndex();
                int n2 = LinkController.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                if (n < 0 || n2 < 0 || LinkController.this.table.isCellEditable(n, n2)) {
                    return null;
                }
                TableCellRenderer tableCellRenderer = LinkController.this.table.getCellRenderer(n, n2);
                Component component = LinkController.this.table.prepareRenderer(tableCellRenderer, n, n2);
                return component instanceof AbstractButton ? (AbstractButton)component : null;
            }
        };
        return abstractAction;
    }
}

