/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.table;

import commvault.cte.component.table.IPathHandler;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.TableModel;

public class TableUtils {
    private static IPathHandler iPathHandler;

    public static synchronized IPathHandler getIPathHadler() {
        if (iPathHandler != null && !iPathHandler.isEnabled()) {
            iPathHandler = null;
        }
        return iPathHandler;
    }

    public static String convertToString(TableModel tableModel, char c, int n, int n2) {
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 0) {
            for (n3 = 0; n3 < tableModel.getColumnCount(); ++n3) {
                String string = tableModel.getColumnName(n3);
                if (n3 != 0) {
                    stringBuffer.append(c);
                }
                stringBuffer.append(TableUtils.escapeAndQuote(string, c));
            }
            stringBuffer.append("\n");
        }
        for (n3 = 0; n3 < n2 && n3 + n < tableModel.getRowCount(); ++n3) {
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                Object object = tableModel.getValueAt(n3 + n, i);
                if (i != 0) {
                    stringBuffer.append(c);
                }
                stringBuffer.append(TableUtils.escapeAndQuote(object == null ? "" : object.toString(), c));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private static String escapeAndQuote(String string, char c) {
        boolean bl;
        char c2 = '\"';
        boolean bl2 = bl = c == ',';
        if (string.length() > 0 && !bl) {
            for (int i = 0; i < string.length(); ++i) {
                char c3 = string.charAt(i);
                if (c3 != c2 && c3 != c && c3 != '\n' && c3 != '\r' && c3 != ' ') continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            return string;
        }
        String string2 = string.replaceAll(String.valueOf(c2), String.valueOf(c2) + String.valueOf(c2));
        return new StringBuffer(2 + string2.length()).append(c2).append(string2).append(c2).toString();
    }

    public static boolean isCellVisible(JTable jTable, int n, int n2) {
        if (!(jTable.getParent() instanceof JViewport)) {
            return false;
        }
        JViewport jViewport = (JViewport)jTable.getParent();
        Rectangle rectangle = jTable.getCellRect(n, n2, true);
        Point point = jViewport.getViewPosition();
        rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
        return new Rectangle(jViewport.getExtentSize()).contains(rectangle);
    }

    public static void scrollToVisible(JTable jTable, int n, int n2) {
        if (!(jTable.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)jTable.getParent();
        Rectangle rectangle = jTable.getCellRect(n, n2, true);
        Point point = jViewport.getViewPosition();
        rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
        jViewport.scrollRectToVisible(rectangle);
    }

    public static Integer createTableId(TableModel tableModel) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(tableModel.getClass().getName());
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            stringBuffer.append(tableModel.getColumnName(i));
        }
        return stringBuffer.toString().hashCode();
    }

    static {
        try {
            Class<?> clazz = Class.forName("commvault.features.summary.PathHandler");
            iPathHandler = (IPathHandler)clazz.newInstance();
            clazz = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

