/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.table;

import commvault.cte.CteStringBank;
import commvault.cte.component.table.IPopup;
import commvault.cte.util.Application;
import commvault.cte.util.Logger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class MyPopupMenu
extends JPopupMenu
implements PopupMenuListener,
ActionListener {
    public static final char DISABLE_MENU_CHAR = '*';
    public static final char DELETE_MENU_CHAR = '-';
    public static final String START_SUB_MENU_STR = "->";
    public static final String END_SUB_MENU_STR = "<-";
    public static final String menuNameSeperator = new String(new char[]{'\u001f'});
    JMenuItem defaultItem = new JMenuItem();
    protected IPopup commNetTreeNode = null;
    protected String[] strings = new String[0];
    boolean isExplorerPopup = false;
    JDialog dialog = null;
    private Point desiredOnScreenLocation = new Point();
    private boolean isEmpty = false;
    private boolean isFavoritesMenuApplicable = false;

    public MyPopupMenu() {
        this.addPopupMenuListener(this);
    }

    public void clearup() {
        this.defaultItem = null;
        this.commNetTreeNode = null;
        this.strings = null;
        this.dialog = null;
    }

    public MyPopupMenu(boolean bl) {
        this();
        this.isExplorerPopup = bl;
    }

    public MyPopupMenu(String[] stringArray) {
        this();
        this.strings = stringArray;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void setDefaultItem(JMenuItem jMenuItem) {
        this.defaultItem = jMenuItem;
    }

    public void defaultAction() {
        if (this.defaultItem != null) {
            this.defaultItem.doClick();
        }
    }

    @Override
    public void setLocation(int n, int n2) {
        this.desiredOnScreenLocation.x = n;
        this.desiredOnScreenLocation.y = n2;
        this.makeMenuVisible(this.desiredOnScreenLocation);
        super.setLocation(this.desiredOnScreenLocation.x, this.desiredOnScreenLocation.y);
    }

    @Override
    public void show(Component component, int n, int n2) {
        if (!this.isEmpty) {
            super.show(component, n, n2);
        }
    }

    protected void makeMenuVisible(Point point) {
        Dimension dimension = this.getToolkit().getScreenSize();
        int n = super.getPreferredSize().height;
        int n2 = super.getPreferredSize().width;
        if (point.y + n > dimension.height) {
            point.y -= n;
        }
        if (point.x + n2 > dimension.width) {
            point.x -= n2;
        }
    }

    public Point getDesiredLocationOnScreen() {
        return this.desiredOnScreenLocation;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        if (this.dialog != null) {
            this.dialog.repaint();
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    public void setSelectedNode(IPopup iPopup, String ... stringArray) {
        Object object;
        this.commNetTreeNode = iPopup;
        this.removeAll();
        this.strings = this.commNetTreeNode.getPopupStrings();
        if (this.strings != null) {
            object = new ArrayList<String>(Arrays.asList(this.strings));
            object.addAll(Arrays.asList(stringArray));
            if (this.isFavoritesMenuApplicable) {
                if (object.size() > 0 && object.get(object.size() - 1) != null && ((String)object.get(object.size() - 1)).equals(CteStringBank.Properties.getI18n())) {
                    object.set(object.size() - 1, CteStringBank.Add_to_Favorites.getI18n());
                    object.add(CteStringBank.Properties.getI18n());
                } else {
                    object.add(CteStringBank.Add_to_Favorites.getI18n());
                }
            }
            this.strings = object.toArray(new String[0]);
        }
        if (this.strings != null && this.strings.length != 0) {
            this.populateSubMenu(this, this);
        } else {
            this.isEmpty = true;
        }
        object = this.commNetTreeNode.getDefaultString();
        if (object != null) {
            JMenuItem jMenuItem = new JMenuItem((String)object);
            jMenuItem.addActionListener(this);
            this.setDefaultItem(jMenuItem);
        }
    }

    public void populateSubMenu(JComponent jComponent, ActionListener actionListener) {
        String string = null;
        Object object = null;
        JMenu[] jMenuArray = null;
        int n = 0;
        this.isEmpty = false;
        for (int i = 0; i < this.strings.length; ++i) {
            Object object2;
            string = this.strings[i];
            if (string == null) continue;
            if (string.length() == 0) {
                if (i == 0) continue;
                if (object != null) {
                    ((JMenu)object).add(new JSeparator());
                    continue;
                }
                jComponent.add(new JSeparator());
                continue;
            }
            boolean bl = true;
            if (string.charAt(0) == '*') {
                string = string.substring(1);
                bl = false;
            }
            if (string.charAt(0) == '-') continue;
            if (string.endsWith(START_SUB_MENU_STR)) {
                object2 = new JMenu(string.substring(0, string.length() - START_SUB_MENU_STR.length()));
                if (!bl) {
                    ((JMenuItem)object2).setEnabled(false);
                }
                if (object == null) {
                    jComponent.add((Component)object2);
                } else {
                    ((JMenu)object).add((JMenuItem)object2);
                }
                if (jMenuArray == null) {
                    jMenuArray = new JMenu[this.strings.length];
                }
                object = object2;
                jMenuArray[n] = object2;
                ++n;
                continue;
            }
            if (string.equals(END_SUB_MENU_STR)) {
                if (object == null) {
                    object2 = new IllegalArgumentException("Invalid Menu items for node:" + this.commNetTreeNode.getClass().getName());
                    Logger.instance();
                    Logger.write(Logger.ERROR, this, "setSelectedNode", object2);
                    throw object2;
                }
                if (n == 0) {
                    object = null;
                    continue;
                }
                if (--n == 0) {
                    object = null;
                    continue;
                }
                object = jMenuArray[n - 1];
                continue;
            }
            object2 = string;
            String string2 = null;
            if (string.contains(menuNameSeperator)) {
                object2 = string.substring(0, string.indexOf(menuNameSeperator));
                string2 = string.substring(string.indexOf(menuNameSeperator) + 1);
            }
            JMenuItem jMenuItem = new JMenuItem((String)object2);
            if (string2 != null) {
                jMenuItem.setActionCommand(string2);
            }
            jMenuItem.setEnabled(bl);
            if (object != null) {
                ((JMenu)object).add(jMenuItem);
            } else {
                jComponent.add(jMenuItem);
            }
            jMenuItem.addActionListener(actionListener);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        JPopupMenu jPopupMenu = (JPopupMenu)((JMenuItem)actionEvent.getSource()).getParent();
        Application.instance().getPopupActionHandler().performAction(string, this.commNetTreeNode, jPopupMenu == null ? null : jPopupMenu.getInvoker());
    }

    public void setDialog(JDialog jDialog) {
        this.dialog = jDialog;
    }

    public void setFavoritesMenuApplicable(boolean bl) {
        this.isFavoritesMenuApplicable = bl;
    }
}

