/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.table;

import commvault.cte.CteStringBank;
import commvault.cte.component.table.NTable;
import commvault.cte.util.Application;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class FindAnimatedImage
extends JComponent {
    int x;
    int y;
    private NTable resultTable;
    JLabel searchLB = new JLabel(CteStringBank.Searching.getI18n());
    ImageIcon icon = Application.instance().getIconSource().getIcon("LoadingDotsInGreen");
    Dimension searchLBDimensions = new Dimension();

    public FindAnimatedImage(NTable nTable) {
        this.resultTable = nTable;
        this.searchLB.setFont(new Font("Dialog", 0, 14));
        this.searchLB.setHorizontalTextPosition(10);
    }

    public FindAnimatedImage(NTable nTable, String string) {
        this.resultTable = nTable;
        if (string != null) {
            this.searchLB = new JLabel(string);
        }
        this.searchLB.setFont(new Font("Dialog", 0, 14));
        this.searchLB.setHorizontalTextPosition(10);
    }

    @Override
    public void update(Graphics graphics) {
        this.paintComponent(graphics);
    }

    public void start() {
    }

    public void stop() {
    }

    @Override
    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void clear() {
        this.stop();
        this.resultTable.clearup();
        this.resultTable = null;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        graphics.setColor(Color.GRAY);
        Rectangle rectangle = this.resultTable.getBounds();
        Point point = new Point(rectangle.width / 2, rectangle.height / 2);
        point = SwingUtilities.convertPoint(this.resultTable, point, this);
        this.x = point.x;
        this.y = point.y;
        this.searchLBDimensions = this.searchLB.getUI().getPreferredSize(this.searchLB);
        int n = this.x - this.searchLBDimensions.width / 2;
        int n2 = this.y - this.searchLBDimensions.height / 2;
        this.icon.paintIcon(this, graphics, this.x + this.searchLBDimensions.width / 2 + 5, this.y - 5);
        int n3 = this.searchLBDimensions.width + 15 + this.icon.getIconWidth() + 20;
        graphics.draw3DRect(n - 15, n2 - 5, n3, this.searchLBDimensions.height + 20, true);
        Font font = new Font("Dialog", 0, 14);
        graphics.setFont(font);
        AttributedString attributedString = new AttributedString(this.searchLB.getText());
        attributedString.addAttribute(TextAttribute.FOREGROUND, Color.black);
        attributedString.addAttribute(TextAttribute.FONT, font);
        graphics.drawString(attributedString.getIterator(), n, this.y + 14);
        super.paintComponent(graphics);
    }
}

