/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.table;

import commvault.cte.CteStringBank;
import commvault.cte.component.Utilities;
import commvault.cte.component.table.AbstractPagedDataLoader;
import commvault.cte.component.table.IColumnValue;
import commvault.cte.component.table.ItemIterator;
import commvault.cte.util.Logger;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class CachedPagingLoader<T>
extends AbstractPagedDataLoader<T> {
    protected FileOutputStream cacheStream = null;
    protected FileOutputStream cacheColStream = null;
    protected File findCacheFile = null;
    protected File colCacheFile = null;

    @Override
    public synchronized void load(final AbstractPagedDataLoader.PageData<T> pageData) throws Exception {
        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                OldPageData oldPageData = (OldPageData)pageData;
                if (oldPageData == null) {
                    return null;
                }
                if (oldPageData.getDatas() == null) {
                    if (oldPageData.stubbedData != null) {
                        oldPageData.setDatas(new ArrayList());
                        RandomAccessFile randomAccessFile = new RandomAccessFile(CachedPagingLoader.this.findCacheFile, "r");
                        for (Item item : oldPageData.stubbedData) {
                            randomAccessFile.seek(item.offset);
                            byte[] byArray = new byte[item.size];
                            randomAccessFile.readFully(byArray);
                            oldPageData.getDatas().add(CachedPagingLoader.this.createRowObject(byArray, item.size, item.type));
                        }
                        randomAccessFile.close();
                    } else {
                        RandomAccessFile randomAccessFile = new RandomAccessFile(CachedPagingLoader.this.findCacheFile, "r");
                        randomAccessFile.seek(oldPageData.fileOffset);
                        byte[] byArray = new byte[oldPageData.byteSize];
                        randomAccessFile.readFully(byArray);
                        randomAccessFile.close();
                        CachedPagingLoader.this.processData(CachedPagingLoader.this.createItemIterator(byArray), oldPageData);
                    }
                }
                return null;
            }
        });
    }

    protected boolean processData(ItemIterator<T> itemIterator, AbstractPagedDataLoader.PageData<T> pageData) throws Exception {
        while (itemIterator.next()) {
            if (pageData.getDatas() == null) {
                pageData.setDatas(new ArrayList());
            }
            pageData.getDatas().add(itemIterator.getItem());
        }
        return true;
    }

    protected ItemIterator<T> createItemIterator(byte[] byArray) {
        return new DeafultItemIterator(byArray);
    }

    protected abstract T createRowObject(byte[] var1, int var2, int var3) throws Exception;

    protected void saveData(byte[] byArray) throws Exception {
        if (this.findCacheFile == null) {
            this.findCacheFile = File.createTempFile("pattern", ".suffix");
            this.findCacheFile.deleteOnExit();
            this.cacheStream = new FileOutputStream(this.findCacheFile);
        }
        this.cacheStream.write(byArray);
        this.cacheStream.flush();
    }

    public void saveCols(byte[] byArray) throws Exception {
        if (this.colCacheFile == null) {
            this.colCacheFile = File.createTempFile("colpattern", ".suffix");
            this.colCacheFile.deleteOnExit();
            this.cacheColStream = new FileOutputStream(this.colCacheFile);
        }
        this.cacheColStream.write(byArray);
        this.cacheColStream.flush();
    }

    @Override
    public void sortBy(final int n, final IColumnValue<T> iColumnValue, final boolean bl) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                CachedPagingLoader.this.sortBy1(n, iColumnValue, bl);
                return null;
            }
        });
    }

    public void sortBy1(int n, IColumnValue<T> iColumnValue, boolean bl) {
        try {
            Object object;
            ArrayList<Item> arrayList = new ArrayList<Item>();
            try {
                for (Object object2 : this.pagedDatas) {
                    AbstractPagedDataLoader.PageData pageData = (OldPageData)object2;
                    object = new RandomAccessFile(this.findCacheFile, "r");
                    ((RandomAccessFile)object).seek(((OldPageData)pageData).fileOffset);
                    byte[] byArray = new byte[((OldPageData)pageData).byteSize];
                    ((RandomAccessFile)object).readFully(byArray);
                    ((RandomAccessFile)object).close();
                    ItemIterator<T> itemIterator = this.createItemIterator(byArray);
                    while (itemIterator.next()) {
                        Item item = new Item();
                        item.offset = ((OldPageData)pageData).fileOffset + itemIterator.getItemOffset();
                        item.size = itemIterator.getItemSize();
                        item.type = itemIterator.getItemType();
                        item.value = iColumnValue.getColumnValue(itemIterator.getItem(), n);
                        arrayList.add(item);
                    }
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                Utilities.showErrorMessage(CteStringBank.Data_is_being_loaded6_Please_wait666.getI18n());
            }
            catch (Error error) {
                Utilities.showErrorMessage(MessageFormat.format(CteStringBank.Failed_to_sort710012.getI18n(), error.getMessage()));
            }
            final boolean bl2 = bl;
            Collections.sort(arrayList, new Comparator<Item>(){

                @Override
                public int compare(Item item, Item item2) {
                    int n;
                    int n2 = n = bl2 ? 1 : -1;
                    if (item.value == item2.value) {
                        return 0;
                    }
                    if (item.value == null) {
                        return n;
                    }
                    if (item2.value == null) {
                        return -n;
                    }
                    if (item.value instanceof Comparable) {
                        return n * ((Comparable)item.value).compareTo(item2.value);
                    }
                    return n * item.value.toString().compareTo(item2.value.toString());
                }
            });
            for (AbstractPagedDataLoader.PageData pageData : this.pagedDatas) {
                pageData.setDatas(null);
                ((OldPageData)pageData).stubbedData = object = new ArrayList();
                for (int i = 0; i < pageData.getRowCount(); ++i) {
                    ((ArrayList)object).add(arrayList.remove(0));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void addPagedData(byte[] byArray) {
        try {
            boolean bl = this.pagedDatas.size() == 0;
            OldPageData oldPageData = new OldPageData();
            ItemIterator<T> itemIterator = this.createItemIterator(byArray);
            int n = itemIterator.getItemCount();
            Object[] objectArray = new Object[]{"noOfElements=", n};
            Logger.instance().println(objectArray);
            oldPageData.byteSize = byArray.length;
            oldPageData.rowCount = itemIterator.getItemCount();
            if (!bl) {
                OldPageData oldPageData2 = (OldPageData)this.pagedDatas.get(this.pagedDatas.size() - 1);
                oldPageData.fileOffset = oldPageData2.fileOffset + oldPageData2.byteSize;
                oldPageData.rowStart = oldPageData2.rowStart + oldPageData2.rowCount;
            }
            if (this.pagedDatas.size() == 0 && !this.processData(itemIterator, oldPageData)) {
                return;
            }
            this.pagedDatas.add(oldPageData);
            this.rowCount += oldPageData.rowCount;
            if (this.model != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CachedPagingLoader.this.model.fireTableDataChanged();
                    }
                });
            }
            this.saveData(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public class DeafultItemIterator
    implements ItemIterator<T> {
        private DataInputStream messageData;
        private int noOfItemsInMessage;
        private int currentIteratorIndex;
        private int itemSize;
        private byte[] item;
        int offset = -1;
        private int itemType;

        public DeafultItemIterator(byte[] byArray) {
            this.messageData = new DataInputStream(new ByteArrayInputStream(byArray));
            try {
                this.noOfItemsInMessage = this.messageData.readInt();
                this.messageData.skipBytes(4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public int getItemOffset() {
            return this.offset;
        }

        @Override
        public T getItem() throws Exception {
            return CachedPagingLoader.this.createRowObject(this.item, this.itemSize, this.itemType);
        }

        @Override
        public int getItemSize() {
            return this.itemSize;
        }

        public final boolean hasNext() {
            return this.noOfItemsInMessage != this.currentIteratorIndex;
        }

        @Override
        public boolean next() throws IOException {
            if (!this.hasNext()) {
                return false;
            }
            this.offset = this.offset == -1 ? 16 : (this.offset += 8 + this.itemSize);
            this.itemType = this.messageData.readInt();
            this.itemSize = this.messageData.readInt();
            this.item = new byte[this.itemSize];
            this.messageData.readFully(this.item, 0, this.itemSize);
            ++this.currentIteratorIndex;
            return true;
        }

        @Override
        public int getItemCount() {
            return this.noOfItemsInMessage;
        }

        @Override
        public int getItemType() {
            return this.itemType;
        }
    }

    public class Item {
        public int offset;
        public int size;
        public int type;
        public Object value;
        public T item;
    }

    public class RowColOffset {
        public int rowOffset;
        public int rowSize;
        public int[] colOffset;
        public int offsetInOriginalFile;
        public int sizeInOriginalFile;
    }

    public class NewPageData
    extends OldPageData {
        public List<RowColOffset> rowColOffsets;

        @Override
        public AbstractPagedDataLoader.PageData<T> copy() {
            NewPageData newPageData = new NewPageData();
            newPageData.rowCount = this.rowCount;
            newPageData.rowStart = this.rowStart;
            newPageData.fileOffset = this.fileOffset;
            newPageData.byteSize = this.byteSize;
            return newPageData;
        }
    }

    public class OldPageData
    extends AbstractPagedDataLoader.PageData<T> {
        public int fileOffset;
        public int byteSize;
        public List<Item> stubbedData;

        @Override
        public AbstractPagedDataLoader.PageData<T> copy() {
            OldPageData oldPageData = new OldPageData();
            oldPageData.rowCount = this.rowCount;
            oldPageData.rowStart = this.rowStart;
            oldPageData.fileOffset = this.fileOffset;
            oldPageData.byteSize = this.byteSize;
            return oldPageData;
        }
    }
}

