/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.table;

import com.jgoodies.binding.beans.Model;
import com.jidesoft.filter.Filter;
import com.jidesoft.grid.ColumnIdentifierTableModel;
import commvault.cte.common.xml.EncoderUtil;
import commvault.cte.component.Utilities;
import commvault.cte.component.table.CVColumn;
import commvault.cte.component.table.NTable;
import commvault.cte.util.EnumUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class CVTableModel<T>
extends AbstractTableModel
implements ColumnIdentifierTableModel {
    protected List<T> originalData;
    protected List<T> rows;
    protected List<CVColumn<T>> columns;
    private Filter[] filters;
    private Set<String> editingColumns = new HashSet<String>();
    private Class<T> rowClass;

    public Class<T> getRowClass() {
        return this.rowClass;
    }

    public void setRowClass(Class<T> clazz) {
        this.rowClass = clazz;
    }

    public CVTableModel(Class<T> clazz, List<String> list, List<T> list2) {
        this.columns = new ArrayList<CVColumn<T>>();
        this.rowClass = clazz;
        List<String> list3 = this.getUIColumns(clazz, list);
        for (String string : list3) {
            this.columns.add(this.createColumn(clazz, string));
        }
        this.setDatas(list2);
    }

    public CVTableModel(Class<T> clazz, List<String> list) {
        this.columns = new ArrayList<CVColumn<T>>();
        this.rowClass = clazz;
        List<String> list2 = this.getUIColumns(clazz, list);
        for (String string : list2) {
            this.columns.add(this.createColumn(clazz, string));
        }
    }

    public CVTableModel(Class<T> clazz, List<String> list, List<T> list2, Filter ... filterArray) {
        this.columns = new ArrayList<CVColumn<T>>();
        this.rowClass = clazz;
        for (String string : list) {
            this.columns.add(this.createColumn(clazz, string));
        }
        this.filters = filterArray;
        this.setDatas(list2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.editingColumns.contains(this.columns.get(n2).getId());
    }

    public Set<String> getEditingColumns() {
        return this.editingColumns;
    }

    public void addEditingColumn(String string) {
        this.editingColumns.add(string);
    }

    protected CVColumn<T> createColumn(Class clazz, String string) {
        return new ReflectionCVColumn(clazz, string);
    }

    public CVTableModel(List<CVColumn<T>> list) {
        this.columns = list;
    }

    public void setDatas(List<T> list) {
        this.setDatas(list, true);
    }

    public void setDatas(List<T> list, boolean bl) {
        this.rows = list;
        this.originalData = list;
        if (this.filters != null && this.filters.length != 0) {
            this.applyFilter();
        } else if (bl) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CVTableModel.this.fireTableDataChanged();
                    }
                });
            } else {
                this.fireTableDataChanged();
            }
        }
    }

    public void applyFilter() {
        this.rows = new ArrayList<T>();
        for (T t : this.originalData) {
            boolean bl = false;
            for (Filter filter : this.filters) {
                if (!filter.isValueFiltered(t)) continue;
                bl = true;
            }
            if (bl) continue;
            this.rows.add(t);
        }
        this.fireTableDataChanged();
    }

    public List<T> getDatas() {
        return this.rows;
    }

    public List<T> getOriginalData() {
        return this.originalData;
    }

    @Override
    public int getRowCount() {
        if (this.rows != null) {
            return this.rows.size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public String getColumnName(int n) {
        return this.columns.get(n).getDisplayName();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            return this.columns.get(n2).getDisplayValue(this.rows.get(n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        try {
            this.columns.get(n2).setValue(this.rows.get(n), object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public List<CVColumn<T>> getColumns() {
        return this.columns;
    }

    public List<T> getSelectedRows(NTable nTable) {
        int[] nArray = nTable.getUnsortedSelectedRows();
        ArrayList<T> arrayList = new ArrayList<T>();
        for (int n : nArray) {
            arrayList.add(this.getDatas().get(n));
        }
        return arrayList;
    }

    public int getColumnIndex(String string) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (this.columns.get(i).getId() != string) continue;
            return i;
        }
        return -1;
    }

    public int[] getColumnIndexes(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < this.columns.size(); ++j) {
                if (this.columns.get(j).getId() != stringArray[i]) continue;
                nArray[i] = j;
            }
        }
        return nArray;
    }

    public int[] getColumnIndexes(CVColumn<T> ... cVColumnArray) {
        int[] nArray = new int[cVColumnArray.length];
        int n = 0;
        for (CVColumn<T> cVColumn : cVColumnArray) {
            nArray[n++] = this.getColumns().indexOf(cVColumn);
        }
        return nArray;
    }

    public List<T> getRows(int[] nArray) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (int n : nArray) {
            arrayList.add(this.rows.get(n));
        }
        return arrayList;
    }

    public void addColumn(CVColumn<T> cVColumn) {
        this.columns.add(cVColumn);
    }

    public TableColumnModel getColumnModel() {
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        int n = 0;
        for (CVColumn<T> cVColumn : this.columns) {
            TableColumn tableColumn = new TableColumn(n++, cVColumn.getWidth());
            defaultTableColumnModel.addColumn(tableColumn);
            tableColumn.setIdentifier(cVColumn.getId());
            tableColumn.setHeaderValue(cVColumn.getDisplayName());
        }
        return defaultTableColumnModel;
    }

    private List<String> getUIColumns(Class clazz, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (!Utilities.isUIField(clazz, string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static <S> List<CVColumn<S>> getAllPossibleColumns(Class<S> clazz, Class clazz2, ColumnFilter columnFilter, String ... stringArray) {
        Field[] fieldArray = clazz2.getDeclaredFields();
        ArrayList<CVColumn<S>> arrayList = new ArrayList<CVColumn<S>>();
        for (Field field : fieldArray) {
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(field.getName());
            Collections.addAll(arrayList2, stringArray);
            if (columnFilter == null || !columnFilter.isColumnAvailable(field)) continue;
            if (EncoderUtil.isPrimitive(field) && Model.class.isAssignableFrom(field.getDeclaringClass())) {
                object = new XPathColumn<S>(clazz, clazz2, field.getName());
                ((XPathColumn)object).setXPath(arrayList2);
                arrayList.add((CVColumn<S>)object);
                continue;
            }
            object = CVTableModel.getAllPossibleColumns(clazz, field.getType(), columnFilter, arrayList2.toArray(new String[0]));
            arrayList.addAll((Collection<CVColumn<S>>)object);
        }
        return arrayList;
    }

    public Object getColumnIdentifier(int n) {
        return this.columns.get(n).getId();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.columns.get(n).getType();
    }

    public void moveRow(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n3 - n;
        if (n6 < 0) {
            n5 = n3;
            n4 = n2;
        } else {
            n5 = n;
            n4 = n3 + n2 - n;
        }
        this.rotate(this.rows, n5, n4 + 1, n6);
        this.fireTableRowsUpdated(n5, n4);
    }

    private void rotate(List list, int n, int n2, int n3) {
        int n4 = n2 - n;
        int n5 = n4 - n3;
        int n6 = this.gcd(n4, n5);
        for (int i = 0; i < n6; ++i) {
            int n7 = i;
            Object e = list.get(n + n7);
            int n8 = (n7 + n5) % n4;
            while (n8 != i) {
                list.set(n + n7, list.get(n + n8));
                n7 = n8;
                n8 = (n7 + n5) % n4;
            }
            list.set(n + n7, e);
        }
    }

    private int gcd(int n, int n2) {
        return n2 == 0 ? n : this.gcd(n2, n % n2);
    }

    public static interface ColumnFilter {
        public boolean isColumnAvailable(Field var1);
    }

    static class XPathColumn<S>
    extends ReflectionCVColumn<S> {
        private Class<S> dataSourceClass;
        private ArrayList<String> xpath;

        public XPathColumn(Class<S> clazz, Class clazz2, String string) {
            super(clazz2, string);
            this.dataSourceClass = clazz;
        }

        public void setXPath(ArrayList<String> arrayList) {
            this.xpath = arrayList;
        }
    }

    public static class ReflectionCVColumn<S>
    extends CVColumn<S> {
        Method getter = null;
        Method setter = null;

        public ReflectionCVColumn(String string, String string2, int n) {
            super(string, n);
            this.setDisplayName(string2);
        }

        public ReflectionCVColumn(Class clazz, String string) {
            super(string);
            if (clazz != null) {
                try {
                    String string2 = clazz.getPackage().getName() + ".MessageBundle";
                    if (string2 != null) {
                        this.setDisplayName(EnumUtil.getLocaleString(clazz.getSimpleName() + "." + string, string2));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private String getUName() {
            String string = this.getId();
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }

        @Override
        public Object getDisplayValue(S s) {
            try {
                if (this.getter == null && s != null) {
                    this.getter = s.getClass().getMethod("get" + this.getUName(), new Class[0]);
                }
                if (this.getter != null) {
                    Object object = this.getter.invoke(s, new Object[0]);
                    if (object instanceof Enum) {
                        object = EnumUtil.getI18n((Enum)object);
                    }
                    return object;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }

        @Override
        public void setValue(S s, Object object) {
            try {
                if (this.setter == null && s != null) {
                    for (Method method : s.getClass().getMethods()) {
                        if (!method.getName().equals("set" + this.getUName())) continue;
                        this.setter = method;
                        break;
                    }
                }
                if (this.setter != null) {
                    this.setter.invoke(s, object);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

