/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.table;

import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.DefaultGroupRow;
import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.GroupTable;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.grid.SummaryGroupRow;
import com.jidesoft.grid.TreeTableUtils;
import commvault.cte.component.table.CVGroupableTableModel;
import commvault.cte.component.table.ParagraphText;
import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class CVGroupableStyledTableModel
extends CVGroupableTableModel
implements StyleModel,
ParagraphText {
    private boolean styleOn = true;
    private JTable table;
    CellStyle _cellStyle = new CellStyle();
    protected final Color BACKGROUND1 = new Color(253, 253, 244);
    protected final Color BACKGROUND2 = new Color(250, 250, 235);
    protected final Color BACKGROUND3 = new Color(210, 255, 210);
    private HighlightPattern highlightPattern = HighlightPattern.TwoColor;
    private int _pattern = this.highlightPattern.ordinal();

    public CVGroupableStyledTableModel(TableModel tableModel) {
        this(tableModel, null);
    }

    public CVGroupableStyledTableModel(TableModel tableModel, JTable jTable) {
        super(tableModel);
        this.table = jTable;
    }

    public CellStyle getCellStyleAt(int n, int n2) {
        if (this.table != null && this.table instanceof GroupTable) {
            GroupTable groupTable = (GroupTable)this.table;
            n = groupTable.getActualRowAt(n);
        }
        this._cellStyle.setHorizontalAlignment(0);
        this._cellStyle.setIcon(null);
        this._cellStyle.setHorizontalAlignment(2);
        this._cellStyle.setVerticalAlignment(1);
        if (this._pattern == 0) {
            if (n % 2 == 0) {
                this._cellStyle.setBackground(this.BACKGROUND1);
            } else {
                this._cellStyle.setBackground(this.BACKGROUND2);
            }
        } else if (this._pattern == 1) {
            if (n % 3 == 0) {
                this._cellStyle.setBackground(this.BACKGROUND2);
            } else if (n % 3 == 1) {
                this._cellStyle.setBackground(this.BACKGROUND1);
            } else {
                this._cellStyle.setBackground(this.BACKGROUND3);
            }
        } else if (this._pattern == 2) {
            if (n2 % 2 == 0) {
                this._cellStyle.setBackground(this.BACKGROUND1);
            } else {
                this._cellStyle.setBackground(this.BACKGROUND2);
            }
        } else if (n % 2 == n2 % 2) {
            this._cellStyle.setBackground(this.BACKGROUND1);
        } else {
            this._cellStyle.setBackground(this.BACKGROUND2);
        }
        if (this.getValueAt(n, 0) instanceof ExpandableRow) {
            this._cellStyle.setBackground(new JLabel().getBackground());
        }
        return this._cellStyle;
    }

    public boolean isCellStyleOn() {
        return this.styleOn;
    }

    public boolean isStyleOn() {
        return this.styleOn;
    }

    public void setStyleOn(boolean bl) {
        this.styleOn = bl;
    }

    public HighlightPattern getHighlightPattern() {
        return this.highlightPattern;
    }

    public void setHighlightPattern(HighlightPattern highlightPattern) {
        this.highlightPattern = highlightPattern;
    }

    @Override
    public String getParagraphText(int n) {
        this.getRowAt(n);
        int n2 = this.getColumnCount();
        StringBuilder stringBuilder = new StringBuilder("<html><table>");
        for (int i = 0; i < n2; ++i) {
            Object object = this.getValueAt(n, i);
            String string = this.getColumnName(i);
            if (object == null || object.equals("")) continue;
            stringBuilder.append("<tr><td>" + string + ": </td><td>" + object + "</td></tr>");
        }
        stringBuilder.append("</table></html>");
        return stringBuilder.toString();
    }

    public Class getColumnClass(int n) {
        if (this.getActualModel() != null) {
            return this.getActualModel().getColumnClass(n);
        }
        return super.getColumnClass(n);
    }

    protected DefaultGroupRow createGroupRow() {
        Object object = this.isSummaryMode() ? new SummaryGroupRow() : new DefaultGroupRow(){

            public Object getValueAt(int n) {
                String string = this.toString();
                if (string != null && string.trim().length() > 0) {
                    int n2 = TreeTableUtils.getDescendantCount((TableModel)((Object)CVGroupableStyledTableModel.this), (Row)this, (boolean)true, (boolean)true);
                    string = string + " (" + n2 + ")";
                }
                return string;
            }
        };
        object.setExpanded(this.isAutoExpand());
        return object;
    }

    public static enum HighlightPattern {
        TwoColor,
        ThreeColor;

    }
}

