/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.ribbon.api.svg;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Icon;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.EventDispatcher;

abstract class SvgBatikIcon
extends UserAgentAdapter
implements Icon {
    protected Map<String, BufferedImage> cachedImages = new HashMap<String, BufferedImage>();
    protected int width;
    protected int height;
    protected byte[] svgBytes;
    protected List listeners;
    private static ExecutorService loadService = Executors.newFixedThreadPool(5);
    static EventDispatcher.Dispatcher completedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((GVTTreeRendererListener)object).gvtRenderingCompleted((GVTTreeRendererEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher startedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((GVTTreeRendererListener)object).gvtRenderingStarted((GVTTreeRendererEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher failedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((GVTTreeRendererListener)object).gvtRenderingFailed((GVTTreeRendererEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher cancelledDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((GVTTreeRendererListener)object).gvtRenderingCancelled((GVTTreeRendererEvent)object2);
        }
    };

    public SvgBatikIcon(InputStream inputStream, int n, int n2) throws IOException {
        int n3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n3 = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n3);
        }
        this.svgBytes = byteArrayOutputStream.toByteArray();
        this.width = n;
        this.height = n2;
        this.listeners = Collections.synchronizedList(new LinkedList());
        this.renderGVTTree(this.width, this.height);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        BufferedImage bufferedImage = this.cachedImages.get(this.getIconWidth() + ":" + this.getIconHeight());
        if (bufferedImage != null) {
            int n3 = (this.width - bufferedImage.getWidth()) / 2;
            int n4 = (this.height - bufferedImage.getHeight()) / 2;
            graphics.drawImage(bufferedImage, n + n3, n2 + n4, null);
        }
    }

    public Dimension2D getViewportSize() {
        return new Dimension(this.width, this.height);
    }

    public synchronized void setPreferredSize(Dimension dimension) {
        if (this.width == dimension.width && this.height == dimension.height) {
            return;
        }
        this.width = dimension.width;
        this.height = dimension.height;
        this.renderGVTTree(this.width, this.height);
    }

    public byte[] getSvgBytes() {
        return this.svgBytes;
    }

    public void fireEvent(EventDispatcher.Dispatcher dispatcher, Object object) {
        EventDispatcher.fireEvent((EventDispatcher.Dispatcher)dispatcher, (List)this.listeners, (Object)object, (boolean)true);
    }

    protected synchronized boolean renderGVTTree(final int n, final int n2) {
        String string = n + ":" + n2;
        if (this.cachedImages.containsKey(string)) {
            return true;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block8: {
                    GVTTreeRendererEvent gVTTreeRendererEvent = new GVTTreeRendererEvent((Object)this, null);
                    try {
                        gVTTreeRendererEvent = new GVTTreeRendererEvent((Object)this, null);
                        SvgBatikIcon.this.fireEvent(startedDispatcher, gVTTreeRendererEvent);
                        BufferedImageTranscoder bufferedImageTranscoder = new BufferedImageTranscoder();
                        if (n != 0 && n2 != 0) {
                            bufferedImageTranscoder.setDimensions(n, n2);
                        }
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(SvgBatikIcon.this.svgBytes);
                        TranscoderInput transcoderInput = new TranscoderInput((InputStream)byteArrayInputStream);
                        bufferedImageTranscoder.transcode(transcoderInput, null);
                        BufferedImage bufferedImage = bufferedImageTranscoder.getBufferedImage();
                        String string = bufferedImage.getWidth() + ":" + bufferedImage.getHeight();
                        if (bufferedImage == null) break block8;
                        SvgBatikIcon svgBatikIcon = SvgBatikIcon.this;
                        synchronized (svgBatikIcon) {
                            SvgBatikIcon.this.cachedImages.put(string, bufferedImage);
                        }
                        gVTTreeRendererEvent = new GVTTreeRendererEvent((Object)this, bufferedImage);
                        SvgBatikIcon.this.fireEvent(completedDispatcher, gVTTreeRendererEvent);
                    }
                    catch (InterruptedBridgeException interruptedBridgeException) {
                        SvgBatikIcon.this.fireEvent(cancelledDispatcher, gVTTreeRendererEvent);
                    }
                    catch (ThreadDeath threadDeath) {
                        SvgBatikIcon.this.fireEvent(failedDispatcher, gVTTreeRendererEvent);
                        throw threadDeath;
                    }
                    catch (Throwable throwable) {
                        SvgBatikIcon.this.fireEvent(failedDispatcher, gVTTreeRendererEvent);
                    }
                }
            }
        };
        loadService.execute(runnable);
        return false;
    }

    public void addGVTTreeRendererListener(GVTTreeRendererListener gVTTreeRendererListener) {
        this.listeners.add(gVTTreeRendererListener);
    }

    public void removeGVTTreeRendererListener(GVTTreeRendererListener gVTTreeRendererListener) {
        this.listeners.remove(gVTTreeRendererListener);
    }

    public static class BufferedImageTranscoder
    extends ImageTranscoder {
        protected BufferedImage bufferedImage;

        public BufferedImage createImage(int n, int n2) {
            return new BufferedImage(n, n2, 2);
        }

        public void writeImage(BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
            this.bufferedImage = bufferedImage;
        }

        public BufferedImage getBufferedImage() {
            return this.bufferedImage;
        }

        public void setDimensions(int n, int n2) {
            this.hints.put((Object)KEY_WIDTH, (Object)new Float(n));
            this.hints.put((Object)KEY_HEIGHT, (Object)new Float(n2));
        }
    }
}

