/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.ribbon.api.ribbon;

import commvault.cte.component.ribbon.api.ribbon.AbstractRibbonBand;
import commvault.cte.component.ribbon.api.ribbon.JRibbon;
import commvault.cte.component.ribbon.api.ribbon.RibbonContextualTaskGroup;
import commvault.cte.component.ribbon.api.ribbon.resize.CoreRibbonResizeSequencingPolicies;
import commvault.cte.component.ribbon.api.ribbon.resize.RibbonBandResizeSequencingPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RibbonTask {
    private JRibbon ribbon;
    private ArrayList<AbstractRibbonBand<?>> bands;
    private String title;
    private RibbonContextualTaskGroup contextualGroup;
    private RibbonBandResizeSequencingPolicy resizeSequencingPolicy;
    private String keyTip;

    public RibbonTask(String string, AbstractRibbonBand<?> ... abstractRibbonBandArray) {
        if (abstractRibbonBandArray == null || abstractRibbonBandArray.length == 0) {
            throw new IllegalArgumentException("Cannot have empty ribbon task");
        }
        this.title = string;
        this.bands = new ArrayList();
        for (AbstractRibbonBand<?> abstractRibbonBand : abstractRibbonBandArray) {
            abstractRibbonBand.setRibbonTask(this);
            this.bands.add(abstractRibbonBand);
        }
        this.resizeSequencingPolicy = new CoreRibbonResizeSequencingPolicies.RoundRobin(this);
    }

    public int getBandCount() {
        return this.bands.size();
    }

    public AbstractRibbonBand<?> getBand(int n) {
        return this.bands.get(n);
    }

    public String getTitle() {
        return this.title;
    }

    void setContextualGroup(RibbonContextualTaskGroup ribbonContextualTaskGroup) {
        if (this.contextualGroup != null) {
            throw new IllegalStateException("The task already belongs to another contextual task group");
        }
        this.contextualGroup = ribbonContextualTaskGroup;
    }

    public RibbonContextualTaskGroup getContextualGroup() {
        return this.contextualGroup;
    }

    public List<AbstractRibbonBand<?>> getBands() {
        return Collections.unmodifiableList(this.bands);
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.ribbon != null) {
            this.ribbon.fireStateChanged();
        }
    }

    void setRibbon(JRibbon jRibbon) {
        if (this.ribbon != null) {
            throw new IllegalStateException("The task already belongs to another ribbon");
        }
        this.ribbon = jRibbon;
    }

    public RibbonBandResizeSequencingPolicy getResizeSequencingPolicy() {
        return this.resizeSequencingPolicy;
    }

    public void setResizeSequencingPolicy(RibbonBandResizeSequencingPolicy ribbonBandResizeSequencingPolicy) {
        this.resizeSequencingPolicy = ribbonBandResizeSequencingPolicy;
    }

    public String getKeyTip() {
        return this.keyTip;
    }

    public void setKeyTip(String string) {
        this.keyTip = string;
    }
}

