/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.filechooser;

import commvault.cte.CteStringBank;
import commvault.cte.component.CVFrame;
import commvault.cte.component.LayoutUtils;
import commvault.cte.component.SComboBox;
import commvault.cte.component.SList;
import commvault.cte.component.SortedComboBoxModel;
import commvault.cte.component.Utilities;
import commvault.cte.component.events.ListClickListener;
import commvault.cte.component.filechooser.OpenFileDirModel;
import commvault.cte.component.filechooser.OpenFileDirRenderer;
import commvault.cte.component.filechooser.OpenFileLookInRenderer;
import commvault.cte.component.filechooser.PatternRecognizer;
import commvault.cte.component.filechooser.ServerFile;
import commvault.cte.help.CVHelp;
import commvault.cte.util.Application;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class CVFileChooser
extends JComponent
implements ActionListener,
ListSelectionListener,
ItemListener,
ListClickListener,
KeyListener,
WindowListener {
    private SComboBox lookInCombo = new SComboBox();
    private SComboBox filterCombobox = new SComboBox();
    private JButton oneLevelUpButton = new JButton();
    private JButton helpButton = new JButton();
    private JButton homeButton = new JButton();
    private FileSystemView fileView = null;
    private ServerFile currentDirectory = null;
    private JTextField fileNameField = new JTextField();
    private SList fileList = new SList();
    private JButton openButton = new JButton(CteStringBank.Open.getI18n());
    private JButton cancelButton = new JButton(CteStringBank.Cancel.getI18n());
    private OpenFileDirModel listModel = null;
    private FileLoader loader = null;
    private SortedComboBoxModel lookInModel = new SortedComboBoxModel();
    private boolean initiatedEvent = false;
    private boolean preventParentBrowsing = false;
    public static final int APPROVE = 0;
    public static final int CANCEL = 1;
    private ServerFile selectedFile = null;
    private int mode = 1;
    private CVHelp currentHelpObj;
    private boolean isUnixFS = false;
    private boolean isNetwareFS = false;
    private ServerFile initialDir = null;
    JDialog dialog = null;
    private boolean isInitializing = true;
    private final StringBuffer userInput = new StringBuffer();
    private Timer timer;
    private FileSelectionNotifier fileSelectionNotifier;

    public CVFileChooser(FileSystemView fileSystemView, boolean bl, boolean bl2) {
        this(null, fileSystemView, false, bl, bl2);
    }

    public CVFileChooser(ServerFile serverFile, FileSystemView fileSystemView, boolean bl, boolean bl2) {
        this(serverFile, fileSystemView, false, bl, bl2);
    }

    public CVFileChooser(ServerFile serverFile, FileSystemView fileSystemView, boolean bl, boolean bl2, boolean bl3) {
        this.setUnixFS(bl2);
        this.setNetwareFS(bl3);
        this.setStartDirectory(serverFile);
        this.setPreventParentBrowse(bl);
        this.setFileSystemView(fileSystemView);
        this.init();
        this.isInitializing = false;
    }

    private void init() {
        this.oneLevelUpButton.setIcon(UIManager.getIcon("FileChooser.upFolderIcon"));
        this.oneLevelUpButton.setToolTipText(CteStringBank.Up_One_Level.getI18n());
        this.oneLevelUpButton.setPreferredSize(new Dimension(24, 24));
        this.helpButton.setIcon(Application.instance().getIconSource().getIcon("aboutIcon"));
        this.helpButton.setToolTipText(CteStringBank.Help.getI18n());
        this.helpButton.setPreferredSize(new Dimension(24, 24));
        this.homeButton.setIcon(UIManager.getIcon("FileChooser.homeFolderIcon"));
        this.homeButton.setIcon(UIManager.getIcon("FileChooser.homeFolderIcon"));
        this.homeButton.setToolTipText(CteStringBank.Home_Directory.getI18n());
        this.homeButton.setPreferredSize(new Dimension(24, 24));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = null;
        jLabel = new JLabel(CteStringBank.Look_In_.getI18n());
        jPanel.add((Component)jLabel, LayoutUtils.getConstraints(gridBagConstraints, 0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(10, 10, 10, 10)));
        jLabel.setDisplayedMnemonic('I');
        jLabel.setLabelFor(this.lookInCombo);
        jPanel.add((Component)this.lookInCombo, LayoutUtils.getConstraints(gridBagConstraints, 1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(10, 0, 10, 7)));
        jPanel.add((Component)this.oneLevelUpButton, LayoutUtils.getConstraints(gridBagConstraints, 2, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(10, 7, 10, 7)));
        jPanel.add((Component)this.homeButton, LayoutUtils.getConstraints(gridBagConstraints, 3, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(10, 7, 10, 7)));
        jPanel.add((Component)this.helpButton, LayoutUtils.getConstraints(gridBagConstraints, 4, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(10, 7, 10, 10)));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.fileList);
        jPanel2.add(jScrollPane);
        Dimension dimension = new Dimension(80, 24);
        this.openButton.setPreferredSize(dimension);
        this.openButton.setDefaultCapable(true);
        this.homeButton.setDefaultCapable(false);
        this.cancelButton.setDefaultCapable(false);
        this.cancelButton.setPreferredSize(dimension);
        this.filterCombobox.setPreferredSize(dimension);
        this.fileNameField.setPreferredSize(dimension);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        jLabel = new JLabel(CteStringBank.File_name_.getI18n());
        jPanel3.add((Component)jLabel, LayoutUtils.getConstraints(gridBagConstraints, 0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 10, 5, 5)));
        jLabel.setDisplayedMnemonic('N');
        jLabel.setLabelFor(this.fileNameField);
        jPanel3.add((Component)this.fileNameField, LayoutUtils.getConstraints(gridBagConstraints, 1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5)));
        jPanel3.add((Component)this.openButton, LayoutUtils.getConstraints(gridBagConstraints, 2, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 10)));
        jLabel = new JLabel(CteStringBank.Files_of_type_.getI18n());
        jPanel3.add((Component)jLabel, LayoutUtils.getConstraints(gridBagConstraints, 0, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 10, 5, 5)));
        jLabel.setDisplayedMnemonic('T');
        jLabel.setLabelFor(this.filterCombobox);
        jPanel3.add((Component)this.filterCombobox, LayoutUtils.getConstraints(gridBagConstraints, 1, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5)));
        jPanel3.add((Component)this.cancelButton, LayoutUtils.getConstraints(gridBagConstraints, 2, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 10)));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        jPanel4.add((Component)jPanel, LayoutUtils.getConstraints(gridBagConstraints, 0, 0, 0, 1, 1.0, 0.0, 10, 1));
        jPanel4.add((Component)jPanel2, LayoutUtils.getConstraints(gridBagConstraints, 0, 1, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 2, 0, 2)));
        jPanel4.add((Component)jPanel3, LayoutUtils.getConstraints(gridBagConstraints, 0, 2, 0, 0, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0)));
        this.setLayout(new BorderLayout());
        this.add(jPanel4);
        this.openButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.homeButton.addActionListener(this);
        this.oneLevelUpButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.oneLevelUpButton.setDefaultCapable(false);
        this.helpButton.setDefaultCapable(false);
        this.fileNameField.addActionListener(this);
        this.lookInCombo.setRenderer(new OpenFileLookInRenderer());
        this.lookInCombo.setModel(this.lookInModel);
        this.fileList.addKeyListener(this);
        this.fileList.getSelectionModel().setSelectionMode(0);
        this.fileList.setCellRenderer(new OpenFileDirRenderer());
        this.fileList.addListClickListener(this);
        this.listModel = new OpenFileDirModel();
        this.fileList.setModel(this.listModel);
        this.listModel.setFilter(this.getCurrentFilter());
        this.fileList.getSelectionModel().addListSelectionListener(this);
        this.filterCombobox.addItemListener(this);
        this.lookInCombo.addItemListener(this);
        this.addChoosableFileFilter(new ExtensionFileFilter("*", CteStringBank.All_Files.getI18n()));
        this.initiatedEvent = true;
        this.recalculateLookinModel();
        this.initiatedEvent = false;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CVFileChooser.this.selectFile(CVFileChooser.this.userInput.toString());
                CVFileChooser.this.timer.stop();
            }
        };
        this.timer = new Timer(500, actionListener);
    }

    public void selectFile(String string) {
        ServerFile serverFile = this.listModel.getFileObject(string);
        if (serverFile != null) {
            this.fileList.setSelectedValue(serverFile, true);
        }
        this.userInput.delete(0, this.userInput.length());
    }

    public void setFileSystemView(FileSystemView fileSystemView) {
        this.fileView = fileSystemView;
    }

    public FileSystemView getFileSystemView() {
        return this.fileView;
    }

    public void setStartDirectory(String string) {
        this.initialDir = new ServerFile(string);
        this.initialDir.setDirectory(true);
    }

    public void setStartDirectory(ServerFile serverFile) {
        this.initialDir = serverFile;
    }

    public ServerFile getStartDirectory() {
        return this.initialDir;
    }

    public void setPreventParentBrowse(boolean bl) {
        this.preventParentBrowsing = bl;
    }

    public boolean getPreventParentBrowse() {
        return this.preventParentBrowsing;
    }

    public void setUnixFS(boolean bl) {
        this.isUnixFS = bl;
    }

    public void setNetwareFS(boolean bl) {
        this.isNetwareFS = bl;
    }

    public boolean isUnixFS() {
        return this.isUnixFS;
    }

    public boolean isNetwareFS() {
        return this.isNetwareFS;
    }

    public synchronized void setDirectory(ServerFile serverFile) {
        if (!this.canTraverse(serverFile)) {
            Utilities.showInfoMessage(this.dialog, CteStringBank.Permission_Denied.getI18n(), CteStringBank.Note.getI18n());
            this.initiatedEvent = true;
            this.setSelection(this.getDirectory());
            this.initiatedEvent = false;
            this.enableDisableButtons();
            return;
        }
        this.currentDirectory = serverFile;
        this.initiatedEvent = true;
        this.recalculateLookinModel(serverFile);
        this.initiatedEvent = false;
        this.fileList.clearSelection();
        this.listModel.removeAllElements();
        this.listModel.setFilter(this.getCurrentFilter());
        this.fileNameField.setText("");
        this.fileList.ensureIndexIsVisible(0);
        this.loadFiles(serverFile);
        this.enableDisableButtons();
    }

    private void recalculateLookinModel() {
        try {
            this.lookInModel.removeAllElements();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ServerFile[] serverFileArray = (ServerFile[])this.getFileSystemView().getRoots();
        for (int i = 0; i < serverFileArray.length; ++i) {
            this.lookInModel.addElement(serverFileArray[i]);
        }
        if (serverFileArray.length != 0) {
            if (this.getStartDirectory() != null) {
                this.setDirectory(this.getStartDirectory());
            } else {
                this.setDirectory((ServerFile)this.fileView.getHomeDirectory());
            }
        }
    }

    private File getRootOf(File file) {
        File file2;
        File file3 = file2 = file;
        while (file2 != null) {
            file3 = file2;
            file2 = file2.getParentFile();
        }
        return file3;
    }

    private void recalculateLookinModel(ServerFile serverFile) {
        int n;
        if (this.isUnixFS || this.isNetwareFS) {
            this.lookInModel.removeAllElements();
        } else {
            for (n = this.lookInModel.getSize() - 1; n >= 0; --n) {
                if (this.isRoot((ServerFile)this.lookInModel.getElementAt(n))) continue;
                this.lookInModel.removeElement(this.lookInModel.getElementAt(n));
            }
        }
        if (this.isRoot(serverFile)) {
            this.setSelection(serverFile);
            return;
        }
        n = this.lookInModel.getIndexOf(this.getRootOf(serverFile));
        ++n;
        Vector<ServerFile> vector = new Vector<ServerFile>();
        for (File file = serverFile; file != null; file = ((File)file).getParentFile()) {
            if (this.isRoot(file)) continue;
            vector.addElement((ServerFile)file);
        }
        if (this.isUnixFS) {
            vector.add(new ServerFile("/", true));
            this.lookInModel.addAll(vector);
        } else {
            for (int i = 0; i < vector.size(); ++i) {
                this.lookInModel.insertElementAt(vector.elementAt(i), n);
            }
        }
        this.setSelection(serverFile);
    }

    private void setSelection(ServerFile serverFile) {
        for (int i = 0; i < this.lookInModel.getSize(); ++i) {
            if (!((ServerFile)this.lookInModel.getElementAt(i)).equals(serverFile)) continue;
            this.lookInCombo.setSelectedIndex(i);
        }
    }

    private boolean isRoot(File file) {
        String string = file.toString();
        return this.isUnixFS ? string.equals("/") : (this.isNetwareFS ? string.endsWith(":") : string.endsWith(":\\"));
    }

    protected void loadFiles(ServerFile serverFile) {
        if (this.loader != null) {
            this.loader.stopThread();
        }
        FileLoader fileLoader = new FileLoader(serverFile);
        fileLoader.start();
    }

    public ServerFile getDirectory() {
        return this.currentDirectory;
    }

    public void showOpenFileDialog(String string) {
        this.showOpenFileDialog((JFrame)((Object)CVFrame.instance()), string, true);
    }

    public void showOpenFileDialog(String string, boolean bl) {
        this.showOpenFileDialog((JFrame)((Object)CVFrame.instance()), string, bl);
    }

    public void showOpenFileDialog(JFrame jFrame, String string) {
        this.showOpenFileDialog(jFrame, string, true);
    }

    public void showOpenFileDialog(JFrame jFrame, String string, boolean bl) {
        this.dialog = new JDialog(jFrame);
        this.currentHelpObj = new CVHelp(this.dialog);
        this.currentHelpObj.createHelpBroker("MainHelp");
        if (string.equalsIgnoreCase(CteStringBank.Open.getI18n())) {
            this.currentHelpObj.setCurrentID("english-en-us-main-nt-NO_TOCHEADINGS.txt-Open(License)");
        } else {
            this.currentHelpObj.setCurrentID("english-en-us-main-nt-NO_TOCHEADINGS.txt-ViewLogFiles");
        }
        this.showOpenFileDialog2(this.dialog, string, bl);
    }

    public void showOpenFileDialog(JDialog jDialog, String string) {
        this.showOpenFileDialog(jDialog, string, true);
    }

    public void showOpenFileDialog(JDialog jDialog, String string, boolean bl) {
        this.dialog = new JDialog(jDialog);
        this.currentHelpObj = new CVHelp(this.dialog);
        this.currentHelpObj.createHelpBroker("MainHelp");
        this.currentHelpObj.setCurrentID("english-en-us-main-nt-NO_TOCHEADINGS.txt-ViewLogFiles");
        this.showOpenFileDialog2(this.dialog, string, bl);
    }

    private void showOpenFileDialog2(JDialog jDialog, String string, boolean bl) {
        jDialog.setTitle(string);
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add(this);
        Dimension dimension = this.getPreferredSize();
        jDialog.setBounds(100, 100, dimension.width, dimension.height);
        if (this.fileSelectionNotifier != null) {
            jDialog.setLocation(jDialog.getParent().getLocation().x + 300, 200);
        } else {
            jDialog.setLocationRelativeTo(jDialog.getParent());
        }
        jDialog.addWindowListener(this);
        jDialog.getRootPane().setDefaultButton(this.openButton);
        if (this.fileSelectionNotifier != null) {
            jDialog.setModal(false);
        } else {
            jDialog.setModal(bl);
        }
        jDialog.setVisible(true);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(508, 327);
    }

    @Override
    public void mouseClicked(JComponent jComponent, int n, int n2) {
        if (jComponent == this.fileList && n == 2) {
            this.accept(n2);
        }
    }

    public void cancel() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
        this.dialog = null;
    }

    public void accept(int n) {
        Object e = this.fileList.getModel().getElementAt(n);
        if (e == null) {
            return;
        }
        String string = ((ServerFile)e).getName();
        this.accept(string);
    }

    private void parseUserInput(String string) {
        if (string.equals("..")) {
            this.goUp();
        }
    }

    protected boolean isAncestor(ServerFile serverFile, ServerFile serverFile2) {
        String string = serverFile.toString().toLowerCase();
        String string2 = serverFile2.toString().toLowerCase();
        return string2.startsWith(string) && !string2.equals(string);
    }

    protected boolean canTraverse(ServerFile serverFile) {
        if (this.isInitializing) {
            return true;
        }
        if (this.getStartDirectory() != null && this.getPreventParentBrowse()) {
            if (this.isAncestor(serverFile, this.getStartDirectory())) {
                return false;
            }
            if (this.getStartDirectory().equals(serverFile)) {
                return true;
            }
            if (!this.isAncestor(this.getStartDirectory(), serverFile)) {
                return false;
            }
        }
        return true;
    }

    public void accept() {
        String string = this.fileNameField.getText();
        if (string == null || string.length() == 0) {
            Object e = this.fileList.getSelectedValue();
            if (e == null) {
                return;
            }
            string = ((ServerFile)e).getName();
        } else {
            if (string.startsWith("..")) {
                this.parseUserInput(string);
                return;
            }
            if (string.indexOf("*") != -1) {
                this.setCursor(new Cursor(3));
                this.listModel.setFilter(new ExtensionFileFilter(string, string));
                this.setCursor(new Cursor(0));
                return;
            }
        }
        this.accept(string);
    }

    public void accept(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        ServerFile serverFile = this.listModel.getFile(string);
        if (serverFile == null) {
            return;
        }
        if (serverFile.isDirectory()) {
            this.setDirectory(serverFile);
        } else {
            this.mode = 0;
            this.selectedFile = serverFile;
            if (this.fileSelectionNotifier != null) {
                this.fileSelectionNotifier.notifySelection(this.selectedFile, this.dialog);
            } else if (this.dialog != null) {
                this.dialog.dispose();
            }
        }
    }

    public int getResponse() {
        return this.mode;
    }

    public void goHome() {
        ServerFile serverFile = (ServerFile)this.getFileSystemView().getHomeDirectory();
        if (serverFile != null) {
            this.setDirectory(serverFile);
        }
    }

    public void goUp() {
        ServerFile serverFile = (ServerFile)this.getDirectory().getParentFile();
        if (serverFile == null) {
            return;
        }
        serverFile.setDirectory(true);
        if (serverFile.getParent() == null) {
            serverFile.setRoot(true);
        }
        this.setDirectory(serverFile);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.openButton || actionEvent.getSource() == this.fileNameField) {
            this.accept();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.cancel();
        } else if (actionEvent.getSource() == this.oneLevelUpButton) {
            this.goUp();
        } else if (actionEvent.getSource() == this.homeButton) {
            this.goHome();
        } else if (actionEvent.getSource() == this.helpButton) {
            this.help();
        }
    }

    public void help() {
        if (this.currentHelpObj != null) {
            this.currentHelpObj.displayHelp();
        }
    }

    private void addFile(ServerFile[] serverFileArray) {
        this.setCursor(new Cursor(3));
        this.listModel.addElements(serverFileArray);
        this.setCursor(new Cursor(0));
    }

    public void addChoosableFileFilter(FileFilter fileFilter) {
        this.filterCombobox.addItem(fileFilter);
    }

    public boolean removeChoosableFileFilter(FileFilter fileFilter) {
        this.filterCombobox.removeItem(fileFilter);
        return true;
    }

    public void setCurrentFilter(FileFilter fileFilter) {
        this.setCursor(new Cursor(3));
        this.filterCombobox.setSelectedItem(fileFilter);
        this.listModel.setFilter(this.getCurrentFilter());
        this.setCursor(new Cursor(0));
    }

    public FileFilter getCurrentFilter() {
        if (this.filterCombobox.getModel().getSize() == 0) {
            return null;
        }
        this.filterCombobox.getSelectedItem();
        return (FileFilter)this.filterCombobox.getSelectedItem();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.fileList.getSelectionModel()) {
            ServerFile serverFile = (ServerFile)this.fileList.getSelectedValue();
            if (serverFile != null && !serverFile.isDirectory()) {
                this.fileNameField.setText(serverFile.getName());
            } else {
                this.fileNameField.setText("");
            }
        }
    }

    public ServerFile getSelectedFile() {
        if (this.mode == 0) {
            return this.selectedFile;
        }
        return null;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.lookInCombo && itemEvent.getStateChange() == 1) {
            if (!this.initiatedEvent && !this.getDirectory().equals(this.lookInCombo.getSelectedItem())) {
                this.setDirectory((ServerFile)this.lookInCombo.getSelectedItem());
            }
        } else if (itemEvent.getSource() == this.filterCombobox) {
            this.listModel.setFilter(this.getCurrentFilter());
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.fileList) {
            if (keyEvent.getKeyChar() == '\n') {
                int n = this.fileList.getSelectedIndex();
                if (n != -1) {
                    this.accept(n);
                }
            } else if (keyEvent.getKeyChar() == '\b') {
                this.goUp();
            } else {
                if (!this.timer.isRunning()) {
                    this.timer.start();
                }
                this.userInput.append(keyEvent.getKeyChar());
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.fileNameField.requestFocus();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void enableDisableButtons() {
    }

    public void setFileSelectionNotifier(FileSelectionNotifier fileSelectionNotifier) {
        this.fileSelectionNotifier = fileSelectionNotifier;
    }

    public static interface FileSelectionNotifier {
        public void notifySelection(Object var1, Component var2);
    }

    public static class ExtensionFileFilter
    extends FileFilter {
        private PatternRecognizer patternRecognizer = null;

        public ExtensionFileFilter(String string, String string2) {
            this.setExtension(string);
            this.setDescription(string2);
        }

        public void setExtension(String string) {
            if (this.patternRecognizer == null) {
                this.patternRecognizer = new PatternRecognizer(string);
            } else {
                this.patternRecognizer.setPattern(string);
            }
        }

        public void setDescription(String string) {
            this.patternRecognizer.setDescription(string);
        }

        @Override
        public boolean accept(File file) {
            return this.patternRecognizer.matchesPattern(file.getName());
        }

        @Override
        public String getDescription() {
            return this.patternRecognizer.getDescription();
        }

        public String toString() {
            return this.getDescription();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            return object.toString().equals(this.toString());
        }
    }

    class FileLoader
    extends Thread {
        ServerFile f = null;
        private boolean isValidThread = true;

        public FileLoader(ServerFile serverFile) {
            this.f = serverFile;
        }

        @Override
        public void run() {
            ServerFile[] serverFileArray = (ServerFile[])CVFileChooser.this.getFileSystemView().getFiles(this.f, false);
            if (!this.isValidThread) {
                return;
            }
            CVFileChooser.this.addFile(serverFileArray);
        }

        public void stopThread() {
            this.isValidThread = false;
        }
    }
}

