/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.explorer;

import commvault.cte.component.tree.CommNetTreeNode;
import commvault.cte.util.Utils;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeNode;

public class CommNetBrowseTreeNode
extends CommNetTreeNode
implements TableModel {
    protected Vector columnNames = new Vector(10, 1);
    protected Vector childVector = new Vector(20, 5);
    protected Vector properties = new Vector(5, 1);

    public CommNetBrowseTreeNode() {
    }

    public CommNetBrowseTreeNode(String string) {
        super(string);
    }

    public CommNetBrowseTreeNode(String string, boolean bl) {
        super(string, bl);
    }

    public CommNetBrowseTreeNode(int n, String string, boolean bl) {
        super(n, string, bl);
    }

    public Vector getColumnNames() {
        return this.columnNames;
    }

    public Vector getData() {
        Vector<Vector> vector = new Vector<Vector>();
        Enumeration enumeration = this.childVector.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((CommNetBrowseTreeNode)enumeration.nextElement()).getProperties());
        }
        return vector;
    }

    public Vector getProperties() {
        return this.properties;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames.elementAt(n).toString();
    }

    @Override
    public int getRowCount() {
        if (this.childVector == null) {
            return 0;
        }
        return this.childVector.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return ((CommNetBrowseTreeNode)this.childVector.elementAt(n)).getProperties().elementAt(n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ((CommNetBrowseTreeNode)this.childVector.elementAt(n)).getProperties().set(n2, object);
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
    }

    public Class getColumnClass(int n) {
        try {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return object.getClass();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.columnNames.elementAt(n).getClass();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public Enumeration enumerateLogicalChildren() {
        return this.childVector.elements();
    }

    void addChildInOrder(CommNetTreeNode commNetTreeNode) {
        int n;
        boolean bl = false;
        for (n = 0; n < this.childVector.size(); ++n) {
            if (Utils.compareStrings(commNetTreeNode.toString().toLowerCase(), this.childVector.elementAt(n).toString().toLowerCase()) >= 0) continue;
            this.childVector.insertElementAt(commNetTreeNode, n);
            bl = true;
            break;
        }
        if (!bl) {
            this.childVector.addElement(commNetTreeNode);
        }
        bl = false;
        for (n = 0; n < super.getChildCount(); ++n) {
            if (Utils.compareStrings(commNetTreeNode.toString().toLowerCase(), super.getChildAt(n).toString().toLowerCase()) >= 0) continue;
            super.insert(commNetTreeNode, n);
            bl = true;
            break;
        }
        if (!bl) {
            super.add(commNetTreeNode);
        }
    }

    void addLogicalChildInOrder(CommNetTreeNode commNetTreeNode) {
        boolean bl = false;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (Utils.compareStrings(commNetTreeNode.toString().toLowerCase(), this.getLogicalChildAt(i).toString().toLowerCase()) >= 0) continue;
            this.childVector.insertElementAt(commNetTreeNode, i);
            bl = true;
            break;
        }
        if (!bl) {
            this.childVector.addElement(commNetTreeNode);
        }
        commNetTreeNode.setParent(this);
    }

    public void addLogicalChildUnsorted(CommNetTreeNode commNetTreeNode) {
        if (commNetTreeNode != null) {
            commNetTreeNode.nodeBeingAdded(this);
            this.childVector.addElement(commNetTreeNode);
            commNetTreeNode.setParent(this);
        }
    }

    @Override
    public void removeAll() {
        if (this.getChildCount() != 0) {
            super.removeAllChildren();
        }
        if (this.getChildCount() != 0) {
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                CommNetTreeNode commNetTreeNode = (CommNetTreeNode)enumeration.nextElement();
                commNetTreeNode.removeAll();
            }
            super.removeAllChildren();
        }
        if (this.getRowCount() != 0) {
            this.childVector.removeAllElements();
        }
    }

    @Override
    public void addUnsorted(CommNetTreeNode commNetTreeNode) {
        if (commNetTreeNode != null) {
            commNetTreeNode.nodeBeingAdded(this);
            this.childVector.addElement(commNetTreeNode);
            super.add(commNetTreeNode);
        }
    }

    protected void loadData() {
        int n = this.getChildCount();
        this.childVector.removeAllElements();
        for (int i = 0; i < n; ++i) {
            CommNetBrowseTreeNode commNetBrowseTreeNode = (CommNetBrowseTreeNode)this.getChildAt(i);
            this.childVector.addElement(commNetBrowseTreeNode.getProperties());
        }
    }

    public void removeLogicalChild(CommNetTreeNode commNetTreeNode) {
        commNetTreeNode.nodeBeingRemoved(this);
        this.childVector.removeElement(commNetTreeNode);
    }

    public void removeAllLogicalChildren() {
        this.childVector.removeAllElements();
    }

    public Enumeration getLogicalChildren() {
        return this.childVector.elements();
    }

    public CommNetTreeNode getLogicalChildAt(int n) {
        return (CommNetTreeNode)this.childVector.get(n);
    }

    public int getLogicalChildCount() {
        int n = 0;
        if (this.childVector != null) {
            n = this.childVector.size();
        }
        return n;
    }

    public int getTotalChildCount() {
        return this.getLogicalChildCount() + this.getChildCount();
    }

    public CommNetTreeNode getTotalChildAt(int n) {
        if (n < 0 || n >= this.getTotalChildCount()) {
            return null;
        }
        int n2 = this.getChildCount();
        if (n < n2) {
            return (CommNetTreeNode)this.getChildAt(n);
        }
        return (CommNetTreeNode)this.childVector.elementAt(n - n2);
    }

    @Override
    public CommNetTreeNode getChildOfId(int n) {
        CommNetTreeNode commNetTreeNode = null;
        this.populate();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getLogicalChildAt(i).getId() != n) continue;
            commNetTreeNode = this.getLogicalChildAt(i);
            break;
        }
        return commNetTreeNode;
    }

    public int[] getColumnSizeMap() {
        return new int[0];
    }

    public boolean isHorizontalScrollRequired() {
        return false;
    }
}

