/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.calender;

import commvault.cte.CteStringBank;
import commvault.cte.common.ui.HourMinComponent;
import commvault.cte.component.LayoutUtils;
import commvault.cte.component.TitledComponent;
import commvault.cte.component.TogglePanel;
import commvault.cte.component.Utilities;
import commvault.cte.component.VerticalFlowLayout;
import commvault.cte.component.calender.TimeChooser;
import commvault.cte.component.calender.TimeZonePanel;
import commvault.cte.net.IdIdNameItem;
import commvault.cte.util.Application;
import commvault.cte.util.DateUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TimeRangePanel
extends JPanel {
    public static final String END_TIME = "endTime";
    public static final String START_TIME = "startTime";
    private TimeChooser m_fromTime = new TimeChooser(1);
    private TimeChooser m_toTime = new TimeChooser(1);
    private TimeZonePanel m_tzPanel = new TimeZonePanel(true);
    private JToggleButton m_specifyTimeRange = new JCheckBox("", true);
    private TogglePanel m_timeRangePanel = null;
    private boolean m_showRelativeTime = false;
    HourMinComponent[] fromToTF = new HourMinComponent[]{new HourMinComponent(true), new HourMinComponent(true)};
    JPanel m_relativeTimeRangePanel = null;
    JToggleButton m_relativeTimeRb = null;
    GridBagConstraints gridBagConstraints = new GridBagConstraints();
    ButtonGroup group = new ButtonGroup();
    private JToggleButton startTimeCheckBox = null;
    private JToggleButton endTimeCheckBox = null;
    private boolean isFromBrowseOptions = false;
    private boolean isFromOracleBackup = false;
    private boolean fillRemaining = true;
    private JRadioButton timeRangefromOracleBackup;
    private boolean hideTimeZoneCombo = false;
    TimeZone clientTimeZone = null;
    private boolean m_showSeconds = false;
    JPanel startTimePanel = new JPanel();
    JPanel endTimePanel = new JPanel();
    private JRadioButton historyAbsoluteTimeRangeButton;
    private boolean isFromHistory;

    public TimeRangePanel() {
        this(new JCheckBox(CteStringBank.Specify_Time_Range.getI18n()), true);
    }

    public TimeRangePanel(String string) {
        this(new JCheckBox(string), true);
    }

    public TimeRangePanel(TimeZonePanel timeZonePanel) {
        this.m_tzPanel = timeZonePanel;
        this.m_fromTime = new TimeChooser(2);
        this.m_toTime = new TimeChooser(2);
        this.initTimeZone();
        this.setLayout(new VerticalFlowLayout(0, 0, 5, true, false));
        this.add(new TitledComponent(CteStringBank.From_Time.getI18n(), (JComponent)this.m_fromTime));
        this.add(new TitledComponent(CteStringBank.To_Time.getI18n(), (JComponent)this.m_toTime));
    }

    public TimeRangePanel(boolean bl) {
        this(new JCheckBox(CteStringBank.Specify_Time_Range.getI18n()), false, bl);
        this.getToggleButton().setSelected(!bl);
        if (!bl) {
            this.getToggleButton().getParent().remove(this.getToggleButton());
            this.setBorder(BorderFactory.createTitledBorder(this.getToggleButton().getText()));
        }
    }

    public TimeRangePanel(JToggleButton jToggleButton, boolean bl) {
        this(jToggleButton, bl, false);
    }

    public TimeRangePanel(JToggleButton jToggleButton, boolean bl, boolean bl2) {
        this.m_specifyTimeRange = jToggleButton;
        this.m_specifyTimeRange.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!TimeRangePanel.this.m_specifyTimeRange.isSelected() && TimeRangePanel.this.startTimeCheckBox != null) {
                    TimeRangePanel.this.startTimeCheckBox.setSelected(false);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.initTimeRangePanel(bl, bl2);
        this.add((Component)this.m_timeRangePanel, "Center");
    }

    public TimeRangePanel(boolean bl, boolean bl2, boolean bl3) {
        this.isFromBrowseOptions = bl3;
        this.m_specifyTimeRange = new JCheckBox(CteStringBank.Specify_Time_Range.getI18n());
        this.m_specifyTimeRange.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!TimeRangePanel.this.m_specifyTimeRange.isSelected() && TimeRangePanel.this.startTimeCheckBox != null) {
                    TimeRangePanel.this.startTimeCheckBox.setSelected(false);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.initTimeRangePanel(bl, bl2);
        this.add((Component)this.m_timeRangePanel, "Center");
    }

    public TimeRangePanel(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(bl, bl2, bl3, bl4, false);
    }

    public TimeRangePanel(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.m_showSeconds = bl5;
        this.isFromBrowseOptions = bl4;
        this.m_specifyTimeRange = new JCheckBox(CteStringBank.Specify_Time_Range.getI18n());
        this.m_specifyTimeRange.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!TimeRangePanel.this.m_specifyTimeRange.isSelected() && TimeRangePanel.this.startTimeCheckBox != null) {
                    TimeRangePanel.this.startTimeCheckBox.setSelected(false);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.fillRemaining = false;
        if (this.m_showSeconds) {
            this.m_fromTime = new TimeChooser(new GregorianCalendar(), 1, this.m_showSeconds);
            this.m_toTime = new TimeChooser(new GregorianCalendar(), 1, this.m_showSeconds);
        }
        this.initTimeRangePanel(false, bl3);
        this.add((Component)this.m_timeRangePanel, "East");
        this.getToggleButton().getParent().remove(this.getToggleButton());
    }

    public TimeRangePanel(boolean bl, boolean bl2, boolean bl3, JRadioButton jRadioButton, boolean bl4, boolean bl5) {
        this.m_showSeconds = bl5;
        this.isFromOracleBackup = bl3;
        this.timeRangefromOracleBackup = jRadioButton;
        this.setLayout(new BorderLayout());
        if (bl5) {
            this.m_fromTime = new TimeChooser(new GregorianCalendar(), 1, this.m_showSeconds);
            this.m_toTime = new TimeChooser(new GregorianCalendar(), 1, this.m_showSeconds);
        }
        this.initTimeRangePanel(bl, bl2);
        this.add((Component)this.m_timeRangePanel, "Center");
        if (bl4 && this.m_tzPanel != null) {
            this.m_tzPanel.setVisible(false);
        }
    }

    public TimeRangePanel(boolean bl, boolean bl2, boolean bl3, JRadioButton jRadioButton, boolean bl4) {
        this(bl, bl2, bl3, jRadioButton, bl4, false);
    }

    public TimeRangePanel(boolean bl, boolean bl2, boolean bl3, JRadioButton jRadioButton, boolean bl4, TimeZone timeZone) {
        this.clientTimeZone = timeZone;
        this.isFromOracleBackup = bl3;
        this.timeRangefromOracleBackup = jRadioButton;
        this.initTimeZone();
        this.setLayout(new BorderLayout());
        this.initTimeRangePanel(bl, bl2);
        this.add((Component)this.m_timeRangePanel, "Center");
        if (bl4 && this.m_tzPanel != null) {
            this.m_tzPanel.setVisible(false);
        }
    }

    public TimeRangePanel(boolean bl, boolean bl2, boolean bl3, JRadioButton jRadioButton) {
        this.isFromOracleBackup = bl3;
        this.timeRangefromOracleBackup = jRadioButton;
        this.setLayout(new BorderLayout());
        this.initTimeRangePanel(bl, bl2);
        this.add((Component)this.m_timeRangePanel, "Center");
    }

    public TimeRangePanel(boolean bl, boolean bl2) {
        this.m_showRelativeTime = bl;
        this.setLayout(new GridBagLayout());
        this.initTimeRangePanel(bl2);
        Utilities.addRow((JPanel)this, null, (JComponent)this.m_timeRangePanel);
        if (this.m_showRelativeTime) {
            Utilities.addRow((JPanel)this, null, (JComponent)this.m_relativeTimeRangePanel);
        }
        Utilities.fillRemaining(this);
    }

    public TimeRangePanel(boolean bl, JRadioButton jRadioButton, boolean bl2) {
        this.setLayout(new BorderLayout());
        this.historyAbsoluteTimeRangeButton = jRadioButton;
        this.isFromHistory = bl2;
        this.initTimeRangePanel(bl, false);
        this.add((Component)this.m_timeRangePanel, "Center");
    }

    private void initTimeZone() {
        this.m_tzPanel.addTimZoneListener(this.m_fromTime);
        this.m_tzPanel.addTimZoneListener(this.m_toTime);
        TimeZone timeZone = DateUtilities.useUserDateFormat ? DateUtilities.getTimeZone() : Application.commServerTimeZone;
        if (this.isFromOracleBackup && this.clientTimeZone != null) {
            timeZone = this.clientTimeZone;
        }
        this.m_tzPanel.setBrowseTimeZone(timeZone);
        this.m_tzPanel.setBrowseTimeZone();
        this.m_fromTime.setTimeZone(timeZone);
        this.m_toTime.setTimeZone(timeZone);
    }

    public void initTimeRangePanel(boolean bl) {
        this.initTimeRangePanel(bl, false);
    }

    public void initTimeRangePanel(boolean bl, boolean bl2) {
        JPanel jPanel;
        if (this.m_showRelativeTime) {
            this.m_specifyTimeRange = new JRadioButton(CteStringBank.Absolute.getI18n());
            this.m_relativeTimeRangePanel = this.createRelativeTimeRangePanel();
            this.group.add(this.m_specifyTimeRange);
            this.group.add(this.m_relativeTimeRb);
        }
        this.m_fromTime.setTime(-86400);
        this.initTimeZone();
        JPanel jPanel2 = new JPanel();
        if (this.isFromOracleBackup) {
            this.startTimeCheckBox = new JCheckBox(CteStringBank.Start_Time.getI18n());
            jPanel2 = new TogglePanel(this.startTimeCheckBox);
            if (this.clientTimeZone != null) {
                this.m_tzPanel.setCommServerClientTimeZones(Application.commServerTimeZone.toString(), this.clientTimeZone.getID(), true);
                this.m_tzPanel.restTimeZoneFromSchedule(true);
            }
        } else if (bl2) {
            this.startTimeCheckBox = new JCheckBox(CteStringBank.Start_Time.getI18n(), true);
            jPanel2 = new TogglePanel(this.startTimeCheckBox);
        } else {
            jPanel2.setBorder(new TitledBorder(CteStringBank.Start_Time.getI18n()));
        }
        jPanel2.add(this.m_fromTime);
        if (this.isFromOracleBackup) {
            this.endTimeCheckBox = new JCheckBox(CteStringBank.End_Time.getI18n());
            jPanel = new TogglePanel(this.endTimeCheckBox);
            jPanel.add(this.m_toTime);
        } else if (!this.isFromBrowseOptions) {
            jPanel = new JPanel();
            jPanel.add(this.m_toTime);
            jPanel.setBorder(new TitledBorder(CteStringBank.End_Time.getI18n()));
        } else {
            this.endTimeCheckBox = new JCheckBox(CteStringBank.End_Time.getI18n());
            jPanel = new TogglePanel(this.endTimeCheckBox);
            jPanel.add(this.m_toTime);
        }
        if (this.isFromOracleBackup || this.isFromHistory) {
            if (this.isFromOracleBackup) {
                this.m_timeRangePanel = new TogglePanel(this.timeRangefromOracleBackup);
            } else {
                this.m_specifyTimeRange = this.historyAbsoluteTimeRangeButton;
                this.m_timeRangePanel = new TogglePanel(this.historyAbsoluteTimeRangeButton);
            }
        } else {
            this.m_timeRangePanel = bl ? new TogglePanel(this.m_specifyTimeRange) : new TogglePanel(this.m_specifyTimeRange, BorderFactory.createEmptyBorder(0, 20, 0, 0));
        }
        this.m_timeRangePanel.setLayout(new GridBagLayout());
        Utilities.addRow((Container)this.m_timeRangePanel, null, (JComponent)this.m_tzPanel, true);
        this.m_timeRangePanel.add((Component)jPanel2, Utilities.getConstraints(this.gridBagConstraints, -1, -1, 1, 1, 1.0, this.m_showRelativeTime ? 0.0 : 1.0, 17, 1, new Insets(0, 15, 10, 5)));
        this.m_timeRangePanel.add((Component)jPanel, Utilities.getConstraints(this.gridBagConstraints, -1, -1, 0, 1, 1.0, this.m_showRelativeTime ? 0.0 : 1.0, 17, 1, new Insets(0, 0, 10, 15)));
        if (this.fillRemaining) {
            Utilities.fillRemaining(this.m_timeRangePanel);
        }
        this.m_specifyTimeRange.doClick();
        this.m_specifyTimeRange.doClick();
    }

    private JPanel createRelativeTimeRangePanel() {
        this.m_relativeTimeRb = new JRadioButton(CteStringBank.Relative.getI18n());
        TogglePanel togglePanel = new TogglePanel(this.m_relativeTimeRb, BorderFactory.createEmptyBorder(0, 20, 0, 0));
        togglePanel.setLayout(new GridBagLayout());
        this.fromToTF[0].setTime(86400);
        this.fromToTF[1].setTime(0);
        LayoutUtils.addRow((Container)togglePanel, new JComponent[]{new JLabel(CteStringBank.From_last.getI18n()), this.fromToTF[0]}, 40, true);
        LayoutUtils.addRow((Container)togglePanel, new JComponent[]{new JLabel(CteStringBank.To_Last.getI18n()), this.fromToTF[1]}, 40, true);
        togglePanel.setBorder(null);
        return togglePanel;
    }

    public int getCommserveStartTime() {
        int n = 0;
        if (this.m_specifyTimeRange.isSelected() && (this.startTimeCheckBox == null || this.startTimeCheckBox.isSelected())) {
            TimeChooser timeChooser = new TimeChooser();
            timeChooser.setTime(this.getStartTime());
            timeChooser.setTimeZone(Application.commServerTimeZone);
            n = timeChooser.getUnixTime();
        }
        return n;
    }

    public int getCommserveEndTime() {
        int n = 0;
        if (this.m_specifyTimeRange.isSelected()) {
            TimeChooser timeChooser = new TimeChooser();
            timeChooser.setTime(this.getEndTime());
            timeChooser.setTimeZone(Application.commServerTimeZone);
            n = timeChooser.getUnixTime();
        }
        return n;
    }

    public int getStartTime() {
        int n = 0;
        if (this.isFromOracleBackup) {
            n = this.m_fromTime.getUnixTime();
        } else if (this.m_specifyTimeRange.isSelected() && (this.startTimeCheckBox == null || this.startTimeCheckBox.isSelected())) {
            n = this.m_fromTime.getUnixTime();
        } else if (this.m_showRelativeTime && this.m_relativeTimeRb.isSelected()) {
            n = this.fromToTF[0].getTime();
        }
        return n;
    }

    public void setStartTime(int n) {
        int n2 = this.m_toTime.getUnixTime();
        if (this.m_specifyTimeRange != null && n > 0) {
            this.m_specifyTimeRange.setSelected(true);
            if (this.startTimeCheckBox != null) {
                this.startTimeCheckBox.setSelected(true);
            }
        }
        this.m_fromTime.setTime(n);
        this.firePropertyChange(START_TIME, n2, n);
    }

    public void setEndTime(int n) {
        int n2 = this.m_toTime.getUnixTime();
        if (this.m_specifyTimeRange != null && n > 0) {
            this.m_specifyTimeRange.setSelected(true);
            if (this.endTimeCheckBox != null) {
                this.endTimeCheckBox.setSelected(true);
            }
        }
        this.m_toTime.setTime(n);
        this.firePropertyChange(END_TIME, n2, n);
    }

    public int getEndTime() {
        int n = 0;
        if (this.isFromOracleBackup || this.m_specifyTimeRange.isSelected()) {
            n = this.m_toTime.getUnixTime();
        } else if (this.m_showRelativeTime && this.m_relativeTimeRb.isSelected()) {
            n = this.fromToTF[1].getTime();
        }
        return n;
    }

    public boolean isRelativeTime() {
        boolean bl = false;
        if (this.m_showRelativeTime && this.m_relativeTimeRb.isSelected()) {
            bl = true;
        }
        return bl;
    }

    public SimpleTimeZone getSelectedTimeZone() {
        return this.m_tzPanel.getSelectedTimeZone();
    }

    public IdIdNameItem getTimeZoneItem() {
        return this.m_tzPanel.getSelectedTimeZoneItem();
    }

    public boolean validateTimeRange() {
        return this.getCommserveStartTime() <= this.getCommserveEndTime();
    }

    public JToggleButton getToggleButton() {
        return this.m_specifyTimeRange;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.m_tzPanel.setBrowseTimeZone(timeZone);
        this.m_tzPanel.setBrowseTimeZone();
        this.m_fromTime.setTimeZone(timeZone);
        this.m_toTime.setTimeZone(timeZone);
    }

    public JToggleButton getStartTimeCb() {
        return this.startTimeCheckBox;
    }

    public JToggleButton getEndTimeCb() {
        return this.endTimeCheckBox;
    }

    public GregorianCalendar getGTime() {
        return this.m_toTime.getTime();
    }

    public GregorianCalendar getGFromTime() {
        return this.m_fromTime.getTime();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_tzPanel.setEnabled(bl);
        if (this.startTimeCheckBox != null) {
            this.startTimeCheckBox.setEnabled(bl);
        }
        if (this.endTimeCheckBox != null) {
            this.endTimeCheckBox.setEnabled(bl);
        }
    }

    public TimeChooser getFromTimeChooser() {
        return this.m_fromTime;
    }

    public TimeChooser getToTimeChooser() {
        return this.m_toTime;
    }

    public void disableEnableTimeRangePanel(boolean bl) {
        this.endTimePanel.setEnabled(bl);
        this.startTimePanel.setEnabled(bl);
        this.m_toTime.setEnabled(bl);
        this.m_fromTime.setEnabled(bl);
    }
}

