/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.calender;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.StyledLabel;
import com.jidesoft.swing.StyledLabelBuilder;
import commvault.cte.component.VTextIcon;
import commvault.cte.component.calender.CalendarViewModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

class RowHeaderRenderer
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor {
    JideButton but = new JideButton();
    JPanel tp = new JPanel(new BorderLayout(0, 0));
    CalendarViewModel.CalendarType calType = CalendarViewModel.CalendarType.MONTHLY;

    public RowHeaderRenderer(CalendarViewModel.CalendarType calendarType) {
        this.calType = calendarType;
        this.but.setOpaque(true);
        this.but.setBorderPainted(false);
        this.but.setOrientation(1);
        this.but.setHorizontalTextPosition(11);
        ThemePainter themePainter = (ThemePainter)UIDefaultsLookup.get((Object)"Theme.painter");
        this.tp.setBackground(themePainter.getControlLt());
        this.tp.add((Component)this.but);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (this.calType == CalendarViewModel.CalendarType.MONTHLY) {
            this.getButton((Date)object);
            return this.tp;
        }
        Component component = this.getLabel((Date)object, jTable, n);
        component.setBackground(jTable.getTableHeader().getBackground());
        return component;
    }

    private Component getLabel(Date date, JTable jTable, int n) {
        JScrollPane jScrollPane = (JScrollPane)jTable.getParent().getParent();
        JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
        int n2 = jScrollBar.getValue() * 2 / jTable.getRowCount();
        String string = "00";
        if (n2 == n) {
            string = n < 12 ? "am" : "pm";
        }
        String string2 = MessageFormat.format("{0,time,hh}'{'{1}:sp'}'", date, string);
        StyledLabel styledLabel = StyledLabelBuilder.createStyledLabel((String)string2);
        styledLabel.setOpaque(true);
        styledLabel.setFont(styledLabel.getFont().deriveFont(16.0f));
        styledLabel.setHorizontalTextPosition(0);
        styledLabel.setVerticalTextPosition(1);
        styledLabel.setVerticalAlignment(1);
        return styledLabel;
    }

    private JButton getButton(Date date) {
        VTextIcon vTextIcon = new VTextIcon((Component)this.but, this.getDayString(date), 2);
        this.but.setIcon((Icon)vTextIcon);
        return this.but;
    }

    private String getDayString(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 6);
        return MessageFormat.format("{0,date,MMM d} - {1,date,MMM d}", date, calendar.getTime());
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        return new RowHeaderRenderer(this.calType).getTableCellRendererComponent(jTable, object, bl, false, n, n2);
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }
}

