/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.calender;

import commvault.cte.CteStringBank;
import commvault.cte.component.calender.CalendarComboBox;
import commvault.cte.component.events.TimeListener;
import commvault.cte.util.DateUtilities;
import commvault.cte.util.RuntimeContext;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.text.BadLocationException;

public class PopupCalendar
extends JPopupMenu {
    private static final String prefix = "cte.component.PopupCalendar.";
    private static final Font TEXT_AREA_FONT = new Font("Dialog", 0, 12);
    CalendarComboBox calendarComboBox;
    JButton todayButton = new JButton(CteStringBank.Today.getI18n());
    JPanel popupPanel = new JPanel();
    BasicArrowButton leftButton = new BasicArrowButton(7);
    JButton popupLabel = new JButton();
    BasicArrowButton rightButton = new BasicArrowButton(3);
    JTextArea popupTextArea = new JTextArea(7, 16);
    JPanel popupPanel3 = new JPanel();
    JPanel popupPanel2 = new JPanel();
    JLabel space = new JLabel("");
    JLabel Sun = new JLabel(CteStringBank.S.getI18n());
    JLabel Mon = new JLabel(CteStringBank.M.getI18n());
    JLabel Tue = new JLabel(CteStringBank.T.getI18n());
    JLabel Wen = new JLabel(CteStringBank.W.getI18n());
    JLabel Thu = new JLabel(CteStringBank.T.getI18n());
    JLabel Fri = new JLabel(CteStringBank.F.getI18n());
    JLabel Sat = new JLabel(CteStringBank.S.getI18n());
    JPanel todayPanel = new JPanel();
    EtchedBorder dBorder = new EtchedBorder();
    SimpleDateFormat dateFormat1 = null;
    SimpleDateFormat dateFormat2 = null;
    Calendar theday;
    JTextArea comboBoxTextField;
    Vector listeners = new Vector();
    private int textStartPosition;
    private int trimmedTextSize;
    private boolean isTimeResetToStartTime = false;

    public PopupCalendar(CalendarComboBox calendarComboBox) {
        this(calendarComboBox, false);
    }

    public PopupCalendar(CalendarComboBox calendarComboBox, boolean bl) {
        this.calendarComboBox = calendarComboBox;
        this.isTimeResetToStartTime = bl;
        this.theday = this.calendarComboBox.theday;
        this.comboBoxTextField = this.calendarComboBox.comboBoxTextField;
        Locale locale = RuntimeContext.instance().getLoggedInLocale();
        this.dateFormat1 = new SimpleDateFormat(DateUtilities.instance().getUserSpecificShortDateFormat(), locale);
        this.dateFormat2 = new SimpleDateFormat(DateUtilities.instance().getUserSpecificShortDateFormat(), locale);
        this.setLayout(new BorderLayout(0, 0));
        this.popupPanel2.setLayout(new BorderLayout(0, 0));
        this.popupPanel.setLayout(new BorderLayout(0, 0));
        this.popupPanel.add("West", this.leftButton);
        this.popupLabel.setBorder(this.dBorder);
        this.popupLabel.setHorizontalAlignment(0);
        this.popupPanel.add("Center", this.popupLabel);
        this.popupPanel.add("East", this.rightButton);
        this.popupPanel2.add("North", this.popupPanel);
        this.popupPanel3.setLayout(new GridLayout());
        this.popupPanel3.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        this.popupPanel3.add(this.space);
        this.popupPanel3.add(this.Sun);
        this.popupPanel3.add(this.Mon);
        this.popupPanel3.add(this.Tue);
        this.popupPanel3.add(this.Wen);
        this.popupPanel3.add(this.Thu);
        this.popupPanel3.add(this.Fri);
        this.popupPanel3.add(this.Sat);
        this.popupPanel2.add("South", this.popupPanel3);
        this.add("North", this.popupPanel2);
        this.popupTextArea.setEditable(false);
        this.popupTextArea.setTabSize(2);
        this.popupTextArea.setBorder(new SoftBevelBorder(1));
        this.popupTextArea.setFont(TEXT_AREA_FONT);
        this.add("Center", this.popupTextArea);
        this.todayButton.setHorizontalAlignment(0);
        this.todayPanel.add(this.todayButton);
        this.add("South", this.todayPanel);
        Mouse mouse = new Mouse();
        this.popupTextArea.addMouseListener(mouse);
        this.todayButton.addMouseListener(mouse);
        this.leftButton.addMouseListener(mouse);
        this.rightButton.addMouseListener(mouse);
        this.popupLabel.addMouseListener(mouse);
        class CompKeyAdapter
        extends KeyAdapter {
            CompKeyAdapter() {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                PopupCalendar.this.moveFocus(keyEvent);
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    PopupCalendar.this.moveFocus(keyEvent);
                }
            }
        }
        CompKeyAdapter compKeyAdapter = new CompKeyAdapter();
        this.todayButton.addKeyListener(compKeyAdapter);
        this.popupTextArea.addKeyListener(compKeyAdapter);
        this.rightButton.addKeyListener(compKeyAdapter);
        this.leftButton.addKeyListener(compKeyAdapter);
        this.addKeyListener(compKeyAdapter);
        this.setTextAreas();
        this.setRequestFocusEnabled(false);
    }

    private void move(int n) {
        int n2 = this.popupTextArea.getSelectionStart();
        switch (n) {
            case 37: {
                if (this.isChar(n2 -= 3, '\n')) {
                    --n2;
                }
                if (this.isChar(n2, '\t') && this.isChar(n2 + 1, '\n')) {
                    --n2;
                }
                this.setSelectedPosition(this.doAdjustment(n2));
                break;
            }
            case 39: {
                try {
                    if (this.popupTextArea.getText(n2, 1).charAt(0) == '\n') {
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setSelectedPosition(this.doAdjustment(n2));
                break;
            }
            case 38: {
                this.setSelectedPosition(this.doAdjustment(n2 - 1));
                break;
            }
            case 40: {
                this.setSelectedPosition(this.doAdjustment(n2 - 1));
            }
        }
    }

    private void moveFocus(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.setVisible(false);
            keyEvent.setKeyCode(0);
        }
        if (keyEvent.getKeyCode() == 37) {
            if ((keyEvent.getModifiers() & 2) == 2) {
                this.leftButton_mouseClicked(null);
            } else {
                this.move(37);
            }
        } else if (keyEvent.getKeyCode() == 39) {
            if ((keyEvent.getModifiers() & 2) == 2) {
                this.rightButton_mouseClicked(null);
            } else {
                this.move(39);
            }
        } else if (keyEvent.getKeyCode() == 38) {
            this.move(38);
        } else if (keyEvent.getKeyCode() == 40) {
            this.move(40);
        } else if (keyEvent.getKeyCode() == 10) {
            this.popupTextArea_mouseReleased(null);
        }
    }

    void setTextAreas() {
        this.comboBoxTextField.setText(this.dateFormat1.format(this.theday.getTime()));
        this.setPopupTextAreas();
        this.setVisible(false);
        this.firePropertyChange("time", 0, (int)(this.theday.getTimeInMillis() / 1000L));
    }

    void setPopupTextAreas() {
        this.popupLabel.setText(this.dateFormat2.format(this.theday.getTime()));
        this.popupTextArea.setText(this.setCalendarString());
        this.popupTextArea_setFocus();
    }

    @Override
    public void setVisible(boolean bl) {
        boolean bl2 = super.isVisible();
        super.setVisible(bl);
        if (bl) {
            this.popupTextArea.requestFocus();
        } else if (bl2) {
            this.calendarComboBox.comboBoxTextField.requestFocus();
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    void todayButton_mouseClicked(MouseEvent mouseEvent) {
        Locale locale = RuntimeContext.instance().getLoggedInLocale();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.theday.getTimeZone(), locale);
        this.theday.set(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5));
        this.setTextAreas();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TimeListener)this.listeners.elementAt(i)).timeChanged(this.theday);
        }
        this.setVisible(false);
    }

    void leftButton_mouseClicked(MouseEvent mouseEvent) {
        this.theday.add(2, -1);
        this.setPopupTextAreas();
    }

    void rightButton_mouseClicked(MouseEvent mouseEvent) {
        this.theday.add(2, 1);
        this.setPopupTextAreas();
    }

    void popupTextArea_setFocus() {
        for (int i = 0; i < 100; ++i) {
            try {
                if (this.theday.get(5) < 10) {
                    if (!this.popupTextArea.getText(i, 1).equals(String.valueOf(this.theday.get(5)))) continue;
                    this.popupTextArea.setSelectionStart(i);
                    this.popupTextArea.setSelectionEnd(i + 1);
                    break;
                }
                if (this.theday.get(5) < 10 || !this.popupTextArea.getText(i, 2).equals(String.valueOf(this.theday.get(5)))) continue;
                this.popupTextArea.setSelectionStart(i);
                this.popupTextArea.setSelectionEnd(i + 2);
                break;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    String setCalendarString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        Locale locale = RuntimeContext.instance().getLoggedInLocale();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.theday.getTimeZone(), locale);
        gregorianCalendar.set(this.theday.get(1), this.theday.get(2), 1);
        int n2 = this.theday.getActualMaximum(5);
        int n3 = gregorianCalendar.get(7);
        for (n = 0; n < n3; ++n) {
            stringBuffer.append('\t');
        }
        this.textStartPosition = n3;
        n = 2 * n3;
        int n4 = 0;
        while (n4 < n2) {
            if (n % 2 == 1) {
                stringBuffer.append('\t');
            } else if (n % 16 == 0) {
                stringBuffer.append('\n');
            } else {
                stringBuffer.append(++n4);
            }
            ++n;
        }
        this.trimmedTextSize = stringBuffer.toString().trim().length();
        return stringBuffer.toString();
    }

    void popupTextArea_mousePressed(MouseEvent mouseEvent) {
        int n = this.popupTextArea.viewToModel(mouseEvent.getPoint()) - 1;
        this.setSelectedPosition(n);
    }

    private void setSelectedPosition(int n) {
        if (n < 0) {
            return;
        }
        try {
            if (!this.popupTextArea.getText(n, 1).equals("\t")) {
                if (!this.popupTextArea.getText(n - 1, 1).equals("\t")) {
                    this.popupTextArea.setSelectionStart(n - 1);
                    this.popupTextArea.setSelectionEnd(n + 1);
                } else {
                    this.popupTextArea.setSelectionStart(n);
                    if (!this.popupTextArea.getText(n + 1, 1).equals("\t")) {
                        this.popupTextArea.setSelectionEnd(n + 2);
                    } else {
                        this.popupTextArea.setSelectionEnd(n + 1);
                    }
                }
                this.theday.set(this.theday.get(1), this.theday.get(2), Integer.parseInt(this.popupTextArea.getSelectedText()));
            } else if (!this.popupTextArea.getText(n + 1, 1).equals("\t")) {
                if (!this.popupTextArea.getText(++n - 1, 1).equals("\t")) {
                    this.popupTextArea.setSelectionStart(n - 1);
                    this.popupTextArea.setSelectionEnd(n + 1);
                } else {
                    this.popupTextArea.setSelectionStart(n);
                    if (!this.popupTextArea.getText(n + 1, 1).equals("\t")) {
                        this.popupTextArea.setSelectionEnd(n + 2);
                    } else {
                        this.popupTextArea.setSelectionEnd(n + 1);
                    }
                }
                this.theday.set(this.theday.get(1), this.theday.get(2), Integer.parseInt(this.popupTextArea.getSelectedText()));
            } else if (!this.popupTextArea.getText(n - 1, 1).equals("\t")) {
                if (!this.popupTextArea.getText(--n - 1, 1).equals("\t")) {
                    this.popupTextArea.setSelectionStart(n - 1);
                    this.popupTextArea.setSelectionEnd(n + 1);
                } else {
                    this.popupTextArea.setSelectionStart(n);
                    if (!this.popupTextArea.getText(n + 1, 1).equals("\t")) {
                        this.popupTextArea.setSelectionEnd(n + 2);
                    } else {
                        this.popupTextArea.setSelectionEnd(n + 1);
                    }
                }
                this.theday.set(this.theday.get(1), this.theday.get(2), Integer.parseInt(this.popupTextArea.getSelectedText()));
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    void popupTextArea_mouseReleased(MouseEvent mouseEvent) {
        this.setTextAreas();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TimeListener)this.listeners.elementAt(i)).timeChanged(this.theday);
        }
        this.setVisible(false);
    }

    public void addTimeListener(TimeListener timeListener) {
        if (timeListener != null) {
            this.listeners.addElement(timeListener);
        }
    }

    public void setTime(int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date(1000L * Long.parseLong(n + "")));
        this.setTime(gregorianCalendar);
    }

    public int getTime() {
        return (int)(this.theday.getTimeInMillis() / 1000L);
    }

    public void setTime(Calendar calendar) {
        this.theday = calendar;
        this.dateFormat1.setTimeZone(this.theday.getTimeZone());
        if (this.isTimeResetToStartTime) {
            this.theday.set(11, 0);
            this.theday.set(12, 0);
            this.theday.set(13, 0);
        }
        this.setTextAreas();
    }

    private int doAdjustment(int n) {
        if (n > this.textStartPosition + this.trimmedTextSize) {
            this.rightButton_mouseClicked(null);
            n = this.textStartPosition;
        } else if (n < this.textStartPosition - 1) {
            this.leftButton_mouseClicked(null);
            n = this.textStartPosition + this.trimmedTextSize - 1;
        }
        return n;
    }

    public boolean isChar(int n, char c) {
        try {
            if (this.popupTextArea.getText(n, 1).charAt(0) == c) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void cancel() {
        this.setVisible(false);
    }

    class Mouse
    extends MouseAdapter {
        Mouse() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == PopupCalendar.this.todayButton) {
                PopupCalendar.this.todayButton_mouseClicked(mouseEvent);
            } else if (object == PopupCalendar.this.leftButton) {
                PopupCalendar.this.leftButton_mouseClicked(mouseEvent);
            } else if (object == PopupCalendar.this.rightButton) {
                PopupCalendar.this.rightButton_mouseClicked(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == PopupCalendar.this.popupTextArea) {
                PopupCalendar.this.popupTextArea_mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == PopupCalendar.this.popupTextArea) {
                PopupCalendar.this.popupTextArea_mouseReleased(mouseEvent);
            }
        }
    }
}

