/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.calender;

import commvault.cte.CteStringBank;
import commvault.cte.common.ui.HourMinComponent;
import commvault.cte.component.LayoutUtils;
import commvault.cte.component.calender.ChangeTimeZoneInterface;
import commvault.cte.component.calender.JDateChooser;
import commvault.cte.component.calender.TimeChooser;
import commvault.cte.component.calender.TimeRangePanel;
import commvault.cte.component.calender.TimeZonePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class NamedDateComponent
extends JPanel
implements ActionListener,
ChangeTimeZoneInterface {
    private static final int IS = 3;
    private static final int AFTER = -1;
    private static final int BEFORE = 1;
    private static final int BETWEEN = 2;
    private static final int ANY = 0;
    private static final int TODAY = 4;
    private static final int YESTERDAY = 5;
    private static final int THIS_WEEK = 6;
    private static final int THIS_MONTH = 7;
    private static final int THIS_YEAR = 8;
    private static final int RELATIVE = 9;
    private static String[] names = new String[]{CteStringBank.Any.getI18n(), CteStringBank.Before.getI18n(), CteStringBank.Between.getI18n(), CteStringBank.Specific_Date.getI18n(), CteStringBank.Today.getI18n(), CteStringBank.Yesterday.getI18n(), CteStringBank.This_Week.getI18n(), CteStringBank.This_Month.getI18n(), CteStringBank.ThisYear.getI18n(), CteStringBank.Relative.getI18n()};
    private JComboBox dates = new JComboBox();
    private JComponent date = null;
    private TimeZonePanel tzPanel;

    public NamedDateComponent(TimeZonePanel timeZonePanel) {
        super(new BorderLayout(0, 0));
        this.setOpaque(false);
        this.tzPanel = timeZonePanel;
        this.initUI();
        this.populate();
        timeZonePanel.addTimZoneListener(this);
    }

    private void populate() {
        this.dates.setModel(new DefaultComboBoxModel<String>(names));
    }

    private void initUI() {
        this.add(this.dates);
        this.dates.addActionListener(this);
    }

    public int getSelectedNamedTime() {
        if (this.dates.getSelectedItem() == null) {
            return -1;
        }
        Object object = this.dates.getSelectedItem();
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    public void setSelectedNamedTime(int n) {
        if (n >= 4) {
            this.dates.setSelectedItem(names[n]);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (this.date != null) {
            this.removeAll();
            this.add((Component)this.dates, "North");
        }
        if ((n = this.getSelectedNamedTime()) == 3) {
            this.date = new JDateChooser();
            this.add((Component)this.date, "South");
        } else if (n == -1 || n == 1) {
            this.date = new TimeChooser(2);
            this.add((Component)this.date, "South");
        } else if (n == 2) {
            this.date = new TimeRangePanel(this.tzPanel);
            this.add((Component)this.date, "South");
        } else if (n == 9) {
            this.date = new RelativeTimeRange();
            this.add((Component)this.date, "South");
        } else {
            this.date = null;
        }
        if (this.date != null) {
            this.date.setOpaque(false);
        }
        this.setTimeZone(this.tzPanel.getSelectedTimeZone());
        SwingUtilities.updateComponentTreeUI(this);
        this.doLayout();
    }

    public int getFrom() {
        Calendar calendar = Calendar.getInstance(this.tzPanel.getSelectedTimeZone());
        calendar.setTime(new Date());
        int n = this.getSelectedNamedTime();
        if (n == 4 || n == 5 || n == 6 || n == 7 || n == 8 || n == 3) {
            if (n == 3) {
                if (((JDateChooser)((Object)this.date)).getDate() == null) {
                    throw new RuntimeException(CteStringBank.Input_Date_is_not_valid.getI18n());
                }
                calendar.setTime(((JDateChooser)((Object)this.date)).getDate());
            }
            if (n == 5) {
                calendar.set(6, calendar.get(6) - 1);
            }
            if (n == 6) {
                calendar.set(7, 1);
            }
            if (n == 7) {
                calendar.set(5, 1);
            }
            if (n == 8) {
                calendar.set(6, 1);
            }
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            return (int)(calendar.getTimeInMillis() / 1000L);
        }
        if (n == -1) {
            return (int)(((TimeChooser)this.date).getTime().getTimeInMillis() / 1000L);
        }
        if (n == 2) {
            return ((TimeRangePanel)this.date).getStartTime();
        }
        if (n == 9) {
            return -((RelativeTimeRange)this.date).from.getTime();
        }
        return 0;
    }

    public int getTo() {
        Calendar calendar = Calendar.getInstance(this.tzPanel.getSelectedTimeZone());
        calendar.setTime(new Date());
        int n = this.getSelectedNamedTime();
        if (n == 4 || n == 5 || n == 6 || n == 7 || n == 8 || n == 3) {
            if (n == 3) {
                calendar.setTime(((JDateChooser)((Object)this.date)).getDate());
            }
            if (n == 5) {
                calendar.set(6, calendar.get(6) - 1);
            }
            if (n == 6) {
                calendar.set(7, 7);
            }
            if (n == 7) {
                calendar.set(5, 30);
            }
            if (n == 8) {
                calendar.set(6, 365);
            }
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            return (int)(calendar.getTimeInMillis() / 1000L);
        }
        if (n == 1) {
            return (int)(((TimeChooser)this.date).getTime().getTimeInMillis() / 1000L);
        }
        if (n == 2) {
            return ((TimeRangePanel)this.date).getEndTime();
        }
        if (n == 9) {
            return -((RelativeTimeRange)this.date).to.getTime();
        }
        return 0;
    }

    public void setTime(int n, int n2, int n3) {
        this.setSelectedNamedTime(n3);
        if (n == n2 && n == 0) {
            this.dates.setSelectedIndex(0);
        } else if (n == 0) {
            this.dates.setSelectedIndex(1);
            ((TimeChooser)this.date).setTime(n2);
        } else if (n2 == 0) {
            this.dates.setSelectedIndex(-1);
            ((TimeChooser)this.date).setTime(n);
        } else if (n3 == 9) {
            ((RelativeTimeRange)this.date).setTime(-n, -n2);
        } else {
            this.dates.setSelectedIndex(2);
            ((TimeRangePanel)this.date).setStartTime(n);
            ((TimeRangePanel)this.date).setEndTime(n2);
        }
    }

    public Object getDisplayString() {
        int n = this.getSelectedNamedTime();
        String string = "";
        DateFormat dateFormat = DateFormat.getInstance();
        if (this.tzPanel.getSelectedTimeZone() != null) {
            dateFormat.setTimeZone(this.tzPanel.getSelectedTimeZone());
        }
        if (this.date != null) {
            if (n == 3) {
                string = dateFormat.format(((JDateChooser)((Object)this.date)).getDate());
            } else if (n == -1 || n == 1) {
                string = dateFormat.format(((TimeChooser)this.date).getTime().getTime());
            } else if (n == 2) {
                TimeRangePanel timeRangePanel = (TimeRangePanel)this.date;
                string = MessageFormat.format(CteStringBank._10012_and_10112.getI18n(), dateFormat.format((long)timeRangePanel.getStartTime() * 1000L), dateFormat.format((long)timeRangePanel.getEndTime() * 1000L));
            } else if (n == 9) {
                RelativeTimeRange relativeTimeRange = (RelativeTimeRange)this.date;
                return relativeTimeRange.getDisplayString();
            }
        }
        return this.dates.getSelectedItem() + string;
    }

    public void setDatesRenderer(ListCellRenderer listCellRenderer) {
        this.dates.setRenderer(listCellRenderer);
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        Object object;
        if (this.date == null || timeZone == null) {
            return;
        }
        if (this.date instanceof JDateChooser) {
            object = (JDateChooser)((Object)this.date);
            object.setTimeZone(timeZone);
        }
        if (this.date instanceof TimeChooser) {
            object = (TimeChooser)this.date;
            ((TimeChooser)object).setTimeZone(timeZone);
        }
    }

    class RelativeTimeRange
    extends JPanel {
        HourMinComponent from;
        HourMinComponent to;

        public RelativeTimeRange() {
            super(new GridBagLayout());
            this.from = new HourMinComponent(true);
            this.to = new HourMinComponent(true);
            this.from.setOpaque(false);
            this.to.setOpaque(false);
            this.setOpaque(false);
            this.from.showDayField();
            this.to.showDayField();
            this.from.setTime(86400);
            this.to.setTime(0);
            LayoutUtils.addRow((Container)this, (JComponent)new JLabel(CteStringBank.From_last.getI18n()), (JComponent)this.from, true);
            LayoutUtils.addRow((Container)this, (JComponent)new JLabel(CteStringBank.To_Last.getI18n()), (JComponent)this.to, true);
        }

        public void setTime(int n, int n2) {
            this.from.setTime(n);
            this.to.setTime(n2);
        }

        public Object getDisplayString() {
            return MessageFormat.format(CteStringBank.From_last_10012_to_last_10112.getI18n(), this.from.getDisplayString(), this.to.getDisplayString());
        }
    }
}

