/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.calender;

import commvault.cte.component.NumericDocument;
import commvault.cte.component.NumericTextField;
import commvault.cte.component.calender.CalendarUtilities;
import commvault.cte.component.calender.ChangeTimeZoneInterface;
import commvault.cte.component.events.TimeListener;
import commvault.cte.util.DateUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.basic.BasicArrowButton;

public final class HourChooser
extends JPanel
implements KeyListener,
FocusListener,
ActionListener,
ChangeTimeZoneInterface {
    private NumericTextField hourField = new NumericTextField("1", new NumericDocument(1L, 12L));
    private NumericTextField minField = new NumericTextField("00", new NumericDocument(0L, 59L));
    private NumericTextField secondField = new NumericTextField("00", new NumericDocument(0L, 59L));
    public final String AM = CalendarUtilities.getAMString();
    public final String PM = CalendarUtilities.getPMString();
    private JTextField ampmField = new JTextField(4);
    private BasicArrowButton incrButton = new BasicArrowButton(1);
    private BasicArrowButton decrButton = new BasicArrowButton(5);
    private JComponent lastFocusedComp = null;
    private Calendar gregorianCalendar = null;
    private int originalHour = 1;
    private int originalMin = 0;
    private int originalSecond = 0;
    private int originalAMPM = 0;
    JPanel mainPanel = new JPanel();
    JLabel label2 = new JLabel(" :", 4);
    EventListenerList listenerList = new EventListenerList();
    ActionEvent actionEvent = null;
    Vector listeners = new Vector();
    boolean showSecondsField = false;
    boolean showampmField = false;
    String userSpecificTimeFormat = "";

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public void addTimeListener(TimeListener timeListener) {
        if (timeListener != null) {
            this.listeners.addElement(timeListener);
        }
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.getUserInputTime2();
        long l = this.gregorianCalendar.getTime().getTime();
        if (l == 0L) {
            l = System.currentTimeMillis();
        }
        Date date = new Date(l);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTimeZone(timeZone);
        gregorianCalendar.setTime(date);
        this.setTime(gregorianCalendar);
    }

    public HourChooser() {
        this(new GregorianCalendar(), false);
        this.lastFocusedComp = this.ampmField;
    }

    private void init(boolean bl, boolean bl2) {
        this.setLayout(new BorderLayout(0, 0));
        if (!bl2) {
            this.hourField = new NumericTextField("0", new NumericDocument(0L, 23L));
        }
        this.mainPanel.setLayout(new FlowLayout(1, 0, 0));
        this.mainPanel.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(0, 0, 0, 0), this.hourField.getBorder()));
        this.mainPanel.setBackground(this.hourField.getBackground());
        this.hourField.setBorder(new EmptyBorder(1, 0, 0, 0));
        this.minField.setBorder(new EmptyBorder(1, 0, 0, 0));
        this.secondField.setBorder(new EmptyBorder(1, 0, 0, 0));
        this.ampmField.setBorder(new EmptyBorder(1, 1, 0, 0));
        this.hourField.addFocusListener(this);
        this.minField.addFocusListener(this);
        this.ampmField.addFocusListener(this);
        this.hourField.addKeyListener(this);
        this.minField.addKeyListener(this);
        this.ampmField.addKeyListener(this);
        this.ampmField.setEditable(false);
        this.ampmField.setBackground(this.hourField.getBackground());
        JLabel jLabel = new JLabel(" :", 4);
        jLabel.setBackground(this.hourField.getBackground());
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.label2.setBackground(this.hourField.getBackground());
        this.label2.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.mainPanel.add(this.hourField);
        this.mainPanel.add(jLabel);
        this.mainPanel.add(this.minField);
        if (bl) {
            this.secondField.addFocusListener(this);
            this.secondField.addKeyListener(this);
            this.mainPanel.add(this.label2);
            this.mainPanel.add(this.secondField);
        }
        if (bl2) {
            this.mainPanel.add(this.ampmField);
        }
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.add(this.incrButton);
        jPanel.add(this.decrButton);
        jPanel.setPreferredSize(new Dimension(18, this.hourField.getPreferredSize().height));
        this.add((Component)this.mainPanel, "Center");
        jPanel.setBorder(new EmptyBorder(0, 2, 0, 0));
        this.add((Component)jPanel, "East");
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        new Dimension(this.hourField.getPreferredSize().width + this.minField.getPreferredSize().width + this.secondField.getPreferredSize().width + this.ampmField.getPreferredSize().width + 66, this.hourField.getPreferredSize().height);
        this.incrButton.addActionListener(this);
        this.decrButton.addActionListener(this);
        this.hourField.setMaxChars(2);
        this.minField.setMaxChars(2);
        this.secondField.setMaxChars(2);
    }

    private void setMinValue(int n) {
        String string = n + "";
        if (n < 10 && this.userSpecificTimeFormat.contains("mm")) {
            string = "0" + n;
        }
        this.minField.setText(string);
    }

    private void setHourValue(int n) {
        String string = n + "";
        if (n < 10 && (this.userSpecificTimeFormat.contains("hh") || this.userSpecificTimeFormat.contains("HH"))) {
            string = "0" + n;
        }
        this.hourField.setText(string);
    }

    private void setSecondValue(int n) {
        String string = n + "";
        if (n < 10 && this.userSpecificTimeFormat.contains("ss")) {
            string = "0" + n;
        }
        this.secondField.setText(string);
    }

    public void setTime(Calendar calendar) {
        this.lastFocusedComp = null;
        this.gregorianCalendar = calendar;
        int n = 0;
        if (!this.showampmField) {
            n = calendar.get(11);
        } else {
            n = calendar.get(10);
            if (n == 0) {
                n = 12;
            }
        }
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        if (DateUtilities.useUserDateFormat) {
            this.setHourValue(n);
            this.setMinValue(n2);
            this.setSecondValue(this.showSecondsField ? n3 : 0);
        } else {
            this.hourField.setText((n < 10 ? "0" : "") + Integer.toString(n));
            this.minField.setText((n2 < 10 ? "0" : "") + Integer.toString(n2));
            this.secondField.setText(this.showSecondsField ? (n3 < 10 ? "0" : "") + Integer.toString(n3) : "0");
        }
        this.originalHour = n;
        this.originalMin = n2;
        this.originalSecond = n3;
        if (calendar.get(9) == 1) {
            this.ampmField.setText(this.PM);
            this.originalAMPM = 1;
        } else {
            this.originalAMPM = 0;
            this.ampmField.setText(this.AM);
        }
        this.lastFocusedComp = this.ampmField;
    }

    public void setTime(int n) {
        this.setTime(n, this.gregorianCalendar.getTimeZone());
    }

    public void setTime(int n, TimeZone timeZone) {
        Date date = new Date(1000L * (long)n);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTime(date);
        this.setTime(gregorianCalendar);
    }

    public void setTimeForSchedule(int n) {
        this.setTimeForSchedule(n, this.gregorianCalendar.getTimeZone());
    }

    public void setTimeForSchedule(int n, TimeZone timeZone) {
        TimeZone timeZone2 = timeZone;
        Date date = new Date(1000L * (long)n);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.setTime(date);
        this.setTime(gregorianCalendar);
        this.gregorianCalendar.setTimeZone(timeZone2);
    }

    public HourChooser(GregorianCalendar gregorianCalendar, boolean bl) {
        this.showSecondsField = bl;
        this.showampmField = false;
        if (DateUtilities.useUserDateFormat) {
            this.userSpecificTimeFormat = bl ? DateUtilities.instance().getUserSpecificLongTimeFormat() : DateUtilities.instance().getUserSpecificTimeFormat();
            if (this.userSpecificTimeFormat.contains("aa") || this.userSpecificTimeFormat.contains("a")) {
                this.showampmField = true;
            }
        } else {
            this.showampmField = true;
        }
        this.init(this.showSecondsField, this.showampmField);
        this.setTime(gregorianCalendar);
    }

    public static boolean isShowAMPMField() {
        boolean bl = false;
        if (DateUtilities.useUserDateFormat) {
            String string = DateUtilities.instance().getUserSpecificTimeFormat();
            if (string.contains("aa") || string.contains("a")) {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public HourChooser(GregorianCalendar gregorianCalendar) {
        this(gregorianCalendar, false);
        this.setTime(gregorianCalendar);
        this.lastFocusedComp = this.ampmField;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.hourField || keyEvent.getSource() == this.minField || keyEvent.getSource() == this.secondField || keyEvent.getSource() == this.ampmField) {
            if (keyEvent.getKeyCode() == 38) {
                this.incrButton.doClick();
                keyEvent.consume();
            } else if (keyEvent.getKeyCode() == 40) {
                this.decrButton.doClick();
                keyEvent.consume();
            } else if (keyEvent.getKeyCode() == 65 && keyEvent.getSource() == this.ampmField) {
                this.ampmField.setText(this.AM);
                this.ampmField.setSelectionStart(0);
                this.ampmField.setSelectionEnd(2);
                this.ampmField.requestFocus();
                this.getUserInputTime();
            } else if (keyEvent.getKeyCode() == 80 && keyEvent.getSource() == this.ampmField) {
                this.ampmField.setText(this.PM);
                this.ampmField.setSelectionStart(0);
                this.ampmField.setSelectionEnd(2);
                this.ampmField.requestFocus();
                this.getUserInputTime();
            } else {
                this.getUserInputTime();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() != this) {
            this.lastFocusedComp = (JComponent)focusEvent.getSource();
            if (this.lastFocusedComp instanceof JTextField) {
                ((JTextField)this.lastFocusedComp).selectAll();
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() != this) {
            this.lastFocusedComp = (JComponent)focusEvent.getSource();
        }
        if (focusEvent.getSource() == this.hourField) {
            int n = this.gregorianCalendar.get(10);
            try {
                n = Integer.parseInt(this.hourField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.showampmField && n == 0) {
                n = 12;
            }
            if (DateUtilities.useUserDateFormat) {
                this.setHourValue(n);
            } else {
                this.hourField.setText((n < 10 ? "0" : "") + Integer.toString(n));
            }
        } else if (focusEvent.getSource() == this.minField) {
            int n = this.gregorianCalendar.get(12);
            try {
                n = Integer.parseInt(this.minField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (DateUtilities.useUserDateFormat) {
                this.setMinValue(n);
            } else {
                this.minField.setText((n < 10 ? "0" : "") + Integer.toString(n));
            }
        } else if (focusEvent.getSource() == this.secondField) {
            int n = this.gregorianCalendar.get(13);
            try {
                n = Integer.parseInt(this.secondField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (DateUtilities.useUserDateFormat) {
                this.setSecondValue(n);
            } else {
                this.secondField.setText((n < 10 ? "0" : "") + Integer.toString(n));
            }
        } else if (focusEvent.getSource() == this.ampmField) {
            this.ampmField.setSelectionStart(0);
            this.ampmField.setSelectionEnd(0);
        }
        this.getUserInputTime();
    }

    private void move(JComponent jComponent, int n) {
        if (jComponent == this.hourField) {
            int n2 = 1;
            String string = this.hourField.getText().trim();
            if (string.length() != 0) {
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n == 1) {
                ++n2;
            } else if (n == 3) {
                --n2;
            }
            int n3 = 12;
            if (DateUtilities.useUserDateFormat && !this.showampmField) {
                n3 = 23;
            }
            if (n2 > n3) {
                n2 = 0;
            } else if (n2 < 1) {
                n2 = n3;
            }
            if (DateUtilities.useUserDateFormat) {
                this.setHourValue(n2);
            } else {
                this.hourField.setText((n2 < 10 ? "0" : "") + Integer.toString(n2));
            }
            this.hourField.requestFocus();
            this.getUserInputTime();
        } else if (jComponent == this.minField) {
            int n4 = 0;
            String string = this.minField.getText().trim();
            if (string.length() != 0) {
                try {
                    n4 = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n == 1) {
                ++n4;
            } else if (n == 3) {
                --n4;
            }
            if (n4 > 59) {
                n4 = 0;
            } else if (n4 < 0) {
                n4 = 59;
            }
            if (DateUtilities.useUserDateFormat) {
                this.setMinValue(n4);
            } else {
                this.minField.setText((n4 < 10 ? "0" : "") + Integer.toString(n4));
            }
            this.minField.requestFocus();
            this.getUserInputTime();
        } else if (jComponent == this.secondField) {
            int n5 = 0;
            String string = this.secondField.getText().trim();
            if (string.length() != 0) {
                try {
                    n5 = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n == 1) {
                ++n5;
            } else if (n == 3) {
                --n5;
            }
            if (n5 > 59) {
                n5 = 0;
            } else if (n5 < 0) {
                n5 = 59;
            }
            if (DateUtilities.useUserDateFormat) {
                this.setSecondValue(n5);
            } else {
                this.secondField.setText((n5 < 10 ? "0" : "") + Integer.toString(n5));
            }
            this.secondField.requestFocus();
            this.getUserInputTime();
        } else if (jComponent == this.ampmField) {
            if (this.ampmField.getText().equals(this.AM)) {
                this.ampmField.setText(this.PM);
            } else {
                this.ampmField.setText(this.AM);
            }
            this.ampmField.setSelectionStart(0);
            this.ampmField.setSelectionEnd(2);
            this.ampmField.requestFocus();
            this.getUserInputTime();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.incrButton) {
            if (this.lastFocusedComp != null && (this.lastFocusedComp instanceof NumericTextField || this.lastFocusedComp instanceof JTextField)) {
                this.move(this.lastFocusedComp, 1);
            }
        } else if (actionEvent.getSource() == this.decrButton && this.lastFocusedComp != null && (this.lastFocusedComp instanceof NumericTextField || this.lastFocusedComp instanceof JTextField)) {
            this.move(this.lastFocusedComp, 3);
        }
    }

    protected void fireActionPerformed() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            if (this.actionEvent == null) {
                this.actionEvent = new ActionEvent(this, 0, "Time Changed");
            }
            ((ActionListener)objectArray[i + 1]).actionPerformed(this.actionEvent);
        }
    }

    public Calendar getTime() {
        this.getUserInputTime();
        if (!this.showSecondsField) {
            this.gregorianCalendar.set(13, 0);
        }
        return this.gregorianCalendar;
    }

    public int getUnixTime() {
        return (int)(this.getTime().getTime().getTime() / 1000L);
    }

    public void getUserInputTime2() {
        try {
            int n;
            int n2 = n = Integer.parseInt(this.hourField.getText());
            if (this.showampmField) {
                if (this.ampmField.getText().equals(this.PM)) {
                    if (n != 12) {
                        n += 12;
                    }
                } else if (n == 12) {
                    n = 0;
                    n2 = 0;
                }
            }
            this.gregorianCalendar.set(10, n2);
            this.gregorianCalendar.set(9, this.ampmField.getText().equals(this.AM) ? 0 : 1);
            this.gregorianCalendar.set(11, n);
            this.gregorianCalendar.set(12, Integer.parseInt(this.minField.getText()));
            String string = this.secondField.getText();
            this.gregorianCalendar.set(13, Integer.parseInt(this.secondField.getText()));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void getUserInputTime() {
        this.getUserInputTime2();
        this.fireTimeChanged();
    }

    public void fireTimeChanged() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < HourChooser.this.listeners.size(); ++i) {
                    ((TimeListener)HourChooser.this.listeners.elementAt(i)).timeChanged(HourChooser.this.gregorianCalendar);
                }
            }
        };
        new Thread(runnable).start();
    }

    public JTextField getTextField() {
        return this.hourField;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.hourField.setEnabled(bl);
        this.minField.setEnabled(bl);
        this.secondField.setEnabled(bl);
        this.ampmField.setEnabled(bl);
        this.incrButton.setEnabled(bl);
        this.decrButton.setEnabled(bl);
    }

    public boolean hasChanged() {
        return this.originalHour != Integer.parseInt(this.hourField.getText()) || this.originalMin != Integer.parseInt(this.minField.getText()) || this.originalSecond != Integer.parseInt(this.secondField.getText()) || this.originalAMPM != (this.ampmField.getText().equals(this.AM) ? 0 : 1);
    }

    public void setEditable(boolean bl) {
        this.hourField.setEditable(bl);
        this.minField.setEditable(bl);
        this.secondField.setEditable(bl);
        this.incrButton.setEnabled(bl);
        this.decrButton.setEnabled(bl);
    }

    public static GregorianCalendar getCalendar(GregorianCalendar gregorianCalendar, int n) {
        int n2 = n / 60 / 60;
        int n3 = (n - n2 * 60 * 60) / 60;
        int n4 = n - n2 * 60 * 60 - n3 * 60;
        gregorianCalendar.set(11, n2);
        gregorianCalendar.set(12, n3);
        gregorianCalendar.set(13, n4);
        return gregorianCalendar;
    }

    public static GregorianCalendar getCalendar(int n) {
        return HourChooser.getCalendar(new GregorianCalendar(), n);
    }

    public static int getSecondsAfterMidnight(GregorianCalendar gregorianCalendar) {
        return gregorianCalendar.get(11) * 60 * 60 + gregorianCalendar.get(12) * 60 + gregorianCalendar.get(13);
    }

    public void setSecondsAfterMidnight(int n) {
        int n2 = n / 3600;
        int n3 = (n -= n2 * 3600) / 60;
        int n4 = n -= n3 * 60;
        this.ampmField.setText(n2 >= 12 ? this.PM : this.AM);
        if (DateUtilities.useUserDateFormat) {
            if (this.showampmField && n2 == 0) {
                n2 = 12;
            }
            if (this.showampmField && n2 > 12) {
                n2 -= 12;
            }
            this.setHourValue(n2);
            this.setMinValue(n3);
            this.setSecondValue(n4);
        } else {
            this.minField.setText(n3 < 10 ? "0" + String.valueOf(n3) : String.valueOf(n3));
            this.secondField.setText(String.valueOf(n4));
            this.hourField.setText(n2 > 12 ? String.valueOf(n2 - 12) : (n2 == 0 ? "12" : String.valueOf(n2)));
        }
    }

    public static String getDisplayValue(int n) {
        int n2 = n / 3600;
        int n3 = (n -= n2 * 3600) / 60;
        n -= n3 * 60;
        StringBuilder stringBuilder = new StringBuilder();
        if (HourChooser.isShowAMPMField()) {
            stringBuilder.append(n2 > 12 ? String.valueOf(n2 - 12) : (n2 == 0 ? "12" : String.valueOf(n2)));
        } else {
            stringBuilder.append(String.valueOf(n2));
        }
        stringBuilder.append(":");
        stringBuilder.append(n3 < 10 ? "0" + String.valueOf(n3) : String.valueOf(n3));
        stringBuilder.append(" ");
        if (HourChooser.isShowAMPMField()) {
            stringBuilder.append(n2 >= 12 ? CalendarUtilities.getPMString() : CalendarUtilities.getAMString());
        }
        return stringBuilder.toString();
    }

    public int getSecondsAfterMidnight() {
        int n = this.hourField.getIntValue();
        if (this.showampmField) {
            if (this.ampmField.getText().equals(this.AM)) {
                if (n == 12) {
                    n = 0;
                }
            } else if (n != 12) {
                n += 12;
            }
        }
        int n2 = this.minField.getIntValue();
        int n3 = this.secondField.getIntValue();
        return n * 3600 + n2 * 60 + n3;
    }

    @Override
    public boolean hasFocus() {
        return this.hourField.hasFocus() || this.minField.hasFocus() || this.secondField.hasFocus();
    }

    public void setMinuteFieldDummy() {
        this.minField.setEditable(false);
        this.minField.setEnabled(false);
        this.minField.setFocusable(false);
        this.minField.removeFocusListener(this);
        this.minField.removeKeyListener(this);
    }
}

