/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.calender;

import commvault.cte.CteStringBank;
import commvault.cte.component.calender.CalendarViewModel;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CalendarUtil {
    public static Calendar createCalendar(Date date) {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        calendar.setTime(date);
        return calendar;
    }

    public static Date getTime(int n, Date date) {
        Calendar calendar = CalendarUtil.createCalendar(date);
        calendar.add(11, n / 2);
        return calendar.getTime();
    }

    public static Date getDay(int n, int n2, Date date) {
        Calendar calendar = CalendarUtil.createCalendar(date);
        calendar.add(3, n);
        calendar.set(7, n2 + calendar.getFirstDayOfWeek());
        return calendar.getTime();
    }

    public static Date getTime(int n, int n2, Date date) {
        Calendar calendar = CalendarUtil.createCalendar(date);
        calendar.add(10, n);
        calendar.set(7, n2 + 1);
        return calendar.getTime();
    }

    public static Date getNextFocusDate(Date date, CalendarViewModel.CalendarType calendarType) {
        Calendar calendar = CalendarUtil.createCalendar(date);
        if (calendarType == CalendarViewModel.CalendarType.MONTHLY) {
            calendar.set(7, 1);
            calendar.add(6, 35);
        } else if (calendarType == CalendarViewModel.CalendarType.WEEKLY) {
            calendar.set(7, 1);
            calendar.add(3, 1);
        } else {
            calendar.add(6, 1);
        }
        return calendar.getTime();
    }

    public static Date getPreviousFocusDate(Date date, CalendarViewModel.CalendarType calendarType) {
        Calendar calendar = CalendarUtil.createCalendar(date);
        if (calendarType == CalendarViewModel.CalendarType.MONTHLY) {
            calendar.set(7, 1);
            calendar.add(3, -5);
        } else if (calendarType == CalendarViewModel.CalendarType.WEEKLY) {
            calendar.set(7, 1);
            calendar.add(3, -1);
        } else {
            calendar.add(6, -1);
        }
        return calendar.getTime();
    }

    public static int getWeekIndex(Calendar calendar, Date date) {
        int n = calendar.get(1);
        int n2 = calendar.get(3);
        Calendar calendar2 = CalendarUtil.createCalendar(date);
        int n3 = calendar2.get(3) - n2 + (calendar2.get(1) - n) * 52;
        if (calendar2.get(3) == 1 && calendar2.get(5) > 10) {
            n3 += 52;
        }
        return n3;
    }

    public static Calendar getMonthStartWeek(Date date) {
        Calendar calendar = CalendarUtil.createCalendar(date);
        calendar.set(4, calendar.getActualMinimum(4));
        calendar.set(7, calendar.getActualMinimum(7));
        calendar.set(11, calendar.getActualMinimum(11));
        calendar.set(12, calendar.getActualMinimum(12));
        calendar.set(13, calendar.getActualMinimum(13));
        return calendar;
    }

    public static Calendar getMonthEndWeekEndTime(Date date) {
        Calendar calendar = CalendarUtil.createCalendar(date);
        calendar.set(4, calendar.getActualMaximum(4));
        calendar.set(7, calendar.getActualMaximum(7));
        calendar.set(11, calendar.getActualMaximum(11));
        calendar.set(12, calendar.getActualMaximum(12));
        calendar.set(13, calendar.getActualMaximum(13));
        return calendar;
    }

    public static Date getStartDateForMonthlyView(Date date) {
        Calendar calendar = CalendarUtil.createCalendar(new Date());
        if (date.getTime() - new Date().getTime() > 63244800000L) {
            calendar = CalendarUtil.createCalendar(date);
        }
        calendar.set(4, 1);
        calendar.set(7, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getScrolledDateByWeek(Date date, int n) {
        Calendar calendar = CalendarUtil.createCalendar(date);
        calendar.add(3, n);
        return calendar.getTime();
    }

    public static Calendar getDay(Date date) {
        Calendar calendar = CalendarUtil.createCalendar(date);
        calendar.set(11, calendar.getMinimum(11));
        calendar.set(12, calendar.getMinimum(12));
        calendar.set(13, calendar.getMinimum(13));
        return calendar;
    }

    public static Calendar getStartDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getMinimum(5));
        calendar.set(11, calendar.getMinimum(11));
        calendar.set(12, calendar.getMinimum(12));
        calendar.set(13, calendar.getMinimum(13));
        return calendar;
    }

    public static Calendar getEndDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getMinimum(5));
        calendar.set(11, calendar.getMinimum(11));
        calendar.set(12, calendar.getMinimum(12));
        calendar.set(13, calendar.getMinimum(13));
        calendar.add(2, 1);
        return calendar;
    }

    public static Calendar getEndTimeOfNextMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getMinimum(5));
        calendar.set(11, calendar.getMinimum(11));
        calendar.set(12, calendar.getMinimum(12));
        calendar.set(13, calendar.getMinimum(13));
        calendar.add(2, 2);
        return calendar;
    }

    public static Date getStartDateForWeeklyView(Date date) {
        Calendar calendar = CalendarUtil.createCalendar(date);
        calendar.set(11, calendar.getMinimum(11));
        calendar.set(12, calendar.getMinimum(12));
        calendar.set(13, calendar.getMinimum(13));
        calendar.set(7, calendar.getMinimum(7));
        return calendar.getTime();
    }

    public static Date getStartDateForDailyView(Date date) {
        Calendar calendar = CalendarUtil.createCalendar(date);
        calendar.set(11, calendar.getMinimum(11));
        calendar.set(12, calendar.getMinimum(12));
        calendar.set(13, calendar.getMinimum(13));
        return calendar.getTime();
    }

    public static String getTimeForDisplay(int n) {
        return "" + n / 3600 + ":" + n % 3600 / 60;
    }

    public static Date getPreviousDay(Date date) {
        return CalendarUtil.getPreviousFocusDate(date, CalendarViewModel.CalendarType.DETAIL);
    }

    public static Date getNextDay(Date date) {
        return CalendarUtil.getNextFocusDate(date, CalendarViewModel.CalendarType.DETAIL);
    }

    public static String getTimeString(Date date) {
        Calendar calendar = CalendarUtil.createCalendar(date);
        return CalendarUtil.convertNumberToString(calendar.get(10), 2, true) + ":" + CalendarUtil.convertNumberToString(calendar.get(12), 2, false) + " " + (calendar.get(9) == 0 ? CteStringBank.AM.getI18n() : CteStringBank.PM.getI18n());
    }

    public static String convertNumberToString(int n, int n2, boolean bl) {
        if (bl && n == 0) {
            return "12";
        }
        StringBuffer stringBuffer = new StringBuffer(Integer.toString(n));
        while (stringBuffer.length() < n2) {
            stringBuffer.insert(0, "0");
        }
        return stringBuffer.toString();
    }

    public static Date getEndTimeOfMonth(Date date) {
        Calendar calendar = CalendarUtil.createCalendar(date);
        calendar.set(5, calendar.getMaximum(5));
        calendar.set(11, calendar.getMaximum(11));
        calendar.set(12, calendar.getMaximum(12));
        calendar.set(13, calendar.getMaximum(13));
        return calendar.getTime();
    }
}

