/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.component.CheckBoxPanel;
import commvault.cte.component.ComponentTitledBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.PopupMenu;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TogglePanel
extends JPanel {
    protected JToggleButton _togglebtn = null;
    private JPanel _content = null;
    private static final int BORDER_OFFSET = 2;
    private static final int DBL_BORDER_OFFSET = 4;
    private Border border = null;
    private boolean toggleControls = true;
    private JPanel eastPanel = new JPanel();
    private JPanel westPanel = new JPanel();
    private JPanel tglpnl = new JPanel();
    private int changeChildState = 1;
    JPanel southPanel = new JPanel();
    private boolean controllState = true;
    private boolean initialized = true;
    private boolean doNotShowBorder;

    public TogglePanel(JToggleButton jToggleButton, Border border) {
        this._togglebtn = jToggleButton;
        this._togglebtn.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (TogglePanel.this._content.isEnabled() != TogglePanel.this._togglebtn.isSelected()) {
                    TogglePanel.this.setChildState(TogglePanel.this._content, TogglePanel.this._togglebtn.isSelected());
                }
            }
        });
        this._content = new JPanel(new BorderLayout());
        this._content.getInsets(new Insets(1, 1, 1, 1));
        this.border = new ComponentTitledBorder(border, jToggleButton);
        this.initDisplay();
    }

    public TogglePanel(JToggleButton jToggleButton, boolean bl) {
        this._togglebtn = jToggleButton;
        if (bl) {
            this._togglebtn.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (TogglePanel.this._content.isEnabled() != TogglePanel.this._togglebtn.isSelected()) {
                        TogglePanel.this.setChildState(TogglePanel.this._content, TogglePanel.this._togglebtn.isSelected());
                    }
                }
            });
        }
        this._content = new JPanel(new BorderLayout());
        this._content.getInsets(new Insets(1, 1, 1, 1));
        this.border = new ComponentTitledBorder(jToggleButton);
        this.initDisplay();
    }

    public TogglePanel(JToggleButton jToggleButton) {
        this(jToggleButton, (Border)null);
    }

    public TogglePanel(JToggleButton jToggleButton, int n) {
        this(jToggleButton, (Border)null);
        this.changeChildState = n;
    }

    public TogglePanel(JToggleButton jToggleButton, JComponent jComponent) {
        this(jToggleButton);
        this.setLayout(new BorderLayout());
        this.add(jComponent);
    }

    public TogglePanel() {
        this(new JToggleButton());
    }

    public JToggleButton getToggleButton() {
        return this._togglebtn;
    }

    private void initDisplay() {
        super.setLayout(new BorderLayout());
        this.tglpnl.setLayout(new FlowLayout(0, 10, 0));
        this.tglpnl.add(this._togglebtn);
        super.add((Component)this.tglpnl, "North");
        super.add((Component)this.eastPanel, "East");
        super.add((Component)this.westPanel, "West");
        super.add((Component)this.southPanel, "South");
        super.add((Component)this._content, "Center");
        this.setLayout(new GridBagLayout());
        this.setChildState(this._content, this._togglebtn.isSelected());
    }

    protected void setChildState(Container container, boolean bl) {
        if (!this.controllState) {
            return;
        }
        if (container == null || !this.toggleControls) {
            return;
        }
        if (container instanceof CheckBoxPanel) {
            ((CheckBoxPanel)container).setState();
        } else if (container instanceof TogglePanel) {
            ((TogglePanel)container).getToggleButton().setEnabled(bl);
            if (this.changeChildState == 1 && !bl) {
                ((TogglePanel)container).getToggleButton().setSelected(bl);
            }
        } else {
            Component[] componentArray = container.getComponents();
            for (int i = componentArray.length - 1; i >= 0; --i) {
                if (componentArray[i] instanceof Container) {
                    this.setChildState((Container)componentArray[i], bl);
                }
                componentArray[i].setEnabled(bl);
            }
            container.setEnabled(bl);
        }
    }

    public void setControllState(boolean bl) {
        this.controllState = bl;
    }

    @Override
    public void paint(Graphics graphics) {
        if (!this.initialized) {
            this._togglebtn.setLocation(this._togglebtn.getLocation().x + 4, this._togglebtn.getLocation().y - 6);
            this.initialized = true;
        }
        super.paint(graphics);
        if (!this.doNotShowBorder) {
            this.border.paintBorder(this, graphics, 0, 2, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (this._content != null) {
            this._content.setLayout(layoutManager);
        }
    }

    @Override
    public Component add(Component component) {
        if (this._content != null) {
            this._content.add(component);
        }
        this.setChildState(this._content, this._togglebtn.isSelected());
        return component;
    }

    @Override
    public Component add(String string, Component component) {
        if (this._content != null) {
            this._content.add(string, component);
            this.setChildState(this._content, this._togglebtn.isSelected());
        }
        return component;
    }

    @Override
    public Component add(Component component, int n) {
        if (this._content != null) {
            this._content.add(component, n);
            this.setChildState(this._content, this._togglebtn.isSelected());
        }
        return component;
    }

    @Override
    public void add(Component component, Object object) {
        if (this._content != null) {
            this._content.add(component, object);
            this.setChildState(this._content, this._togglebtn.isSelected());
        }
    }

    @Override
    public void add(Component component, Object object, int n) {
        if (this._content != null) {
            this._content.add(component, object, n);
            this.setChildState(this._content, this._togglebtn.isSelected());
        }
    }

    @Override
    public void add(PopupMenu popupMenu) {
        if (this._content != null) {
            this._content.add(popupMenu);
        }
    }

    public void setToggleControls(boolean bl) {
        this.toggleControls = bl;
    }

    public boolean getToggleControls() {
        return this.toggleControls;
    }

    public void setSouthPanelSize(int n, int n2) {
        this.southPanel.setSize(n, n2);
    }

    public void removeSouthPanelSize() {
        this.southPanel.setPreferredSize(new Dimension(5, 2));
        this.invalidate();
        this.revalidate();
    }

    @Override
    public Border getBorder() {
        return this.border;
    }

    @Override
    public void setBorder(Border border) {
    }

    public void setDoNotShowBorder(boolean bl) {
        super.setBorder(BorderFactory.createEmptyBorder());
        this.doNotShowBorder = bl;
        this._content.removeAll();
    }

    public void setEnable(boolean bl) {
        this.setChildState(this._content, bl);
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        if (this._content != null) {
            this._content.setOpaque(bl);
        }
        if (this.southPanel != null) {
            this.southPanel.setOpaque(bl);
        }
        if (this._togglebtn != null) {
            this._togglebtn.setOpaque(bl);
        }
        if (this.eastPanel != null) {
            this.eastPanel.setOpaque(bl);
        }
        if (this.westPanel != null) {
            this.westPanel.setOpaque(bl);
        }
        if (this.tglpnl != null) {
            this.tglpnl.setOpaque(bl);
        }
    }
}

