/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import com.jidesoft.status.LabelStatusBarItem;
import com.jidesoft.status.ProgressStatusBarItem;
import com.jidesoft.swing.DefaultOverlayable;
import commvault.cte.CteStringBank;
import commvault.cte.component.Utilities;
import commvault.cte.util.Application;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class StatusBar
extends com.jidesoft.status.StatusBar {
    LabelStatusBarItem csName = new LabelStatusBarItem("CommServe-Name");
    LabelStatusBarItem csVersion = new LabelStatusBarItem("CommServe-Version");
    LabelStatusBarItem uName = new LabelStatusBarItem("userName");
    LabelStatusBarItem messageLabel = new LabelStatusBarItem("message");
    LabelStatusBarItem activeAlerts = new LabelStatusBarItem("activeAlerts");
    LabelStatusBarItem saveUserPreferences = new LabelStatusBarItem("SaveUserPreferences");
    ProgressStatusBarItem progressBar = new ProgressStatusBarItem();
    JLabel consoleAlertUnreadCountLB = new JLabel();
    LabelStatusBarItem progressView = new LabelStatusBarItem();
    LabelStatusBarItem lock = new LabelStatusBarItem("Lock");
    private boolean isLocked = false;
    private int alertCount = 0;
    DefaultOverlayable overlayableLabel;

    public void setHourGlass() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusBar.this.messageLabel.setIcon((Icon)Application.instance().getIconSource().getIcon("hourGlass16"));
            }
        });
    }

    public void resetHourGlass() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusBar.this.messageLabel.setIcon((Icon)Application.instance().getIconSource().getIcon("transparent16"));
            }
        });
    }

    public StatusBar() {
        this.createProgressView();
        this.add((Component)this.messageLabel, "vary");
        this.add((Component)this.csName, "flexible");
        this.add((Component)this.csVersion, "flexible");
        this.add((Component)this.uName, "flexible");
        this.addConosoleAlertIcon();
        this.addSaveUserPreferencesIcon();
        this.addLockIcon();
        this.progressBar.setPreferredWidth(200);
        this.add((Component)this.progressBar, "flexible");
    }

    private void addSaveUserPreferencesIcon() {
        this.saveUserPreferences.setIcon((Icon)Application.instance().getIconSource().getIcon("jgraphx/save.gif"));
        this.saveUserPreferences.setToolTipText(CteStringBank.Save_User_Preferences.getI18n());
        this.add((Component)this.saveUserPreferences, "flexible");
    }

    public void addLockIcon() {
        this.lock.setIcon((Icon)Application.instance().getIconSource().getIcon("Locked.png"));
        this.lock.setToolTipText(CteStringBank.LockApplication.getI18n());
        this.add((Component)this.lock, "flexible");
        this.lock.setVisible(false);
    }

    private void addConosoleAlertIcon() {
        this.activeAlerts.setIcon((Icon)Application.instance().getIconSource().getIcon("Console_Alerts_Gray16x16"));
        this.activeAlerts.setToolTipText(CteStringBank.Live_Feeds.getI18n());
        this.overlayableLabel = new DefaultOverlayable((JComponent)this.activeAlerts, this.consoleAlertUnreadCountLB, 8){

            public Dimension getPreferredSize() {
                if (StatusBar.this.alertCount > 0) {
                    int n = StatusBar.this.consoleAlertUnreadCountLB.getFontMetrics(StatusBar.this.consoleAlertUnreadCountLB.getFont()).stringWidth(StatusBar.this.alertCount + "");
                    Dimension dimension = this.getActualComponent() == null ? new Dimension(0, 0) : new Dimension(n + (Utilities.userDefinedFont >= 14 ? 25 : 20), 20);
                    Insets insets = this.getOverlayLocationInsets();
                    if (insets != null) {
                        dimension.width += Math.max(0, insets.left) + Math.max(0, insets.right);
                        dimension.height += Math.max(0, insets.top) + Math.max(0, insets.bottom);
                    }
                    return dimension;
                }
                return super.getPreferredSize();
            }
        };
        this.overlayableLabel.setOverlayLocation(this.overlayableLabel.getOverlayComponents()[0], 8);
        this.add((Component)this.overlayableLabel, "flexible");
    }

    public void setConsoleAlertUnreadCount(int n) {
        Insets insets;
        String string = "Console_Alerts_Gray16x16";
        Insets insets2 = insets = n > 0 ? new Insets(3, -16, 0, 6) : new Insets(3, -15, 0, 6);
        if (n > 0) {
            this.consoleAlertUnreadCountLB.setText("<html><body ><B>&nbsp;" + n + "&nbsp;</B></body></html>");
            string = "Console_Alerts16x16";
        } else {
            this.consoleAlertUnreadCountLB.setText("");
        }
        this.overlayableLabel.setOverlayLocationInsets(insets);
        this.activeAlerts.setIcon((Icon)Application.instance().getIconSource().getIcon(string));
        this.alertCount = n;
        this.overlayableLabel.revalidate();
        this.overlayableLabel.repaint();
    }

    public LabelStatusBarItem getActiveAlertButton() {
        return this.activeAlerts;
    }

    public void setCommServerName(String string) {
        if (string != null) {
            this.csName.setText(string);
            this.csName.setToolTipText("CommServe: " + string);
        }
    }

    public void setCommServerVersion(String string) {
        if (string != null) {
            this.csVersion.setText(string);
            this.csVersion.setToolTipText("CommServe Version: " + string);
        }
    }

    public void setUserName(String string) {
        if (string != null) {
            this.uName.setText(string);
            this.uName.setToolTipText("Current User: " + string);
        }
    }

    public void setStatusMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusBar.this.messageLabel.setText(string);
            }
        });
    }

    public void resetStatusMessage() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusBar.this.messageLabel.setText("");
            }
        });
    }

    public void setProgress(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (n == 0 && StatusBar.this.progressBar.getProgressBar().getValue() != 0) {
                    StatusBar.this.progressBar.getProgressBar().setVisible(false);
                }
                if (n > 0) {
                    StatusBar.this.progressBar.getProgressBar().setVisible(true);
                }
                StatusBar.this.progressBar.setProgress(n);
                StatusBar.this.progressBar.repaint();
            }
        });
    }

    public void setProgressAsIndeterminate(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusBar.this.progressBar.getProgressBar().setVisible(bl);
                StatusBar.this.progressBar.setIndeterminate(bl);
                StatusBar.this.progressBar.repaint();
            }
        });
    }

    public synchronized void changeProgressViewIcon(boolean bl) {
        if (bl) {
            this.progressView.setIcon((Icon)Application.instance().getIconSource().getIcon("statusGreen"));
        } else {
            this.progressView.setIcon((Icon)Application.instance().getIconSource().getIcon("statusRed"));
        }
    }

    private void createProgressView() {
        this.add((Component)this.progressView, 0);
        this.progressView.setIcon((Icon)Application.instance().getIconSource().getIcon("statusGreen"));
    }

    public void setCancelListener(MouseListener mouseListener) {
        this.progressView.addMouseListener(mouseListener);
    }

    public void hideProgressBar() {
        this.progressView.setVisible(false);
    }

    public LabelStatusBarItem getSaveUserPreferenceButton() {
        return this.saveUserPreferences;
    }

    public LabelStatusBarItem getLockButton() {
        return this.lock;
    }

    public void setLocked(boolean bl) {
        this.isLocked = bl;
    }

    public boolean isLocked() {
        return this.isLocked;
    }
}

