/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.component.NumericDocument2;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.text.Document;

public final class NumericTextField2
extends JTextField
implements FocusListener {
    NumericDocument2 nDoc;
    int behavior = 0;
    Vector focusLostListeners = new Vector();

    public NumericTextField2(String string, NumericDocument2 numericDocument2) {
        super(numericDocument2, string, 2);
        this.setHorizontalAlignment(4);
        this.nDoc = numericDocument2;
        this.setText(string);
        super.removeFocusListener(this);
        super.addFocusListener(this);
    }

    public NumericTextField2() {
        this.setHorizontalAlignment(4);
        this.nDoc = new NumericDocument2(1L, Long.MAX_VALUE);
        this.setDocument(this.nDoc);
        this.setText("");
    }

    public void setNonNumericText(String string) {
        super.setText(string);
    }

    public void setLong(long l) {
        this.setText(new Long(l).toString());
    }

    @Override
    public void setText(String string) {
        try {
            long l = Long.parseLong(string);
            if (l < this.getMinValue() || l > this.getMaxValue()) {
                return;
            }
            super.setText(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected Document createDefaultModel() {
        return this.nDoc;
    }

    public long getMaxValue() {
        return this.nDoc.getMaxValue();
    }

    public long getMinValue() {
        return this.nDoc.getMinValue();
    }

    public void setBehavior(int n) {
        this.behavior = n;
    }

    public void setMaxValue(long l) {
        this.nDoc.setMaxValue(l);
    }

    public void setMinValue(long l) {
        this.nDoc.setMinValue(l);
    }

    public boolean isMaxValueReached() {
        return this.nDoc.isMaxValueReached();
    }

    public boolean isMinValueReached() {
        return this.nDoc.isMinValueReached();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        try {
            this.setSelectionStart(0);
            this.setSelectionEnd(this.getText().length());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isInvalidValue() {
        String string = super.getText();
        if (string == null || string.trim().length() == 0) {
            return true;
        }
        return !this.nDoc.isValidValue();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.isInvalidValue() && this.behavior == 0) {
            this.nDoc.resetToValidValue();
        }
        for (int i = 0; i < this.focusLostListeners.size(); ++i) {
            ((FocusLostListener)this.focusLostListeners.elementAt(i)).lostFocus();
        }
    }

    public void addFocusLostListener(FocusLostListener focusLostListener) {
        if (focusLostListener != null) {
            this.focusLostListeners.addElement(focusLostListener);
        }
    }

    public long getLongValue() {
        return this.nDoc.getLongValue();
    }

    public void setMaxChars(int n) {
        this.nDoc.setMaxChars(n);
    }

    public void setAllowNonNumericValue(boolean bl) {
        this.nDoc.setAllowNonNumericValue(bl);
    }

    public boolean isAllowNonNumericValue() {
        return this.nDoc.isAllowNonNumericValue();
    }

    public static interface FocusLostListener {
        public void lostFocus();
    }
}

