/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.CteStringBank;
import commvault.cte.component.ControlledTextField;
import commvault.cte.component.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.border.LineBorder;

public class NameTextField
extends ControlledTextField {
    public static final String DISALLOWED_CHARS = "";
    public static final int MAX_ENTITY_NAME_SIZE = 128;
    private String disAllowedCharsForDisplay = "";
    private String disAllowedChars = "";
    private JToolTip tooTipComponent = new JToolTip();
    private Popup popup;
    Timer startTime = null;
    Robot r = null;
    private static final String NAME_RULE_MSG = CteStringBank.Please_enter_a_valid_name_1.getI18n();
    private static final String UNKNOWN_RULE_MSG = CteStringBank.Please_enter_a_valid_name_1.getI18n();
    private static final String NAME_RULE_MSG2 = CteStringBank.Please_enter_a_valid_name_2.getI18n();
    private static final String NO_SPACE_RULE_MSG2 = CteStringBank.No_leading_and_trailing_spaces_allowed_2.getI18n();
    private static final String UNKNOWN_RULE_MSG2 = CteStringBank.Please_enter_a_valid_name_2.getI18n();

    public NameTextField() {
        this.init();
    }

    public NameTextField(String string, String string2) {
        super(string);
        this.disAllowedChars = string2;
        this.init();
    }

    public NameTextField(String string, String string2, int n) {
        super(string, n);
        this.disAllowedChars = string2;
        this.init();
    }

    public NameTextField(String string, int n) {
        super(string, n);
        this.init();
    }

    public NameTextField(int n) {
        super(n);
        this.init();
    }

    public NameTextField(double d) {
        this.init();
        this.setMaximumChars((int)d);
    }

    public NameTextField(double d, String string) {
        this(d);
        this.disAllowedChars = string;
    }

    public NameTextField(String string) {
        super(string);
        this.init();
    }

    private void showTooltip() {
        this.hideTooltip();
        Point point = this.getLocationOnScreen();
        try {
            this.getRobot().mouseMove(point.x + 2, point.y + 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Point point2 = new Point();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.tooTipComponent.getPreferredSize();
        this.tooTipComponent.setBorder(new TooltipBorder());
        this.tooTipComponent.setBackground(new Color(254, 249, 203));
        point2.x = point.x + dimension2.width / 2 - dimension.width / 2;
        point2.y = point.y + dimension.height;
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        this.popup = popupFactory.getPopup(this, this.tooTipComponent, point2.x, point2.y);
        this.popup.show();
    }

    private void hideTooltip() {
        if (this.popup != null) {
            this.popup.hide();
        }
    }

    private Robot getRobot() throws Exception {
        if (this.r == null) {
            this.r = new Robot();
            return this.r;
        }
        return this.r;
    }

    private void init() {
        this.tooTipComponent.setTipText("<html>Name can not have following characters:<p align='center'>" + this.disAllowedChars + "</p></html>");
        this.addRule(new ControlledTextField.NameRule());
        this.addRule(new ControlledTextField.NoSpaceRule());
        this.startTime = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NameTextField.this.hideTooltip();
                NameTextField.this.startTime.stop();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                NameTextField.this.hideTooltip();
            }
        });
        this.startTime.setRepeats(false);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                NameTextField.this.hideTooltip();
                if (NameTextField.this.disAllowedChars != null && NameTextField.this.disAllowedChars.length() != 0 && NameTextField.this.disAllowedChars.indexOf(c) >= 0) {
                    NameTextField.this.showTooltip();
                    NameTextField.this.startTime.start();
                    keyEvent.consume();
                }
            }
        });
    }

    public boolean validateName(String string) {
        Object[] objectArray = new String[]{string};
        if (!this.isValidText()) {
            if (this.getLastRuleIdentifier().equals("NameRule")) {
                Utilities.showErrorMessage(this.getParent(), MessageFormat.format(NAME_RULE_MSG, objectArray));
            } else if (this.getLastRuleIdentifier().equals("NoSpaceRule")) {
                Utilities.showErrorMessage(this.getParent(), MessageFormat.format(NO_SPACE_RULE_MSG2, objectArray));
            } else {
                Utilities.showErrorMessage(this.getParent(), MessageFormat.format(UNKNOWN_RULE_MSG, objectArray));
            }
            return false;
        }
        return true;
    }

    public boolean validateText(String string) {
        Object[] objectArray = new String[]{string};
        if (!this.isValidText()) {
            if (this.getLastRuleIdentifier().equals("NameRule")) {
                Utilities.showErrorMessage(this.getParent(), MessageFormat.format(NAME_RULE_MSG2, objectArray));
            } else if (this.getLastRuleIdentifier().equals("NoSpaceRule")) {
                Utilities.showErrorMessage(this.getParent(), MessageFormat.format(NO_SPACE_RULE_MSG2, objectArray));
            } else {
                Utilities.showErrorMessage(this.getParent(), MessageFormat.format(UNKNOWN_RULE_MSG2, objectArray));
            }
            return false;
        }
        return true;
    }

    public String validateTextWithoutPopup(String string) {
        Object[] objectArray = new String[]{string};
        if (!this.isValidText()) {
            if (this.getLastRuleIdentifier().equals("NameRule")) {
                return MessageFormat.format(NAME_RULE_MSG2, objectArray);
            }
            if (this.getLastRuleIdentifier().equals("NoSpaceRule")) {
                return MessageFormat.format(NO_SPACE_RULE_MSG2, objectArray);
            }
            return MessageFormat.format(UNKNOWN_RULE_MSG2, objectArray);
        }
        return null;
    }

    private class TooltipBorder
    extends LineBorder {
        public TooltipBorder() {
            super(Color.black);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(this.lineColor);
            for (int i = 0; i < this.thickness; ++i) {
                graphics.drawRoundRect(n + i, n2 + i, n3 - i - i - 1, n4 - i - i - 1, 5, 5);
            }
            graphics.setColor(color);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
        }
    }
}

