/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.common.IMutable;
import commvault.cte.common.IMutableListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.ItemSelectable;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;

public class MutablePanel
extends JPanel
implements IMutable,
ContainerListener {
    private boolean dirty = false;
    private boolean componentStateInitialized = false;
    private Set<IMutableListener> mutableListeners = new HashSet<IMutableListener>();

    public MutablePanel() {
        this.addContainerListener(this);
    }

    @Override
    public void addMutableListener(IMutableListener iMutableListener) {
        this.mutableListeners.add(iMutableListener);
    }

    @Override
    public void removeMutableListener(IMutableListener iMutableListener) {
        this.mutableListeners.remove(iMutableListener);
    }

    protected void firePanelChanged(boolean bl) {
        if (this.componentStateInitialized) {
            for (IMutableListener iMutableListener : this.mutableListeners) {
                iMutableListener.mutated(this);
            }
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void save() {
    }

    @Override
    public void setDirty(boolean bl) {
        if (this.componentStateInitialized) {
            this.dirty = bl;
        }
    }

    protected void panelChanged(boolean bl) {
        this.dirty = bl;
        this.firePanelChanged(bl);
    }

    protected void componentStateInitialized(boolean bl) {
        this.componentStateInitialized = bl;
    }

    private void bindComponents(Container container) {
        if (container instanceof ItemSelectable) {
            ItemSelectable itemSelectable = (ItemSelectable)((Object)container);
            itemSelectable.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    MutablePanel.this.panelChanged(true);
                }
            });
        } else if (container instanceof JList) {
            JList jList = (JList)container;
            jList.getModel().addListDataListener(new ListDataListener(){

                @Override
                public void intervalRemoved(ListDataEvent listDataEvent) {
                    MutablePanel.this.panelChanged(true);
                }

                @Override
                public void intervalAdded(ListDataEvent listDataEvent) {
                    MutablePanel.this.panelChanged(true);
                }

                @Override
                public void contentsChanged(ListDataEvent listDataEvent) {
                    MutablePanel.this.panelChanged(true);
                }
            });
        } else if (container instanceof JTable) {
            JTable jTable = (JTable)container;
            jTable.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    MutablePanel.this.panelChanged(true);
                }
            });
        } else if (container instanceof JTree) {
            JTree jTree = (JTree)container;
            jTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    MutablePanel.this.panelChanged(true);
                }
            });
        } else if (container instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)container;
            jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    MutablePanel.this.panelChanged(true);
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    MutablePanel.this.panelChanged(true);
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    MutablePanel.this.panelChanged(true);
                }
            });
        } else {
            for (Component component : container.getComponents()) {
                if (!(component instanceof Container)) continue;
                this.bindComponents((Container)component);
            }
        }
        container.addContainerListener(this);
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        if (containerEvent.getChild() instanceof Container) {
            this.bindComponents((Container)containerEvent.getChild());
        }
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
    }
}

