/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.CteStringBank;
import commvault.cte.component.Utilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListFilterPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected JList viewList = new JList(new DefaultListModel());
    protected boolean hasChanged;
    JButton delButton = new Utilities.NonDefaultButton(CteStringBank.Delete.getI18n());
    JButton addButton = new Utilities.NonDefaultButton(CteStringBank.Add.getI18n());
    JButton upButton = new Utilities.NonDefaultButton(CteStringBank.Up.getI18n());
    JButton downButton = new Utilities.NonDefaultButton(CteStringBank.Down.getI18n());
    protected String message;

    public ListFilterPanel(ArrayList arrayList, String string, boolean bl) {
        super.setLayout(new GridBagLayout());
        this.message = string;
        this.populate(arrayList);
        this.viewList.setSelectionMode(2);
        this.viewList.addListSelectionListener(this);
        Dimension dimension = new Dimension(70, 24);
        this.addButton.setPreferredSize(dimension);
        this.addButton.setMnemonic('A');
        this.delButton.setPreferredSize(dimension);
        this.delButton.setMnemonic('D');
        this.upButton.setPreferredSize(dimension);
        this.downButton.setPreferredSize(dimension);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JScrollPane jScrollPane = new JScrollPane(this.viewList);
        this.add((Component)jScrollPane, Utilities.getConstraints(gridBagConstraints, 0, 0, 1, 4, 1.0, 1.0, 17, 1, new Insets(10, 10, 10, 10)));
        this.add((Component)this.addButton, Utilities.getConstraints(gridBagConstraints, 1, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 5, 5)));
        this.add((Component)this.delButton, Utilities.getConstraints(gridBagConstraints, 1, 1, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5)));
        this.add((Component)this.upButton, Utilities.getConstraints(gridBagConstraints, 1, 2, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5)));
        this.add((Component)this.downButton, Utilities.getConstraints(gridBagConstraints, 1, 3, 0, 0, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 5)));
        this.addButton.addActionListener(this);
        this.delButton.addActionListener(this);
        this.upButton.addActionListener(this);
        this.downButton.addActionListener(this);
        this.enableUpDown(false);
        this.checkList();
        this.setEditable(bl);
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(CteStringBank.Add.getI18n())) {
            this.addAction();
        } else if (actionEvent.getActionCommand().equals(CteStringBank.Delete.getI18n())) {
            this.deleteAction();
        } else if (actionEvent.getActionCommand().equals(CteStringBank.Up.getI18n())) {
            this.upAction();
        } else if (actionEvent.getActionCommand().equals(CteStringBank.Down.getI18n())) {
            this.downAction();
        }
    }

    public void populate(ArrayList arrayList) {
        if (arrayList == null) {
            return;
        }
        DefaultListModel defaultListModel = (DefaultListModel)this.viewList.getModel();
        for (int i = 0; i < arrayList.size(); ++i) {
            defaultListModel.addElement(arrayList.get(i));
        }
        this.checkList();
    }

    public void addAction() {
        String string = null;
        boolean bl = false;
        do {
            if ((string = JOptionPane.showInputDialog(this, this.message, "", -1)) == null) {
                return;
            }
            if (string.toString().trim().length() == 0) {
                Utilities.showErrorMessage(CteStringBank.Please_enter_a_valid_value.getI18n());
                continue;
            }
            this.addAction(string);
            bl = true;
        } while (!bl);
    }

    public void upAction() {
        DefaultListModel defaultListModel = (DefaultListModel)this.viewList.getModel();
        int n = this.viewList.getSelectedIndex();
        if (n == 0) {
            return;
        }
        int n2 = n - 1;
        Object e = defaultListModel.getElementAt(n);
        defaultListModel.setElementAt(defaultListModel.getElementAt(n2), n);
        defaultListModel.setElementAt(e, n2);
        this.viewList.setSelectedIndex(n2);
    }

    public void downAction() {
        DefaultListModel defaultListModel = (DefaultListModel)this.viewList.getModel();
        int n = this.viewList.getSelectedIndex();
        if (n == defaultListModel.getSize() - 1) {
            return;
        }
        int n2 = n + 1;
        Object e = defaultListModel.getElementAt(n);
        defaultListModel.setElementAt(defaultListModel.getElementAt(n2), n);
        defaultListModel.setElementAt(e, n2);
        this.viewList.setSelectedIndex(n2);
    }

    public void addAction(String string) {
        DefaultListModel defaultListModel = (DefaultListModel)this.viewList.getModel();
        defaultListModel.addElement(string);
        this.checkList();
        this.hasChanged = true;
    }

    public void deleteAction() {
        int[] nArray = this.viewList.getSelectedIndices();
        DefaultListModel defaultListModel = (DefaultListModel)this.viewList.getModel();
        int n = nArray.length;
        while (--n >= 0) {
            defaultListModel.removeElementAt(nArray[n]);
        }
        this.checkList();
        this.hasChanged = true;
    }

    public void checkList() {
        int n = this.viewList.getModel().getSize();
        if (n == 0 || this.viewList.getSelectedIndex() == -1) {
            this.delButton.setEnabled(false);
        } else {
            this.delButton.setEnabled(true);
        }
        if (n < 2) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            return;
        }
        int[] nArray = this.viewList.getSelectedIndices();
        if (nArray.length != 1) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            return;
        }
        int n2 = nArray[0];
        if (n2 == 0) {
            this.upButton.setEnabled(false);
        } else {
            this.upButton.setEnabled(true);
        }
        if (n2 == n - 1) {
            this.downButton.setEnabled(false);
        } else {
            this.downButton.setEnabled(true);
        }
    }

    @Override
    public void requestFocus() {
        this.viewList.requestFocus();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.checkList();
    }

    public ArrayList getNewList() {
        DefaultListModel defaultListModel = (DefaultListModel)this.viewList.getModel();
        ArrayList arrayList = new ArrayList(defaultListModel.getSize());
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            arrayList.add(defaultListModel.get(i));
        }
        return arrayList;
    }

    public void setEditable(boolean bl) {
        this.viewList.setEnabled(bl);
        this.delButton.setEnabled(bl);
        this.addButton.setEnabled(bl);
    }

    public int getItemCount() {
        return this.viewList.getModel().getSize();
    }

    public ListModel getListModel() {
        return this.viewList.getModel();
    }

    public void enableUpDown(boolean bl) {
        this.upButton.setVisible(bl);
        this.downButton.setVisible(bl);
    }
}

