/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.tree.TreePath;

public class JTreeKeySearcher
implements KeyListener,
ActionListener {
    Timer keyTimer = new Timer(1000, this);
    JTree sourceTree;
    boolean enableKeySearch = true;
    StringBuffer buffer = new StringBuffer(3);

    public JTreeKeySearcher(JTree jTree) {
        this.sourceTree = jTree;
        this.sourceTree.addKeyListener(this);
        this.keyTimer.setCoalesce(true);
        this.keyTimer.setRepeats(false);
    }

    public void setEnableKeySearch(boolean bl) {
        this.enableKeySearch = bl;
    }

    public boolean getEnableKeySearch() {
        return this.enableKeySearch;
    }

    @Override
    public synchronized void keyTyped(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        if (n == 0 || n == 1) {
            char c = keyEvent.getKeyChar();
            if (this.buffer.length() != 0 && this.buffer.charAt(this.buffer.length() - 1) == c) {
                this.buffer.setLength(0);
            }
            this.buffer.append(c);
            this.keyTimer.stop();
            this.searchFor(this.sourceTree, this.buffer.toString());
            this.keyTimer.start();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private void searchFor(JTree jTree, String string) {
        TreePath treePath = jTree.getSelectionPath();
        if (treePath == null) {
            treePath = jTree.getPathForRow(0);
        }
        if (treePath == null) {
            return;
        }
        treePath.getLastPathComponent();
        int n = jTree.getRowForPath(treePath);
        int n2 = n + 1;
        string = string.toLowerCase();
        if (n2 == jTree.getRowCount()) {
            n2 = 0;
        }
        while (n != n2) {
            TreePath treePath2 = jTree.getPathForRow(n2);
            Object object = treePath2.getLastPathComponent();
            if (object.toString().toLowerCase().startsWith(string)) {
                jTree.scrollPathToVisible(treePath2);
                jTree.setSelectionRow(n2);
                break;
            }
            if (++n2 != jTree.getRowCount()) continue;
            n2 = 0;
        }
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.keyTimer) {
            this.buffer.setLength(0);
        }
    }
}

