/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.Action;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class GradientToggleButton
extends JToggleButton {
    private boolean mouseOver;
    private boolean mousePressed;

    public GradientToggleButton(Action action) {
        super(action);
        this.setOpaque(false);
    }

    public GradientToggleButton() {
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (!UIManager.getLookAndFeel().getName().equalsIgnoreCase("Windows")) {
            super.paintComponent(graphics);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, new Color(245, 244, 242), 0.0f, this.getHeight(), new Color(213, 210, 202));
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(graphics);
        int n = 40;
        graphics2D.setPaint(paint);
        if (this.mousePressed) {
            n = 80;
        }
        if (this.mouseOver) {
            graphics2D.setColor(new Color(12, 12, 160));
            graphics2D.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            graphics2D.setColor(new Color(12, 12, 160, n));
            graphics2D.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    public void setMouseOver(boolean bl) {
        this.mouseOver = bl;
    }

    public void setMousePressed(boolean bl) {
        this.mousePressed = bl;
    }
}

