/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.CteStringBank;
import commvault.cte.component.VerticalFlowLayout;
import commvault.cte.component.table.NTable;
import commvault.cte.util.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ControlPanel
extends JPanel {
    public static final String POPUP = "popup";
    public static final String SMALL_ICON = "SmallIcon";
    public static final String MEDIUM_ICON = "MEDIUM_ICON";
    public static final String LARGE_ICON = "LARGE_ICON";
    private Control selectedControl = null;
    private static final int LEFT_OFFSET = 5;
    private static final int TOP_OFFSET = 5;
    private boolean isSummaryPage = false;
    private static final int tableRowHeight = 25;
    private Dimension PREFFERED_SIZE = new Dimension(190, 50);
    JScrollPane scroll = null;
    public static final String VIEW_TILES = CteStringBank.Tiles.getI18n();
    public static final String VIEW_ICON = CteStringBank.Icons.getI18n();
    public static final String VIEW_LIST = CteStringBank.List.getI18n();
    public static final String VIEW_DETAILS = CteStringBank.Details.getI18n();
    protected String currentView = VIEW_ICON;
    private String[] VIEW_OPTIONS = new String[]{VIEW_TILES, VIEW_ICON, VIEW_LIST, VIEW_DETAILS};
    private List<Control> controls = new ArrayList<Control>();
    private ActionListener VIEW_LISTENER = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ControlPanel.this.showView(actionEvent.getActionCommand());
            ControlPanel.this.setPrefferedSize();
        }
    };
    String biggerString = "";
    String biggerTokenedString = "";
    int numberOfWrappedRow = 0;
    private JComponent firstFocusableComponent;
    Control biggerControl = null;

    public ControlPanel(Action[] actionArray, String string) {
        this(actionArray, string, false);
    }

    public ControlPanel(Action[] actionArray, String string, boolean bl, boolean bl2) {
        super(new BorderLayout(0, 0));
        this.initUI(actionArray, string, bl2);
        this.isSummaryPage = bl;
    }

    public ControlPanel(Action[] actionArray, String string, boolean bl) {
        super(new BorderLayout(0, 0));
        this.initUI(actionArray, string, true);
        this.isSummaryPage = bl;
    }

    protected ControlPanel() {
        super(new BorderLayout(0, 0));
    }

    protected void initUI(Action[] actionArray, String string, boolean bl) {
        Object object;
        if (actionArray == null || actionArray.length == 0) {
            return;
        }
        this.currentView = string;
        Iterator<Action> iterator = null;
        if (bl) {
            object = new TreeSet<Action>(new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object == null || object2 == null) {
                        return 0;
                    }
                    if (object instanceof Comparable) {
                        return ((Comparable)object).compareTo(object2);
                    }
                    String string = (String)((Action)object).getValue("Name");
                    String string2 = (String)((Action)object2).getValue("Name");
                    if (string == null) {
                        return -1;
                    }
                    if (string == null) {
                        return 1;
                    }
                    return string.compareTo(string2);
                }
            });
            ((TreeSet)object).addAll(Arrays.asList(actionArray));
            iterator = ((TreeSet)object).iterator();
        } else {
            iterator = Arrays.asList(actionArray).iterator();
        }
        this.scroll = new JScrollPane();
        this.scroll.getVerticalScrollBar().setUnitIncrement(20);
        this.add(this.scroll);
        while (iterator.hasNext()) {
            StringTokenizer stringTokenizer;
            int n;
            object = iterator.next();
            if (object == null) continue;
            String string2 = object.getValue("Name").toString();
            Control control = this.addControl((Action)object);
            if (this.biggerString.length() < string2.length() || this.biggerString == null) {
                this.biggerString = string2;
                this.biggerControl = control;
            }
            int n2 = this.numberOfWrappedRow = this.numberOfWrappedRow > (n = (stringTokenizer = new StringTokenizer(object.getValue("Name").toString(), " ")).countTokens()) ? this.numberOfWrappedRow : n;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                this.biggerTokenedString = this.biggerTokenedString.length() > string2.length() ? this.biggerTokenedString : string2;
            }
        }
        if (this.isSummaryPage) {
            string = VIEW_ICON;
        }
        if (string == null || string.equals("")) {
            this.showView(VIEW_DETAILS);
        } else {
            this.showView(string);
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ControlPanel.this.setPrefferedSize();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                super.keyTyped(keyEvent);
            }
        });
    }

    JComponent getContainer() {
        return (JComponent)this.scroll.getViewport().getView();
    }

    private void configureControlContainer() {
        JComponent jComponent = this.getContainer();
        if (jComponent == null) {
            return;
        }
        jComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (ControlPanel.this.selectedControl != null) {
                    ControlPanel.this.selectedControl.deselectLabel();
                }
                ControlPanel.this.showPopup(mouseEvent);
            }
        });
    }

    private void setPrefferedSize() {
        JComponent jComponent = this.getContainer();
        if (jComponent == null) {
            return;
        }
        if (jComponent instanceof JTable) {
            if (jComponent.getPreferredSize().height < this.getSize().height) {
                jComponent.setPreferredSize(this.getSize());
            }
            ((DetailViewModel)((NTable)jComponent.getClientProperty("table.parent")).getModel()).fireTableDataChanged();
            return;
        }
        int n = jComponent.getComponentCount();
        if (this.currentView == VIEW_LIST) {
            int n2 = this.scroll.getViewport().getSize().height / (this.PREFFERED_SIZE.height + 5);
            int n3 = (int)((float)n / (float)n2 * (float)(this.PREFFERED_SIZE.width + this.getHorzontalSpace()));
            jComponent.setPreferredSize(new Dimension(n3, this.scroll.getViewport().getSize().height));
            return;
        }
        int n4 = this.getSize().width / (this.PREFFERED_SIZE.width + 5);
        int n5 = (int)((float)n / (float)n4 * (float)(this.PREFFERED_SIZE.height + this.getVerticalSpace())) + 30;
        jComponent.setPreferredSize(new Dimension(this.getSize().width, n5));
    }

    public Control addControl(Action action) {
        Control control = new Control(action);
        this.controls.add(control);
        return control;
    }

    private void launchFeature(Action action) {
        if (!action.isEnabled()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Object object = action.getValue("ActionCommandKey");
        action.actionPerformed(new ActionEvent(this, 0, object == null ? null : object.toString()));
        this.setCursor(Cursor.getDefaultCursor());
    }

    protected void showView(String string) {
        JComponent jComponent = null;
        this.currentView = Arrays.asList(this.VIEW_OPTIONS).contains(string) ? string : VIEW_ICON;
        for (Control jComponent2 : this.controls) {
            jComponent2.setView(string);
        }
        if (this.controls.size() > 0) {
            this.firstFocusableComponent = this.controls.get(0);
        }
        if (VIEW_DETAILS.equals(this.currentView)) {
            this.firstFocusableComponent = jComponent = new DetailView().getTable();
            this.scroll.setVerticalScrollBarPolicy(20);
            this.scroll.setHorizontalScrollBarPolicy(30);
        } else {
            if (VIEW_LIST.equals(this.currentView) && this.biggerControl != null) {
                this.PREFFERED_SIZE = this.biggerControl.calculatePrefferedSize();
                this.PREFFERED_SIZE.width += 30;
                this.PREFFERED_SIZE.height += 10;
                jComponent = new JPanel(new VerticalFlowLayout(0, this.getHorzontalSpace(), this.getVerticalSpace(), false, false));
                jComponent.setBackground(Color.white);
                this.scroll.setVerticalScrollBarPolicy(21);
                this.scroll.setHorizontalScrollBarPolicy(30);
            } else {
                if (VIEW_TILES.equals(this.currentView) && this.biggerControl != null) {
                    this.PREFFERED_SIZE = this.biggerControl.calculatePrefferedSize();
                    this.PREFFERED_SIZE.width += 50;
                    this.PREFFERED_SIZE.height += 10;
                } else if (this.biggerControl != null) {
                    JLabel jLabel = new JLabel(this.biggerTokenedString);
                    this.PREFFERED_SIZE = jLabel.getUI().getPreferredSize(jLabel);
                    Dimension dimension = this.biggerControl.iconLabel.getUI().getPreferredSize(this.biggerControl.iconLabel);
                    if (this.PREFFERED_SIZE.width < dimension.width) {
                        this.PREFFERED_SIZE = dimension;
                    }
                    JLabel jLabel2 = new JLabel(this.biggerString);
                    this.PREFFERED_SIZE.width += 25;
                    this.PREFFERED_SIZE.height = Utils.getParagraphHeight(jLabel2, this.biggerString, this.PREFFERED_SIZE.width) + 60;
                }
                jComponent = new JPanel(new FlowLayout(0, this.getHorzontalSpace(), this.getVerticalSpace()));
                jComponent.setBackground(Color.white);
                this.scroll.setVerticalScrollBarPolicy(20);
                this.scroll.setHorizontalScrollBarPolicy(31);
            }
            for (JComponent jComponent2 : this.controls) {
                jComponent2.setPreferredSize(this.PREFFERED_SIZE);
                jComponent.add(jComponent2);
            }
        }
        this.scroll.setViewportView(jComponent);
        this.configureControlContainer();
        jComponent.doLayout();
        jComponent.repaint();
        SwingUtilities.updateComponentTreeUI(this);
        jComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                super.keyTyped(keyEvent);
            }
        });
    }

    protected int getVerticalSpace() {
        return 5;
    }

    protected int getHorzontalSpace() {
        return 5;
    }

    private void changeSelection(KeyEvent keyEvent) {
        int n;
        int n2 = 0;
        if (this.selectedControl == null) {
            return;
        }
        int n3 = this.controls.size();
        for (n = 0; n < n3; ++n) {
            if (this.controls.get(n) != this.selectedControl) continue;
            n2 = n;
            break;
        }
        if ((n = this.getSize().width / (this.PREFFERED_SIZE.width + this.getHorzontalSpace())) == 0) {
            n = 1;
        }
        int n4 = n3 / n;
        int n5 = n2 / n;
        int n6 = n2 - n2 / n * n;
        if (this.currentView == VIEW_LIST) {
            n4 = this.scroll.getViewport().getSize().height / (this.PREFFERED_SIZE.height + this.getVerticalSpace());
            n = n3 / n4;
            n6 = n2 / n4;
            n5 = n2 - n2 / n4 * n4;
        }
        switch (keyEvent.getKeyCode()) {
            case 37: {
                --n6;
                break;
            }
            case 39: {
                ++n6;
                break;
            }
            case 38: {
                --n5;
                break;
            }
            case 40: {
                ++n5;
                break;
            }
            default: {
                int n7;
                int n8 = this.controls.size() - 1;
                if (this.controls.indexOf(this.selectedControl) >= 0) {
                    n8 = this.controls.indexOf(this.selectedControl);
                }
                if ((n7 = this.getKeySelectedRow(keyEvent, n8)) >= 0) {
                    this.selectAndScrollControl(n7, keyEvent);
                }
                return;
            }
        }
        int n9 = n5 * n + n6;
        if (this.currentView == VIEW_LIST) {
            n9 = n6 * n4 + n5;
        }
        if (n9 < 0 || n9 >= n3) {
            return;
        }
        this.selectAndScrollControl(n9, keyEvent);
    }

    private void selectAndScrollControl(int n, KeyEvent keyEvent) {
        Control control = this.controls.get(n);
        Point point = this.scroll.getViewport().getViewPosition();
        if (!this.scroll.getViewport().getViewRect().contains(control.getBounds())) {
            if (keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 39 || this.currentView == VIEW_LIST) {
                point.x = control.getLocation().x;
            } else {
                point.y = control.getLocation().y;
            }
            this.scroll.getViewport().setViewPosition(point);
        }
        control.selectLabel();
    }

    private void showControlPopup(Control control, Point point) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        Action action = control.getAction();
        if (action.getValue(POPUP) != null) {
            jPopupMenu = (JPopupMenu)action.getValue(POPUP);
        } else {
            JMenuItem jMenuItem = jPopupMenu.add(action);
            jMenuItem.setText(this.createOpenActionName());
            jMenuItem.setIcon(null);
        }
        jPopupMenu.show(control, point.x + 1, point.y + 1);
    }

    protected String createOpenActionName() {
        return CteStringBank.Open.getI18n();
    }

    protected void showPopup(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3) {
            JPopupMenu jPopupMenu = this.createPopupMenu();
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenu jMenu = new JMenu(CteStringBank.View.getI18n());
        jPopupMenu.add(jMenu);
        for (int i = 0; i < this.VIEW_OPTIONS.length; ++i) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.VIEW_OPTIONS[i]);
            if (!this.VIEW_OPTIONS[i].equals(VIEW_DETAILS) || !this.isSummaryPage) {
                jMenu.add(jRadioButtonMenuItem);
            }
            if (this.currentView.equals(this.VIEW_OPTIONS[i])) {
                jRadioButtonMenuItem.setSelected(true);
            }
            jRadioButtonMenuItem.addActionListener(this.VIEW_LISTENER);
            jRadioButtonMenuItem.setActionCommand(this.VIEW_OPTIONS[i]);
        }
        return jPopupMenu;
    }

    private int getKeySelectedRow(KeyEvent keyEvent, int n) {
        if (n >= this.controls.size()) {
            return n;
        }
        int n2 = -1;
        int n3 = -1;
        char c = Character.toUpperCase(keyEvent.getKeyChar());
        for (Control control : this.controls) {
            ++n3;
            String string = this.controls.get(n).getAction().getValue("Name").toString();
            String string2 = control.getAction().getValue("Name").toString();
            if (!control.getAction().isEnabled() || c != string2.charAt(0)) continue;
            if (string2.charAt(0) == string.charAt(0)) {
                if (n3 <= n) continue;
                n2 = n3;
                break;
            }
            n2 = n3;
            break;
        }
        return n2;
    }

    public String getTableColumnName(int n) {
        if (n == 0) {
            return CteStringBank.Name.getI18n();
        }
        return CteStringBank.Description.getI18n();
    }

    protected int getControlColumn() {
        return 0;
    }

    public boolean acceptChanges(Component component) {
        return true;
    }

    public String getCurrentView() {
        return this.currentView;
    }

    public void setScrollVisible(boolean bl) {
        if (this.scroll != null) {
            this.scroll.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public void setCurrentView(String string) {
        this.showView(string);
    }

    public JComponent getFirstFocusableComponent() {
        return this.firstFocusableComponent;
    }

    protected int createFirstColumnWidth() {
        return new JLabel((String)this.biggerString).getPreferredSize().width;
    }

    public void setDraggingEnabled(boolean bl) {
        for (Control control : this.controls) {
            control.label.setTransferHandler(new TransferHandler("ControlPanel:" + control.getAction().getValue("ActionCommandKey")));
        }
    }

    class Editor
    extends AbstractCellEditor
    implements TableCellEditor {
        Editor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (n2 == ControlPanel.this.getControlColumn()) {
                Control control = (Control)object;
                if (control == null) {
                    return null;
                }
                control.selectLabel1();
                return control;
            }
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return "";
        }
    }

    class DetailView
    extends NTable {
        public DetailView() {
            super(new DetailViewModel());
            this.setAutoResizeMode(0);
            this.table.setShowGrid(false);
            this.table.setRowHeight(25);
            this.table.getTableHeader().setReorderingAllowed(false);
            this.table.setSelectionMode(0);
            TableColumn tableColumn = this.table.getColumnModel().getColumn(ControlPanel.this.getControlColumn());
            tableColumn.setCellEditor(new Editor());
            this.table.setAutoResizeMode(3);
            this.table.setDefaultCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    if (n2 == ControlPanel.this.getControlColumn()) {
                        TableCellRenderer tableCellRenderer = (TableCellRenderer)jTable.getValueAt(n, n2);
                        if (tableCellRenderer != null) {
                            return tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                        }
                        return new JLabel();
                    }
                    bl = false;
                    Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    Color color = jTable.getBackground();
                    component.setBackground(new Color((int)((double)color.getRed() * 0.98), (int)((double)color.getGreen() * 0.98), (int)((double)color.getBlue() * 0.98)));
                    return component;
                }
            });
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        int n = DetailView.this.getUnsortedSelectedRow();
                        if (n < 0 || n >= DetailView.this.table.getRowCount()) {
                            return;
                        }
                        Control control = (Control)ControlPanel.this.controls.get(n);
                        if (control != null) {
                            ControlPanel.this.launchFeature(control.getAction());
                        }
                    }
                }
            });
            tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setMinWidth(ControlPanel.this.createFirstColumnWidth() + 20);
            tableColumn.setPreferredWidth(ControlPanel.this.createFirstColumnWidth() + 40);
            tableColumn.setMaxWidth(ControlPanel.this.createFirstColumnWidth() + 60);
        }
    }

    class DetailViewModel
    extends AbstractTableModel {
        DetailViewModel() {
        }

        @Override
        public int getRowCount() {
            return ControlPanel.this.controls.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n >= ControlPanel.this.controls.size()) {
                return null;
            }
            if (n2 == ControlPanel.this.getControlColumn()) {
                return ControlPanel.this.controls.get(n);
            }
            return ((Control)ControlPanel.this.controls.get(n)).getDescription();
        }

        @Override
        public String getColumnName(int n) {
            return ControlPanel.this.getTableColumnName(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == ControlPanel.this.getControlColumn();
        }
    }

    class Control
    extends JPanel
    implements TableCellRenderer {
        Action act = null;
        JLabel label = null;
        JLabel iconLabel = null;

        public Control(Action action) {
            this.act = action;
            this.setOpaque(false);
            this.setControlText(action);
            this.label.getActionMap().put("copy-to-clipboard", action);
            this.label.setVerticalTextPosition(1);
            this.label.setHorizontalTextPosition(2);
            this.iconLabel = new JLabel((Icon)action.getValue(ControlPanel.SMALL_ICON));
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        ControlPanel.this.launchFeature(Control.this.getAction());
                    } else {
                        ControlPanel.this.changeSelection(keyEvent);
                    }
                }
            });
            this.setFocusable(true);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 3) {
                        if (Control.this.getComponentAt(mouseEvent.getPoint()) == null || Control.this.getComponentAt(mouseEvent.getPoint()) == Control.this) {
                            ControlPanel.this.showPopup(mouseEvent);
                            return;
                        }
                        ControlPanel.this.showControlPopup(Control.this, mouseEvent.getPoint());
                    }
                    if (mouseEvent.getClickCount() == 1) {
                        if (Control.this.getComponentAt(mouseEvent.getPoint()) == null || Control.this.getComponentAt(mouseEvent.getPoint()) == Control.this) {
                            if (ControlPanel.this.selectedControl != null) {
                                ControlPanel.this.selectedControl.deselectLabel();
                            }
                            return;
                        }
                        Control.this.selectLabel();
                    }
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() != 3 && mouseEvent.getClickCount() == 2) {
                        ControlPanel.this.launchFeature(Control.this.getAction());
                    }
                }
            };
            ToolTipManager.sharedInstance().registerComponent(this);
            this.setToolTipText(this.getDescription());
            this.addMouseListener(mouseAdapter);
        }

        @Override
        public String toString() {
            return (String)this.act.getValue("Name");
        }

        public Dimension calculatePrefferedSize() {
            Dimension dimension = this.label.getUI().getPreferredSize(this.label);
            Dimension dimension2 = this.iconLabel.getUI().getPreferredSize(this.iconLabel);
            if (VIEW_DETAILS.equals(ControlPanel.this.currentView) || VIEW_LIST.equals(ControlPanel.this.currentView) || VIEW_TILES.equals(ControlPanel.this.currentView)) {
                dimension.width += dimension2.width + 5;
                dimension.height = dimension.height > dimension2.height ? dimension.height : dimension2.height;
            } else {
                dimension.height += dimension2.height + 5;
                dimension.width = dimension.width > dimension2.width ? dimension.width : dimension2.width;
            }
            return dimension;
        }

        private void setControlText(Action action) {
            Color color = UIManager.getColor("textInactiveText");
            this.label = action.isEnabled() ? new JLabel("<html><body><p align='center'>" + action.getValue("Name").toString() + "</p></body></html>", 0) : new JLabel("<html><body><p align='center'><font color=" + this.toHexString(color) + ">" + action.getValue("Name").toString() + "</font></p></body></html>", 0);
        }

        private String toHexString(Color color) {
            String string;
            String string2;
            String string3 = Integer.toHexString(color.getRed() & 0xFF);
            if (string3.length() == 1) {
                string3 = "0" + string3;
            }
            if ((string2 = Integer.toHexString(color.getGreen() & 0xFF)).length() == 1) {
                string2 = "0" + string2;
            }
            if ((string = Integer.toHexString(color.getBlue() & 0xFF)).length() == 1) {
                string = "0" + string;
            }
            return "#" + string3 + string2 + string;
        }

        private void setView(String string) {
            this.removeAll();
            if (VIEW_DETAILS.equals(string) || VIEW_LIST.equals(string) || VIEW_TILES.equals(string)) {
                this.setLayout(new FlowLayout(0));
            } else {
                this.setLayout(new VerticalFlowLayout());
            }
            this.add(this.iconLabel);
            this.add(this.label);
            this.selectLabel();
            this.deselectLabel();
            if (VIEW_DETAILS.equals(string) || VIEW_LIST.equals(string)) {
                this.iconLabel.setIcon((Icon)this.act.getValue(ControlPanel.SMALL_ICON));
            }
            if (VIEW_TILES.equals(string)) {
                this.iconLabel.setIcon((Icon)this.act.getValue(ControlPanel.LARGE_ICON));
            }
            if (VIEW_ICON.equals(string)) {
                this.iconLabel.setIcon((Icon)this.act.getValue(ControlPanel.MEDIUM_ICON));
            }
        }

        private String getDescription() {
            return this.act.getValue("ShortDescription").toString();
        }

        protected void selectLabel() {
            if (this.isSelected() || ControlPanel.this.getContainer() instanceof JTable) {
                return;
            }
            if (ControlPanel.this.selectedControl != null) {
                ControlPanel.this.selectedControl.deselectLabel();
            }
            this.selectLabel1();
            this.repaint();
            this.requestFocusInWindow();
            ControlPanel.this.selectedControl = this;
        }

        private void selectLabel1() {
            if (this.act.isEnabled()) {
                this.label.setOpaque(true);
                this.label.setForeground(UIManager.getColor("textHighlightText"));
                this.label.setBackground(UIManager.getColor("textHighlight"));
            }
        }

        @Override
        public void requestFocus() {
            super.requestFocus();
            this.selectLabel();
        }

        private boolean isSelected() {
            return ControlPanel.this.selectedControl == this;
        }

        protected void deselectLabel() {
            this.deselectLabel1();
            this.repaint();
            ControlPanel.this.selectedControl = null;
        }

        private void deselectLabel1() {
            if (this.act.isEnabled()) {
                this.label.setOpaque(false);
                this.label.setForeground(UIManager.getColor("textText"));
                this.label.setBackground(new Color(255, 255, 255, 255));
            } else {
                this.label.setForeground(UIManager.getColor("Label.disabledForeground"));
                this.label.setBackground(new Color(255, 255, 255, 255));
            }
        }

        public Action getAction() {
            return this.act;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Control control = (Control)object;
            if (bl) {
                control.selectLabel1();
            } else {
                control.deselectLabel1();
            }
            return control;
        }
    }
}

