/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComboBox;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class ComboboxDocument
extends PlainDocument {
    JComboBox comboBox;
    JTextComponent editor;
    boolean selecting = false;
    boolean allowNewValue;
    private boolean ignoreCase = true;

    public ComboboxDocument(JComboBox jComboBox) {
        this(jComboBox, true);
    }

    public ComboboxDocument(final JComboBox jComboBox, boolean bl) {
        this.comboBox = jComboBox;
        this.comboBox.setEditable(true);
        ((JTextComponent)this.comboBox.getEditor().getEditorComponent()).setDocument(this);
        this.allowNewValue = bl;
        this.editor = (JTextComponent)jComboBox.getEditor().getEditorComponent();
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!ComboboxDocument.this.selecting) {
                    ComboboxDocument.this.highlightCompletedText(0);
                }
            }
        });
        this.editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\u001b') {
                    jComboBox.setPopupVisible(false);
                    ComboboxDocument.this.editor.setSelectionStart(ComboboxDocument.this.getLength());
                    ComboboxDocument.this.editor.setSelectionEnd(ComboboxDocument.this.getLength());
                } else if (jComboBox.isDisplayable()) {
                    jComboBox.setPopupVisible(true);
                }
            }
        });
        this.editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (jComboBox.isDisplayable()) {
                    jComboBox.setPopupVisible(true);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                jComboBox.firePopupMenuCanceled();
                jComboBox.setPopupVisible(false);
            }
        });
        this.editor.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (jComboBox.isDisplayable()) {
                    jComboBox.setPopupVisible(true);
                }
            }
        });
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.remove(n, n2);
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.insertString(n, string, attributeSet);
        Object object = this.lookupItem(this.getText(0, this.getLength()));
        if (object != null) {
            this.setSelectedItem(object);
            this.setText(object.toString());
        } else if (!this.allowNewValue) {
            object = this.comboBox.getSelectedItem();
            n -= string.length();
            this.comboBox.getToolkit().beep();
            if (object != null) {
                this.setText(object.toString());
            }
        } else {
            this.comboBox.getModel().setSelectedItem(this.editor.getText());
        }
        this.highlightCompletedText(n + string.length());
    }

    private void setText(String string) throws BadLocationException {
        super.remove(0, this.getLength());
        super.insertString(0, string, null);
    }

    private void highlightCompletedText(int n) {
        this.editor.setSelectionStart(n);
        this.editor.setSelectionEnd(this.getLength());
    }

    private void setSelectedItem(Object object) {
        this.selecting = true;
        this.comboBox.getModel().setSelectedItem(object);
        this.selecting = false;
    }

    private Object lookupItem(String string) {
        Object object = this.comboBox.getModel().getSelectedItem();
        if (object != null && this.startsWithIgnoreCase(object.toString(), string)) {
            return object;
        }
        int n = this.comboBox.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            Object e = this.comboBox.getModel().getElementAt(i);
            if (e == null || !this.startsWithIgnoreCase(e.toString(), string)) continue;
            return e;
        }
        return null;
    }

    private boolean startsWithIgnoreCase(String string, String string2) {
        if (this.ignoreCase) {
            return string.toUpperCase().startsWith(string2.toUpperCase());
        }
        return string.startsWith(string2);
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }
}

