/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.component.SortedListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;

public class CheckedListBox
extends JPanel {
    protected JList listCheckBox = new JList();
    protected JList listDescription = new JList();
    private JScrollPane scrollPane;

    public CheckedListBox() {
        this.listDescription.setSelectionMode(0);
        this.listDescription.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                CheckBoxItem checkBoxItem;
                int n = CheckedListBox.this.listDescription.locationToIndex(mouseEvent.getPoint());
                if (n < 0) {
                    return;
                }
                checkBoxItem.setChecked(!(checkBoxItem = (CheckBoxItem)CheckedListBox.this.listCheckBox.getModel().getElementAt(n)).isChecked());
                CheckedListBox.this.listCheckBox.repaint();
            }
        });
        this.listCheckBox.setCellRenderer(new CheckBoxRenderer());
        this.listCheckBox.setSelectionMode(0);
        this.listCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                CheckBoxItem checkBoxItem;
                int n = CheckedListBox.this.listCheckBox.locationToIndex(mouseEvent.getPoint());
                if (n < 0) {
                    return;
                }
                checkBoxItem.setChecked(!(checkBoxItem = (CheckBoxItem)CheckedListBox.this.listCheckBox.getModel().getElementAt(n)).isChecked());
                CheckedListBox.this.listDescription.setSelectedIndex(n);
                CheckedListBox.this.listCheckBox.repaint();
            }
        });
        this.scrollPane = new JScrollPane();
        this.scrollPane.setRowHeaderView(this.listCheckBox);
        this.scrollPane.setViewportView(this.listDescription);
        this.listCheckBox.setFixedCellHeight(this.listDescription.getFixedCellHeight());
        this.setLayout(new BorderLayout());
        this.add(this.scrollPane);
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    private CheckBoxItem[] buildCheckBoxItems(int n) {
        CheckBoxItem[] checkBoxItemArray = new CheckBoxItem[n];
        for (int i = 0; i < n; ++i) {
            checkBoxItemArray[i] = new CheckBoxItem();
        }
        return checkBoxItemArray;
    }

    public void setModel(ListModel listModel) {
        this.listCheckBox.setModel(new SortedListModel(this.buildCheckBoxItems(listModel.getSize())));
        this.listDescription.setModel(listModel);
        this.listCheckBox.setFixedCellHeight(this.listDescription.getFixedCellHeight());
    }

    public ListModel getModel() {
        return this.listDescription.getModel();
    }

    public void setPrototypeCellValue(Object object) {
        this.listDescription.setPrototypeCellValue(object);
    }

    public void setCheck(int n, boolean bl) {
        CheckBoxItem checkBoxItem = (CheckBoxItem)this.listCheckBox.getModel().getElementAt(n);
        checkBoxItem.setChecked(bl);
        this.listCheckBox.repaint();
    }

    public boolean isChecked(int n) {
        return ((CheckBoxItem)this.listCheckBox.getModel().getElementAt(n)).isChecked();
    }

    class CheckBoxRenderer
    extends JCheckBox
    implements ListCellRenderer {
        public CheckBoxRenderer() {
            this.setBackground(UIManager.getColor("List.textBackground"));
            this.setForeground(UIManager.getColor("List.textForeground"));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setSelected(((CheckBoxItem)object).isChecked());
            return this;
        }
    }

    class CheckBoxItem {
        private boolean isChecked = false;

        public boolean isChecked() {
            return this.isChecked;
        }

        public void setChecked(boolean bl) {
            this.isChecked = bl;
        }
    }
}

