/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.CteStringBank;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public final class CVJViewPort
extends JViewport
implements ChangeListener {
    private static final int X_OFFSET = 5;
    protected Component actualComponent = null;
    protected String displayString = "";
    protected int height;
    protected boolean enableNoItemDisplay;
    protected Icon icon = null;
    protected MessagePanel messagePanel = null;
    private final Font font = new JLabel().getFont();

    public MessagePanel getMessagePanel() {
        return this.messagePanel;
    }

    public CVJViewPort() {
        this(false, CteStringBank.There_are_no_items_to_show_in_this_view6.getI18n());
    }

    public CVJViewPort(String string) {
        this(false, string);
    }

    public CVJViewPort(boolean bl) {
        this(bl, CteStringBank.There_are_no_items_to_show_in_this_view6.getI18n());
    }

    public CVJViewPort(boolean bl, String string) {
        JLabel jLabel = new JLabel(string);
        this.setDisplayString(string);
        this.height = jLabel.getFontMetrics(jLabel.getFont()).getHeight();
        this.enableNoItemDisplay = bl;
        this.addChangeListener(this);
    }

    public final void setDisplayString(String string) {
        this.displayString = string;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CVJViewPort.this.repaint();
            }
        });
    }

    public void disableMessagePanel() {
        this.messagePanel = null;
        this.setView(this.actualComponent);
    }

    public final String getDisplayString() {
        return this.displayString;
    }

    public void setNoItemDisplay(boolean bl) {
        this.enableNoItemDisplay = bl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CVJViewPort.this.repaint();
            }
        });
    }

    public boolean getNoItemDisplay() {
        return this.enableNoItemDisplay;
    }

    public final void setDisplayParams(boolean bl, String string) {
        this.enableNoItemDisplay = bl;
        this.displayString = string;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CVJViewPort.this.repaint();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.enableNoItemDisplay && this.displayString != null) {
            int n = 5;
            int n2 = this.height;
            for (String string : this.displayString.split("\n")) {
                graphics.drawString(string, n, n2);
                n2 += graphics.getFontMetrics().getHeight();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.enableNoItemDisplay) {
            this.repaint();
        }
    }

    public void setDisplayComponents() {
        if (this.enableNoItemDisplay) {
            if (this.messagePanel != null && this.getView() != null && !(this.getView() instanceof MessagePanel)) {
                this.messagePanel.setSize(this.messagePanel.getPreferredSize());
                this.actualComponent = this.getView();
                this.setView(this.messagePanel);
            } else if (this.messagePanel != null && this.getView() == null || this.messagePanel != null && this.getView() != null && this.getView() instanceof MessagePanel && this.messagePanel != (MessagePanel)this.getView()) {
                this.setView(this.messagePanel);
            }
        } else if (!(this.actualComponent == null || this.getView() != null && this.getView().equals(this.actualComponent))) {
            this.setView(this.actualComponent);
        }
    }

    @Override
    public Color getBackground() {
        return UIManager.getColor("Table.background");
    }

    public final void setErrorMessage(String string) {
        this.icon = UIManager.getIcon("OptionPane.errorIcon");
        this.enableNoItemDisplay = true;
        this.displayString = "";
        this.messagePanel = new MessagePanel(string, this.icon);
        this.setDisplayComponents();
        this.repaint();
    }

    public final void setInformationMessage(String string) {
        this.icon = UIManager.getIcon("OptionPane.informationIcon");
        this.enableNoItemDisplay = true;
        this.displayString = "";
        this.messagePanel = new MessagePanel(string, this.icon);
        this.setDisplayComponents();
        this.repaint();
    }

    public class MessagePanel
    extends JPanel {
        public MessagePanel(String string) {
            this(string, null);
        }

        public MessagePanel(String string, Icon icon) {
            this(string, icon, null);
        }

        public MessagePanel(String string, Icon icon, Font font) {
            JComponent jComponent;
            this.setOpaque(false);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints(-1, -1, -1, -1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0);
            if (icon != null) {
                jComponent = new JLabel(icon);
                jComponent.setSize(jComponent.getPreferredSize());
                this.add((Component)jComponent, gridBagConstraints);
            }
            if (string != null) {
                Object object;
                jComponent = new JTextArea();
                if (font != null) {
                    ((JTextArea)jComponent).setFont(font);
                }
                ((JTextArea)jComponent).setLineWrap(true);
                ((JTextComponent)jComponent).setText(string);
                ((JTextComponent)jComponent).setEditable(false);
                FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
                int n = fontMetrics.charWidth('m');
                int n2 = fontMetrics.getHeight();
                String string2 = string;
                int n3 = 1;
                int n4 = 0;
                while (string2.indexOf(10) != -1) {
                    object = string2.substring(0, string2.indexOf(10));
                    if (n4 < ((String)object).length() * n) {
                        n4 = ((String)object).length() * n;
                    }
                    string2 = string2.substring(string2.indexOf(10) + 1);
                    ++n3;
                }
                if (n4 < string2.length() * n) {
                    n4 = string2.length() * n;
                }
                jComponent.setPreferredSize(new Dimension(n4, n3 * n2 + 10));
                jComponent.setSize(((JTextArea)jComponent).getPreferredSize());
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new Insets(10, 6, 0, 0);
                this.add((Component)jComponent, gridBagConstraints);
                gridBagConstraints.gridheight = 0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.weighty = 1.0;
                object = new JPanel();
                ((JComponent)object).setOpaque(false);
                this.add((Component)object, gridBagConstraints);
            }
            this.setSize(this.getPreferredSize());
        }

        public void dispose() {
            this.removeAll();
        }
    }
}

