/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import com.jidesoft.action.CommandBar;
import com.jidesoft.action.CommandMenuBar;
import com.jidesoft.action.DefaultDockableBarManager;
import com.jidesoft.action.MainContainer;
import com.jidesoft.docking.DefaultDockableHolder;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.office2003.Office2003Painter;
import com.jidesoft.swing.ContentContainer;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.utils.PortingUtils;
import commvault.cte.CteStringBank;
import commvault.cte.component.CVWorkspace;
import commvault.cte.component.StatusBar;
import commvault.cte.component.dock.CVDockableFrameManager;
import commvault.cte.component.dock.FeatureFrame;
import commvault.cte.component.events.CTEAction;
import commvault.cte.component.ribbon.api.common.AsynchronousLoadListener;
import commvault.cte.component.ribbon.api.common.AsynchronousLoading;
import commvault.cte.component.ribbon.api.common.icon.ResizableIcon;
import commvault.cte.component.ribbon.api.common.popup.JPopupPanel;
import commvault.cte.component.ribbon.api.common.popup.PopupPanelManager;
import commvault.cte.component.ribbon.api.ribbon.JRibbon;
import commvault.cte.component.ribbon.internal.ui.ribbon.AbstractBandControlPanel;
import commvault.cte.component.ribbon.internal.utils.FlamingoUtilities;
import commvault.cte.component.ribbon.internal.utils.KeyTipManager;
import commvault.cte.component.ribbon.internal.utils.KeyTipRenderingUtilities;
import commvault.cte.component.ribbon.internal.utils.RenderingUtils;
import commvault.cte.util.Application;
import commvault.cte.util.RuntimeContext;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;

public class CVFrame
extends DefaultDockableHolder {
    private static final int IMAGE_WIDTH = 465;
    public static final String MENU_BAR = "Menu Bar";
    public static final String TOOLBAR = "Tool Bar";
    protected static CVFrame instance = null;
    private StatusBar _statusBar;
    protected CVWorkspace workSpace;
    protected JPanel toolBar = new ContentContainer(){
        private ThemePainter _painter;
        private Color imageColor = Color.black;
        {
            try {
                final ImageIcon imageIcon = Application.instance().getIconSource().getIcon("quinetixGuiBarIconPNG");
                this.setBorder(new MatteBorder(new Insets(0, 0, 0, 465), imageIcon){

                    @Override
                    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                        if (CVFrame.this.getDockableBarManager().getDockableBar(CVFrame.TOOLBAR) != null) {
                            graphics.drawImage(imageIcon.getImage(), n + n3 - 465, 0, n + n3, n4, imageIcon.getIconWidth() - 465, 0, imageIcon.getIconWidth(), n4, component);
                        }
                    }
                });
                BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 1);
                imageIcon.paintIcon((Component)((Object)this), bufferedImage.getGraphics(), 0, 0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this._painter != null) {
                this._painter.getBackgroundLt();
                Graphics2D graphics2D = (Graphics2D)graphics;
                Rectangle rectangle = this.getBounds();
                rectangle.width -= 465;
                int n = rectangle.width = (int)Math.ceil((double)rectangle.width / 2.0);
                JideSwingUtilities.fillGradient((Graphics2D)graphics2D, (Shape)rectangle, (Color)this._painter.getBackgroundLt(), (Color)this._painter.getBackgroundDk(), (boolean)false);
                rectangle.x += n;
                JideSwingUtilities.fillGradient((Graphics2D)graphics2D, (Shape)rectangle, (Color)this._painter.getBackgroundDk(), (Color)this.imageColor, (boolean)false);
            }
        }

        public void add(Component component, Object object) {
            super.add(component, object);
            if (component instanceof MainContainer) {
                component.setVisible(false);
            }
        }

        public void updateUI() {
            super.updateUI();
            this._painter = (ThemePainter)UIDefaultsLookup.get((Object)"Theme.painter");
        }
    };
    private DefaultDockableBarManager dockableBarManager;
    public static Cursor waitPointCursor = null;
    private JRibbon ribbon;
    private boolean wasSetIconImagesCalled;
    private ResizableIcon appIcon;

    protected CVFrame() throws HeadlessException {
        this.init();
        instance = this;
        this.initRibbon();
    }

    protected CVFrame(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        this.init();
        instance = this;
        this.initRibbon();
    }

    protected CVFrame(String string) throws HeadlessException {
        super(string);
        instance = this;
        this.init();
        this.initRibbon();
    }

    private void init() {
        PortingUtils.prerequisiteChecking();
        try {
            waitPointCursor = Toolkit.getDefaultToolkit().createCustomCursor(Application.instance().getIconSource().getIcon("busyIcon").getImage(), new Point(0, 0), CteStringBank.Busy.getI18n());
        }
        catch (Exception exception) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
        this.setDefaultCloseOperation(2);
        this.setLookAndFeel();
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.initDockableBarManager();
        this.initDockingManager();
        this.getLayoutPersistence().setUsePref(false);
        this._statusBar = this.createStatusBar();
        this.getContentPane().add((Component)((Object)this._statusBar), "Last");
        this.getDockingManager().getWorkspace().setLayout((LayoutManager)new BorderLayout());
        Component component = this.createWorkSpace(this.getDockingManager());
        this.getDockingManager().getWorkspace().add(component, (Object)"Center");
        this.getDockingManager().setHeavyweightComponentEnabled(true);
    }

    private void initDockableBarManager() {
        this.getDockingManager().getMainContainer().add((Component)this.toolBar, "North");
        this.dockableBarManager = new DefaultDockableBarManager((RootPaneContainer)((Object)this), (Container)this.toolBar);
        this.getDockableBarManager().setShowContextMenu(false);
    }

    public DefaultDockableBarManager getDockableBarManager() {
        return this.dockableBarManager;
    }

    private void initDockingManager() {
        DockingManager dockingManager = this.getDockingManager();
        dockingManager.setTabbedPaneCustomizer(new DockingManager.TabbedPaneCustomizer(){

            public void customize(final JideTabbedPane jideTabbedPane) {
                jideTabbedPane.setShowCloseButton(true);
                jideTabbedPane.setUseDefaultShowCloseButtonOnTab(false);
                jideTabbedPane.setShowCloseButtonOnTab(true);
                jideTabbedPane.setTabPlacement(1);
                jideTabbedPane.setCloseAction((Action)new CTEAction(jideTabbedPane.getCloseAction()){

                    @Override
                    protected void performAction(ActionEvent actionEvent) {
                        JideTabbedPane.NoFocusButton noFocusButton = (JideTabbedPane.NoFocusButton)actionEvent.getSource();
                        int n = noFocusButton.getIndex();
                        JComponent jComponent = (JComponent)jideTabbedPane.getComponentAt(n);
                        if (jComponent instanceof DockableFrame) {
                            DockableFrame dockableFrame = (DockableFrame)jComponent;
                            CVDockableFrameManager.getInstance().removeFrame(dockableFrame.getKey());
                        }
                    }
                });
            }
        });
        dockingManager.setFloatAllTabs(false);
        dockingManager.setOutlineMode(2);
        dockingManager.setAutohideAllTabs(false);
        dockingManager.setInitSplitPriority(3);
        dockingManager.setEasyTabDock(true);
        dockingManager.setDoubleClickAction(1);
        dockingManager.getWorkspace().setAcceptDockableFrame(true);
        dockingManager.setInitSouthSplit(0);
        dockingManager.setInitEastSplit(1);
        dockingManager.setGroupAllowedOnSidePane(false);
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                CVWorkspace cVWorkspace;
                Component component;
                Container container;
                MouseEvent mouseEvent;
                if (aWTEvent instanceof MouseEvent && (mouseEvent = (MouseEvent)aWTEvent).getID() == 500 && mouseEvent.getClickCount() != 2 && (container = SwingUtilities.getAncestorOfClass(FeatureFrame.class, component = mouseEvent.getComponent())) != null && container.getParent() != null && container.getParent().getParent() == CVFrame.getInstance().getWorkspace() && (cVWorkspace = CVFrame.getInstance().getWorkspace()).getDocument(container.getName()) != null) {
                    cVWorkspace.setActiveDocument(container.getName(), true);
                }
            }
        }, 16L);
    }

    protected void setLookAndFeel() {
        try {
            if (RuntimeContext.isGUIRunningOnWindowsOS()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            LookAndFeelFactory.installJideExtension((int)3);
            Office2003Painter.setNative((boolean)false);
            Office2003Painter office2003Painter = (Office2003Painter)Office2003Painter.getInstance();
            office2003Painter.setColorName("NormalColor");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Component createWorkSpace(DockingManager dockingManager) {
        this.workSpace = new CVWorkspace(dockingManager);
        return this.workSpace;
    }

    protected StatusBar createStatusBar() {
        StatusBar statusBar = new StatusBar();
        return statusBar;
    }

    public StatusBar getStatusBar() {
        return this._statusBar;
    }

    public static void cleanup(boolean bl) {
        if (instance != null) {
            if (bl && instance.getLayoutPersistence() != null) {
                instance.getLayoutPersistence().saveLayoutData();
            }
            if (CVFrame.instance._statusBar != null && CVFrame.instance._statusBar.getParent() != null) {
                CVFrame.instance._statusBar.getParent().remove((Component)((Object)CVFrame.instance._statusBar));
            }
            CVFrame.instance._statusBar = null;
            instance.dispose();
            instance = null;
        }
    }

    protected CVFrame(String string, GraphicsConfiguration graphicsConfiguration) {
        super(string, graphicsConfiguration);
        instance = this;
        this.init();
    }

    public static CVFrame instance() {
        return instance;
    }

    public void revalidate() {
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void setFullBusyCursor(boolean bl) {
        if (CVFrame.isCreated()) {
            instance.getStatusBar().setHourGlass();
        }
    }

    public void setFullBusyCursor() {
        this.setFullBusyCursor(false);
    }

    public void resetFullBusyCursor() {
        if (CVFrame.isCreated()) {
            instance.getStatusBar().resetHourGlass();
        }
    }

    public static void setBusyStatus() {
        if (CVFrame.isCreated()) {
            instance.getStatusBar().setStatusMessage(CteStringBank.Sent_request_to_server5_waiting_for_response666.getI18n());
        }
    }

    public static void resetBusyStatus() {
        if (CVFrame.isCreated()) {
            instance.getStatusBar().resetStatusMessage();
        }
    }

    public void setBusyCursor() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setCursor(waitPointCursor);
            this.getStatusBar().setHourGlass();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CVFrame.this.setCursor(waitPointCursor);
                    CVFrame.this.getStatusBar().setHourGlass();
                }
            });
        }
    }

    public void resetCursor() {
        try {
            this.getStatusBar().resetHourGlass();
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setHourGlassCursor() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void resetHourGlassCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static boolean isCreated() {
        return instance != null;
    }

    public static CVFrame getInstance() {
        return CVFrame.instance();
    }

    public static CommandBar createToolBar() {
        CommandBar commandBar = new CommandBar(TOOLBAR);
        commandBar.setInitSide(1);
        commandBar.setInitMode(2);
        commandBar.setInitIndex(1);
        commandBar.setFloatable(true);
        commandBar.setHidable(false);
        return commandBar;
    }

    public static CommandBar createMenuBar() {
        CommandMenuBar commandMenuBar = new CommandMenuBar(MENU_BAR);
        commandMenuBar.setStretch(true);
        commandMenuBar.setPaintBackground(false);
        return commandMenuBar;
    }

    public static void main(String[] stringArray) {
        new CVFrame().setVisible(true);
    }

    public static void createFrame() {
        new CVFrame();
    }

    public CVWorkspace getWorkspace() {
        return this.workSpace;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void nextWindow() {
        if (this.getDockingManager().getFrame(this.getDockingManager().getActiveFrameKey()) != null) {
            int n;
            String string = this.getDockingManager().getFrame(this.getDockingManager().getActiveFrameKey()).getName();
            String[] stringArray = this.getDockingManager().getAllVisibleFrameKeys();
            for (n = 0; n < stringArray.length && !string.equals(stringArray[n]); ++n) {
            }
            if (n == stringArray.length - 1) {
                this.getWorkspace().nextDocument();
                this.getWorkspace().requestFocusInWindow();
                this.getWorkspace().getActiveDocument().getComponent().requestFocusInWindow();
            } else {
                this.getDockingManager().showFrame(stringArray[n + 1]);
            }
        } else {
            String string = this.getWorkspace().getActiveDocumentName();
            String[] stringArray = this.getWorkspace().getDocumentNames();
            if (string == null || string.equals(stringArray[stringArray.length - 1])) {
                this.getDockingManager().showFrame(this.getDockingManager().getAllVisibleFrameKeys()[0]);
            } else {
                this.getWorkspace().nextDocument();
            }
        }
    }

    public void previousWindow() {
        if (this.getDockingManager().getFrame(this.getDockingManager().getActiveFrameKey()) != null) {
            int n;
            String string = this.getDockingManager().getFrame(this.getDockingManager().getActiveFrameKey()).getName();
            String[] stringArray = this.getDockingManager().getAllVisibleFrameKeys();
            for (n = 0; n < stringArray.length && !stringArray[n].equals(string); ++n) {
            }
            if (n == 0) {
                this.getWorkspace().prevDocument();
                this.getWorkspace().requestFocusInWindow();
                this.getWorkspace().getActiveDocument().getComponent().requestFocusInWindow();
            } else {
                this.getDockingManager().showFrame(stringArray[n - 1]);
            }
        } else {
            String string = this.getWorkspace().getActiveDocumentName();
            String[] stringArray = this.getWorkspace().getDocumentNames();
            if (string == null || string.equals(stringArray[0])) {
                String[] stringArray2 = this.getDockingManager().getAllVisibleFrameKeys();
                this.getDockingManager().showFrame(stringArray2[stringArray2.length - 1]);
            } else {
                this.getWorkspace().prevDocument();
            }
        }
    }

    private void initRibbon() {
        this.ribbon = new JRibbon();
        this.ribbon.putClientProperty("ribbon.internal.isUsingTitlePane", true);
        this.add(this.ribbon, "North");
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){
            private boolean prevAltModif = false;

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                Component component;
                Object object = aWTEvent.getSource();
                if (object instanceof Component && ((component = (Component)object) == CVFrame.this || SwingUtilities.getWindowAncestor(component) == CVFrame.this)) {
                    InputEvent inputEvent;
                    if (aWTEvent instanceof KeyEvent) {
                        inputEvent = (KeyEvent)aWTEvent;
                        switch (inputEvent.getID()) {
                            case 401: {
                                break;
                            }
                            case 402: {
                                boolean bl = this.prevAltModif;
                                boolean bl2 = this.prevAltModif = inputEvent.getModifiersEx() == 512;
                                if (bl && ((KeyEvent)inputEvent).getKeyCode() == 18) break;
                                char c = ((KeyEvent)inputEvent).getKeyChar();
                                if (Character.isLetter(c) || Character.isDigit(c)) {
                                    KeyTipManager.defaultManager().handleKeyPress(c);
                                }
                                if (((KeyEvent)inputEvent).getKeyCode() == 18 || ((KeyEvent)inputEvent).getKeyCode() == 121) {
                                    if (inputEvent.getModifiers() != 0 || inputEvent.getModifiersEx() != 0) break;
                                    boolean bl3 = !PopupPanelManager.defaultManager().getShownPath().isEmpty();
                                    PopupPanelManager.defaultManager().hidePopups(null);
                                    if (bl3 || KeyTipManager.defaultManager().isShowingKeyTips()) {
                                        KeyTipManager.defaultManager().hideAllKeyTips();
                                    }
                                }
                                if (((KeyEvent)inputEvent).getKeyCode() != 27) break;
                                KeyTipManager.defaultManager().showPreviousChain();
                            }
                        }
                    }
                    if (aWTEvent instanceof MouseEvent) {
                        inputEvent = (MouseEvent)aWTEvent;
                        CVFrame.this.fireCTRLKey((MouseEvent)inputEvent);
                        switch (inputEvent.getID()) {
                            case 500: 
                            case 501: 
                            case 502: 
                            case 506: {
                                KeyTipManager.defaultManager().hideAllKeyTips();
                            }
                        }
                    }
                }
            }
        }, 24L);
        final KeyTipLayer keyTipLayer = new KeyTipLayer();
        JRootPane jRootPane = this.getRootPane();
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        final LayoutManager layoutManager = jRootPane.getLayout();
        jRootPane.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String string, Component component) {
                layoutManager.addLayoutComponent(string, component);
            }

            @Override
            public void layoutContainer(Container container) {
                layoutManager.layoutContainer(container);
                CVFrame cVFrame = CVFrame.this;
                if (cVFrame.getRootPane().getWindowDecorationStyle() != 0) {
                    keyTipLayer.setBounds(cVFrame.getRootPane().getBounds());
                } else {
                    keyTipLayer.setBounds(cVFrame.getRootPane().getContentPane().getBounds());
                }
            }

            @Override
            public Dimension minimumLayoutSize(Container container) {
                return layoutManager.minimumLayoutSize(container);
            }

            @Override
            public Dimension preferredLayoutSize(Container container) {
                return layoutManager.preferredLayoutSize(container);
            }

            @Override
            public void removeLayoutComponent(Component component) {
                layoutManager.removeLayoutComponent(component);
            }
        });
        jLayeredPane.add((Component)keyTipLayer, (Object)(JLayeredPane.DEFAULT_LAYER + 60));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                KeyTipManager keyTipManager = KeyTipManager.defaultManager();
                if (keyTipManager.isShowingKeyTips()) {
                    keyTipManager.hideAllKeyTips();
                }
            }
        });
        KeyTipManager.defaultManager().addKeyTipListener(new KeyTipManager.KeyTipListener(){

            @Override
            public void keyTipsHidden(KeyTipManager.KeyTipEvent keyTipEvent) {
                if (keyTipEvent.getSource() == CVFrame.this) {
                    keyTipLayer.setVisible(false);
                }
            }

            @Override
            public void keyTipsShown(KeyTipManager.KeyTipEvent keyTipEvent) {
                if (keyTipEvent.getSource() == CVFrame.this) {
                    keyTipLayer.setVisible(true);
                }
            }
        });
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        super.setIconImages(Arrays.asList(FlamingoUtilities.getBlankImage(16, 16)));
    }

    public JRibbon getRibbon() {
        return this.ribbon;
    }

    public boolean isShowingKeyTips() {
        return KeyTipManager.defaultManager().isShowingKeyTips();
    }

    public synchronized void setApplicationIcon(final ResizableIcon resizableIcon) {
        new Thread(){

            @Override
            public void run() {
                AsynchronousLoading asynchronousLoading;
                if (resizableIcon instanceof AsynchronousLoading && (asynchronousLoading = (AsynchronousLoading)((Object)resizableIcon)).isLoading()) {
                    final CountDownLatch countDownLatch = new CountDownLatch(1);
                    final boolean[] blArray = new boolean[1];
                    AsynchronousLoadListener asynchronousLoadListener = new AsynchronousLoadListener(){

                        @Override
                        public void completed(boolean bl) {
                            blArray[0] = bl;
                            countDownLatch.countDown();
                        }
                    };
                    asynchronousLoading.addAsynchronousLoadListener(asynchronousLoadListener);
                    try {
                        countDownLatch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    asynchronousLoading.removeAsynchronousLoadListener(asynchronousLoadListener);
                }
                CVFrame.this.setApplicationAndMenuButtonIcon(resizableIcon);
            }
        }.start();
    }

    private static Image getImage(ResizableIcon resizableIcon, int n) {
        Object object;
        Object object2;
        resizableIcon.setDimension(new Dimension(n, n));
        if (resizableIcon instanceof AsynchronousLoading && (object2 = (AsynchronousLoading)((Object)resizableIcon)).isLoading()) {
            object = new CountDownLatch(1);
            final boolean[] blArray = new boolean[1];
            AsynchronousLoadListener asynchronousLoadListener = new AsynchronousLoadListener((CountDownLatch)object){
                final /* synthetic */ CountDownLatch val$latch;
                {
                    this.val$latch = countDownLatch;
                }

                @Override
                public void completed(boolean bl) {
                    blArray[0] = bl;
                    this.val$latch.countDown();
                }
            };
            object2.addAsynchronousLoadListener(asynchronousLoadListener);
            try {
                ((CountDownLatch)object).await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            object2.removeAsynchronousLoadListener(asynchronousLoadListener);
            if (!blArray[0]) {
                return null;
            }
            if (object2.isLoading()) {
                return null;
            }
        }
        object2 = FlamingoUtilities.getBlankImage(n, n);
        object = (Graphics2D)((Image)object2).getGraphics().create();
        resizableIcon.paintIcon(null, (Graphics)object, 0, 0);
        ((Graphics)object).dispose();
        return object2;
    }

    private void setLegacyIconImages(List<Image> list) {
        if (this.wasSetIconImagesCalled) {
            return;
        }
        super.setIconImages(list);
    }

    public synchronized void setIconImages(List<? extends Image> list) {
        super.setIconImages(list);
        this.wasSetIconImagesCalled = true;
    }

    private void setApplicationAndMenuButtonIcon(ResizableIcon resizableIcon) {
        if (System.getProperty("os.name").startsWith("Mac")) {
            final Image image = CVFrame.getImage(resizableIcon, 16);
            final Image image2 = CVFrame.getImage(resizableIcon, 128);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (image != null) {
                        CVFrame.this.setLegacyIconImages(Arrays.asList(image));
                    }
                    if (image2 != null) {
                        try {
                            Class<?> clazz = Class.forName("com.apple.eawt.Application");
                            if (clazz != null) {
                                Object obj = clazz.newInstance();
                                Method method = clazz.getDeclaredMethod("setDockIconImage", Image.class);
                                if (method != null) {
                                    method.invoke(obj, image2);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                }
            });
        } else {
            Image image;
            Image image3;
            final ArrayList<Image> arrayList = new ArrayList<Image>();
            Image image4 = CVFrame.getImage(resizableIcon, 16);
            if (image4 != null) {
                arrayList.add(image4);
            }
            if ((image3 = CVFrame.getImage(resizableIcon, 32)) != null) {
                arrayList.add(image3);
            }
            if ((image = CVFrame.getImage(resizableIcon, 64)) != null) {
                arrayList.add(image);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!arrayList.isEmpty()) {
                        CVFrame.this.setLegacyIconImages(arrayList);
                    }
                }
            });
        }
    }

    private void setMainAppIcon(ResizableIcon resizableIcon) {
        this.appIcon = resizableIcon;
        FlamingoUtilities.updateRibbonFrameIconImages(this);
    }

    public synchronized ResizableIcon getApplicationIcon() {
        return this.appIcon;
    }

    protected void fireCTRLKey(MouseEvent mouseEvent) {
    }

    private class KeyTipLayer
    extends JComponent {
        public KeyTipLayer() {
            this.setOpaque(false);
            try {
                if (RuntimeContext.getJavaVersion() > 8) {
                    Class<?> clazz = Class.forName("java.awt.Component");
                    Method method = clazz.getMethod("setMixingCutoutShape", Shape.class);
                    method.invoke((Object)this, new Rectangle());
                } else {
                    Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
                    Method method = clazz.getMethod("setComponentMixingCutoutShape", Component.class, Shape.class);
                    method.invoke(null, this, new Rectangle());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public synchronized void addMouseListener(MouseListener mouseListener) {
        }

        @Override
        public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        }

        @Override
        public synchronized void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        }

        @Override
        public synchronized void addKeyListener(KeyListener keyListener) {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            CVFrame cVFrame = (CVFrame)((Object)SwingUtilities.getWindowAncestor(this));
            if (!cVFrame.isShowingKeyTips()) {
                return;
            }
            if (!cVFrame.isActive()) {
                return;
            }
            Collection<KeyTipManager.KeyTipLink> collection = KeyTipManager.defaultManager().getCurrentlyShownKeyTips();
            if (collection != null) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                RenderingUtils.installDesktopHints(graphics2D);
                for (KeyTipManager.KeyTipLink keyTipLink : collection) {
                    if (SwingUtilities.getAncestorOfClass(JPopupPanel.class, keyTipLink.comp) != null) continue;
                    Rectangle rectangle = keyTipLink.comp.getBounds();
                    if (!keyTipLink.comp.isShowing() || rectangle.getWidth() == 0.0 || rectangle.getHeight() == 0.0) continue;
                    Dimension dimension = KeyTipRenderingUtilities.getPrefSize(graphics2D.getFontMetrics(), keyTipLink.keyTipString);
                    Point point = keyTipLink.prefAnchorPoint;
                    Point point2 = SwingUtilities.convertPoint(keyTipLink.comp, point, this);
                    Container container = SwingUtilities.getAncestorOfClass(AbstractBandControlPanel.class, keyTipLink.comp);
                    if (container != null) {
                        if (this.hasClientPropertySetToTrue(keyTipLink.comp, "flamingo.internal.ribbonBandControlPanel.topRow")) {
                            point2 = SwingUtilities.convertPoint(keyTipLink.comp, point, container);
                            point2.y = 0;
                            point2 = SwingUtilities.convertPoint(container, point2, this);
                        }
                        if (this.hasClientPropertySetToTrue(keyTipLink.comp, "flamingo.internal.ribbonBandControlPanel.midRow")) {
                            point2 = SwingUtilities.convertPoint(keyTipLink.comp, point, container);
                            point2.y = container.getHeight() / 2;
                            point2 = SwingUtilities.convertPoint(container, point2, this);
                        }
                        if (this.hasClientPropertySetToTrue(keyTipLink.comp, "flamingo.internal.ribbonBandControlPanel.bottomRow")) {
                            point2 = SwingUtilities.convertPoint(keyTipLink.comp, point, container);
                            point2.y = container.getHeight();
                            point2 = SwingUtilities.convertPoint(container, point2, this);
                        }
                    }
                    KeyTipRenderingUtilities.renderKeyTip(graphics2D, this, new Rectangle(point2.x - dimension.width / 2, point2.y - dimension.height / 2, dimension.width, dimension.height), keyTipLink.keyTipString, keyTipLink.enabled);
                }
                graphics2D.dispose();
            }
        }

        private boolean hasClientPropertySetToTrue(Component component, String string) {
            while (component != null) {
                JComponent jComponent;
                if (component instanceof JComponent && Boolean.TRUE.equals((jComponent = (JComponent)component).getClientProperty(string))) {
                    return true;
                }
                component = component.getParent();
            }
            return false;
        }

        @Override
        public boolean contains(int n, int n2) {
            return false;
        }
    }
}

