/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.xml;

import commvault.cte.common.xml.BinaryEncodingType;
import commvault.cte.common.xml.CVClass;
import commvault.cte.common.xml.CVEnum;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;

public class BinaryOutputStream
extends ByteArrayOutputStream {
    public static final int PACKAGE_ID_SHIFT = 24;
    int msgId = 0;
    int version = 1;

    BinaryOutputStream() {
        super(128);
    }

    BinaryOutputStream(int n) {
        super(n);
    }

    BinaryOutputStream(CVClass cVClass, int n) {
        if (cVClass != null) {
            this.msgId = cVClass.getTagIdValue() << 24 | cVClass.getIdValue();
        }
        this.writeFixed32(this.version);
        this.writeFixed32(this.msgId);
    }

    public static int zigZagEncode32(int n) {
        return n << 1 ^ n >> 31;
    }

    public void writeRawByte(int n) {
        this.write(n);
    }

    public void writeRawBytes(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void writeRawBytes(byte[] byArray, int n) throws IOException {
        this.write(byArray, 0, n);
    }

    public void writeRawBytes(byte[] byArray, int n, int n2) throws IOException {
        this.write(byArray, n, n2);
    }

    public void writeKeyOrSize(BinaryEncodingType binaryEncodingType, int n) throws IOException {
        if (binaryEncodingType == BinaryEncodingType.FIXED32) {
            this.writeFixed32(n);
        } else {
            this.writeVarInt32(n);
        }
    }

    public void writeVarInt32(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.write(n);
                return;
            }
            this.write(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public void writeSignedVarInt32(int n) throws IOException {
        this.writeVarInt32(BinaryOutputStream.zigZagEncode32(n));
    }

    public void writeFixed32(int n) {
        this.writeRawByte(n & 0xFF);
        this.writeRawByte(n >> 8 & 0xFF);
        this.writeRawByte(n >> 16 & 0xFF);
        this.writeRawByte(n >> 24 & 0xFF);
    }

    public void writeFixed64(long l) {
        this.writeRawByte((int)l & 0xFF);
        this.writeRawByte((int)(l >> 8) & 0xFF);
        this.writeRawByte((int)(l >> 16) & 0xFF);
        this.writeRawByte((int)(l >> 24) & 0xFF);
        this.writeRawByte((int)(l >> 32) & 0xFF);
        this.writeRawByte((int)(l >> 40) & 0xFF);
        this.writeRawByte((int)(l >> 48) & 0xFF);
        this.writeRawByte((int)(l >> 56) & 0xFF);
    }

    public void writeLong(Object object) {
        this.writeFixed64((Long)object);
    }

    public void writeLongList(List list) {
        for (Object e : list) {
            this.writeLong(e);
        }
    }

    public void writeDouble(Object object) {
        double d = (Double)object;
        this.writeFixed64(Double.doubleToLongBits(d));
    }

    public void writeDoubleList(List list) {
        for (Object e : list) {
            this.writeDouble(e);
        }
    }

    public void writeFloat(Object object) {
        float f = ((Float)object).floatValue();
        this.writeFixed32(Float.floatToIntBits(f));
    }

    public void writeFloatList(List list) {
        for (Object e : list) {
            this.writeFloat(e);
        }
    }

    public void writeString(Object object) throws IOException {
        try {
            if (object instanceof String) {
                String string = (String)object;
                byte[] byArray = string.getBytes("UTF-8");
                this.writeKeyOrSize(BinaryEncodingType.VARINT, byArray.length);
                this.writeRawBytes(byArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void writeBString(Object object) throws IOException {
        try {
            byte[] byArray = (byte[])object;
            this.writeKeyOrSize(BinaryEncodingType.VARINT, byArray.length);
            this.writeRawBytes(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void writeStringList(List list, int n) throws IOException {
        for (Object e : list) {
            this.writeKeyOrSize(BinaryEncodingType.FIXED32, n);
            this.writeString(e);
        }
    }

    public void writeBStringList(List list, int n) throws IOException {
        for (Object e : list) {
            this.writeKeyOrSize(BinaryEncodingType.FIXED32, n);
            this.writeBString(e);
        }
    }

    @Override
    public byte[] toByteArray() {
        return Arrays.copyOfRange(this.buf, 0, this.size());
    }

    public void writeBool(Object object) throws IOException {
        if (((Boolean)object).booleanValue()) {
            this.writeVarInt32(1);
        } else {
            this.writeVarInt32(0);
        }
    }

    public void writeBoolList(List list) throws IOException {
        for (Object e : list) {
            this.writeBool(e);
        }
    }

    public void writeEnum(Object object) throws IOException {
        if (object != null) {
            this.writeSignedVarInt32(((CVEnum)object).getEnumValue());
        }
    }

    public void writeEnumL(Object object) throws IOException {
        if (object != null) {
            this.writeVarInt32(((CVEnum)object).getEnumValue());
        }
    }

    public void writeEnumList(List list) throws IOException {
        int n = list.size() * 5;
        BinaryOutputStream binaryOutputStream = new BinaryOutputStream(n);
        for (Object e : list) {
            binaryOutputStream.writeEnumL(e);
        }
        this.writeKeyOrSize(BinaryEncodingType.VARINT, binaryOutputStream.count);
        this.writeRawBytes(binaryOutputStream.buf, 0, binaryOutputStream.count);
        binaryOutputStream.flush();
        binaryOutputStream.close();
    }

    public void writeUnsignedInteger(Object object) throws IOException {
        this.writeVarInt32((Integer)object);
    }

    public void writeUnsignedLInteger(Object object) throws IOException {
        this.writeVarInt32(((Long)object).intValue());
    }

    public void writeUnsignedIntegerList(List list) throws IOException {
        int n = list.size() * 5;
        BinaryOutputStream binaryOutputStream = new BinaryOutputStream(n);
        for (Object e : list) {
            binaryOutputStream.writeUnsignedInteger(e);
        }
        this.writeStream(binaryOutputStream);
    }

    public void writeUnsignedLIntegerList(List list) throws IOException {
        int n = list.size() * 5;
        BinaryOutputStream binaryOutputStream = new BinaryOutputStream(n);
        for (Object e : list) {
            binaryOutputStream.writeUnsignedLInteger(e);
        }
        this.writeStream(binaryOutputStream);
    }

    public void writeSignedInteger(Object object) throws IOException {
        this.writeSignedVarInt32((Integer)object);
    }

    public void writeSignedLInteger(Object object) throws IOException {
        this.writeSignedVarInt32(((Long)object).intValue());
    }

    public void writeSignedIntegerList(List list) throws IOException {
        int n = list.size() * 5;
        BinaryOutputStream binaryOutputStream = new BinaryOutputStream(n);
        for (Object e : list) {
            binaryOutputStream.writeSignedInteger(e);
        }
        this.writeStream(binaryOutputStream);
    }

    public void writeSignedLIntegerList(List list) throws IOException {
        int n = list.size() * 5;
        BinaryOutputStream binaryOutputStream = new BinaryOutputStream(n);
        for (Object e : list) {
            binaryOutputStream.writeSignedLInteger(e);
        }
        this.writeStream(binaryOutputStream);
    }

    public void writeStream(BinaryOutputStream binaryOutputStream) throws IOException {
        this.writeKeyOrSize(BinaryEncodingType.VARINT, binaryOutputStream.count);
        this.writeRawBytes(binaryOutputStream.buf, 0, binaryOutputStream.count);
    }

    public void copyStream(BinaryOutputStream binaryOutputStream) throws IOException {
        this.writeRawBytes(binaryOutputStream.buf, 0, binaryOutputStream.count);
    }
}

