/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.workflow;

import commvault.cte.common.workflow.SystemElement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class ActivitySystem {
    public static final String START_TIME = "startTime";
    public static final String END_TIME = "endTime";
    public static final String TIMED_OUT = "timedOut";
    public static final String STATUS = "status";
    private static final List<SystemElement> systemElements = new ArrayList<SystemElement>();
    private Element element;

    public ActivitySystem() {
        this(new Element("system"));
    }

    public ActivitySystem(Element element) {
        this.element = element;
        this.buildElements(this.element, systemElements);
    }

    private void buildElements(Element element, List<SystemElement> list) {
        for (SystemElement systemElement : list) {
            Element element2 = element.getChild(systemElement.name);
            if (element2 == null) {
                element2 = new Element(systemElement.name);
                element.addContent((Content)element2);
            }
            element2.setAttribute("class", systemElement.type.getName());
            if (systemElement.childElements.size() <= 0) continue;
            this.buildElements(element2, systemElement.childElements);
        }
    }

    public void set(String string, Object object) {
        Element element = this.element.getChild(string);
        if (object == null) {
            element.setText("");
        } else {
            element.setText(String.valueOf(object));
        }
    }

    public Element getElement() {
        return this.element;
    }

    static {
        systemElements.add(new SystemElement(START_TIME, Date.class));
        systemElements.add(new SystemElement(END_TIME, Date.class));
        systemElements.add(new SystemElement(STATUS, String.class));
        systemElements.add(new SystemElement(TIMED_OUT, Boolean.class));
    }
}

