/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.schema;

import commvault.cte.common.schema.SchemaAnnotation;
import commvault.cte.common.schema.SchemaDocument;
import commvault.cte.common.schema.SchemaProperty;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public abstract class SchemaType
implements Serializable {
    protected SchemaDocument schemaDocument;

    protected abstract void parse() throws Exception;

    public abstract QName getName();

    public abstract SchemaType getBaseType();

    public abstract List<SchemaProperty> getProperties();

    public abstract Class getJavaClass();

    public abstract boolean isAbstract();

    public abstract boolean isAny();

    public abstract boolean isComplex();

    public abstract Element getElement();

    public abstract Vector<String> getEnumerations();

    public abstract SchemaAnnotation getAnnotation();

    public SchemaProperty getProperty(String string) {
        if (this.getProperties() == null) {
            return null;
        }
        for (SchemaProperty schemaProperty : this.getProperties()) {
            if (!schemaProperty.getName().getLocalPart().equalsIgnoreCase(string)) continue;
            return schemaProperty;
        }
        return null;
    }

    public SchemaDocument getSchemaDocument() {
        return this.schemaDocument;
    }

    public String getJavaName() {
        if (this.getJavaClass() != null) {
            return this.getJavaClass().getName();
        }
        return this.buildClassName();
    }

    private String buildClassName() {
        if (this.getName() != null) {
            return this.getName().getNamespaceURI() + "." + this.getName().getLocalPart();
        }
        return null;
    }

    public String getXml() {
        if (this.getElement() != null) {
            try {
                XMLOutputter xMLOutputter = new XMLOutputter();
                Format format = xMLOutputter.getFormat().setTextMode(Format.TextMode.TRIM);
                xMLOutputter.setFormat(format);
                StringWriter stringWriter = new StringWriter();
                xMLOutputter.output(this.getElement(), (Writer)stringWriter);
                stringWriter.close();
                return stringWriter.toString();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public String toString() {
        if (this.getName() == null) {
            return super.toString();
        }
        return this.getName().toString();
    }
}

