/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.schema;

import java.util.List;
import java.util.Vector;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ApplicationInfo {
    private Element appInfoElement;
    private Element autoLink;
    private Element userType;
    private Element linkDisabled;
    private Element displayName;
    private Element controlType;
    private Element readOnly;
    private Element searchable;
    private Element visible;
    private List<String> options;
    private Element controlAlignment;
    private Element controlHidden;

    protected ApplicationInfo(Namespace namespace) {
        this(new Element("appinfo", namespace));
    }

    protected ApplicationInfo(Element element) {
        this.appInfoElement = element;
        this.autoLink = this.getChild("autoLink");
        this.readOnly = this.getChild("readOnly");
        this.searchable = this.getChild("searchable");
        this.userType = this.getChild("userType");
        this.linkDisabled = this.getChild("linkDisabled");
        this.displayName = this.getChild("displayName");
        this.controlType = this.getChild("controlType");
        this.visible = this.getChild("visible");
        this.searchable = this.getChild("searchable");
        this.controlAlignment = this.getChild("controlAlignment");
        this.controlHidden = this.getChild("controlHidden");
        List<Element> list = this.getChildren("userOptions");
        if (list != null && list.size() > 0) {
            this.options = new Vector<String>();
            for (Element element2 : list) {
                this.options.add(element2.getText());
            }
        }
    }

    private Element getChild(String string) {
        Element element = this.appInfoElement.getChild(string);
        if (element != null) {
            return element;
        }
        return this.appInfoElement.getChild(string, this.appInfoElement.getNamespace());
    }

    private List<Element> getChildren(String string) {
        List list = this.appInfoElement.getChildren(string);
        if (list != null) {
            return list;
        }
        return this.appInfoElement.getChildren(string, this.appInfoElement.getNamespace());
    }

    public void setDisplayName(String string) {
        if (this.displayName == null) {
            this.displayName = new Element("displayName");
            this.appInfoElement.addContent((Content)this.displayName);
        }
        this.displayName.setText(string);
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return "";
        }
        return this.displayName.getText();
    }

    public void setControlType(String string) {
        if (this.controlType == null) {
            this.controlType = new Element("controlType");
            this.appInfoElement.addContent((Content)this.controlType);
        }
        this.controlType.setText(string);
    }

    public String getControlType() {
        if (this.controlType == null) {
            return "";
        }
        return this.controlType.getText();
    }

    public void setLinkDisabled(boolean bl) {
        if (bl) {
            if (this.linkDisabled == null) {
                this.linkDisabled = new Element("linkDisabled");
                this.appInfoElement.addContent((Content)this.linkDisabled);
            }
            this.linkDisabled.setText(String.valueOf(bl));
        } else if (this.linkDisabled != null) {
            this.appInfoElement.removeContent((Content)this.linkDisabled);
            this.linkDisabled = null;
        }
    }

    public boolean getLinkDisabled() {
        if (this.linkDisabled == null || this.linkDisabled.getTextTrim().length() == 0) {
            return false;
        }
        return Boolean.valueOf(this.linkDisabled.getText());
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            if (this.visible == null) {
                this.visible = new Element("visible");
                this.appInfoElement.addContent((Content)this.visible);
            }
            this.visible.setText(String.valueOf(bl));
        } else if (this.visible != null) {
            this.appInfoElement.removeContent((Content)this.visible);
            this.visible = null;
        }
    }

    public boolean isVisible() {
        if (this.visible == null || this.visible.getTextTrim().length() == 0) {
            return true;
        }
        return Boolean.valueOf(this.visible.getText());
    }

    public void setAutoLink(boolean bl) {
        if (!bl) {
            if (this.autoLink == null) {
                this.autoLink = new Element("autoLink");
                this.appInfoElement.addContent((Content)this.autoLink);
            }
            this.autoLink.setText(String.valueOf(bl));
        } else if (this.autoLink != null) {
            this.appInfoElement.removeContent((Content)this.autoLink);
            this.autoLink = null;
        }
    }

    public boolean getAutoLink() {
        if (this.autoLink == null || this.autoLink.getTextTrim().length() == 0) {
            return true;
        }
        return Boolean.parseBoolean(this.autoLink.getText());
    }

    public void setReadOnly(boolean bl) {
        if (this.readOnly == null) {
            this.readOnly = new Element("readOnly");
            this.appInfoElement.addContent((Content)this.readOnly);
        }
        this.readOnly.setText(String.valueOf(bl));
    }

    public boolean getReadOnly() {
        if (this.readOnly == null || this.readOnly.getTextTrim().length() == 0) {
            return false;
        }
        return Boolean.parseBoolean(this.readOnly.getText());
    }

    public void setSearchable(boolean bl) {
        if (this.searchable == null) {
            this.searchable = new Element("searchable");
            this.appInfoElement.addContent((Content)this.searchable);
        }
        this.searchable.setText(String.valueOf(bl));
    }

    public boolean getSearchable() {
        if (this.searchable == null || this.searchable.getTextTrim().length() == 0) {
            return false;
        }
        return Boolean.parseBoolean(this.searchable.getText());
    }

    public void setUserType(boolean bl) {
        if (!bl) {
            if (this.userType == null) {
                this.userType = new Element("userType");
                this.appInfoElement.addContent((Content)this.userType);
            }
            this.userType.setText(String.valueOf(bl));
        } else if (this.userType != null) {
            this.appInfoElement.removeContent((Content)this.userType);
            this.userType = null;
        }
    }

    public boolean getUserType() {
        if (this.userType == null || this.userType.getTextTrim().length() == 0) {
            return true;
        }
        return Boolean.parseBoolean(this.userType.getText());
    }

    public String[] getOptions() {
        if (this.options != null) {
            return this.options.toArray(new String[0]);
        }
        return null;
    }

    public void setOptions(List<String> list) {
        this.options = list;
        this.appInfoElement.removeChildren("userOptions");
        if (list != null && list.size() > 0) {
            for (String string : list) {
                Element element = new Element("userOptions");
                element.setText(string);
                this.appInfoElement.addContent((Content)element);
            }
        }
    }

    public Element getElement() {
        return this.appInfoElement;
    }

    public void setControlAlignment(String string) {
        if (this.controlAlignment == null) {
            this.controlAlignment = new Element("controlAlignment");
            this.appInfoElement.addContent((Content)this.controlAlignment);
        }
        this.controlAlignment.setText(string);
    }

    public String getControlAlignment() {
        if (this.controlAlignment == null) {
            return "";
        }
        return this.controlAlignment.getText();
    }

    public void setControlHidden(boolean bl) {
        if (this.controlHidden == null) {
            this.controlHidden = new Element("controlHidden");
            this.appInfoElement.addContent((Content)this.controlHidden);
        }
        this.controlHidden.setText(String.valueOf(bl));
    }

    public boolean getControlHidden() {
        if (this.controlHidden == null || this.controlHidden.getTextTrim().length() == 0) {
            return false;
        }
        return Boolean.parseBoolean(this.controlHidden.getText());
    }
}

