/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common;

import com.creamtec.ajaxswing.AjaxSwingManager;
import javax.swing.SwingUtilities;

public abstract class SwingWorker<V> {
    private V value;
    private ThreadVar threadVar;

    protected synchronized V getValue() {
        return this.value;
    }

    private synchronized void setValue(V v) {
        this.value = v;
    }

    public abstract V construct();

    public void finished() {
    }

    public void interrupt() {
        Thread thread = this.threadVar.get();
        if (thread != null) {
            thread.interrupt();
        }
        this.threadVar.clear();
    }

    public V get() {
        Thread thread;
        while ((thread = this.threadVar.get()) != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public SwingWorker() {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SwingWorker.this.finished();
                if (AjaxSwingManager.isAjaxSwingRunning()) {
                    AjaxSwingManager.endOperation();
                }
            }
        };
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                }
                finally {
                    SwingWorker.this.threadVar.clear();
                }
                SwingUtilities.invokeLater(runnable);
            }
        };
        Thread thread = new Thread(runnable2);
        this.threadVar = new ThreadVar(thread);
    }

    public void start() {
        Thread thread = this.threadVar.get();
        if (thread != null) {
            if (AjaxSwingManager.isAjaxSwingRunning()) {
                AjaxSwingManager.beginOperation();
            }
            thread.start();
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread thread) {
            this.thread = thread;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

