/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.cm;

import commvault.cte.cm.Attachment;
import commvault.cte.cm.AttachmentStream;
import commvault.cte.cm.db.DBInsert;
import commvault.cte.cm.db.DBSelect;
import commvault.cte.cm.db.DBUpdate;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public class FolderAttachment
extends Attachment {
    protected FolderAttachment() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAttachment(File file) throws Exception {
        block7: {
            FileOutputStream fileOutputStream = null;
            InputStream inputStream = null;
            try {
                inputStream = this.getBinaryStream();
                if (inputStream != null) {
                    int n;
                    fileOutputStream = new FileOutputStream(file);
                    byte[] byArray = new byte[2048];
                    while ((n = inputStream.read(byArray)) >= 0) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    break block7;
                }
                throw new Exception("failed to write attachment to [" + file + "], error: attachment stream is null");
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
    }

    protected void save(InputStream inputStream) throws Exception {
        if (inputStream != null) {
            if (this.getRowId() > 0) {
                if (this.getAttachmentId() == 0) {
                    this.insertAttachment(inputStream);
                } else {
                    this.updateAttachment(inputStream);
                }
            } else {
                throw new Exception("invalid row id for attachment [" + this.getFileName() + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertAttachment(InputStream inputStream) throws Exception {
        String string = "insert into " + this.getAttachmentTable() + " (RowId,FileName,ContentType,Size,Description,Attachment) values (?,?,?,?,?,?)";
        try (DBInsert dBInsert = null;){
            dBInsert = DBInsert.create(string);
            dBInsert.getStatement().setInt(1, this.getRowId());
            dBInsert.getStatement().setString(2, this.getFileName());
            dBInsert.getStatement().setString(3, this.getContentType());
            dBInsert.getStatement().setLong(4, this.getSize());
            dBInsert.getStatement().setString(5, this.getDescription());
            dBInsert.getStatement().setBinaryStream(6, inputStream);
            dBInsert.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAttachment(InputStream inputStream) throws Exception {
        String string = "update " + this.getAttachmentTable() + " set FileName=?,ContentType=?,Size=?,Description=?,Attachment=? Where AttachmentId=?";
        try (DBUpdate dBUpdate = null;){
            dBUpdate = DBUpdate.create(string);
            dBUpdate.getStatement().setString(1, this.getFileName());
            dBUpdate.getStatement().setString(2, this.getContentType());
            dBUpdate.getStatement().setLong(3, this.getSize());
            dBUpdate.getStatement().setString(4, this.getDescription());
            dBUpdate.getStatement().setBinaryStream(5, inputStream);
            dBUpdate.getStatement().setInt(6, this.getAttachmentId());
            dBUpdate.execute();
        }
    }

    public InputStream getBinaryStream() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select Attachment from ");
        stringBuilder.append(this.getAttachmentTable());
        stringBuilder.append(" where AttachmentId = ");
        stringBuilder.append(this.getAttachmentId());
        DBSelect dBSelect = DBSelect.create(stringBuilder.toString());
        return AttachmentStream.open(dBSelect);
    }

    public String toString() {
        return this.getFileName();
    }
}

