/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.binder;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.value.AbstractConverter;
import com.jgoodies.binding.value.ValueModel;
import commvault.cte.binder.Operator;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class ValueModelUtil {
    public static ValueModel createValueModel(ValueModel valueModel, Object object, Operator operator) {
        return new OparatorValueModel(valueModel, object, operator);
    }

    public static ValueModel createValueModel(Object object, String string) {
        return new PresentationModel(object).getModel(string);
    }

    private static class OparatorValueModel
    extends AbstractConverter {
        private Object value;
        private Operator op;

        public OparatorValueModel(ValueModel valueModel, Object object, Operator operator) {
            super(valueModel);
            this.op = operator;
            this.value = object;
        }

        public Object convertFromSubject(Object object) {
            if (object == null) {
                return false;
            }
            if (this.op == Operator.EQUAL) {
                return object.equals(this.value);
            }
            if (this.op == Operator.NOT_EQUAL) {
                return !object.equals(this.value);
            }
            if (this.op == Operator.LESS_THAN) {
                return ((Number)object).doubleValue() < ((Number)this.value).doubleValue();
            }
            if (this.op == Operator.LESS_THAN_EQUAL) {
                return ((Number)object).doubleValue() <= ((Number)this.value).doubleValue();
            }
            if (this.op == Operator.GREATER_THAN) {
                return ((Number)object).doubleValue() > ((Number)this.value).doubleValue();
            }
            if (this.op == Operator.GREATER_THAN_EQUAL) {
                return ((Number)object).doubleValue() >= ((Number)this.value).doubleValue();
            }
            return null;
        }

        public void setValue(Object object) {
            if (this.op == Operator.EQUAL && object != null && ((Boolean)object).booleanValue()) {
                this.subject.setValue(this.value);
            }
        }
    }

    public static class ArrayListConverter
    extends AbstractConverter {
        public ArrayListConverter(ValueModel valueModel) {
            super(valueModel);
        }

        public Object convertFromSubject(Object object) {
            if (!(object instanceof ArrayList)) {
                return null;
            }
            ArrayList arrayList = (ArrayList)object;
            if (arrayList == null || arrayList.size() == 0) {
                return "";
            }
            return arrayList.get(0);
        }

        public void setValue(Object object) {
            if (object == null) {
                this.subject.setValue(null);
            }
            this.subject.setValue(object);
        }
    }

    public static class ByteArrayConverter
    extends AbstractConverter {
        public ByteArrayConverter(ValueModel valueModel) {
            super(valueModel);
        }

        public Object convertFromSubject(Object object) {
            byte[] byArray = (byte[])object;
            if (byArray == null) {
                return new String();
            }
            return new String(byArray, StandardCharsets.UTF_8);
        }

        public void setValue(Object object) {
            if (object == null) {
                this.subject.setValue(null);
            }
            this.subject.setValue((Object)object.toString().getBytes(StandardCharsets.UTF_8));
        }
    }
}

