/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.alert;

import commvault.cte.CteStringBank;
import commvault.cte.alert.model.Alert;
import commvault.cte.component.CVComponentComboBox;
import commvault.cte.component.Utilities;
import commvault.cte.component.wizard.AbstractWizardPage;
import commvault.cte.component.wizard.WizardDialog;
import commvault.cte.net.IdIdNameItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.JTextComponent;

public class UserAndGroupSelectionPage
extends AbstractWizardPage
implements ListDataListener {
    private static final String prefix = "commvault.cte.component.wizard.UserAndGroupSelectionPage";
    public boolean initialized = false;
    private JCheckBox notifyOwners;
    boolean disablCBEvents = false;
    private CVComponentComboBox combo = null;
    JPanel tempPanel1 = new JPanel(new BorderLayout());
    JTabbedPane regularTabbedPane = new JTabbedPane();
    JPanel emailPanel;
    JPanel escalationemailPanel;
    boolean enableSSOForActionableAlerts;
    MultiInputAutoCompleteCombobox toUsers;
    MultiInputAutoCompleteCombobox ccUsers;
    MultiInputAutoCompleteCombobox bccUsers;
    MultiInputAutoCompleteCombobox toUsersE;
    MultiInputAutoCompleteCombobox ccUsersE;
    MultiInputAutoCompleteCombobox bccUsersE;
    JTextField senderDisplayName = new JTextField();
    JTextField senderEmailId = new JTextField();
    JLabel displayNameLbl = new JLabel(CteStringBank.Sender_Display_Name.getI18n());
    JLabel emailIdLbl = new JLabel(CteStringBank.Sender_Email_Id.getI18n());

    public UserAndGroupSelectionPage(WizardDialog wizardDialog, boolean bl) {
        super(wizardDialog);
        this.setTitle(CteStringBank.User3s4_and_User_Group3s4__Selection.getI18n());
        this.enableSSOForActionableAlerts = bl;
        this.createHelpLink();
    }

    public void initComponents() {
        this.componentPanel = new JPanel();
        this.componentPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(CteStringBank.Notification_Recipients.getI18n()));
        this.emailPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Alert alert = (Alert)this.getWizardController().getData();
        List list = alert.getAlertServerObject().loadUsersAndGroups();
        this.toUsers = new MultiInputAutoCompleteCombobox(list, alert.getToUsersList(1));
        this.ccUsers = new MultiInputAutoCompleteCombobox(list, alert.getCcUsersList(1));
        this.bccUsers = new MultiInputAutoCompleteCombobox(list, alert.getBccUsersList(1));
        JComboBox jComboBox = this.toUsers.getComboBox();
        JComboBox jComboBox2 = this.ccUsers.getComboBox();
        JComboBox jComboBox3 = this.bccUsers.getComboBox();
        this.emailPanel.add((Component)new JLabel(CteStringBank.Email_To.getI18n()), Utilities.getConstraints(gridBagConstraints, 0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15)));
        this.emailPanel.add((Component)jComboBox, Utilities.getConstraints(gridBagConstraints, 1, 9, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 0)));
        this.emailPanel.add((Component)new JLabel(CteStringBank.Email_CC.getI18n()), Utilities.getConstraints(gridBagConstraints, 0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15)));
        this.emailPanel.add((Component)jComboBox2, Utilities.getConstraints(gridBagConstraints, 1, 10, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 0)));
        this.emailPanel.add((Component)new JLabel(CteStringBank.Email_BCC.getI18n()), Utilities.getConstraints(gridBagConstraints, 0, 11, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15)));
        this.emailPanel.add((Component)jComboBox3, Utilities.getConstraints(gridBagConstraints, 1, 11, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 0)));
        this.emailPanel.add((Component)new JLabel("   "), Utilities.getConstraints(gridBagConstraints, 0, 12, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15)));
        this.emailPanel.add((Component)new JLabel("   "), Utilities.getConstraints(gridBagConstraints, 1, 12, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 0)));
        this.emailPanel.getComponent(3).setVisible(false);
        jPanel.add((Component)this.emailPanel, "North");
        this.toUsersE = new MultiInputAutoCompleteCombobox(list, alert.getToUsersList(2));
        this.ccUsersE = new MultiInputAutoCompleteCombobox(list, alert.getCcUsersList(2));
        this.bccUsersE = new MultiInputAutoCompleteCombobox(list, alert.getBccUsersList(2));
        JComboBox jComboBox4 = this.toUsersE.getComboBox();
        JComboBox jComboBox5 = this.ccUsersE.getComboBox();
        JComboBox jComboBox6 = this.bccUsersE.getComboBox();
        this.escalationemailPanel = new JPanel(new GridBagLayout());
        this.escalationemailPanel.add((Component)new JLabel(CteStringBank.Email_To.getI18n()), Utilities.getConstraints(gridBagConstraints, 0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15)));
        this.escalationemailPanel.add((Component)jComboBox4, Utilities.getConstraints(gridBagConstraints, 1, 9, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 0)));
        this.escalationemailPanel.add((Component)new JLabel(CteStringBank.Email_CC.getI18n()), Utilities.getConstraints(gridBagConstraints, 0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15)));
        this.escalationemailPanel.add((Component)jComboBox5, Utilities.getConstraints(gridBagConstraints, 1, 10, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 0)));
        this.escalationemailPanel.add((Component)new JLabel(CteStringBank.Email_BCC.getI18n()), Utilities.getConstraints(gridBagConstraints, 0, 11, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15)));
        this.escalationemailPanel.add((Component)jComboBox6, Utilities.getConstraints(gridBagConstraints, 1, 11, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 0)));
        this.escalationemailPanel.add((Component)new JLabel("   "), Utilities.getConstraints(gridBagConstraints, 0, 12, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15)));
        this.escalationemailPanel.add((Component)new JLabel("   "), Utilities.getConstraints(gridBagConstraints, 1, 12, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 0)));
        if (this.isEscaltedEmailSelected()) {
            this.setSenderDetails(this.escalationemailPanel);
        }
        if (this.isRegularEmailSelected()) {
            this.setSenderDetails(this.emailPanel);
        }
        this.senderEmailId.setText(alert.getSenderEmailId());
        this.senderDisplayName.setText(alert.getSenderDisplayName());
        this.tempPanel1.add((Component)this.escalationemailPanel, "North");
        this.regularTabbedPane.addTab(CteStringBank.regular.getI18n(), jPanel);
        this.tempPanel1.setBorder(BorderFactory.createTitledBorder(CteStringBank.Escalated_Notification_Recipients.getI18n()));
        this.regularTabbedPane.addTab(CteStringBank.escalation.getI18n(), this.tempPanel1);
        this.componentPanel.add((Component)this.regularTabbedPane, "Center");
        this.tempPanel1.setVisible(this.getAlertDetails().isEscalationSelected());
        this.regularTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (UserAndGroupSelectionPage.this.isRegularEmailSelected() && UserAndGroupSelectionPage.this.regularTabbedPane.getSelectedIndex() == 0) {
                    UserAndGroupSelectionPage.this.setSenderDetails(UserAndGroupSelectionPage.this.emailPanel);
                } else if (UserAndGroupSelectionPage.this.isEscaltedEmailSelected() && UserAndGroupSelectionPage.this.regularTabbedPane.getSelectedIndex() == 1) {
                    UserAndGroupSelectionPage.this.setSenderDetails(UserAndGroupSelectionPage.this.escalationemailPanel);
                }
            }
        });
        SwingUtilities.invokeLater(() -> {
            if (this.getAlertDetails().isEscalationSelected()) {
                if (this.componentPanel != null) {
                    this.componentPanel.invalidate();
                    this.componentPanel.revalidate();
                    this.componentPanel.repaint();
                }
                if (this.regularTabbedPane != null && this.regularTabbedPane.getComponentCount() > 1) {
                    this.regularTabbedPane.setSelectedIndex(1);
                    this.regularTabbedPane.setSelectedIndex(0);
                }
            }
        });
    }

    void setSenderDetails(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.add((Component)this.displayNameLbl, Utilities.getConstraints(gridBagConstraints, 0, 13, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15)));
        jPanel.add((Component)this.senderDisplayName, Utilities.getConstraints(gridBagConstraints, 1, 13, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 0)));
        jPanel.add((Component)this.emailIdLbl, Utilities.getConstraints(gridBagConstraints, 0, 14, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15)));
        jPanel.add((Component)this.senderEmailId, Utilities.getConstraints(gridBagConstraints, 1, 14, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 0)));
    }

    void setEmailComponents(boolean bl, boolean bl2) {
        this.emailPanel.getComponent(2).setVisible(bl);
        this.emailPanel.getComponent(3).setVisible(bl);
        this.emailPanel.getComponent(4).setVisible(bl);
        this.emailPanel.getComponent(5).setVisible(bl);
        this.escalationemailPanel.getComponent(2).setVisible(bl2);
        this.escalationemailPanel.getComponent(3).setVisible(bl2);
        this.escalationemailPanel.getComponent(4).setVisible(bl2);
        this.escalationemailPanel.getComponent(5).setVisible(bl2);
        if (bl2) {
            this.setSenderDetails(this.escalationemailPanel);
        }
        if (bl) {
            this.setSenderDetails(this.emailPanel);
        }
        this.displayNameLbl.setVisible(bl2 || bl);
        this.senderDisplayName.setVisible(bl2 || bl);
        this.senderEmailId.setVisible(bl2 || bl);
        this.emailIdLbl.setVisible(bl2 || bl);
    }

    @Override
    protected void addHeaderPanel() {
        Utilities.addRow((Container)this, null, (JComponent)this.headerPanel, true);
    }

    private void updateRegularAlertTabbs() {
        int n = this.regularTabbedPane.indexOfTab(CteStringBank.escalation.getI18n());
        if (n > 0) {
            this.regularTabbedPane.setEnabledAt(n, this.getAlertDetails().isEscalationSelected());
        }
    }

    private Alert getAlertDetails() {
        return (Alert)this.getWizardController().getData();
    }

    private void setEscalationPanelState() {
        this.emailPanel.setVisible(true);
        this.escalationemailPanel.setVisible(true);
        this.setEmailComponents(this.isRegularEmailSelected(), this.isEscaltedEmailSelected());
        this.updateRegularAlertTabbs();
    }

    @Override
    public void activated() {
        if (!this.initialized) {
            this.initComponents();
            this.addComponents();
            this.initialized = true;
        }
        this.setEscalationPanelState();
    }

    @Override
    public void deactivated() {
        this.getAlertDetails().setUserGroupList(new ArrayList());
        this.getAlertDetails().setUserList(new ArrayList<Alert.AlertUser>());
        this.getAlertDetails().setExternalGroupList(new ArrayList());
        this.getAlertDetails().setNonGalaxyUserList(new ArrayList<IdIdNameItem>());
        this.getAlertDetails().setNonGalaxyUserListCc(new ArrayList<IdIdNameItem>());
        this.getAlertDetails().setNonGalaxyUserListBcc(new ArrayList<IdIdNameItem>());
        this.getAlertDetails().setUserListTo(new ArrayList<IdIdNameItem>());
        this.getAlertDetails().setUserListCc(new ArrayList<IdIdNameItem>());
        this.getAlertDetails().setUserListBcc(new ArrayList<IdIdNameItem>());
        this.getAlertDetails().setUserGroupList(new ArrayList());
        this.getAlertDetails().setUserGroupListCc(new ArrayList<IdIdNameItem>());
        this.getAlertDetails().setUserGroupListBcc(new ArrayList<IdIdNameItem>());
        this.getAlertDetails().setExternalUserGroupListCc(new ArrayList<IdIdNameItem>());
        this.getAlertDetails().setExternalUserGroupListBcc(new ArrayList<IdIdNameItem>());
        if (this.isRegularEmailSelected() || this.isActiveAlertSelected()) {
            this.setSelectedUsersinAlert(1);
        }
        if (this.getAlertDetails().isEscalationSelected() && (this.isEscaltedEmailSelected() || this.isEscaltedActiveAlertSelected())) {
            this.setSelectedUsersinAlert(2);
        }
        if (this.toUsers.isSelectionChanged() || this.ccUsers.isSelectionChanged() || this.bccUsers.isSelectionChanged() || this.toUsersE.isSelectionChanged() || this.ccUsersE.isSelectionChanged() || this.bccUsersE.isSelectionChanged()) {
            this.getAlertDetails().setModificationBit(2);
            this.getAlertDetails().setModificationBit(4);
        }
        this.getAlertDetails().setSenderDisplayName(this.senderDisplayName.getText());
        this.getAlertDetails().setSenderEmailId(this.senderEmailId.getText());
    }

    void setSelectedUsersinAlert(int n) {
        Object object2;
        List<IdIdNameItem> list;
        List<IdIdNameItem> list2 = list = n == 1 ? this.toUsers.getSelectedUsersAndGroups() : this.toUsersE.getSelectedUsersAndGroups();
        if (!this.canSkip() && this.wizard.getActionPerformed() != 1 && list.size() < 1) {
            if (n == 1) {
                throw new IllegalStateException(CteStringBank.Please_add_valid_recipients.getI18n());
            }
            throw new IllegalStateException(CteStringBank.Please_add_valid_recipients_for_Escalated_notification.getI18n());
        }
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            object2 = list.get(i);
            if (((IdIdNameItem)object2).getSecondId() == 1 || ((IdIdNameItem)object2).getSecondId() == 3) {
                this.getAlertDetails().getUserListTo().add(new IdIdNameItem(((IdIdNameItem)object2).getFirstId(), n, ((IdIdNameItem)object2).getName()));
                continue;
            }
            if (((IdIdNameItem)object2).getSecondId() == 2) {
                this.getAlertDetails().getUserGroupList().add(new IdIdNameItem(((IdIdNameItem)object2).getFirstId(), n, ((IdIdNameItem)object2).getName()));
                continue;
            }
            if (((IdIdNameItem)object2).getSecondId() == 4) {
                this.getAlertDetails().getExternalGroupList().add(new IdIdNameItem(((IdIdNameItem)object2).getFirstId(), n, ((IdIdNameItem)object2).getName()));
                continue;
            }
            if (((IdIdNameItem)object2).getSecondId() != 5) continue;
            this.getAlertDetails().getNonGalaxyUserList().add(new IdIdNameItem(((IdIdNameItem)object2).getFirstId(), n, ((IdIdNameItem)object2).getName()));
            ++n2;
        }
        List<IdIdNameItem> list3 = n == 1 ? this.ccUsers.getSelectedUsersAndGroups() : this.ccUsersE.getSelectedUsersAndGroups();
        for (IdIdNameItem object3 : list3) {
            if (object3.getSecondId() == 1 || object3.getSecondId() == 3) {
                this.getAlertDetails().getUserListCc().add(new IdIdNameItem(object3.getFirstId(), n, object3.getName()));
                continue;
            }
            if (object3.getSecondId() == 2) {
                this.getAlertDetails().getUserGroupListCc().add(new IdIdNameItem(object3.getFirstId(), n, object3.getName()));
                continue;
            }
            if (object3.getSecondId() == 4) {
                this.getAlertDetails().getExternalUserGroupListCc().add(new IdIdNameItem(object3.getFirstId(), n, object3.getName()));
                continue;
            }
            if (object3.getSecondId() != 5) continue;
            this.getAlertDetails().getNonGalaxyUserListCc().add(new IdIdNameItem(object3.getFirstId(), n, object3.getName()));
        }
        object2 = n == 1 ? this.bccUsers.getSelectedUsersAndGroups() : this.bccUsersE.getSelectedUsersAndGroups();
        Iterator<IdIdNameItem> iterator = object2.iterator();
        while (iterator.hasNext()) {
            IdIdNameItem idIdNameItem = iterator.next();
            if (idIdNameItem.getSecondId() == 1 || idIdNameItem.getSecondId() == 3) {
                this.getAlertDetails().getUserListBcc().add(new IdIdNameItem(idIdNameItem.getFirstId(), n, idIdNameItem.getName()));
                continue;
            }
            if (idIdNameItem.getSecondId() == 2) {
                this.getAlertDetails().getUserGroupListBcc().add(new IdIdNameItem(idIdNameItem.getFirstId(), n, idIdNameItem.getName()));
                continue;
            }
            if (idIdNameItem.getSecondId() == 4) {
                this.getAlertDetails().getExternalUserGroupListBcc().add(new IdIdNameItem(idIdNameItem.getFirstId(), n, idIdNameItem.getName()));
                continue;
            }
            if (idIdNameItem.getSecondId() != 5) continue;
            this.getAlertDetails().getNonGalaxyUserListBcc().add(new IdIdNameItem(idIdNameItem.getFirstId(), n, idIdNameItem.getName()));
        }
        if (this.enableSSOForActionableAlerts && !this.canSkip() && this.wizard.getActionPerformed() != 1 && (this.isActionRegularEmailSelected() && n == 1 || this.isActionEscalatedEmailSelected() && n == 2) && (object2.size() > 0 || list3.size() > 0 || n2 > 0)) {
            Utilities.showInfoMessage(CteStringBank.SSO_Not_Applicable_Message.getI18n(), CteStringBank.SSO_Not_Applicable.getI18n());
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    private boolean isActionRegularEmailSelected() {
        int n = this.getAlertDetails().getAlertDetails().getNotifType();
        return (n & 0x40000) != 0;
    }

    private boolean isActionEscalatedEmailSelected() {
        int n = this.getAlertDetails().getAlertDetails().getEscNotifType();
        return (n & 0x40000) != 0;
    }

    private boolean isActiveAlertSelected() {
        int n = this.getAlertDetails().getAlertDetails().getNotifType();
        return (n & 0x2000) != 0;
    }

    private boolean isRegularEmailSelected() {
        int n = this.getAlertDetails().getAlertDetails().getNotifType();
        return (n & 1) != 0;
    }

    private boolean isEscaltedEmailSelected() {
        int n = this.getAlertDetails().getAlertDetails().getEscNotifType();
        return (n & 1) != 0;
    }

    private boolean isEscaltedActiveAlertSelected() {
        int n = this.getAlertDetails().getAlertDetails().getEscNotifType();
        return (n & 0x2000) != 0;
    }

    @Override
    public boolean canSkip() {
        return !this.isRegularEmailSelected() && !this.isEscaltedEmailSelected() && !this.isActiveAlertSelected() && !this.isEscaltedActiveAlertSelected() || (((Alert)this.getWizardController().getData()).getAlertDetails().getStatus() & 0x80) > 0 || this.getAlertDetails().getIsCustomRecipientColumnSupported();
    }

    private void createHelpLink() {
        String string = "main-nt";
        String string2 = "english-en-us-" + string + "-NO_TOCHEADINGS.txt-AlertWizard(UsersandUserGroupsSelection)";
        this.setHelpLink(string2);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    @Override
    public boolean checkValid() {
        return true;
    }

    private class MultiInputAutoCompleteCombobox {
        private MultiInputComboBox2 cb;
        private JTextComponent tc;
        private boolean disableEvents = false;
        private boolean disableKeyEvents = false;
        private DefaultComboBoxModel cbModel;
        private String newValue = "";
        private String oldValue = "";
        private Set<IdIdNameItem> selectedUserAndGroup = new HashSet<IdIdNameItem>();
        boolean selectionChanged = false;

        public MultiInputAutoCompleteCombobox(List<IdIdNameItem> list, List<IdIdNameItem> list2) {
            DefaultComboBoxModel<Object> defaultComboBoxModel;
            this.cb = new MultiInputComboBox2();
            this.cb.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            Collections.sort(list, (idIdNameItem, idIdNameItem2) -> idIdNameItem.getName().compareToIgnoreCase(idIdNameItem2.getName()));
            this.cbModel = defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
            this.tc = (JTextComponent)this.cb.getEditor().getEditorComponent();
            for (IdIdNameItem idIdNameItem3 : list2) {
                this.oldValue = this.oldValue + idIdNameItem3.getName() + ';';
                this.selectedUserAndGroup.add(idIdNameItem3);
            }
            this.init();
        }

        boolean isSelectionChanged() {
            return this.selectionChanged;
        }

        void setSelectedItem(String string) {
            this.disableEvents = true;
            this.cb.setSelectedItem(string);
            this.disableEvents = false;
            this.selectionChanged = true;
        }

        public boolean isUserSelected() {
            return this.tc.getText().length() > 0;
        }

        void init() {
            this.cb.setEditable(true);
            this.cb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1 && !MultiInputAutoCompleteCombobox.this.disableEvents && MultiInputAutoCompleteCombobox.this.cb.getSelectedIndex() >= 0) {
                        int n = -1;
                        n = MultiInputAutoCompleteCombobox.this.oldValue.lastIndexOf(59);
                        if (n >= 0 && n != MultiInputAutoCompleteCombobox.this.oldValue.length()) {
                            MultiInputAutoCompleteCombobox.this.oldValue = MultiInputAutoCompleteCombobox.this.oldValue.substring(0, n + 1);
                        } else if (n == -1) {
                            MultiInputAutoCompleteCombobox.this.oldValue = "";
                        }
                        MultiInputAutoCompleteCombobox.this.newValue = MultiInputAutoCompleteCombobox.this.oldValue + (MultiInputAutoCompleteCombobox.this.cb.getSelectedIndex() > 0 ? MultiInputAutoCompleteCombobox.this.cb.getSelectedItem().toString() + ";" : "");
                        if (MultiInputAutoCompleteCombobox.this.cb.getSelectedItem() instanceof IdIdNameItem) {
                            MultiInputAutoCompleteCombobox.this.selectedUserAndGroup.add((IdIdNameItem)MultiInputAutoCompleteCombobox.this.cb.getSelectedItem());
                        }
                        MultiInputAutoCompleteCombobox.this.setSelectedItem(MultiInputAutoCompleteCombobox.this.newValue);
                        MultiInputAutoCompleteCombobox.this.oldValue = MultiInputAutoCompleteCombobox.this.newValue;
                        MultiInputAutoCompleteCombobox.this.updateList("", false);
                        MultiInputAutoCompleteCombobox.this.cb.setPopupVisible(false);
                    }
                }
            });
            this.tc.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    if (!MultiInputAutoCompleteCombobox.this.disableEvents && !MultiInputAutoCompleteCombobox.this.disableKeyEvents && MultiInputAutoCompleteCombobox.this.cb.getSelectedIndex() < 0) {
                        MultiInputAutoCompleteCombobox.this.newValue = MultiInputAutoCompleteCombobox.this.tc.getText();
                        MultiInputAutoCompleteCombobox.this.setSelectedItem(MultiInputAutoCompleteCombobox.this.newValue);
                        if (!MultiInputAutoCompleteCombobox.this.newValue.equals(MultiInputAutoCompleteCombobox.this.oldValue)) {
                            int n = MultiInputAutoCompleteCombobox.this.newValue.lastIndexOf(59);
                            String string = "";
                            if (MultiInputAutoCompleteCombobox.this.newValue.length() > n) {
                                string = MultiInputAutoCompleteCombobox.this.newValue.substring(n >= 0 ? n + 1 : 0);
                            }
                            MultiInputAutoCompleteCombobox.this.updateList(string, true);
                            MultiInputAutoCompleteCombobox.this.cb.showPopup();
                        }
                        MultiInputAutoCompleteCombobox.this.oldValue = MultiInputAutoCompleteCombobox.this.newValue;
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    if (!MultiInputAutoCompleteCombobox.this.disableEvents && !MultiInputAutoCompleteCombobox.this.disableKeyEvents && MultiInputAutoCompleteCombobox.this.cb.getSelectedIndex() < 0) {
                        MultiInputAutoCompleteCombobox.this.newValue = MultiInputAutoCompleteCombobox.this.tc.getText();
                        MultiInputAutoCompleteCombobox.this.setSelectedItem(MultiInputAutoCompleteCombobox.this.newValue);
                        if (MultiInputAutoCompleteCombobox.this.newValue.isEmpty()) {
                            MultiInputAutoCompleteCombobox.this.selectedUserAndGroup.clear();
                        }
                        if (!MultiInputAutoCompleteCombobox.this.newValue.equals(MultiInputAutoCompleteCombobox.this.oldValue)) {
                            int n = MultiInputAutoCompleteCombobox.this.newValue.lastIndexOf(59);
                            String string = "";
                            if (MultiInputAutoCompleteCombobox.this.newValue.length() > n && MultiInputAutoCompleteCombobox.this.tc.getCaretPosition() > n) {
                                string = MultiInputAutoCompleteCombobox.this.newValue.substring(n >= 0 ? n + 1 : 0);
                                MultiInputAutoCompleteCombobox.this.updateList(string, true);
                                MultiInputAutoCompleteCombobox.this.cb.showPopup();
                            }
                        }
                        MultiInputAutoCompleteCombobox.this.oldValue = MultiInputAutoCompleteCombobox.this.newValue;
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                }
            });
            this.cb.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                    IdIdNameItem idIdNameItem;
                    if (object instanceof JComponent) {
                        return (JComponent)object;
                    }
                    boolean bl3 = false;
                    if (object instanceof IdIdNameItem && ((idIdNameItem = (IdIdNameItem)object).getSecondId() == 2 || idIdNameItem.getSecondId() == 4)) {
                        bl3 = true;
                    }
                    super.getListCellRendererComponent(jList, object, n, bl, bl2);
                    if (bl3) {
                        this.setFont(this.getFont().deriveFont(1));
                    }
                    return this;
                }
            });
            this.updateList("", false);
            this.cb.setSelectedItem(this.oldValue);
        }

        void updateList(final String string, final boolean bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MultiInputAutoCompleteCombobox.this.disableEvents = true;
                    ArrayList arrayList = new ArrayList();
                    MultiInputAutoCompleteCombobox.this.cb.removeAllItems();
                    MultiInputAutoCompleteCombobox.this.cb.setPopupVisible(false);
                    MultiInputAutoCompleteCombobox.this.cb.addItem(" ");
                    if (string.length() == 0) {
                        for (int i = 0; i < MultiInputAutoCompleteCombobox.this.cbModel.getSize(); ++i) {
                            MultiInputAutoCompleteCombobox.this.cb.addItem(MultiInputAutoCompleteCombobox.this.cbModel.getElementAt(i));
                        }
                    } else {
                        for (int i = 0; i < MultiInputAutoCompleteCombobox.this.cbModel.getSize(); ++i) {
                            IdIdNameItem idIdNameItem = (IdIdNameItem)MultiInputAutoCompleteCombobox.this.cbModel.getElementAt(i);
                            if (!idIdNameItem.getName().toLowerCase().contains(string.toLowerCase())) continue;
                            MultiInputAutoCompleteCombobox.this.cb.addItem(idIdNameItem);
                        }
                    }
                    MultiInputAutoCompleteCombobox.this.setSelectedItem(MultiInputAutoCompleteCombobox.this.oldValue);
                    MultiInputAutoCompleteCombobox.this.disableEvents = false;
                    MultiInputAutoCompleteCombobox.this.cb.setPopupVisible(bl);
                }
            });
        }

        JComboBox getComboBox() {
            return this.cb;
        }

        List<IdIdNameItem> getSelectedUsersAndGroups() {
            Object object;
            Object object22;
            ArrayList<IdIdNameItem> arrayList = new ArrayList<IdIdNameItem>();
            HashSet<String> hashSet = new HashSet<String>();
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            HashMap<String, IdIdNameItem> hashMap2 = new HashMap<String, IdIdNameItem>();
            for (int i = 0; i < this.cbModel.getSize(); ++i) {
                if (hashMap2.containsKey(this.cbModel.getElementAt(i).toString())) continue;
                hashMap2.put(this.cbModel.getElementAt(i).toString(), (IdIdNameItem)this.cbModel.getElementAt(i));
            }
            Iterator<IdIdNameItem> iterator = this.selectedUserAndGroup.iterator();
            for (int i = 0; i < this.selectedUserAndGroup.size(); ++i) {
                hashSet.add(iterator.next().getName());
            }
            String[] stringArray = this.oldValue.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                object22 = hashMap.get(stringArray[i]);
                hashMap.put(stringArray[i], object22 == null ? 1 : (Integer)object22 + 1);
            }
            Iterator<IdIdNameItem> iterator2 = this.selectedUserAndGroup.iterator();
            while (iterator2.hasNext()) {
                object22 = iterator2.next();
                object = hashMap.get(((IdIdNameItem)object22).getName());
                if (object == null) continue;
                arrayList.add((IdIdNameItem)object22);
                if ((Integer)object == 1) {
                    hashMap.remove(((IdIdNameItem)object22).getName());
                } else {
                    hashMap.put(((IdIdNameItem)object22).getName(), (Integer)object - 1);
                }
                iterator2.remove();
            }
            for (Object object22 : hashMap.keySet()) {
                object = (IdIdNameItem)hashMap2.get(object22);
                if (object != null && !arrayList.contains(object)) {
                    arrayList.add((IdIdNameItem)object);
                    continue;
                }
                if (!this.isValidEmail((String)object22)) continue;
                IdIdNameItem idIdNameItem = new IdIdNameItem(0, 5, (String)object22);
                arrayList.add(idIdNameItem);
            }
            return arrayList;
        }

        boolean isValidEmail(String string) {
            boolean bl = true;
            try {
                InternetAddress internetAddress = new InternetAddress(string);
                internetAddress.validate();
            }
            catch (AddressException addressException) {
                bl = false;
            }
            return bl;
        }

        class MultiInputComboBox2
        extends JComboBox {
            public MultiInputComboBox2() {
                MyComboBoxEditor myComboBoxEditor = new MyComboBoxEditor();
                this.setEditor(new MyComboBoxEditor());
            }
        }

        class MyComponent
        extends JTextField {
            MyComponent() {
            }

            @Override
            public void processKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    MultiInputAutoCompleteCombobox.this.disableKeyEvents = true;
                    super.processKeyEvent(keyEvent);
                    MultiInputAutoCompleteCombobox.this.disableKeyEvents = false;
                } else {
                    super.processKeyEvent(keyEvent);
                }
            }
        }

        class MyComboBoxEditor
        extends BasicComboBoxEditor {
            public MyComboBoxEditor() {
                this.editor = new MyComponent();
            }
        }
    }
}

