/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.alert;

import commvault.cte.CteStringBank;
import commvault.cte.alert.AbstractAlertCritPanel;
import commvault.cte.alert.model.Alert;
import commvault.cte.alert.model.AlertCriteria;
import commvault.cte.alert.model.AlertListItem;
import commvault.cte.alert.model.ICriteria;
import commvault.cte.alert.model.ReportingCriteria;
import commvault.cte.common.ui.HourMinComponent;
import commvault.cte.component.JNumericTextField;
import commvault.cte.component.JSLabel;
import commvault.cte.component.NumericDocument;
import commvault.cte.component.TogglePanel;
import commvault.cte.component.Utilities;
import commvault.cte.component.events.CTEAction;
import commvault.cte.component.wizard.AbstractWizardPage;
import commvault.cte.component.wizard.WizardDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class AlertNotifCriteriaPage
extends AbstractWizardPage {
    private static final String ALERT_CRITERIA = CteStringBank.Alert_Criteria3s4_7.getI18n();
    private static final String prefix = "commvault.cte.component.AlertNotifCriteriaPage";
    private static final String ESCALATE_NOTIFICATION_CRITERIA = CteStringBank.Escalate_Notification_Criteria.getI18n();
    boolean jobFailedAndSucceeded;
    boolean regularNotifSelected;
    private Integer reportId;
    public static final String NOTIF_CRITERIA = CteStringBank.Notification_Criteria.getI18n();
    protected boolean isGalaxyGUI = true;
    int category = -1;
    int type = -1;
    ReportingCriteriaPanel reportingCriteriaPanel = null;
    ReportingCriteriaPanel escalationCriteriaPanel = null;
    AbstractAlertCritPanel alertCriteriaPanel = null;
    protected JCheckBox indvidualMessagesCh = new JCheckBox(CteStringBank.Send_individual_notification_for_this_alert.getI18n());
    protected JCheckBox discoveredVirtualMachineCh = new JCheckBox(CteStringBank.Send_individual_notification_for_each_backed_up_discovered_virtual_machine.getI18n());

    public AlertNotifCriteriaPage(WizardDialog wizardDialog) {
        super(wizardDialog);
        this.setTitle(CteStringBank.Threshold_and_Notification__Criteria_Selection.getI18n());
        this.createHelpLink();
    }

    protected void initComponents() {
        Object object;
        boolean bl;
        this.componentPanel = new JPanel();
        this.componentPanel.setLayout(new GridBagLayout());
        System.err.println(this.category + ", " + this.type);
        this.reportingCriteriaPanel = new ReportingCriteriaPanel(1);
        this.escalationCriteriaPanel = new ReportingCriteriaPanel(2);
        boolean bl2 = false;
        if (this.getAlertDetails().getAlertType().getAlertTypeId() == 65) {
            bl2 = this.getAlertDetails().getAlertDetails().getPrimaryKey();
            if (bl2) {
                this.reportingCriteriaPanel.initComponents();
                this.escalationCriteriaPanel.initComponents();
            } else {
                this.reportingCriteriaPanel.reportCustomQueryCheckBox.setSelected(true);
            }
        } else {
            this.reportingCriteriaPanel.initComponents();
            this.escalationCriteriaPanel.initComponents();
        }
        int n = this.getAlertDetails().getAllPossibleReporingOption(1);
        boolean bl3 = bl = n != 0 && n != 1;
        if (this.category == 7) {
            object = this.getAlertDetails().getCriteria();
            AlertCriteria alertCriteria = (AlertCriteria)object.get(0);
            String string = alertCriteria.getAlertValue();
            this.alertCriteriaPanel = this.getAlertDetails().getAlertServerObject().getSrmRepPanel(this.type, alertCriteria.getReportId(), string);
            this.alertCriteriaPanel.setReport(this.reportId);
        } else {
            this.alertCriteriaPanel = new AlertCriteriaPanel();
        }
        this.alertCriteriaPanel.setAlertNotifCriteriaPage(this);
        object = Utilities.fillRemainingConstr();
        ((GridBagConstraints)object).insets.bottom = 1;
        this.componentPanel.add((Component)this.alertCriteriaPanel, object);
        this.alertCriteriaPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), ALERT_CRITERIA));
        if (bl2) {
            Utilities.addRow((Container)this.componentPanel, (JComponent)this.indvidualMessagesCh, true);
        } else if (this.getAlertDetails().getAlertDetails().getAlertType().getId() == 3 || this.getAlertDetails().getAlertDetails().getAlertType().getId() == 4) {
            Utilities.addRow((Container)this.componentPanel, (JComponent)this.indvidualMessagesCh, true);
            if (this.getAlertDetails().getAlertDetails().getAlertType().getId() == 4) {
                this.discoveredVirtualMachineCh.setText(CteStringBank.Send_individual_notification_for_each_restored_discovered_virtual_machine.getI18n());
            }
            Utilities.addRow((Container)this.componentPanel, (JComponent)this.discoveredVirtualMachineCh, true);
        }
        if (bl) {
            Utilities.addRow((Container)this.componentPanel, null, (JComponent)this.reportingCriteriaPanel, true);
            if (this.getAlertDetails().isEscalationSupported()) {
                Utilities.addRow((Container)this.componentPanel, null, (JComponent)this.escalationCriteriaPanel, true);
            }
        }
    }

    public void updateWizardButtonState() {
        this.fireStateChanged();
    }

    private Alert getAlertDetails() {
        return (Alert)this.getWizardController().getData();
    }

    @Override
    public void activated() {
        AlertListItem alertListItem = this.getAlertDetails().getAlertDetails();
        int n = alertListItem.getAlertCategory().getId();
        int n2 = alertListItem.getAlertType().getId();
        if (this.category == -1 || this.type == -1 || this.category != n || this.type != n2) {
            this.category = n;
            this.type = n2;
            this.remove(this.componentPanel);
            this.initComponents();
            this.addComponents();
            SwingUtilities.updateComponentTreeUI(this);
        }
    }

    @Override
    public void deactivated() {
        this.alertCriteriaPanel.fillRequestObject(this.getAlertDetails());
        this.reportingCriteriaPanel.fillRequestObject(this.getAlertDetails());
        if (this.escalationCriteriaPanel != null && this.getAlertDetails().isEscalationSupported()) {
            this.escalationCriteriaPanel.fillRequestObject(this.getAlertDetails());
        }
        int n = this.getAlertDetails().getAlertDetails().getStatus();
        n |= 0x10;
        n |= 0x400;
        if (!this.indvidualMessagesCh.isSelected()) {
            n ^= 0x10;
        }
        if (!this.discoveredVirtualMachineCh.isSelected()) {
            n ^= 0x400;
        }
        this.getAlertDetails().getAlertDetails().setStatus(n);
    }

    @Override
    public boolean checkValid() {
        if (this.alertCriteriaPanel != null && this.reportingCriteriaPanel != null) {
            return this.alertCriteriaPanel.checkValid() && this.reportingCriteriaPanel.checkValid();
        }
        return true;
    }

    private void createHelpLink() {
        String string = "main-nt";
        String string2 = "english-en-us-" + string + "-NO_TOCHEADINGS.txt-AlertWizard(ThresholdandNotificationCriteriaSelection)";
        this.setHelpLink(string2);
    }

    public boolean isJobFailedAndSucceeded() {
        return this.jobFailedAndSucceeded;
    }

    public void setJobFailedAndSucceeded(boolean bl) {
        this.jobFailedAndSucceeded = bl;
    }

    public boolean isRegularNotifSelected() {
        return this.regularNotifSelected;
    }

    public void setRegularNotifSelected(boolean bl) {
        this.regularNotifSelected = bl;
    }

    public AbstractAlertCritPanel getAlertCriteriaPanel() {
        return this.alertCriteriaPanel;
    }

    public Integer getReportId() {
        return this.reportId;
    }

    public void setReportId(Integer n) {
        this.reportId = n;
    }

    public ReportingCriteriaPanel getReportingCriteriaPanel() {
        return this.reportingCriteriaPanel;
    }

    public class ReportingCriteriaPanel
    extends JPanel
    implements ActionListener {
        private JRadioButton immediateNotifButton = new JRadioButton(CteStringBank.Immediate_Notification.getI18n(), true);
        private JCheckBox extRetentionNotifButton = new JCheckBox(CteStringBank.Notify_if_job_has_extended_retention.getI18n());
        private JCheckBox failedFilesNotifButton = new JCheckBox(CteStringBank.Notify_only_when_job_contains_failed_objects.getI18n());
        private JRadioButton laterNotifButton = new JRadioButton(CteStringBank.If_the_condition_persists_for.getI18n());
        private JCheckBox recurNotifCheckBox = new JCheckBox(CteStringBank.Repeat_notification_every.getI18n());
        private JCheckBox jobCountThresholdCheckBox = new JCheckBox(CteStringBank.Notify_When_Job_Count_Is_More_Than.getI18n());
        private JNumericTextField jobCountThresholdValue = new JNumericTextField();
        private JCheckBox persistNotifCheckBox = new JCheckBox(CteStringBank.Notify_only_if_Condition_persists_for.getI18n());
        private JCheckBox clearNotifCheckBox = new JCheckBox(CteStringBank.Notify_when_the_condition_clears.getI18n());
        private JCheckBox reportCustomQueryCheckBox = new JCheckBox(CteStringBank.Notify_when_the_current_results.getI18n());
        private JCheckBox lmConditionalEntryNotifCB = new JCheckBox(CteStringBank.Notify_after_enty_matches_criteria_greater_than.getI18n());
        HourMinComponent lmConditionalEntryNotifHourPeriod = null;
        private JTextField lmConditionalEntryTF = new JTextField(5);
        HourMinComponent initNotifHourPeriod = null;
        HourMinComponent recurNotifHourPeriod = null;
        HourMinComponent persistNotifHourPeriod = null;
        private int category = 1;
        private JCheckBox reportingCh;
        private JCheckBox ddbJobNotifButton = new JCheckBox(CteStringBank.Notify_DDB_Job.getI18n());
        private JCheckBox eventCheckBox = new JCheckBox(CteStringBank.Match_using_event_description.getI18n());

        public ReportingCriteriaPanel(int n) {
            this.setLayout(new GridBagLayout());
            this.category = n;
        }

        public void initComponents() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            if (this.category == 1) {
                jPanel.setBorder(BorderFactory.createTitledBorder(CteStringBank.Notification_Criteria.getI18n()));
            } else {
                this.reportingCh = new JCheckBox(new CTEAction(ESCALATE_NOTIFICATION_CRITERIA, this));
                jPanel = new TogglePanel(this.reportingCh);
                jPanel.setLayout(new GridBagLayout());
            }
            Utilities.fillRemaining(this, jPanel);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.immediateNotifButton);
            buttonGroup.add(this.laterNotifButton);
            this.recurNotifCheckBox.addActionListener(this);
            this.jobCountThresholdCheckBox.addActionListener(this);
            this.eventCheckBox.addActionListener(this);
            this.persistNotifCheckBox.addActionListener(this);
            this.clearNotifCheckBox.addActionListener(this);
            this.immediateNotifButton.addActionListener(this);
            this.laterNotifButton.addActionListener(this);
            this.reportCustomQueryCheckBox.addActionListener(this);
            int n = AlertNotifCriteriaPage.this.getAlertDetails().getAllPossibleReporingOption(this.category);
            if (this.isOptionSelected(n, 1) && this.isOptionSelected(n, 8)) {
                this.initNotifHourPeriod = new HourMinComponent(false, 15);
                Utilities.addRow((Container)jPanel, null, (JComponent)this.immediateNotifButton, true);
                Utilities.addRow((Container)jPanel, (JComponent)this.laterNotifButton, (JComponent)this.initNotifHourPeriod, true);
            } else if (this.isOptionSelected(n, 64) && this.isOptionSelected(n, 8)) {
                this.initNotifHourPeriod = new HourMinComponent(false, 15);
                TogglePanel togglePanel = new TogglePanel((JToggleButton)this.lmConditionalEntryNotifCB, BorderFactory.createEmptyBorder(0, 0, 0, 0));
                togglePanel.setLayout(new FlowLayout());
                togglePanel.add(this.lmConditionalEntryTF);
                togglePanel.add(new JSLabel(CteStringBank.times_every.getI18n()));
                togglePanel.add(this.initNotifHourPeriod);
                Utilities.addRow(jPanel, togglePanel);
                this.lmConditionalEntryNotifCB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AlertNotifCriteriaPage.this.fireStateChanged();
                    }
                });
                this.lmConditionalEntryTF.addKeyListener(new LmConditionalEntryKeyListener());
            } else if (this.isOptionSelected(n, 8)) {
                this.initNotifHourPeriod = new HourMinComponent(false, 15);
                this.laterNotifButton.setSelected(true);
                Utilities.addRow((Container)jPanel, (JComponent)new JLabel(CteStringBank.If_the_condition_persists_for.getI18n()), (JComponent)this.initNotifHourPeriod, true);
            } else {
                this.immediateNotifButton.setSelected(true);
            }
            if (this.isOptionSelected(n, 16)) {
                Utilities.addRow((Container)jPanel, null, (JComponent)this.extRetentionNotifButton, true);
            }
            if (this.isOptionSelected(n, 32)) {
                Utilities.addRow((Container)jPanel, null, (JComponent)this.failedFilesNotifButton, true);
            }
            if (this.isOptionSelected(n, 256)) {
                this.persistNotifHourPeriod = new HourMinComponent(false, 15);
                Utilities.addRow((Container)jPanel, (JComponent)this.persistNotifCheckBox, (JComponent)this.persistNotifHourPeriod, true);
            }
            if (this.isOptionSelected(n, 2)) {
                this.recurNotifHourPeriod = new HourMinComponent(false, 1);
                Utilities.addRow((Container)jPanel, (JComponent)this.recurNotifCheckBox, (JComponent)this.recurNotifHourPeriod, true);
                if (AlertNotifCriteriaPage.this.getAlertDetails().getAlertType().getAlertTypeId() == 58) {
                    this.recurNotifCheckBox.setText(CteStringBank.Suppress_notification_events.getI18n());
                    Utilities.addRow((Container)jPanel, null, (JComponent)this.eventCheckBox, true);
                }
            }
            if (this.isAnomalousRunTimeCriteriaApplicable()) {
                Utilities.addRow((Container)jPanel, (JComponent)this.jobCountThresholdCheckBox, (JComponent)this.jobCountThresholdValue, false);
            }
            if (this.isOptionSelected(n, 4)) {
                Utilities.addRow((Container)jPanel, null, (JComponent)this.clearNotifCheckBox, true);
            }
            if (this.isOptionSelected(n, 128)) {
                Utilities.addRow((Container)jPanel, null, (JComponent)this.ddbJobNotifButton, true);
            }
            this.checkAvailableOptions();
            this.initialiseSelection();
        }

        boolean isAnomalousRunTimeCriteriaSelected() {
            if (AlertNotifCriteriaPage.this.getAlertDetails().getAlertType().getAlertTypeId() == 75) {
                Iterator iterator = AlertNotifCriteriaPage.this.getAlertDetails().getCriteria().iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    AlertCriteria alertCriteria = (AlertCriteria)iterator.next();
                    ICriteria iCriteria = alertCriteria.getCriteria();
                    if (iCriteria.getCriterta().getId() != 94) continue;
                    return true;
                }
            }
            return false;
        }

        boolean isAnomalousRunTimeCriteriaApplicable() {
            return AlertNotifCriteriaPage.this.getAlertDetails().getAlertType().getAlertTypeId() == 75;
        }

        private void checkAvailableOptions() {
            int n = AlertNotifCriteriaPage.this.getAlertDetails().getAvailableReportingOption(this.category);
            if (n == 0 && this.reportingCh != null) {
                this.reportingCh.setSelected(false);
                this.reportingCh.setEnabled(false);
            } else if (this.reportingCh != null) {
                this.reportingCh.setEnabled(true);
            }
            if (this.reportingCh != null && !this.reportingCh.isSelected()) {
                n = 0;
            }
            this.immediateNotifButton.setEnabled(this.isOptionSelected(n, 1));
            this.laterNotifButton.setEnabled(this.isOptionSelected(n, 8));
            if (!this.isOptionSelected(n, 8)) {
                this.laterNotifButton.setSelected(this.isOptionSelected(n, 8));
            }
            this.persistNotifCheckBox.setEnabled(this.isOptionSelected(n, 256));
            if (!this.isOptionSelected(n, 256)) {
                this.persistNotifCheckBox.setSelected(this.isOptionSelected(n, 256));
            }
            if (this.persistNotifHourPeriod != null) {
                this.persistNotifHourPeriod.setEnabled(this.persistNotifCheckBox.isSelected());
            }
            this.reportCustomQueryCheckBox.setEnabled(this.isOptionSelected(n, 1024));
            if (!this.isOptionSelected(n, 1024)) {
                this.reportCustomQueryCheckBox.setSelected(this.isOptionSelected(n, 1024));
            }
            this.recurNotifCheckBox.setEnabled(this.isOptionSelected(n, 2));
            if (!this.isOptionSelected(n, 2)) {
                this.recurNotifCheckBox.setSelected(this.isOptionSelected(n, 2));
            }
            this.jobCountThresholdCheckBox.setEnabled(this.isAnomalousRunTimeCriteriaSelected() && this.recurNotifCheckBox.isEnabled() && this.recurNotifCheckBox.isSelected());
            this.jobCountThresholdValue.setEnabled(this.jobCountThresholdCheckBox.isEnabled() && this.jobCountThresholdCheckBox.isSelected());
            if (!this.jobCountThresholdCheckBox.isEnabled()) {
                this.jobCountThresholdCheckBox.setSelected(false);
            }
            if (this.recurNotifHourPeriod != null) {
                this.recurNotifHourPeriod.setEnabled(this.recurNotifCheckBox.isSelected());
            }
            if (this.recurNotifCheckBox.isSelected()) {
                this.eventCheckBox.setEnabled(true);
            } else {
                this.eventCheckBox.setEnabled(false);
                this.eventCheckBox.setSelected(false);
            }
            this.clearNotifCheckBox.setEnabled(this.isOptionSelected(n, 4));
            if (!this.isOptionSelected(n, 4)) {
                this.clearNotifCheckBox.setSelected(this.isOptionSelected(n, 4));
            }
        }

        private boolean isOptionSelected(int n, int n2) {
            return (n & n2) > 0;
        }

        private void initialiseSelection() {
            int n = AlertNotifCriteriaPage.this.getWizardController().getMode();
            if (n != 2) {
                return;
            }
            ReportingCriteria reportingCriteria = AlertNotifCriteriaPage.this.getAlertDetails().getReportingCriteria(this.category);
            int n2 = 0;
            if (reportingCriteria == null) {
                return;
            }
            n2 = reportingCriteria.getReportingOptions();
            if (this.reportingCh != null) {
                this.reportingCh.setSelected(AlertNotifCriteriaPage.this.getAlertDetails().isEscalationSelected());
            }
            this.immediateNotifButton.setSelected(this.isOptionSelected(n2, 1));
            this.laterNotifButton.setSelected(this.isOptionSelected(n2, 8));
            if (this.initNotifHourPeriod != null && this.laterNotifButton.isSelected()) {
                this.initNotifHourPeriod.setTime(reportingCriteria.getDelayTimeSeconds());
                this.initNotifHourPeriod.setEnabled(this.laterNotifButton.isSelected() && this.reportingCh != null && this.reportingCh.isSelected());
            }
            this.recurNotifCheckBox.setSelected(this.isOptionSelected(n2, 2));
            this.jobCountThresholdCheckBox.setEnabled(this.isAnomalousRunTimeCriteriaSelected() && this.recurNotifCheckBox.isEnabled() && this.recurNotifCheckBox.isSelected());
            this.jobCountThresholdCheckBox.setSelected(AlertNotifCriteriaPage.this.getAlertDetails().getMinJobCountForJobAnomaly() > 0);
            this.jobCountThresholdValue.setEnabled(this.jobCountThresholdCheckBox.isSelected());
            if (this.jobCountThresholdValue.isEnabled()) {
                this.jobCountThresholdValue.setIntValue(AlertNotifCriteriaPage.this.getAlertDetails().getMinJobCountForJobAnomaly());
            }
            this.persistNotifCheckBox.setSelected(this.isOptionSelected(n2, 256));
            this.reportCustomQueryCheckBox.setSelected(this.isOptionSelected(n2, 1024));
            this.extRetentionNotifButton.setSelected(this.isOptionSelected(n2, 16));
            this.failedFilesNotifButton.setSelected(this.isOptionSelected(n2, 32));
            this.ddbJobNotifButton.setSelected(this.isOptionSelected(n2, 128));
            if (this.persistNotifHourPeriod != null) {
                if (this.persistNotifCheckBox.isSelected()) {
                    this.persistNotifHourPeriod.setTime(reportingCriteria.getDelayTimeSeconds());
                }
                this.persistNotifHourPeriod.setEnabled(this.persistNotifCheckBox.isSelected());
            }
            if (this.recurNotifHourPeriod != null) {
                if (this.recurNotifCheckBox.isSelected()) {
                    this.recurNotifHourPeriod.setTime(reportingCriteria.getPersistTimeSeconds());
                }
                this.recurNotifHourPeriod.setEnabled(this.recurNotifCheckBox.isSelected());
            }
            this.clearNotifCheckBox.setSelected(this.isOptionSelected(n2, 4));
            this.lmConditionalEntryNotifCB.setSelected(this.isOptionSelected(n2, 64));
            if (this.initNotifHourPeriod != null && this.lmConditionalEntryNotifCB.isSelected()) {
                this.initNotifHourPeriod.setTime(reportingCriteria.getDelayTimeSeconds());
                this.lmConditionalEntryTF.setText(String.valueOf(reportingCriteria.getPersistTimeSeconds()));
            }
            if (this.recurNotifCheckBox.isSelected()) {
                this.eventCheckBox.setEnabled(true);
                if (AlertNotifCriteriaPage.this.getAlertDetails().getEventParams() == 1) {
                    this.eventCheckBox.setSelected(true);
                } else {
                    this.eventCheckBox.setSelected(false);
                }
            } else {
                this.eventCheckBox.setEnabled(false);
                this.eventCheckBox.setSelected(false);
            }
            boolean bl = this.reportCustomQueryCheckBox.isSelected();
            if (bl) {
                this.persistNotifCheckBox.setEnabled(!bl);
                this.recurNotifCheckBox.setEnabled(!bl);
                this.clearNotifCheckBox.setEnabled(!bl);
                if (this.initNotifHourPeriod != null) {
                    this.initNotifHourPeriod.setEnabled(false);
                }
                if (this.persistNotifCheckBox.isEnabled()) {
                    this.persistNotifHourPeriod.setEnabled(this.persistNotifCheckBox.isSelected());
                } else {
                    this.persistNotifCheckBox.setSelected(false);
                    this.persistNotifHourPeriod.setEnabled(false);
                }
                if (this.recurNotifCheckBox.isEnabled()) {
                    this.recurNotifHourPeriod.setEnabled(this.recurNotifCheckBox.isSelected());
                } else {
                    this.recurNotifCheckBox.setSelected(false);
                    this.recurNotifHourPeriod.setEnabled(false);
                }
                if (!this.clearNotifCheckBox.isEnabled()) {
                    this.clearNotifCheckBox.setSelected(false);
                }
            }
        }

        public boolean checkValid() {
            return this.lmConditionalEntryNotifCB == null || !this.lmConditionalEntryNotifCB.isSelected() || !this.lmConditionalEntryTF.getText().trim().isEmpty() && Integer.parseInt(this.lmConditionalEntryTF.getText()) != 0;
        }

        private boolean hasChanged(ReportingCriteria reportingCriteria) {
            int n = reportingCriteria.getReportingOptions();
            if (this.immediateNotifButton.isSelected() != (n & 1) > 0) {
                return true;
            }
            if ((n & 8) > 0) {
                if (this.laterNotifButton.isSelected()) {
                    if (this.initNotifHourPeriod.getTime() != reportingCriteria.getDelayTimeSeconds()) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            if ((n & 0x100) > 0) {
                if (this.persistNotifCheckBox.isSelected()) {
                    if (this.persistNotifHourPeriod.getTime() != reportingCriteria.getDelayTimeSeconds()) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            if ((n & 2) > 0) {
                if (this.recurNotifCheckBox.isSelected()) {
                    if (this.recurNotifHourPeriod.getTime() != reportingCriteria.getPersistTimeSeconds()) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            if (this.clearNotifCheckBox.isSelected() != (n & 4) > 0) {
                return true;
            }
            if (this.reportCustomQueryCheckBox.isSelected() != (n & 0x400) > 0) {
                return true;
            }
            if (this.lmConditionalEntryNotifCB.isSelected()) {
                if (this.initNotifHourPeriod.getTime() != reportingCriteria.getDelayTimeSeconds()) {
                    return true;
                }
                if (Integer.parseInt(this.lmConditionalEntryTF.getText()) != reportingCriteria.getPersistTimeSeconds()) {
                    return true;
                }
            }
            return false;
        }

        private void fillRequestObject(Alert alert) {
            int n = 0;
            ReportingCriteria reportingCriteria = alert.getReportingCriteria(this.category);
            if (reportingCriteria == null) {
                return;
            }
            if (this.hasChanged(reportingCriteria)) {
                AlertNotifCriteriaPage.this.getAlertDetails().setModificationBit(8);
            }
            if (this.category == 1 || this.reportingCh != null && this.reportingCh.isSelected()) {
                if (this.immediateNotifButton.isSelected()) {
                    n |= 1;
                }
                if (this.extRetentionNotifButton.isSelected()) {
                    n |= 0x10;
                }
                if (this.failedFilesNotifButton.isSelected()) {
                    n |= 0x20;
                }
                if (this.reportCustomQueryCheckBox.isSelected()) {
                    n |= 0x400;
                }
                if (this.laterNotifButton.isSelected()) {
                    n |= 8;
                    reportingCriteria.setDelayTimeSeconds(this.initNotifHourPeriod.getTime());
                }
                if (this.persistNotifCheckBox.isSelected()) {
                    n |= 0x100;
                    reportingCriteria.setDelayTimeSeconds(this.persistNotifHourPeriod.getTime());
                }
                if (!this.laterNotifButton.isSelected() && !this.persistNotifCheckBox.isSelected()) {
                    reportingCriteria.setDelayTimeSeconds(0);
                }
                if (this.recurNotifCheckBox.isSelected()) {
                    n |= 2;
                    reportingCriteria.setPersistTimeSeconds(this.recurNotifHourPeriod.getTime());
                } else {
                    reportingCriteria.setPersistTimeSeconds(0);
                }
                if (this.clearNotifCheckBox.isSelected()) {
                    n |= 4;
                }
                if (this.lmConditionalEntryNotifCB.isSelected()) {
                    n |= 0x40;
                    n |= 8;
                    reportingCriteria.setDelayTimeSeconds(this.initNotifHourPeriod.getTime());
                    reportingCriteria.setPersistTimeSeconds(Integer.parseInt(this.lmConditionalEntryTF.getText()));
                }
                if (this.ddbJobNotifButton.isSelected()) {
                    n |= 0x80;
                }
                if (this.eventCheckBox.isSelected()) {
                    AlertNotifCriteriaPage.this.getAlertDetails().setEventParams(1);
                } else {
                    AlertNotifCriteriaPage.this.getAlertDetails().setEventParams(0);
                }
            }
            if (n != reportingCriteria.getReportingOptions()) {
                AlertNotifCriteriaPage.this.getAlertDetails().setModificationBit(8);
            }
            AlertNotifCriteriaPage.this.getAlertDetails().setMinJobCountForJobAnomaly(this.jobCountThresholdCheckBox.isEnabled() && this.jobCountThresholdCheckBox.isSelected() && this.jobCountThresholdValue.isEnabled() ? this.jobCountThresholdValue.getIntValue() : 0);
            reportingCriteria.setReportingOptions(n);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.laterNotifButton && this.initNotifHourPeriod != null) {
                this.initNotifHourPeriod.setEnabled(this.laterNotifButton.isSelected());
            } else if (actionEvent.getSource() == this.immediateNotifButton) {
                this.initNotifHourPeriod.setEnabled(this.laterNotifButton.isSelected());
            } else if (actionEvent.getSource() == this.persistNotifCheckBox) {
                this.persistNotifHourPeriod.setEnabled(this.persistNotifCheckBox.isSelected());
            } else if (actionEvent.getSource() == this.recurNotifCheckBox) {
                this.recurNotifHourPeriod.setEnabled(this.recurNotifCheckBox.isSelected());
                this.jobCountThresholdCheckBox.setEnabled(this.recurNotifCheckBox.isSelected());
                if (!this.jobCountThresholdCheckBox.isEnabled()) {
                    this.jobCountThresholdCheckBox.setSelected(false);
                }
                this.jobCountThresholdValue.setEnabled(this.jobCountThresholdCheckBox.isEnabled() && this.jobCountThresholdCheckBox.isSelected());
                if (this.recurNotifCheckBox.isSelected()) {
                    this.eventCheckBox.setEnabled(true);
                } else {
                    this.eventCheckBox.setEnabled(false);
                    this.eventCheckBox.setSelected(false);
                }
            } else if (actionEvent.getActionCommand() == ESCALATE_NOTIFICATION_CRITERIA) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                boolean bl = jCheckBox.isSelected();
                if (!bl) {
                    return;
                }
                if (this.initNotifHourPeriod != null) {
                    this.initNotifHourPeriod.setEnabled(this.laterNotifButton.isSelected());
                }
                this.recurNotifHourPeriod.setEnabled(this.recurNotifCheckBox.isSelected());
            } else if (actionEvent.getSource() == this.reportCustomQueryCheckBox) {
                boolean bl = this.reportCustomQueryCheckBox.isSelected();
                this.persistNotifCheckBox.setEnabled(!bl);
                this.recurNotifCheckBox.setEnabled(!bl);
                this.clearNotifCheckBox.setEnabled(!bl);
                if (this.initNotifHourPeriod != null) {
                    this.initNotifHourPeriod.setEnabled(false);
                }
                if (this.persistNotifCheckBox.isEnabled()) {
                    this.persistNotifHourPeriod.setEnabled(this.persistNotifCheckBox.isSelected());
                } else {
                    this.persistNotifCheckBox.setSelected(false);
                    this.persistNotifHourPeriod.setEnabled(false);
                }
                if (this.recurNotifCheckBox.isEnabled()) {
                    this.recurNotifHourPeriod.setEnabled(this.recurNotifCheckBox.isSelected());
                } else {
                    this.recurNotifCheckBox.setSelected(false);
                    this.recurNotifHourPeriod.setEnabled(false);
                }
                if (!this.clearNotifCheckBox.isEnabled()) {
                    this.clearNotifCheckBox.setSelected(false);
                }
            } else if (actionEvent.getSource() == this.jobCountThresholdCheckBox) {
                this.jobCountThresholdValue.setEnabled(this.jobCountThresholdCheckBox.isSelected());
            }
        }

        public JCheckBox getRecurNotifCheckBox() {
            return this.recurNotifCheckBox;
        }

        public JCheckBox getEventCheckBox() {
            return this.eventCheckBox;
        }
    }

    public class LmConditionalEntryKeyListener
    extends KeyAdapter {
        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (!Character.isDigit(keyEvent.getKeyChar())) {
                keyEvent.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            AlertNotifCriteriaPage.this.fireStateChanged();
        }
    }

    public class AlertCriteriaPanel
    extends AbstractAlertCritPanel {
        CriteriaPanel[] panels;
        JScrollPane pane;

        public AlertCriteriaPanel() {
            int n;
            super(new BorderLayout(0, 0));
            List list = AlertNotifCriteriaPage.this.getAlertDetails().getAvailableAlertCriterias();
            boolean bl = (AlertNotifCriteriaPage.this.getAlertDetails().getAlertDetails().getStatus() & 4) == 4;
            int n2 = AlertNotifCriteriaPage.this.getAlertDetails().getAlertType().getAlertTypeId();
            if (bl && n2 == 4) {
                for (n = 0; n < list.size(); ++n) {
                    if (((AlertCriteria)list.get(n)).getCriteria().getCriterta().getId() != 6) continue;
                    list.remove(n);
                    --n;
                }
            }
            if (bl && n2 == 3) {
                for (n = 0; n < list.size(); ++n) {
                    int n3 = ((AlertCriteria)list.get(n)).getCriteria().getCriterta().getId();
                    if (n3 != 65 && n3 != 73) continue;
                    list.remove(n);
                    --n;
                }
            }
            Collections.sort(list, new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object == object2) {
                        return 0;
                    }
                    AlertCriteria alertCriteria = (AlertCriteria)object;
                    AlertCriteria alertCriteria2 = (AlertCriteria)object2;
                    if (alertCriteria.isCompositeCriteria()) {
                        return -1;
                    }
                    if (alertCriteria2.isCompositeCriteria()) {
                        return 1;
                    }
                    return alertCriteria.getCriteria().getCriterta().getName().compareTo(alertCriteria2.getCriteria().getCriterta().getName());
                }
            });
            this.panels = new CriteriaPanel[list.size()];
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setLayout(new FlowLayout(){

                @Override
                public void layoutContainer(Container container) {
                    int n = container.getComponentCount();
                    int n2 = 0;
                    int n3 = 0;
                    Rectangle rectangle = container.getBounds();
                    for (int i = 0; i < n; ++i) {
                        Component component = container.getComponent(i);
                        if (component instanceof JSeparator) {
                            component.setPreferredSize(new Dimension(rectangle.width + 100, 40));
                        } else if (component instanceof JPanel && component.getName() != null && component.getName().equals("DummyPanel")) continue;
                        Dimension dimension = component.getPreferredSize();
                        if (n2 != 0 && n2 + dimension.width > 500) {
                            n2 = 0;
                            n3 += dimension.height;
                        }
                        component.setBounds(n2, n3, dimension.width, dimension.height);
                        n2 += dimension.width + 10;
                    }
                }
            });
            block2: for (int i = 0; i <= this.panels.length / 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    GridBagConstraints gridBagConstraints;
                    Object object;
                    if (i * 2 + j == this.panels.length) {
                        object = new JPanel();
                        ((Component)object).setName("DummyPanel");
                        jPanel.add((Component)object, Utilities.getRightConstraints());
                        continue block2;
                    }
                    object = (AlertCriteria)list.get(i * 2 + j);
                    this.panels[i * 2 + j] = new CriteriaPanel((AlertCriteria)object);
                    GridBagConstraints gridBagConstraints2 = gridBagConstraints = j == 1 ? Utilities.getRightConstraints() : Utilities.getLeftConstraints();
                    if (((AlertCriteria)object).isCompositeCriteria()) {
                        if (j == 0 && i != 0) {
                            JPanel jPanel2 = new JPanel();
                            jPanel2.setName("DummyPanel");
                            jPanel.add((Component)jPanel2, Utilities.getRightConstraints());
                        }
                        gridBagConstraints = Utilities.getRightConstraints(17, true, 0);
                    }
                    jPanel.add((Component)this.panels[i * 2 + j], gridBagConstraints);
                }
            }
            this.subScriptionBasedAlerts(true);
            if (AlertNotifCriteriaPage.this.getAlertDetails().getAlertDetails().getAlertType().getId() == 3) {
                this.pane = new JScrollPane(jPanel, 20, 30);
                jPanel.setPreferredSize(new Dimension(500, 600));
            } else {
                Utilities.addRow((Container)jPanel, null, (JComponent)new JSeparator(), true);
                Utilities.addRow((Container)jPanel, null, (JComponent)AlertNotifCriteriaPage.this.indvidualMessagesCh, true);
                this.pane = new JScrollPane(jPanel, 20, 30);
                jPanel.setPreferredSize(new Dimension(500, 350));
            }
            this.add(this.pane);
        }

        private void subScriptionBasedAlerts(boolean bl) {
            if ((AlertNotifCriteriaPage.this.getAlertDetails().getAlertDetails().getStatus() & 0x80) > 0) {
                AlertNotifCriteriaPage.this.indvidualMessagesCh.setSelected(true);
                AlertNotifCriteriaPage.this.indvidualMessagesCh.setEnabled(false);
                AlertNotifCriteriaPage.this.discoveredVirtualMachineCh.setSelected(false);
                AlertNotifCriteriaPage.this.discoveredVirtualMachineCh.setEnabled(false);
            } else {
                if (bl) {
                    AlertNotifCriteriaPage.this.indvidualMessagesCh.setSelected((AlertNotifCriteriaPage.this.getAlertDetails().getAlertDetails().getStatus() & 0x10) > 0);
                    AlertNotifCriteriaPage.this.discoveredVirtualMachineCh.setSelected((AlertNotifCriteriaPage.this.getAlertDetails().getAlertDetails().getStatus() & 0x400) > 0);
                }
                AlertNotifCriteriaPage.this.indvidualMessagesCh.setEnabled(true);
                AlertNotifCriteriaPage.this.discoveredVirtualMachineCh.setEnabled(true);
            }
        }

        @Override
        public boolean checkValid() {
            this.subScriptionBasedAlerts(false);
            for (int i = 0; i < this.panels.length; ++i) {
                if (!this.panels[i].selectCB.isSelected()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void fillRequestObject(Alert alert) {
            for (int i = 0; i < this.panels.length; ++i) {
                if (!this.panels[i].selectCB.isSelected()) continue;
                this.panels[i].fillRequestObject(alert);
            }
        }

        @Override
        public void setReport(Integer n) {
        }

        class InputControl
        extends JPanel {
            AlertCriteria.CriteriaInput input = null;
            JNumericTextField textField = null;

            public InputControl(AlertCriteria.CriteriaInput criteriaInput, boolean bl) {
                this.input = criteriaInput;
                int n = criteriaInput.getMaxValue() <= 0 ? Integer.MAX_VALUE : criteriaInput.getMaxValue();
                this.textField = new JNumericTextField("" + criteriaInput.getDefaulValue(), new NumericDocument(criteriaInput.getMinValue(), n));
                this.textField.setColumns(("" + n).length());
                this.textField.setText("" + criteriaInput.getDefaulValue());
                if (bl && AlertNotifCriteriaPage.this.getWizardController().getMode() == 2) {
                    this.textField.setText("" + criteriaInput.getValue());
                }
                this.textField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AlertNotifCriteriaPage.this.getAlertDetails().setModificationBit(8);
                    }
                });
                this.add(this.textField);
                this.textField.setEnabled(bl);
            }

            public int getValue() {
                return Integer.parseInt(this.textField.getText());
            }

            @Override
            public void setEnabled(boolean bl) {
                this.textField.setEnabled(bl);
            }
        }

        class CriteriaPanel
        extends JPanel {
            private AlertCriteria criteria;
            private JComponent[] controls;
            private JCheckBox selectCB;

            public CriteriaPanel(AlertCriteria alertCriteria) {
                super(new FlowLayout(0));
                this.selectCB = new JCheckBox();
                this.criteria = alertCriteria;
                this.selectCB.setSelected(this.criteria.isSelected());
                this.controls = this.criteria.getParsedName().size() > 0 && this.criteria.getParsedName().get(0) instanceof AlertCriteria.CriteriaInput ? new JComponent[this.criteria.getParsedName().size() + 1] : new JComponent[this.criteria.getParsedName().size()];
                int n = 0;
                for (int i = 0; i < this.controls.length; ++i) {
                    Object e = this.criteria.getParsedName().get(n++);
                    if (i == 0) {
                        this.controls[i] = this.selectCB;
                        if (e instanceof AlertCriteria.CriteriaInput) {
                            n = 0;
                        } else {
                            this.selectCB.setText(e.toString());
                        }
                    } else {
                        this.controls[i] = this.createControl(e);
                    }
                    this.add(this.controls[i]);
                }
                this.selectCB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        CriteriaPanel.this.criteria.setSelected(CriteriaPanel.this.selectCB.isSelected());
                        for (int i = 0; i < CriteriaPanel.this.controls.length; ++i) {
                            if (!(CriteriaPanel.this.controls[i] instanceof InputControl)) continue;
                            CriteriaPanel.this.controls[i].setEnabled(CriteriaPanel.this.selectCB.isSelected());
                        }
                        AlertNotifCriteriaPage.this.reportingCriteriaPanel.checkAvailableOptions();
                        AlertNotifCriteriaPage.this.escalationCriteriaPanel.checkAvailableOptions();
                        AlertNotifCriteriaPage.this.getAlertDetails().setModificationBit(8);
                        AlertNotifCriteriaPage.this.fireStateChanged();
                    }
                });
            }

            private JComponent createControl(Object object) {
                AlertCriteria.CriteriaInput criteriaInput;
                if (object instanceof AlertCriteria.CriteriaInput && (criteriaInput = (AlertCriteria.CriteriaInput)object).getType() != 0) {
                    return new InputControl((AlertCriteria.CriteriaInput)object, this.selectCB.isSelected());
                }
                return new JLabel(object.toString());
            }

            public void fillRequestObject(Alert alert) {
                int n = 0;
                for (int i = 0; i < this.controls.length; ++i) {
                    AlertCriteria.CriteriaInput criteriaInput;
                    Object e = this.criteria.getParsedName().get(n++);
                    if (i == 0 && e instanceof AlertCriteria.CriteriaInput) {
                        n = 0;
                    }
                    if (!(e instanceof AlertCriteria.CriteriaInput) || (criteriaInput = (AlertCriteria.CriteriaInput)e).getType() == 0) continue;
                    int n2 = 0;
                    if (this.controls[i] instanceof InputControl) {
                        InputControl inputControl = (InputControl)this.controls[i];
                        n2 = inputControl.getValue();
                    }
                    criteriaInput.setValue(n2);
                }
            }
        }
    }
}

