/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.alert;

import com.jgoodies.binding.beans.BeanAdapter;
import commvault.cte.alert.AlertEntityContext;
import commvault.cte.alert.model.Alert;
import commvault.cte.component.Utilities;
import commvault.cte.component.tree.AlertMultiStateTreeNode;
import commvault.cte.component.tree.Entity;
import commvault.cte.component.tree.EntityTreeNode;
import commvault.cte.component.tree.MultiStateTreeNode;
import commvault.cte.component.tree.NodeState;
import commvault.cte.component.tree.NodeType;
import commvault.msgs.CvEntities.EntityFlags;
import commvault.msgs.CvEntities.EntityType;
import commvault.msgs.CvEntities.GenericEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class AlertEntityAppTypeContext
extends AlertEntityContext {
    Alert alert;
    int mode;
    List<GenericEntity> selectedList = new ArrayList<GenericEntity>();
    List<GenericEntity> excludedList = new ArrayList<GenericEntity>();
    HashMap<Integer, List<Integer>> clientAppTypeEntitiesMap;

    public AlertEntityAppTypeContext(Alert alert, int n, HashMap<Integer, List<Integer>> hashMap) {
        super(alert, n);
        this.alert = alert;
        this.mode = n;
        this.clientAppTypeEntitiesMap = hashMap;
    }

    public void applyEntitySelection(List<GenericEntity> list) {
        this.selectedList.clear();
        this.excludedList.clear();
        if (list != null) {
            for (GenericEntity genericEntity : list) {
                if (genericEntity.getFlags() != null && genericEntity.getFlags().getExclude()) {
                    this.excludedList.add(genericEntity);
                    continue;
                }
                this.selectedList.add(genericEntity);
            }
        }
        this.selectedEntities = (ArrayList)this.selectedList;
        this.excludedEntities = (ArrayList)this.excludedList;
    }

    public boolean isAssociated(MultiStateTreeNode multiStateTreeNode, Boolean bl) {
        int n = multiStateTreeNode.getEntity().getNodeType().getNodeType();
        int n2 = multiStateTreeNode.getId();
        Boolean bl2 = false;
        Boolean bl3 = false;
        ArrayList<GenericEntity> arrayList = new ArrayList<GenericEntity>();
        if (bl.booleanValue()) {
            arrayList.addAll(this.excludedList);
        } else {
            arrayList.addAll(this.selectedList);
        }
        if (multiStateTreeNode.getParent() != null && ((MultiStateTreeNode)multiStateTreeNode.getParent()).getEntity().getNodeType().getNodeType() == EntityType.CLIENT_GROUP_ENTITY.getEnumValue()) {
            bl2 = true;
        } else if (multiStateTreeNode.getParent() != null && ((MultiStateTreeNode)multiStateTreeNode.getParent()).getEntity().getNodeType().getNodeType() == EntityType.USERGROUP_ENTITY.getEnumValue()) {
            bl3 = true;
        }
        if (arrayList != null) {
            for (GenericEntity genericEntity : arrayList) {
                if (genericEntity.get_type_().getEnumValue() != n) continue;
                switch (EntityType.getEnumByValue((int)n)) {
                    case ALL_CLIENTS: {
                        return true;
                    }
                    case CLIENT_ENTITY: {
                        if (!(bl2 != false ? n2 == genericEntity.getClientId() && ((MultiStateTreeNode)multiStateTreeNode.getParent()).getId() == genericEntity.getClientGroupId() : n2 == genericEntity.getClientId() && genericEntity.getClientGroupId() == 0)) break;
                        return true;
                    }
                    case APPTYPE_ENTITY: {
                        if (n2 != genericEntity.getApplicationId() || ((MultiStateTreeNode)multiStateTreeNode.getParent()).getId() != genericEntity.getClientId()) break;
                        return true;
                    }
                    case INSTANCE_ENTITY: {
                        if (n2 != genericEntity.getInstanceId()) break;
                        return true;
                    }
                    case BACKUPSET_ENTITY: {
                        if (n2 != genericEntity.getBackupsetId()) break;
                        return true;
                    }
                    case SUBCLIENT_ENTITY: {
                        if (n2 != genericEntity.getSubclientId()) break;
                        return true;
                    }
                    case ALL_CLIENT_GROUPS_ENTITY: {
                        return true;
                    }
                    case CLIENT_GROUP_ENTITY: {
                        if (n2 != genericEntity.getClientGroupId()) break;
                        return true;
                    }
                    case LIBRARIES_ENTITY: {
                        return true;
                    }
                    case LIBRARY_ENTITY: {
                        if (n2 != genericEntity.getLibraryId()) break;
                        return true;
                    }
                    case STORAGE_POLICIES_ENTITY: {
                        return true;
                    }
                    case STORAGE_POLICY_ENTITY: {
                        if (n2 != genericEntity.getStoragePolicyId()) break;
                        return true;
                    }
                    case STORAGE_POLICY_COPY_ENTITY: {
                        if (n2 != genericEntity.getCopyId()) break;
                        return true;
                    }
                    case ALL_MEDIAAGENTS: {
                        return true;
                    }
                    case MEDIAAGENT_ENTITY: {
                        if (n2 != genericEntity.getMediaAgentId()) break;
                        return true;
                    }
                    case EXTERNAL_QUERY_ENTITY: {
                        return true;
                    }
                    case CUSTOM_QUERY_ENTITY: {
                        if (n2 != genericEntity.getCommCellId()) break;
                        return true;
                    }
                    case ALL_WORKFLOW: {
                        return true;
                    }
                    case WORKFLOW_ENTITY: {
                        if (n2 != genericEntity.getWorkflowId()) break;
                        return true;
                    }
                    case TRACKING_POLICIES_ENTITY: {
                        return true;
                    }
                    case TRACKING_POLICY_ENTITY: {
                        if (n2 != genericEntity.getTrackingPolicyId()) break;
                        return true;
                    }
                    case USERGROUPS_ENTITY: {
                        return true;
                    }
                    case USERGROUP_ENTITY: {
                        if (n2 != genericEntity.getUserGroupId()) break;
                        return true;
                    }
                    case USERS_ENTITY: {
                        return true;
                    }
                    case USER_ENTITY: {
                        if (!(bl3 != false ? n2 == genericEntity.getUserId() && ((MultiStateTreeNode)multiStateTreeNode.getParent()).getId() == genericEntity.getUserGroupId() : n2 == genericEntity.getUserId() && genericEntity.getUserGroupId() == 0)) break;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public Boolean isAnyChildAssociated(MultiStateTreeNode multiStateTreeNode, Boolean bl) {
        int n = multiStateTreeNode.getEntity().getNodeType().getNodeType();
        Boolean bl2 = false;
        Boolean bl3 = false;
        int n2 = multiStateTreeNode.getEntity().getId();
        ArrayList<GenericEntity> arrayList = new ArrayList<GenericEntity>();
        if (bl.booleanValue()) {
            arrayList.addAll(this.excludedList);
        } else {
            arrayList.addAll(this.selectedList);
        }
        if (multiStateTreeNode.getParent() != null && ((MultiStateTreeNode)multiStateTreeNode.getParent()).getEntity().getNodeType().getNodeType() == EntityType.CLIENT_GROUP_ENTITY.getEnumValue()) {
            bl2 = true;
        } else if (multiStateTreeNode.getParent() != null && ((MultiStateTreeNode)multiStateTreeNode.getParent()).getEntity().getNodeType().getNodeType() == EntityType.USERGROUP_ENTITY.getEnumValue()) {
            bl3 = true;
        }
        for (GenericEntity genericEntity : arrayList) {
            if (genericEntity.get_type_().getEnumValue() == n) continue;
            switch (EntityType.getEnumByValue((int)n)) {
                case ALL_CLIENTS: {
                    if (genericEntity.getClientId() == 0 || genericEntity.getClientGroupId() != 0) break;
                    return true;
                }
                case CLIENT_ENTITY: {
                    if (bl2.booleanValue() || genericEntity.getClientId() != n2 || genericEntity.getClientGroupId() != 0) break;
                    return true;
                }
                case APPTYPE_ENTITY: {
                    if (n2 != genericEntity.getApplicationId() || ((MultiStateTreeNode)multiStateTreeNode.getParent()).getId() != genericEntity.getClientId()) break;
                    return true;
                }
                case INSTANCE_ENTITY: {
                    if (n2 != genericEntity.getInstanceId()) break;
                    return true;
                }
                case BACKUPSET_ENTITY: {
                    if (n2 != genericEntity.getBackupsetId()) break;
                    return true;
                }
                case SUBCLIENT_ENTITY: {
                    if (n2 != genericEntity.getSubclientId()) break;
                    return true;
                }
                case ALL_CLIENT_GROUPS_ENTITY: {
                    if (genericEntity.getClientGroupId() == 0) break;
                    return true;
                }
                case CLIENT_GROUP_ENTITY: {
                    if (n2 != genericEntity.getClientGroupId()) break;
                    return true;
                }
                case LIBRARIES_ENTITY: {
                    if (genericEntity.getLibraryId() == 0) break;
                    return true;
                }
                case LIBRARY_ENTITY: {
                    if (n2 != genericEntity.getLibraryId()) break;
                    return true;
                }
                case STORAGE_POLICIES_ENTITY: {
                    if (genericEntity.getStoragePolicyId() == 0) break;
                    return true;
                }
                case STORAGE_POLICY_ENTITY: {
                    if (n2 != genericEntity.getStoragePolicyId()) break;
                    return true;
                }
                case STORAGE_POLICY_COPY_ENTITY: {
                    if (n2 != genericEntity.getCopyId()) break;
                    return true;
                }
                case ALL_MEDIAAGENTS: {
                    if (genericEntity.getMediaAgentId() == 0) break;
                    return true;
                }
                case MEDIAAGENT_ENTITY: {
                    if (n2 != genericEntity.getMediaAgentId()) break;
                    return true;
                }
                case EXTERNAL_QUERY_ENTITY: {
                    if (genericEntity.getCommCellId() == 0) break;
                    return true;
                }
                case CUSTOM_QUERY_ENTITY: {
                    if (n2 != genericEntity.getCommCellId()) break;
                    return true;
                }
                case ALL_WORKFLOW: {
                    if (genericEntity.getWorkflowId() == 0) break;
                    return true;
                }
                case WORKFLOW_ENTITY: {
                    if (n2 != genericEntity.getWorkflowId()) break;
                    return true;
                }
                case TRACKING_POLICIES_ENTITY: {
                    if (genericEntity.getTrackingPolicyId() == 0) break;
                    return true;
                }
                case TRACKING_POLICY_ENTITY: {
                    if (n2 != genericEntity.getTrackingPolicyId()) break;
                    return true;
                }
                case USERGROUPS_ENTITY: {
                    if (genericEntity.getUserGroupId() == 0) break;
                    return true;
                }
                case USERGROUP_ENTITY: {
                    if (n2 != genericEntity.getUserGroupId()) break;
                    return true;
                }
                case USERS_ENTITY: {
                    if (genericEntity.getUserId() == 0 || genericEntity.getUserGroupId() != 0) break;
                    return true;
                }
                case USER_ENTITY: {
                    if (bl3.booleanValue() || genericEntity.getUserId() != n2 || genericEntity.getUserGroupId() != 0) break;
                    return true;
                }
            }
        }
        return false;
    }

    public void setSelected(MultiStateTreeNode multiStateTreeNode, Boolean bl) {
        NodeState nodeState;
        Boolean bl2 = this.isAnyChildAssociated(multiStateTreeNode, true);
        if (bl.booleanValue()) {
            multiStateTreeNode.setState(NodeState.SelectedBecauseParentIsSelected);
            nodeState = NodeState.SelectedBecauseParentIsSelected;
            multiStateTreeNode.setTreeIcon(Utilities.getIcon(nodeState.getIcon()));
            if (bl2.booleanValue()) {
                multiStateTreeNode.setState(NodeState.SelectedWithExclusionsBecOfParent);
                nodeState = NodeState.SelectedWithExclusionsBecOfParent;
                multiStateTreeNode.setTreeIcon(Utilities.getIcon(nodeState.getIcon()));
            }
        } else {
            multiStateTreeNode.setState(NodeState.Selected);
            nodeState = NodeState.Selected;
            multiStateTreeNode.setTreeIcon(Utilities.getIcon(nodeState.getIcon()));
            multiStateTreeNode.setSelected(true);
            if (bl2.booleanValue()) {
                multiStateTreeNode.setState(NodeState.SelectedWithExclusions);
                nodeState = NodeState.SelectedWithExclusions;
                multiStateTreeNode.setTreeIcon(Utilities.getIcon(nodeState.getIcon()));
                multiStateTreeNode.setSelected(true);
            }
        }
        for (int i = 0; i < multiStateTreeNode.getChildCount(); ++i) {
            this.setSelected((MultiStateTreeNode)multiStateTreeNode.getChildAt(i), true);
        }
    }

    public void setExcluded(MultiStateTreeNode multiStateTreeNode, Boolean bl) {
        NodeState nodeState;
        if (bl.booleanValue()) {
            multiStateTreeNode.setState(NodeState.ExcludedBecauseParentIsExcluded);
            nodeState = NodeState.ExcludedBecauseParentIsExcluded;
            multiStateTreeNode.setTreeIcon(Utilities.getIcon(nodeState.getIcon()));
        } else {
            multiStateTreeNode.setState(NodeState.Excluded);
            nodeState = NodeState.Excluded;
            multiStateTreeNode.setTreeIcon(Utilities.getIcon(nodeState.getIcon()));
            multiStateTreeNode.getEntity().setExcluded(true);
        }
        for (int i = 0; i < multiStateTreeNode.getChildCount(); ++i) {
            this.setExcluded((MultiStateTreeNode)multiStateTreeNode.getChildAt(i), true);
        }
    }

    void updateParent(MultiStateTreeNode multiStateTreeNode, Boolean bl) {
        MultiStateTreeNode multiStateTreeNode2 = (MultiStateTreeNode)multiStateTreeNode.getParent();
        if (multiStateTreeNode2 != null) {
            if (bl.booleanValue()) {
                multiStateTreeNode2.setState(NodeState.PartiallySelected);
                NodeState nodeState = NodeState.PartiallySelected;
                multiStateTreeNode2.setTreeIcon(Utilities.getIcon(nodeState.getIcon()));
                this.updateParent(multiStateTreeNode2, true);
            } else {
                if (multiStateTreeNode2.getCurrentState() == NodeState.Selected || multiStateTreeNode2.getCurrentState() == NodeState.SelectedWithExclusions) {
                    multiStateTreeNode2.setState(NodeState.SelectedWithExclusions);
                    NodeState nodeState = NodeState.SelectedWithExclusions;
                    multiStateTreeNode2.setTreeIcon(Utilities.getIcon(nodeState.getIcon()));
                } else if (multiStateTreeNode2.getCurrentState() == NodeState.SelectedBecauseParentIsSelected || multiStateTreeNode2.getCurrentState() == NodeState.SelectedWithExclusionsBecOfParent) {
                    multiStateTreeNode2.setState(NodeState.SelectedWithExclusionsBecOfParent);
                    NodeState nodeState = NodeState.SelectedWithExclusionsBecOfParent;
                    multiStateTreeNode2.setTreeIcon(Utilities.getIcon(nodeState.getIcon()));
                } else {
                    multiStateTreeNode2.setState(NodeState.PartiallySelected);
                    NodeState nodeState = NodeState.PartiallySelected;
                    multiStateTreeNode2.setTreeIcon(Utilities.getIcon(nodeState.getIcon()));
                }
                this.updateParent(multiStateTreeNode2, false);
            }
        }
    }

    public void fillSelections(MultiStateTreeNode multiStateTreeNode) {
        if (this.isAssociated(multiStateTreeNode, false)) {
            this.setSelected(multiStateTreeNode, false);
            this.updateParent(multiStateTreeNode, true);
            return;
        }
        for (int i = 0; i < multiStateTreeNode.getChildCount(); ++i) {
            this.fillSelections((MultiStateTreeNode)multiStateTreeNode.getChildAt(i));
        }
        if (multiStateTreeNode.getCurrentState() == NodeState.NotSelected && this.isAnyChildAssociated(multiStateTreeNode, false).booleanValue()) {
            multiStateTreeNode.setState(NodeState.PartiallySelected);
            multiStateTreeNode.setTreeIcon(Utilities.getIcon(NodeState.PartiallySelected.getIcon()));
        }
    }

    public void fillExclusions(MultiStateTreeNode multiStateTreeNode) {
        if (this.isAssociated(multiStateTreeNode, true)) {
            this.setExcluded(multiStateTreeNode, false);
            this.updateParent(multiStateTreeNode, false);
            return;
        }
        for (int i = 0; i < multiStateTreeNode.getChildCount(); ++i) {
            this.fillExclusions((MultiStateTreeNode)multiStateTreeNode.getChildAt(i));
        }
    }

    public void fillTree(MultiStateTreeNode multiStateTreeNode) {
        this.fillSelections(multiStateTreeNode);
        this.fillExclusions(multiStateTreeNode);
    }

    public void clearSelection(MultiStateTreeNode multiStateTreeNode) {
        int n = multiStateTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            MultiStateTreeNode multiStateTreeNode2 = (MultiStateTreeNode)multiStateTreeNode.getChildAt(i);
            multiStateTreeNode2.setState(NodeState.NotSelected);
            multiStateTreeNode2.setSelected(false);
            multiStateTreeNode2.getEntity().setExcluded(false);
            multiStateTreeNode2.setTreeIcon(Utilities.getIcon(NodeState.NotSelected.getIcon()));
            this.clearSelection(multiStateTreeNode2);
        }
    }

    @Override
    public List<EntityTreeNode> getEntityNodes(NodeType nodeType, Entity entity) {
        ArrayList<EntityTreeNode> arrayList = new ArrayList<EntityTreeNode>();
        Entity[] entityArray = this.getEntityLoader().getEntities(nodeType, entity, this.alert.getAlertType().getAlertTypeId());
        boolean bl = AlertEntityAppTypeContext.getAlert().getAlertType().getAlertTypeId() == 65 && this.mode == 1;
        List<Integer> list = AlertEntityAppTypeContext.getAlert().getAllSelectedAppTypes();
        List<GenericEntity> list2 = AlertEntityAppTypeContext.getAlert().getAppTypeFilter();
        if ((list == null || list.size() == 0) && list2.size() > 0) {
            HashMap<Integer, List<Integer>> hashMap = AlertEntityAppTypeContext.getAlert().getAlertServerObject().getAppGroupTypeMap();
            for (int i = 0; i < list2.size(); ++i) {
                if (list2.get(i).get_type_() == EntityType.AGENTTYPE_ENTITY) {
                    list.add(list2.get(i).getApplicationId());
                    continue;
                }
                if (list2.get(i).get_type_() != EntityType.APPGROUP_ENTITY) continue;
                list.addAll((Collection)hashMap.get(list2.get(i).getAppGroupId()));
            }
        }
        for (Entity entity2 : entityArray) {
            if (bl && entity2.getId() == 2) {
                entity2.setSelected(true);
            }
            if (entity2.getNodeType().getNodeType() == EntityType.APPTYPE_ENTITY.getEnumValue()) {
                if (list != null && list.size() != 0 && !list.contains(entity2.getId())) continue;
                arrayList.add(new AlertMultiStateTreeNode(entity2, this));
                continue;
            }
            if (entity2.getNodeType().getNodeType() == EntityType.CLIENT_ENTITY.getEnumValue() && this.clientAppTypeEntitiesMap != null) {
                List<Integer> list3 = this.clientAppTypeEntitiesMap.get(entity2.getId());
                if (list != null && list.size() != 0 && (list3 == null || !this.doesClientHaveSelectedAppType(list3, list))) continue;
                arrayList.add(new AlertMultiStateTreeNode(entity2, this));
                continue;
            }
            arrayList.add(new AlertMultiStateTreeNode(entity2, this));
        }
        return arrayList;
    }

    private boolean doesClientHaveSelectedAppType(List<Integer> list, List<Integer> list2) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list2.contains(list.get(i))) continue;
            return true;
        }
        return false;
    }

    public void loadSelectionsAndExclusions(MultiStateTreeNode multiStateTreeNode) {
        this.clearSelection(multiStateTreeNode);
        this.applyEntitySelection(AlertEntityAppTypeContext.getAlert().getEntitList());
        this.fillTree(multiStateTreeNode);
    }

    public List<GenericEntity> getSelections(MultiStateTreeNode multiStateTreeNode) {
        ArrayList<GenericEntity> arrayList = new ArrayList<GenericEntity>();
        NodeState nodeState = multiStateTreeNode.getCurrentState();
        List<Object> list = new ArrayList();
        if (multiStateTreeNode.isSelected()) {
            arrayList.add(this.getGenericEntity(multiStateTreeNode.getEntity(), false));
        } else if (nodeState == NodeState.PartiallySelected || nodeState == NodeState.Null) {
            if (multiStateTreeNode.getChildCount() == 0) {
                if (this.isAnyChildAssociated(multiStateTreeNode, false).booleanValue()) {
                    arrayList.addAll(this.getAssociatedChildren(multiStateTreeNode, false));
                }
            } else {
                int n;
                for (n = 0; n < multiStateTreeNode.getChildCount(); ++n) {
                    arrayList.addAll(this.getSelections((MultiStateTreeNode)multiStateTreeNode.getChildAt(n)));
                }
                n = multiStateTreeNode.getEntity().getNodeType().getNodeType();
                if (n == EntityType.ALL_CLIENTS.getEnumValue() || n == EntityType.CLIENT_ENTITY.getEnumValue()) {
                    list = this.getAssociatedChildren(multiStateTreeNode, false);
                    for (int i = 0; i < multiStateTreeNode.getChildCount(); ++i) {
                        for (int j = 0; j < list.size(); ++j) {
                            if (n == EntityType.ALL_CLIENTS.getEnumValue() && ((GenericEntity)list.get(j)).getClientId() == ((MultiStateTreeNode)multiStateTreeNode.getChildAt(i)).getId()) {
                                list.remove(j);
                                --j;
                            }
                            if (n != EntityType.CLIENT_ENTITY.getEnumValue() || ((GenericEntity)list.get(j)).getApplicationId() != ((MultiStateTreeNode)multiStateTreeNode.getChildAt(i)).getId()) continue;
                            list.remove(j);
                            --j;
                        }
                    }
                    arrayList.addAll(list);
                }
            }
        }
        return arrayList;
    }

    public List<GenericEntity> getExclusions(MultiStateTreeNode multiStateTreeNode) {
        ArrayList<GenericEntity> arrayList = new ArrayList<GenericEntity>();
        List<Object> list = new ArrayList();
        NodeState nodeState = multiStateTreeNode.getCurrentState();
        if (multiStateTreeNode.isExcluded()) {
            arrayList.add(this.getGenericEntity(multiStateTreeNode.getEntity(), true));
        } else if (nodeState == NodeState.PartiallySelected || nodeState == NodeState.SelectedWithExclusions || nodeState == NodeState.SelectedWithExclusionsBecOfParent || nodeState == NodeState.Null || nodeState == NodeState.NotSelected) {
            if (multiStateTreeNode.getChildCount() == 0) {
                if (this.isAnyChildAssociated(multiStateTreeNode, true).booleanValue()) {
                    arrayList.addAll(this.getAssociatedChildren(multiStateTreeNode, true));
                }
            } else {
                int n;
                for (n = 0; n < multiStateTreeNode.getChildCount(); ++n) {
                    arrayList.addAll(this.getExclusions((MultiStateTreeNode)multiStateTreeNode.getChildAt(n)));
                }
                n = multiStateTreeNode.getEntity().getNodeType().getNodeType();
                if (n == EntityType.ALL_CLIENTS.getEnumValue() || n == EntityType.CLIENT_ENTITY.getEnumValue()) {
                    list = this.getAssociatedChildren(multiStateTreeNode, true);
                    for (int i = 0; i < multiStateTreeNode.getChildCount(); ++i) {
                        for (int j = 0; j < list.size(); ++j) {
                            if (n == EntityType.ALL_CLIENTS.getEnumValue() && ((GenericEntity)list.get(j)).getClientId() == ((MultiStateTreeNode)multiStateTreeNode.getChildAt(i)).getId()) {
                                list.remove(j);
                                --j;
                            }
                            if (n != EntityType.CLIENT_ENTITY.getEnumValue() || ((GenericEntity)list.get(j)).getApplicationId() != ((MultiStateTreeNode)multiStateTreeNode.getChildAt(i)).getId()) continue;
                            list.remove(j);
                            --j;
                        }
                    }
                    arrayList.addAll(list);
                }
            }
        }
        return arrayList;
    }

    private GenericEntity getGenericEntity(Entity entity, Boolean bl) {
        boolean bl2 = true;
        GenericEntity genericEntity = new GenericEntity();
        BeanAdapter beanAdapter = new BeanAdapter((Object)genericEntity);
        for (Entity entity2 = entity; entity2 != null; entity2 = entity2.getParentEntity()) {
            if (entity2.getNodeType().getIdDef() != null) {
                beanAdapter.setValue(entity2.getNodeType().getIdDef(), (Object)entity2.getId());
                beanAdapter.setValue(entity2.getNodeType().getNodeName(), (Object)entity2.toString());
            }
            for (EntityType entityType : EntityType.values()) {
                if (!bl2 || entityType.getEnumValue() != entity2.getNodeType().getNodeType()) continue;
                beanAdapter.setValue("_type_", (Object)entityType);
                bl2 = false;
            }
            if (!bl.booleanValue()) continue;
            EntityFlags entityFlags = new EntityFlags();
            entityFlags.setExclude(true);
            genericEntity.setFlags(entityFlags);
        }
        return genericEntity;
    }

    private List<GenericEntity> getAssociatedChildren(MultiStateTreeNode multiStateTreeNode, Boolean bl) {
        ArrayList<GenericEntity> arrayList = new ArrayList<GenericEntity>();
        ArrayList<GenericEntity> arrayList2 = new ArrayList<GenericEntity>();
        if (bl.booleanValue()) {
            arrayList2.addAll(this.excludedList);
        } else {
            arrayList2.addAll(this.selectedList);
        }
        int n = multiStateTreeNode.getEntity().getNodeType().getNodeType();
        Boolean bl2 = false;
        Boolean bl3 = false;
        int n2 = multiStateTreeNode.getEntity().getId();
        if (multiStateTreeNode.getParent() != null && ((MultiStateTreeNode)multiStateTreeNode.getParent()).getEntity().getNodeType().getNodeType() == EntityType.CLIENT_GROUP_ENTITY.getEnumValue()) {
            bl2 = true;
        } else if (multiStateTreeNode.getParent() != null && ((MultiStateTreeNode)multiStateTreeNode.getParent()).getEntity().getNodeType().getNodeType() == EntityType.USERGROUP_ENTITY.getEnumValue()) {
            bl3 = true;
        }
        for (GenericEntity genericEntity : arrayList2) {
            switch (EntityType.getEnumByValue((int)n)) {
                case ALL_CLIENTS: {
                    if (genericEntity.getClientId() == 0 || genericEntity.getClientGroupId() != 0) break;
                    arrayList.add(genericEntity);
                    break;
                }
                case CLIENT_ENTITY: {
                    if (bl2.booleanValue() || genericEntity.getClientId() != n2 || genericEntity.getClientGroupId() != 0) break;
                    arrayList.add(genericEntity);
                    break;
                }
                case APPTYPE_ENTITY: {
                    if (n2 != genericEntity.getApplicationId() || ((MultiStateTreeNode)multiStateTreeNode.getParent()).getId() != genericEntity.getClientId()) break;
                    arrayList.add(genericEntity);
                    break;
                }
                case INSTANCE_ENTITY: {
                    if (n2 != genericEntity.getInstanceId()) break;
                    arrayList.add(genericEntity);
                    break;
                }
                case BACKUPSET_ENTITY: {
                    if (n2 != genericEntity.getBackupsetId()) break;
                    arrayList.add(genericEntity);
                    break;
                }
                case SUBCLIENT_ENTITY: {
                    if (n2 != genericEntity.getSubclientId()) break;
                    arrayList.add(genericEntity);
                    break;
                }
                case ALL_CLIENT_GROUPS_ENTITY: {
                    if (genericEntity.getClientGroupId() == 0) break;
                    arrayList.add(genericEntity);
                    break;
                }
                case CLIENT_GROUP_ENTITY: {
                    if (n2 != genericEntity.getClientGroupId()) break;
                    arrayList.add(genericEntity);
                    break;
                }
                case USERGROUPS_ENTITY: {
                    if (genericEntity.getUserGroupId() == 0) break;
                    arrayList.add(genericEntity);
                    break;
                }
                case USERGROUP_ENTITY: {
                    if (n2 != genericEntity.getUserGroupId()) break;
                    arrayList.add(genericEntity);
                    break;
                }
                case USERS_ENTITY: {
                    if (genericEntity.getUserId() == 0 || genericEntity.getUserGroupId() != 0) break;
                    arrayList.add(genericEntity);
                    break;
                }
                case USER_ENTITY: {
                    if (bl3.booleanValue() || genericEntity.getUserId() != n2 || genericEntity.getUserGroupId() != 0) break;
                    arrayList.add(genericEntity);
                }
            }
        }
        return arrayList;
    }

    public boolean anyChildExcluded(MultiStateTreeNode multiStateTreeNode) {
        Object object;
        for (int i = 0; i < multiStateTreeNode.getChildCount(); ++i) {
            object = ((MultiStateTreeNode)multiStateTreeNode.getChildAt(i)).getCurrentState();
            if (object != NodeState.Excluded && object != NodeState.SelectedWithExclusions && object != NodeState.SelectedWithExclusionsBecOfParent) continue;
            return true;
        }
        Boolean bl = false;
        if (multiStateTreeNode.getParent() != null && ((MultiStateTreeNode)multiStateTreeNode.getParent()).getEntity().getNodeType().getNodeType() == EntityType.CLIENT_GROUP_ENTITY.getEnumValue()) {
            bl = true;
        }
        if (multiStateTreeNode.getEntity().getNodeType().getNodeType() == EntityType.ALL_CLIENTS.getEnumValue() || multiStateTreeNode.getEntity().getNodeType().getNodeType() == EntityType.CLIENT_ENTITY.getEnumValue()) {
            object = this.getAssociatedChildren(multiStateTreeNode, true);
            for (int i = 0; i < multiStateTreeNode.getChildCount(); ++i) {
                for (int j = 0; j < object.size(); ++j) {
                    if (multiStateTreeNode.getEntity().getNodeType().getNodeType() == EntityType.ALL_CLIENTS.getEnumValue() && ((GenericEntity)object.get(j)).getClientId() == ((MultiStateTreeNode)multiStateTreeNode.getChildAt(i)).getId()) {
                        object.remove(j);
                        --j;
                    }
                    if (multiStateTreeNode.getEntity().getNodeType().getNodeType() != EntityType.CLIENT_ENTITY.getEnumValue() || bl.booleanValue() || ((GenericEntity)object.get(j)).getApplicationId() != ((MultiStateTreeNode)multiStateTreeNode.getChildAt(i)).getId()) continue;
                    object.remove(j);
                    --j;
                }
            }
            if (object.size() > 0) {
                return true;
            }
        }
        return false;
    }
}

