/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.alert;

import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.SearchableBar;
import com.jidesoft.swing.TreeSearchable;
import commvault.cte.CteStringBank;
import commvault.cte.alert.AlertEntityContext;
import commvault.cte.alert.model.Alert;
import commvault.cte.alert.model.AlertListItem;
import commvault.cte.component.tree.AlertMultiStateTreeNode;
import commvault.cte.component.tree.Entity;
import commvault.cte.component.tree.EntityTree;
import commvault.cte.component.tree.EntityTreeNode;
import commvault.cte.component.tree.MultiStateTreeNode;
import commvault.cte.component.wizard.AbstractWizardPage;
import commvault.cte.component.wizard.WizardDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;

public class AlertEntitiesSelectionPage
extends AbstractWizardPage {
    private EntityTree entityTree = null;
    private MultiStateTreeNode rootNode;
    int category = -1;
    int type = -1;
    int subscriptionBasedAlert = -1;
    private static final String ENTITY_SELECTION = CteStringBank.Entities_Selection.getI18n();
    public static final String PERMISSION_MSG = CteStringBank.You_do_not_have_permission_to_proceed.getI18n();
    private SearchableBar searchBar;
    private Map<KeyStroke, ActionListener> keyboardShortcutMap;
    private final KeyStroke showSearchBarKeyStroke = KeyStroke.getKeyStroke(70, 128);

    public AlertEntitiesSelectionPage(WizardDialog wizardDialog) {
        super(wizardDialog);
        this.setTitle(ENTITY_SELECTION);
        this.createHelpLink();
    }

    @Override
    public void activated() {
        AlertListItem alertListItem = this.getAlert().getAlertDetails();
        int n = alertListItem.getAlertCategory().getId();
        int n2 = alertListItem.getAlertType().getId();
        int n3 = alertListItem.getStatus() & 0x80;
        if (this.category == -1 || this.type == -1 || this.subscriptionBasedAlert == -1 || this.category != n || this.type != n2 || this.subscriptionBasedAlert != n3) {
            this.remove(this.componentPanel);
            this.initComponents();
            this.addComponents();
            this.category = n;
            this.type = n2;
            this.subscriptionBasedAlert = n3;
        }
    }

    private Alert getAlert() {
        return (Alert)this.getWizardController().getData();
    }

    protected void initComponents() {
        this.rootNode = new AlertMultiStateTreeNode(this.getAlert().getRootEntity(), new AlertEntityContext(this.getAlert(), this.getWizardController().getMode()));
        this.entityTree = new EntityTree(this.rootNode);
        this.componentPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.entityTree);
        this.componentPanel.add(jScrollPane);
        this.entityTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                EntityTreeNode entityTreeNode;
                if (AlertEntitiesSelectionPage.this.entityTree.isTriStateClick(mouseEvent) && (entityTreeNode = (EntityTreeNode)AlertEntitiesSelectionPage.this.entityTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()).getLastPathComponent()) != null && !entityTreeNode.getEntity().isRestricted()) {
                    AlertEntitiesSelectionPage.this.fireStateChanged();
                    AlertEntitiesSelectionPage.this.getAlert().setModificationBit(1);
                }
            }
        });
        if (this.getWizardController().getMode() == 2) {
            this.rootNode.applyState(1);
        }
        this.initializeSearchBar();
        this.initializeKeyboardShortcuts();
    }

    public void initializeKeyboardShortcuts() {
        this.keyboardShortcutMap = new HashMap<KeyStroke, ActionListener>();
        this.keyboardShortcutMap.put(this.showSearchBarKeyStroke, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AlertEntitiesSelectionPage.this.searchBar.getInstaller().openSearchBar(AlertEntitiesSelectionPage.this.searchBar);
                AlertEntitiesSelectionPage.this.searchBar.focusSearchField();
            }
        });
        this.registerKeyboardShortcuts(this);
    }

    public void registerKeyboardShortcuts(JComponent jComponent) {
        if (jComponent != null) {
            for (Map.Entry<KeyStroke, ActionListener> entry : this.keyboardShortcutMap.entrySet()) {
                jComponent.registerKeyboardAction(entry.getValue(), entry.getKey(), 1);
            }
        }
    }

    private void initializeSearchBar() {
        TreeSearchable treeSearchable = new TreeSearchable((JTree)this.entityTree);
        this.searchBar = new SearchableBar((Searchable)treeSearchable);
        this.searchBar.setCompact(true);
        this.searchBar.setInstaller(new SearchableBar.Installer(){

            public void openSearchBar(SearchableBar searchableBar) {
                AlertEntitiesSelectionPage alertEntitiesSelectionPage = AlertEntitiesSelectionPage.this;
                alertEntitiesSelectionPage.add((Component)searchableBar);
                alertEntitiesSelectionPage.invalidate();
                alertEntitiesSelectionPage.revalidate();
            }

            public void closeSearchBar(SearchableBar searchableBar) {
                AlertEntitiesSelectionPage.this.closeSearchBar(searchableBar);
            }
        });
    }

    private void closeSearchBar(SearchableBar searchableBar) {
        AlertEntitiesSelectionPage alertEntitiesSelectionPage = this;
        alertEntitiesSelectionPage.remove((Component)searchableBar);
        alertEntitiesSelectionPage.invalidate();
        alertEntitiesSelectionPage.revalidate();
        this.entityTree.grabFocus();
    }

    @Override
    public boolean canSkip() {
        boolean bl;
        boolean bl2 = bl = this.getAlert().getAlertType().getRootNodeType().getChildNodeTypes().size() == 0;
        if (bl) {
            int n = this.getAlert().getAlertType().getAlertTypeId();
            boolean bl3 = this.getAlert().getEntityLoader().hasEntityPermission(n);
            if (!bl3) {
                throw new IllegalStateException(PERMISSION_MSG);
            }
        }
        return bl;
    }

    @Override
    public void deactivated() {
        this.rootNode.updateEntityState();
        if (this.rootNode.getEntity() != null && this.rootNode.getEntity().getChildren() != null) {
            for (Entity entity : this.rootNode.getEntity().getChildren()) {
                if (entity == null) continue;
                entity.setAssociationSelectionState(entity.isSelected());
            }
        }
        this.getAlert().getAlertServerObject().setAssociations(this.getAlert());
    }

    @Override
    public boolean checkValid() {
        if (this.canSkip() || (this.getAlert().getAlertDetails().getStatus() & 0x80) > 0) {
            return true;
        }
        return this.rootNode.isNodeSelectionState();
    }

    private void createHelpLink() {
        String string = "main-nt";
        String string2 = "english-en-us-" + string + "-NO_TOCHEADINGS.txt-AlertWizard(EntitiesSelected)";
        this.setHelpLink(string2);
    }
}

